﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 状态视图模型
    /// </summary>
    public class MainStatusViewModel : ViewModelBase
    {
        /// <summary>
        /// 状态视图模型
        /// </summary>
        public MainStatusViewModel()
        {
            // 初始化命令
            this.InitCommand();

            // 初始化消息
            this.InitMessage();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.OpenVizCommandLogWindowCommand = new VCommand(this.OpenVizCommandLogWindow);
            this.OpenErrorLogWindowCommand = new VCommand(this.OpenErrorLogWindow);
        }

        /// <summary>
        /// 初始化消息
        /// </summary>
        private void InitMessage()
        {
            ApplicationDomainEx.MessageManager.Register<ProjectOpenMessage>(this, this.OnProjectOpenMessage);
            ApplicationDomainEx.MessageManager.Register<ProjectCloseMessage>(this, this.OnProjectCloseMessage);
            ApplicationDomainEx.MessageManager.Register<PageOpenMessage>(this, this.OnPageOpenMessage);
        }

        // ======================================================================
        // Property
        // ======================================================================

        #region ProjectName -- 项目名称

        private string projectName;
        /// <summary>
        /// 项目名称
        /// </summary>
        public string ProjectName
        {
            get { return projectName; }
            set { projectName = value; this.RaisePropertyChanged(nameof(ProjectName)); }
        }

        #endregion

        #region Scene -- 当前打开的场景

        private string scene;
        /// <summary>
        /// 当前打开的场景
        /// </summary>
        public string Scene
        {
            get { return scene; }
            set { scene = value; this.RaisePropertyChanged(nameof(Scene)); }
        }

        #endregion

        // ======================================================================
        // Command
        // ======================================================================

        #region OpenVizCommandLogWindowCommand -- 打开Viz命令日志窗口命令

        /// <summary>
        /// 打开Viz命令日志窗口命令
        /// </summary>
        public VCommand OpenVizCommandLogWindowCommand { get; set; }

        /// <summary>
        /// 打开Viz命令日志窗口
        /// </summary>
        private void OpenVizCommandLogWindow()
        {
            ApplicationDomainEx.VizCommandLogWindow.Visibility = System.Windows.Visibility.Visible;
            ApplicationDomainEx.VizCommandLogWindow.WindowState = System.Windows.WindowState.Normal;
        }

        #endregion

        #region OpenErrorLogWindowCommand -- 打开错误日志窗口命令

        /// <summary>
        /// 打开错误日志窗口命令
        /// </summary>
        public VCommand OpenErrorLogWindowCommand { get; set; }

        /// <summary>
        /// 打开错误日志窗口
        /// </summary>
        private void OpenErrorLogWindow()
        {
            ApplicationDomainEx.ErrorLogWindow.Visibility = System.Windows.Visibility.Visible;
            ApplicationDomainEx.ErrorLogWindow.WindowState = System.Windows.WindowState.Normal;
        }

        #endregion

        // ======================================================================
        // Message
        // ======================================================================

        /// <summary>
        /// 项目打开消息
        /// </summary>
        /// <param name="msg">消息</param>
        private void OnProjectOpenMessage(ProjectOpenMessage msg)
        {
            if (ApplicationDomainEx.ProjectDbContext == null)
            {
                this.ProjectName = null;
                return;
            }

            this.ProjectName = System.IO.Path.GetFileNameWithoutExtension(ApplicationDomainEx.ProjectDbContext.Path);
        }

        /// <summary>
        /// 项目关闭消息
        /// </summary>
        /// <param name="msg">消息</param>
        private void OnProjectCloseMessage(ProjectCloseMessage msg)
        {
            this.ProjectName = null;
        }

        /// <summary>
        /// 页打开消息
        /// </summary>
        /// <param name="msg">消息</param>
        private void OnPageOpenMessage(PageOpenMessage msg)
        {
            this.Scene = msg.Page?.Scene;
        }
    }
}
