﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Common;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 插件服务
    /// </summary>
    public interface IPluginService : IService
    {
        /// <summary>
        /// 获取当前插件视图
        /// </summary>
        /// <returns>当前插件视图</returns>
        object GetCurrentPluginView();

        /// <summary>
        /// 根据视图获取页ID
        /// </summary>
        /// <param name="view">视图</param>
        /// <returns>页ID</returns>
        PageModel GetPageModelFromView(IPluginView view);

        /// <summary>
        /// 获取所有的插件视图
        /// </summary>
        /// <returns>插件视图</returns>
        List<IPluginView> GetPluginViews();

        /// <summary>
        /// 获取插件视图
        /// </summary>
        /// <typeparam name="T">插件视图类型</typeparam>
        /// <returns>插件视图</returns>
        List<T> GetPluginViews<T>() where T : class, IPluginView;
    }
}
