﻿using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 插件映射设置视图模型
    /// </summary>
    public class PluginMappingSettingViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(PluginMappingSettingViewModel));

        /// <summary>
        /// 媒资库配置设置视图模型
        /// </summary>
        public PluginMappingSettingViewModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
            this.AddCommand = new VCommand(this.Add);
            this.DeleteCommand = new VCommand(this.Delete);
        }

        // =========================================================================
        // Property
        // =========================================================================

        #region Mappings -- 映射集合

        private ObservableCollection<PluginMappingModel> mappings;
        /// <summary>
        /// 映射集合
        /// </summary>
        public ObservableCollection<PluginMappingModel> Mappings
        {
            get { return mappings; }
            set { mappings = value; this.RaisePropertyChanged(nameof(Mappings)); }
        }

        #endregion

        #region SelectedMapping -- 当前选中的映射

        private PluginMappingModel selectedMapping;
        /// <summary>
        /// 当前选中的映射
        /// </summary>
        public PluginMappingModel SelectedMapping
        {
            get { return selectedMapping; }
            set { selectedMapping = value; this.RaisePropertyChanged(nameof(SelectedMapping)); }
        }

        #endregion

        #region PluginInfos -- 插件信息集合

        private List<PluginInfo> pluginInfos;
        /// <summary>
        /// 插件信息集合
        /// </summary>
        public List<PluginInfo> PluginInfos
        {
            get { return pluginInfos; }
            set { pluginInfos = value; this.RaisePropertyChanged(nameof(PluginInfos)); }
        }

        #endregion

        // =========================================================================
        // Command
        // =========================================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            // 插件映射配置
            PluginMappingConfigEntity config = ApplicationDomainEx.PluginMappingConfig;

            ObservableCollection<PluginMappingModel> list = new ObservableCollection<PluginMappingModel>();

            if (config.Mappings != null)
            {
                foreach (PluginMapping item in config.Mappings)
                {
                    PluginMappingModel model = new PluginMappingModel();
                    model.Scene = item.Scene;
                    model.PluginID = item.PluginID;

                    list.Add(model);
                }
            }

            this.Mappings = list;

            // 插件信息
            this.PluginInfos = ApplicationDomainEx.PluginInfos.Where(p => p.PluginType == PluginType.Page && p.Group != ApplicationConstants.APPLICATION_GROUP_NAME).ToList();
        }

        #endregion

        #region AddCommand -- 添加命令

        /// <summary>
        /// 添加命令
        /// </summary>
        public VCommand AddCommand { get; set; }

        /// <summary>
        /// 添加
        /// </summary>
        private void Add()
        {
            PluginMappingModel model = new PluginMappingModel();
            this.Mappings.Add(model);
        }

        #endregion

        #region DeleteCommand -- 删除命令

        /// <summary>
        /// 删除命令
        /// </summary>
        public VCommand DeleteCommand { get; set; }

        /// <summary>
        /// 删除
        /// </summary>
        private void Delete()
        {
            if (this.SelectedMapping == null)
                return;

            this.Mappings.Remove(this.SelectedMapping);
        }

        #endregion

        // =========================================================================
        // Public Function
        // =========================================================================

        /// <summary>
        /// 保存
        /// </summary>
        public void Save()
        {
            PluginMappingConfigEntity config = ApplicationDomainEx.PluginMappingConfig;

            List<PluginMapping> list = new List<PluginMapping>();
            if (this.Mappings != null)
            {
                foreach (PluginMappingModel model in this.Mappings)
                {
                    PluginMapping item = new PluginMapping();
                    item.Scene = model.Scene;
                    item.PluginID = model.PluginID;

                    list.Add(item);
                }
            }
            config.Mappings = list;

            ApplicationDomainEx.LocalDbContext.PluginMappingConfig.Update(config);
        }
    }
}