﻿using log4net;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.CBA.Module
{
    public static class ConfigManage
    {

        private static ILog Log = LogManager.GetLogger(typeof(ConfigManage));    
        #region 1.获取当前类库的文件配置

        public static Configuration InitLogConfig()
        {
            string baesePath = AppDomain.CurrentDomain.BaseDirectory;
            string fullName = Path.GetFileName(Assembly.GetCallingAssembly().Location);
            string path = string.Format(@"{0}CBA.Module.config", baesePath);
            //AppDomain.CurrentDomain.BaseDirectory
            if (File.Exists(path) == false)
            {
                {
                    string msg = string.Format("{0}路径下的文件未找到 ", path);
                    throw new FileNotFoundException(msg);
                }
            }
            try
            {
                ExeConfigurationFileMap configFile = new ExeConfigurationFileMap();
                configFile.ExeConfigFilename = path;
                Configuration config= ConfigurationManager.OpenMappedExeConfiguration(configFile, ConfigurationUserLevel.None);
                return config;
            }
            catch (Exception ex)
            {
                //throw new Exception(ex.Message);
                Log.Error(ex.Message);
                return null;
            }
            #endregion

        }
    }
}
