﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using log4net;
using VIZ.Package.Domain;
using VIZ.Package.Service;
using VIZ.Package.Storage;
using DevExpress.Xpf.Grid;
using VIZ.Package.Common;

namespace VIZ.TVP.CBA.Module
{
    public class DayMatchViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log= LogManager.GetLogger(typeof(DayMatchViewModel));

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();


        public DayMatchViewModel()
        {
            
            BtnCmd = new VCommand(BtnCommand);
            BtnMatchDayUp = new VCommand(BtnMatchDayUpData);
            BtnRoundCmd = new VCommand(BtmRoundCommand);
            PromptCommand = new VCommand(PromptCmd);
            ColumnChoiceCommand = new VCommand(ColumnChoice);
            ShowGridMenuCommand = new VCommand<GridMenuEventArgs>(ShowGridMenu);
            matchDate = DateTime.Today.ToShortDateString();
            GetSchedule();

            RoundMatchs = new ObservableCollection<int>();
            for (int i = 1; i < 100; i++)
            {
                RoundMatchs.Add(i);
            }

            roundMatchItem = 1;

            chooseMatchItems = new ObservableCollection<string>() { "日期","轮次"};

            RoundComEnable = false;
            RoundBtnEnable = false;

            MateDateEnable = true;
            BtmEnable = true;
        }

        private string matchDate;


        /// <summary>
        ///获取日期
        /// </summary>
        public string MatchDate
        {
            get { return matchDate; }
            set { matchDate = value; this.RaisePropertyChanged(nameof(MatchDate)); }
        }

        public VCommand BtnCmd { get; set; }

        public VCommand BtnMatchDayUp { get; set; }


        public VCommand BtnRoundCmd { get; set; }


        /// <summary>
        /// 获取今日赛程
        /// </summary>
        private void BtnCommand()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human,"CBA日期："+ PluginConstant.Operate_Load);
            GetSchedule();
        }


        /// <summary>
        /// 添加轮次刷新
        /// </summary>
        private void BtmRoundCommand()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA轮次：" + PluginConstant.Operate_Load);
            SetRoundMatchData();
        }


        /// <summary>
        /// 构造指定日期赛程的数据
        /// </summary>
        private void BtnMatchDayUpData()
        {
            Log.Info("比赛日期上版和数据:"+ CombineMatchData());
            //ApplicationDomainEx.VizEngineModel.STAGE_START("Default/JRSCBEN", "Data", CombineMatchData());
        }


        /// <summary>
        /// 今日赛程信息
        /// </summary>
        private ObservableCollection<Dayschedule> matchData;

        /// <summary>
        /// 绑定数据列表
        /// </summary>
        public ObservableCollection<Dayschedule> MatchData
        {
            get { return matchData; }

            set { matchData = value; this.RaisePropertyChanged(nameof(MatchData)); }
        }


        //private ObservableCollection<string> lightHigts=new ObservableCollection<string>()
        //{
        //    "不高亮",
        //    "高亮"
        //};


        //public ObservableCollection<string> LightHigts
        //{
        //    get
        //    {
        //        return lightHigts;
        //    }
        //    set { lightHigts = value; this.RaisePropertyChanged(nameof(LightHigts)); }

        //}

        //private string light;

        //public string Light
        //{
        //    get { return light; }
        //    set { light=value; this.RaisePropertyChanged(nameof(Light)); }
        //}






        private string title = "今日赛程";

        /// <summary>
        /// 标题
        /// </summary>
        public string Title
        {
            get { return title; }
            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }

        /// <summary>
        /// 是否执行成功
        /// </summary>
        public bool flag = false;

        Dayschedules dayschedules = null;

        /// <summary>
        /// 获取赛程信息
        /// </summary>
        public async void GetSchedule()
        {
            
            try
            {


                string date = Convert.ToDateTime(matchDate).ToString("yyyy-MM-dd");
                flag = false;
                dayschedules = new Dayschedules();
                dayschedules =  await JsonModel.PostTomorrowMatch_Path(date);

                if (dayschedules == null|| dayschedules.dayschedule==null) return ;

            
                // matchData.AddRange(dayschedules.dayschedule);

                MatchData = new ObservableCollection<Dayschedule>();
                foreach (var dayschedule in dayschedules.dayschedule)
                {
                    if (dayschedule.Status == "1")
                    {
                        dayschedule.Status = "未开赛";
                    }
                    else if (dayschedule.Status == "2")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "3")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "4")
                    {
                        dayschedule.Status = "已结束";
                    }
                    else if (dayschedule.Status == "5")
                    {
                        dayschedule.Status = "延期";
                    }

                    MatchData.Add(dayschedule);
                }
                flag = true;


                
            }
            catch(Exception ex)
            {
               
                Log.Error(ex.Message);
            }

        }

        private string selectChooseMatchItem= "日期";

        public string SelectChooseMatchItem
        {
            get { return selectChooseMatchItem; }
            set
            {
                selectChooseMatchItem=value;
                this.RaisePropertyChanged(nameof(SelectChooseMatchItem));

                if(selectChooseMatchItem == "日期")
                {
                    RoundBtnEnable = false;
                    RoundComEnable = false;

                    MateDateEnable = true;
                    BtmEnable = true;
                    //Title = "今日赛程";
                }
                else if(selectChooseMatchItem == "轮次")
                {
                    RoundBtnEnable = true;
                    RoundComEnable = true;

                    MateDateEnable = false;
                    BtmEnable = false;
                    //Title = "本轮赛程";
                }
            }
        }

        /// <summary>
        /// 赛程和轮次
        /// </summary>

        private ObservableCollection<string> chooseMatchItems;

        public ObservableCollection<string> ChooseMatchItems
        {
            get { return chooseMatchItems; }

            set { chooseMatchItems=value;this.RaisePropertyChanged(nameof(chooseMatchItems)); }
        }


        private int roundMatchItem;

        public int RoundMatchItem
        {
            get { return roundMatchItem; }
            set { roundMatchItem = value; this.RaisePropertyChanged(nameof(RoundMatchItem)); }
        }


        private ObservableCollection<int> roundMatch;

        public ObservableCollection<int> RoundMatchs
        {
            get { return roundMatch; }
            set { roundMatch = value; this.RaisePropertyChanged(nameof(RoundMatchs)); }
        }

        /// <summary>
        /// 日期的可用性
        /// </summary>
        private bool mateDateEnable=true;
        public bool MateDateEnable
        {
            get { return mateDateEnable; }
            set { mateDateEnable = value; this.RaisePropertyChanged(nameof(MateDateEnable)); }
        }


        /// <summary>
        /// 加载赛程可用性
        /// </summary>
        private bool btmEnable=true;

        public bool BtmEnable
        {
            get { return btmEnable; }
            set { btmEnable = value;this.RaisePropertyChanged(nameof(BtmEnable)); }
        }


        /// <summary>
        /// 轮次选择可用性
        /// </summary>

        private bool roundComEnable = false;
        public bool RoundComEnable
        {
            get { return roundComEnable; }
            set { roundComEnable = value; this.RaisePropertyChanged(nameof(RoundComEnable)); }
        }


        private bool roundBtnEnable=false;
        public bool RoundBtnEnable
        {
            get { return roundBtnEnable; }
            set { roundBtnEnable = value; this.RaisePropertyChanged(nameof(RoundBtnEnable)); }
        }

        #region IsColumnChooserVisible -- 是否显示列选择器

        private bool isColumnChooserVisible;
        /// <summary>
        /// 是否显示列选择器
        /// </summary>
        public bool IsColumnChooserVisible
        {
            get { return isColumnChooserVisible; }
            set { isColumnChooserVisible = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible)); }
        }

        #endregion


        #region ColumnChoiceCommand -- 列选择命令

        /// <summary>
        /// 列选择命令
        /// </summary>
        public VCommand ColumnChoiceCommand { get; set; }

        /// <summary>
        /// 列选择
        /// </summary>
        private void ColumnChoice()
        {
            this.IsColumnChooserVisible = true;
        }

        #endregion


        #region ShowGridMenuCommand -- 显示列命令

        /// <summary>
        /// 显示列命令
        /// </summary>
        public VCommand<GridMenuEventArgs> ShowGridMenuCommand { get; set; }

        /// <summary>
        /// 显示列
        /// </summary>
        /// <param name="e">事件参数</param>
        private void ShowGridMenu(GridMenuEventArgs e)
        {
            GridControlHelper.RemoveAllDefaultMenuItem(e);
        }

        #endregion

        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA赛程和轮次：" + PluginConstant.Operate_Message);

            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
            if (dayschedules != null)
            {
                string onAirLastDate = $"赛程接口更新时间：{dayschedules.LastPushDataDateTime}";
                vm.OnErrorLogMessage(onAirLastDate);
            }

            if (roundSchedules != null)
            {
                string playerSeasonLastDate = $"轮次接口更新时间：{roundSchedules.LastPushDataDateTime}";
                vm.OnErrorLogMessage(playerSeasonLastDate);
            }

            //if (TeamSeasonData != null)
            //{
            //    string teamSeasonLastDate = $"球队赛季接口更新时间:{TeamSeasonData.LastPushDataDateTime}";
            //    vm.OnErrorLogMessage(teamSeasonLastDate);
            //}
            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;

            // messageLastRecordDate.ShowDialog();
        }

        #endregion

        RoundSchedules roundSchedules = null;

        /// <summary>
        /// 轮次方法
        /// </summary>
        public void SetRoundMatchData()
        {
             roundSchedules=new RoundSchedules();

             roundSchedules = JsonModel.PostGetGameRound_Path(roundMatchItem.ToString());

            if (roundSchedules == null) return;


            roundSchedules.schedulelist = roundSchedules.schedulelist.OrderBy(a=>a.MatchGTM8Time).ToList();

            MatchData = new ObservableCollection<Dayschedule>();



            foreach (var rudData in roundSchedules.schedulelist)
            {

                Dayschedule d = new Dayschedule();
                if (rudData.Status == "1")
                {
                    rudData.Status = "未开赛";
                }
                else if (rudData.Status == "2")
                {
                    rudData.Status = "进行中";
                }
                else if (rudData.Status == "3")
                {
                    rudData.Status = "进行中";
                }
                else if (rudData.Status == "4")
                {
                    rudData.Status = "已结束";
                }
                else if (rudData.Status == "5")
                {
                    rudData.Status = "延期";
                }

                d.dates = rudData.dates;
                d.time = rudData.time;

                d.HomeTeamName = rudData.HomeTeamName;
                d.HomeTeamScore = rudData.HomeTeamScore;
                d.VisitingTeamName = rudData.VisitingTeamName;
                d.VisitingTeamScore = rudData.VisitingTeamScore;
                d.Status = rudData.Status;

                MatchData.Add(d);
            }

   
        }



        /// <summary>
        /// 组装往包装发送得数据
        /// </summary>
        /// <returns></returns>
        public string CombineMatchData()
        {
            try

            {
                string data = "";
                data += title + "&";


                foreach (var tempMatchData in matchData)
                {
                    if (tempMatchData.SelectLight == "不高亮")
                    {
                        data += "0";
                    }
                    else
                    {
                        data += "1";
                    }

                    data += "*";
                    if (string.IsNullOrEmpty(tempMatchData.dates))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.dates.Replace(" ", "");
                    }


                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.time))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.time.Replace(" ", "");
                    }

                    data += "*";

                    data += tempMatchData.HomeTeamName.Replace(" ", "");

                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.HomeTeamScore))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.HomeTeamScore.Replace(" ", "");
                    }


                    data += "*";
                    data += tempMatchData.VisitingTeamName.Replace(" ", "");

                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.VisitingTeamScore))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.VisitingTeamScore.Replace(" ", "");
                    }


                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.Status))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.Status.Replace(" ", "");
                    }
                    data += ";";

                }

                return data;
            }
            catch(Exception ex)
            {
                Log.Error(ex.ToString());
                return "";
            }
        }

    }
}
