﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Module;
using VIZ.Package.Domain;
using VIZ.Package.Module;
using VIZ.Package.Storage;

namespace VIZ.TVP.CBA.Module
{
    public class AppSetup_InitCBALiteDB
    {

        private static AppSetup_InitCBALiteDB _createInstance = null;

        public static AppSetup_InitCBALiteDB CreateInstance
        {
            get
            {
                if (null == _createInstance)
                {
                    _createInstance = new AppSetup_InitCBALiteDB();
                }
                return _createInstance;
            }
        }


        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitCBALiteDB));

        /// <summary>
        /// 描述
        /// </summary>
        public static string Detail { get; } = "应用程序启动 -- 初始化LiteDB";


        /// <summary>
        /// CBA数据库Context
        /// </summary>
        public static CBALocalDbContext cBALocalDbContext { get; set; }

        public static HttpUrlConfigEntity HttpUrlConfigEntity { get; set; }

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public AppSetup_InitCBALiteDB()
        {
            string folder = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "db");
            if (!System.IO.Directory.Exists(folder))
            {
                System.IO.Directory.CreateDirectory(folder);
            }

            string path = System.IO.Path.Combine(folder, "CBAcache.db");

            log.Error(path);
            cBALocalDbContext = new CBALocalDbContext(path);
            HttpUrlConfigEntity= cBALocalDbContext.HttpUrlConfig.FindAll().FirstOrDefault()??new HttpUrlConfigEntity();
        }

    }
}
