﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Storage;
using LiteDB;

namespace VIZ.TVP.CBA.Module
{
    public  class CBALocalDbContext
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(LocalDbContext));

        /// <summary>
        /// 数据库
        /// </summary>
        private ILiteDatabase Database;

        /// <summary>
        /// LiteDB数据库
        /// </summary>
        /// <param name="path">数据库路径</param>
        public CBALocalDbContext(string path)
        {
            this.Path = path;

            this.Database = new LiteDatabase(path);
            this.HttpUrlConfig = this.Database.GetCollection<HttpUrlConfigEntity>();

        }

        /// <summary>
        /// 数据库文件路径
        /// </summary>
        public string Path { get; private set; }


        /// <summary>
        /// 数据访问接口配置
        /// </summary>
        public ILiteCollection<HttpUrlConfigEntity> HttpUrlConfig { get; private set; }


        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.HttpUrlConfig = null;
            this.Database?.Dispose();
        }
    }
}
