﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.CBA.Module
{
    /// <summary>
    /// Interaction logic for TeamStandingUI.xaml
    /// </summary>
    public partial class TeamStandingView : UserControl, IPluginView
    {
        TeamStandingViewModel vm = null;

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        public TeamStandingView()
        {
            InitializeComponent();

            WPFHelper.BindingViewModel(this,new TeamStandingViewModel());
            vm = this.DataContext as TeamStandingViewModel;
        }

        public void Dispose()
        {
           
        }

        public void PageOpend(ConnModel conn, PageModel page)
        {
            if (conn.IsConnected && vm.TeamRanksModel != null)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamStandingData()));
            }
        }

        public void PreviewContinue(ConnModel conn)
        {
            //if(conn.IsConnected)
            //{
            //    conn.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            //}
        }

        public void PreviewIn(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_PREVIEW_PLAY);

            if (conn.IsConnected&&vm.TeamRanksModel!=null)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamStandingData()));
            }

        }

        public void PreviewOut(ConnModel conn)
        {
            
        }

        public void PreviewUpdate(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_PREVIEW_UPDATE);
            if (conn.IsConnected && vm.TeamRanksModel != null)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamStandingData()));
            }
        }

        public void TakeContinue(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_CONTINUE);

            if (conns.IsConnected && vm.TeamRanksModel != null)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        public void TakeOut(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_OUT);

            if (conns.IsConnected && vm.TeamRanksModel != null)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        public void TakeUpdate(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_UPDATE);

            if (conns.IsConnected && vm.TeamRanksModel != null)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamStandingData()));
            }
        }

        public void TakIn(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_TAKE);
            if (conns.IsConnected && vm.TeamRanksModel != null)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamStandingData()));
            }
        }
    }
}
