﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using log4net;

using VIZ.Package.Service;
using VIZ.Package.Domain;
using VIZ.Package.Storage;
using DevExpress.Xpf.Grid;
using VIZ.Package.Common;

namespace VIZ.TVP.CBA.Module
{
    public class TeamStandingViewModel: ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log= LogManager.GetLogger(typeof(TeamStandingViewModel));

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        /// <summary>
        /// 球队排名初始化排名
        /// </summary>
        public TeamStandingViewModel()
        {
            //TeamRanksModel = new ObservableCollection<Model.Teamrank>()
            //{
            //    new Model.Teamrank()
            //    {
            //        Id = 1,
            //        Wins=5,
            //        TeamCNAlias="热火1",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    },

            //    new Model.Teamrank()
            //    {
            //        Id = 2,
            //        Wins=5,
            //        TeamCNAlias="热火2",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    },


            //    new Model.Teamrank()
            //    {
            //        Id = 3,
            //        Wins=5,
            //        TeamCNAlias="热火3",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    },

            //    new Model.Teamrank()
            //    {
            //        Id = 4,
            //        Wins=5,
            //        TeamCNAlias="热火4",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    },
            //    new Model.Teamrank()
            //    {
            //        Id = 5,
            //        Wins=5,
            //        TeamCNAlias="热火5",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    },
            //    new Model.Teamrank()
            //    {
            //        Id = 6,
            //        Wins=5,
            //        TeamCNAlias="热火6",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    },
            //    new Model.Teamrank()
            //    {
            //        Id = 7,
            //        Wins=5,
            //        TeamCNAlias="热火7",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    }
            //};
            BtnCmd = new VCommand(BtmCommand);
            BtnCmdTeamStandingUp = new VCommand(BtnCmdTeamStandingUpData);
            BtnCmdNextPage = new VCommand(BtnCmdNextPageData);
            PromptCommand = new VCommand(PromptCmd);

            ColumnChoiceCommand = new VCommand(ColumnChoice);
            ShowGridMenuCommand = new VCommand<GridMenuEventArgs>(ShowGridMenu);
        }


        private ObservableCollection<Teamrank> teamRanksModel;
        public ObservableCollection<Teamrank> TeamRanksModel
        {
            get { return teamRanksModel; }

            set { teamRanksModel = value; this.RaisePropertyChanged(nameof(TeamRanksModel)); }
        }

        public VCommand BtnCmd { get; set; }


        TeamRanks teamStands = null;
        private void BtmCommand()
        {

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA球队积分排名：" + PluginConstant.Operate_Load);
            teamStands =new TeamRanks();
            teamStands = JsonModel.PostTeamScoreData_Path();
            if (teamStands == null) return;
            TeamRanksModel = new ObservableCollection<Teamrank>();
            int i = 1;
            foreach(var teamRank in teamStands.teamrank)
            {
                teamRank.Id = i;

                teamRank.WinningPercentageStr = (teamRank.WinningPercentage * 100).ToString("F1") + "%";

                if(teamRank.StreakType==1)
                {
                    teamRank.StreakName = "连胜";
                }
                else if(teamRank.StreakType==0)
                {
                    teamRank.StreakName = "连败";
                }
                TeamRanksModel.Add(teamRank);
                i++;
            }
        }



        public VCommand BtnCmdTeamStandingUp { get; set; }


        private void BtnCmdTeamStandingUpData()
        {
            if(TeamRanksModel!=null)
            {
                Log.Info("球队排名上版信息和数据："+ CombineTeamStandingData());
                //ApplicationDomainEx.VizEngineModel.STAGE_START("Default/JFB", "Data", CombineTeamStandingData());
            }
        }



        public VCommand BtnCmdNextPage { get; set; }


        private void BtnCmdNextPageData()
        {
           // ApplicationDomainEx.VizEngineModel.CONTINUE();
        }

        public string CombineTeamStandingData()
        {
            try
            {


                string data = "";

                data += title;

                data += "&";

                foreach (var tempTeamRankModel in TeamRanksModel)
                {
                    data += tempTeamRankModel.Id.ToString().Replace(" ", "");

                    data += "*";
                    data += tempTeamRankModel.TeamCNAlias.Replace(" ", "");

                    data += "*";
                    data += tempTeamRankModel.Wins.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.Losses.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.WinningPercentageStr.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.Integral.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.StreakNumber.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.StreakName.Replace(" ", "");
                    data += ";";
                }

                //如果CBA球队数据不等于20条数据时候，往后数据进行清空处理
                for(int i= TeamRanksModel.Count;i<=20;i++)
                {
                    data += "";

                    data += "*";
                    data += "";

                    data += "*";
                    data += "";


                    data += "*";
                    data += "";


                    data += "*";
                    data += "";


                    data += "*";
                    data += "";


                    data += "*";
                    data += "";


                    data += "*";
                    data += "";
                    data += ";";
                }

                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }


        private string title = "球队积分排名";

        public string Title
        {
            get { return title;}
            set { title = value;this.RaisePropertyChanged(nameof(Title)); }   
        }


        #region IsColumnChooserVisible -- 是否显示列选择器

        private bool isColumnChooserVisible;
        /// <summary>
        /// 是否显示列选择器
        /// </summary>
        public bool IsColumnChooserVisible
        {
            get { return isColumnChooserVisible; }
            set { isColumnChooserVisible = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible)); }
        }

        #endregion


        #region ColumnChoiceCommand -- 列选择命令

        /// <summary>
        /// 列选择命令
        /// </summary>
        public VCommand ColumnChoiceCommand { get; set; }

        /// <summary>
        /// 列选择
        /// </summary>
        private void ColumnChoice()
        {
            this.IsColumnChooserVisible = true;
        }

        #endregion


        #region ShowGridMenuCommand -- 显示列命令

        /// <summary>
        /// 显示列命令
        /// </summary>
        public VCommand<GridMenuEventArgs> ShowGridMenuCommand { get; set; }

        /// <summary>
        /// 显示列
        /// </summary>
        /// <param name="e">事件参数</param>
        private void ShowGridMenu(GridMenuEventArgs e)
        {
            GridControlHelper.RemoveAllDefaultMenuItem(e);
        }

        #endregion


        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {


            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA球队积分排名：" + PluginConstant.Operate_Message);

            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
            if (teamStands != null)
            {
                string onAirLastDate = $"球队积分接口更新时间：{teamStands.LastPushDataDateTime}";
                vm.OnErrorLogMessage(onAirLastDate);
            }

           
            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;

            // messageLastRecordDate.ShowDialog();
        }

        #endregion

    }
}
