﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.FTB.Module
{
    public static class Utils
    {
        /// <summary>
        /// MD5加密
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string GetMD5(string str)
        {
            //创建MD5对象
            MD5 md5 = new MD5CryptoServiceProvider();
            byte[] buffer = System.Text.Encoding.UTF8.GetBytes(str);
            byte[] MD5Buffer = md5.ComputeHash(buffer);
            string strNew = null;
            for (int i = 0; i < MD5Buffer.Length; i++)
            {
                strNew += MD5Buffer[i].ToString("x2");//可以了解下ToString("")的格式问题 
            }
            return strNew;
        }

        /// <summary>
        /// 艾果的密钥加密
        /// </summary>
        /// <param name="appId"></param>
        /// <param name="appKey"></param>
        /// <returns></returns>

        public static string GetKey(string appId, string appKey)
        {
            int random = new Random().Next(0, 100);

            long timeStamp = DateToTicks(DateTime.Now);

            string key = Convert.ToBase64String(Encoding.UTF8.GetBytes(string.Format("{0},{1},{2},{3}", appId, appKey, timeStamp, random)));

            return key;
        }

        /// <summary>
        /// 获取时间戳
        /// </summary>
        /// <param name="time"></param>
        /// <returns></returns>
        public static long DateToTicks(DateTime? time)
        {
            return ((time.HasValue ? time.Value.Ticks : DateTime.Parse("1990-01-01").Ticks) - 621355968000000000) / 10000;
        }

    }
}
