﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.FTB.Module
{
    public  class AppSetup_InitLiteDB
    {
        private static AppSetup_InitLiteDB _createInstance = null;

        public static AppSetup_InitLiteDB CreateInstance
        {
            get
            {
                if (null == _createInstance)
                {
                    _createInstance = new AppSetup_InitLiteDB();
                }
                return _createInstance;
            }
        }


        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitLiteDB));

        /// <summary>
        /// 描述
        /// </summary>
        public static string Detail { get; } = "应用程序启动 -- 初始化LiteDB";


        /// <summary>
        /// CBA数据库Context
        /// </summary>
        public static LocalDbContext localDbContext { get; set; }

        public static HttpUrlConfigEntity HttpUrlConfigEntity { get; set; }

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public AppSetup_InitLiteDB()
        {
            string folder = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "db");
            if (!System.IO.Directory.Exists(folder))
            {
                System.IO.Directory.CreateDirectory(folder);
            }

            string path = System.IO.Path.Combine(folder, "FootballCache.db");

            log.Error(path);
            localDbContext = new LocalDbContext(path);
            HttpUrlConfigEntity = localDbContext.HttpUrlConfig.FindAll().FirstOrDefault() ?? new HttpUrlConfigEntity();
        }
    }
}
