﻿using DevExpress.Xpf.Grid;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Common;
using VIZ.Package.Domain;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.WMCUP.Module
{
    /// <summary>
    /// 今日赛程
    /// </summary>
    public class FDayMatchViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(FDayMatchViewModel));

        /// <summary>
        /// 对象实例
        /// </summary>

        public static FDayMatchViewModel FDayMatchViewModelInstance = new FDayMatchViewModel();

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();


        public FDayMatchViewModel()
        {

            BtnCmd = new VCommand(BtnCommand);
            BtnMatchDayUp = new VCommand(BtnMatchDayUpData);

            PromptCommand = new VCommand(PromptCmd);
            ColumnChoiceCommand = new VCommand(ColumnChoice);
            ShowGridMenuCommand = new VCommand<GridMenuEventArgs>(ShowGridMenu);
            matchDate = DateTime.Today.ToShortDateString();
            GetSchedule();
  
        }

        private string matchDate;


        /// <summary>
        ///获取日期
        /// </summary>
        public string MatchDate
        {
            get { return matchDate; }
            set { matchDate = value; this.RaisePropertyChanged(nameof(MatchDate)); }
        }

        public VCommand BtnCmd { get; set; }

        public VCommand BtnMatchDayUp { get; set; }




        /// <summary>
        /// 获取今日赛程
        /// </summary>
        private void BtnCommand()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "女足世界杯日期：" + PluginConstant.Operate_Load);
            GetSchedule();
        }




        /// <summary>
        /// 构造指定日期赛程的数据
        /// </summary>
        private void BtnMatchDayUpData()
        {
            Log.Info("比赛日期上版和数据:" + CombineMatchData());
            //ApplicationDomainEx.VizEngineModel.STAGE_START("Default/JRSCBEN", "Data", CombineMatchData());
        }


        /// <summary>
        /// 今日赛程信息
        /// </summary>
        private ObservableCollection<Dayschedule> matchData;

        /// <summary>
        /// 绑定数据列表
        /// </summary>
        public ObservableCollection<Dayschedule> MatchData
        {
            get { return matchData; }

            set { matchData = value; this.RaisePropertyChanged(nameof(MatchData)); }
        }


        //private ObservableCollection<string> lightHigts=new ObservableCollection<string>()
        //{
        //    "不高亮",
        //    "高亮"
        //};


        //public ObservableCollection<string> LightHigts
        //{
        //    get
        //    {
        //        return lightHigts;
        //    }
        //    set { lightHigts = value; this.RaisePropertyChanged(nameof(LightHigts)); }

        //}

        //private string light;

        //public string Light
        //{
        //    get { return light; }
        //    set { light=value; this.RaisePropertyChanged(nameof(Light)); }
        //}




        private string title = "赛果预告";

        /// <summary>
        /// 标题
        /// </summary>
        public string Title
        {
            get { return title; }
            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }



        Dayschedules dayschedules = null;

        /// <summary>
        /// 获取赛程信息
        /// </summary>
        public async void GetSchedule()
        {
            try
            {

                string date = Convert.ToDateTime(matchDate).ToString("yyyy-MM-dd");

                dayschedules = new Dayschedules();
                dayschedules = await JsonModel.PostTomorrowMatch_Path(date);

                if (dayschedules == null || dayschedules.dayschedule == null) return;


                // matchData.AddRange(dayschedules.dayschedule);

                MatchData = new ObservableCollection<Dayschedule>();
                foreach (var dayschedule in dayschedules.dayschedule)
                {
                    //if (dayschedule.Status == "1")
                    //{
                    //    dayschedule.Status = "未开赛";
                    //}
                    //else if (dayschedule.Status == "2")
                    //{
                    //    dayschedule.Status = "进行中";
                    //}
                    //else if (dayschedule.Status == "3")
                    //{
                    //    dayschedule.Status = "进行中";
                    //}
                    //else if (dayschedule.Status == "4")
                    //{
                    //    dayschedule.Status = "已结束";
                    //}
                    //else if (dayschedule.Status == "5")
                    //{
                    //    dayschedule.Status = "延期";
                    //}

                    dayschedule.homeTeamLogo = dayschedule.homeNationName;
                    dayschedule.visitingTeamLogo = dayschedule.visitingNationName;

                    MatchData.Add(dayschedule);
                }
           
            }
            catch (Exception ex)
            {

                Log.Error(ex.Message);
            }

        }





        #region IsColumnChooserVisible -- 是否显示列选择器

        private bool isColumnChooserVisible;
        /// <summary>
        /// 是否显示列选择器
        /// </summary>
        public bool IsColumnChooserVisible
        {
            get { return isColumnChooserVisible; }
            set { isColumnChooserVisible = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible)); }
        }

        #endregion


        #region ColumnChoiceCommand -- 列选择命令

        /// <summary>
        /// 列选择命令
        /// </summary>
        public VCommand ColumnChoiceCommand { get; set; }

        /// <summary>
        /// 列选择
        /// </summary>
        private void ColumnChoice()
        {
            this.IsColumnChooserVisible = true;
        }

        #endregion


        #region ShowGridMenuCommand -- 显示列命令

        /// <summary>
        /// 显示列命令
        /// </summary>
        public VCommand<GridMenuEventArgs> ShowGridMenuCommand { get; set; }

        /// <summary>
        /// 显示列
        /// </summary>
        /// <param name="e">事件参数</param>
        private void ShowGridMenu(GridMenuEventArgs e)
        {
            GridControlHelper.RemoveAllDefaultMenuItem(e);
        }

        #endregion

        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "咪咕女足世界赛程：" + PluginConstant.Operate_Message);

            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
            if (dayschedules != null)
            {
                string onAirLastDate = $"赛程接口更新时间：{dayschedules.LastPushDataDateTime}";
                vm.OnErrorLogMessage(onAirLastDate);
            }

           
            //if (TeamSeasonData != null)
            //{
            //    string teamSeasonLastDate = $"球队赛季接口更新时间:{TeamSeasonData.LastPushDataDateTime}";
            //    vm.OnErrorLogMessage(teamSeasonLastDate);
            //}
            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;

            // messageLastRecordDate.ShowDialog();
        }

        #endregion



      



        /// <summary>
        /// 组装往包装发送得数据
        /// </summary>
        /// <returns></returns>
        public string CombineMatchData()
        {
            try

            {
                string data = "";
                data += title + "&";

                foreach (var tempMatchData in matchData)
                {
                    //data += "*";
                    if (string.IsNullOrEmpty(tempMatchData.time))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.time.Replace(" ", "");
                    }

                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.homeTeamLogo))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.homeTeamLogo.Replace(" ", "");
                    }


                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.homeNationName))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.homeTeamName.Replace(" ", "");
                    }

                    data += "*";

                    //if (string.IsNullOrEmpty(tempMatchData.homeTeamScore) &&string.IsNullOrEmpty(tempMatchData.visitingTeamScore))
                    //{
                       
                        data += "vs";
                    //}
                    //else
                    //{

                    //    data += string.Format("{0}:{1}",tempMatchData.homeTeamScore,tempMatchData.visitingTeamScore);
                    //}


                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.visitingNationName))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.visitingTeamName.Replace(" ", "");
                    }


                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.visitingTeamLogo))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.visitingTeamLogo.Replace(" ", "");
                    }

                    data += ";";
                }


                //foreach (var tempMatchData in matchData)
                //{
                //    if (tempMatchData.SelectLight == "不高亮")
                //    {
                //        data += "0";
                //    }
                //    else
                //    {
                //        data += "1";
                //    }
                //    data += "*";
                //    if (string.IsNullOrEmpty(tempMatchData.dates))
                //    {
                //        data += "";
                //    }
                //    else
                //    {
                //        data += tempMatchData.dates.Replace(" ", "");
                //    }

                //    data += "*";

                //    if (string.IsNullOrEmpty(tempMatchData.time))
                //    {
                //        data += "";
                //    }
                //    else
                //    {
                //        data += tempMatchData.time.Replace(" ", "");
                //    }

                //    data += "*";

                //    data += tempMatchData.HomeTeamName.Replace(" ", "");

                //    data += "*";

                //    if (string.IsNullOrEmpty(tempMatchData.HomeTeamScore))
                //    {
                //        data += "";
                //    }
                //    else
                //    {
                //        data += tempMatchData.HomeTeamScore.Replace(" ", "");
                //    }


                //    data += "*";
                //    data += tempMatchData.VisitingTeamName.Replace(" ", "");

                //    data += "*";

                //    if (string.IsNullOrEmpty(tempMatchData.VisitingTeamScore))
                //    {
                //        data += "";
                //    }
                //    else
                //    {
                //        data += tempMatchData.VisitingTeamScore.Replace(" ", "");
                //    }


                //    data += "*";

                //    if (string.IsNullOrEmpty(tempMatchData.Status))
                //    {
                //        data += "";
                //    }
                //    else
                //    {
                //        data += tempMatchData.Status.Replace(" ", "");
                //    }
                //    data += ";";
                //}

                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.ToString());
                return "";
            }
        }

    }
}
