﻿using DevExpress.Mvvm.POCO;
using DevExpress.Xpf.Grid;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Common;

namespace VIZ.TVP.WMCUP.Module
{
    public class FGTeamStandingViewModel:ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(FGTeamStandingViewModel));

        /// <summary>
        /// 
        /// </summary>
        public static FGTeamStandingViewModel FGTeamStandingViewModelInstance = new FGTeamStandingViewModel();
        public FGTeamStandingViewModel()
        {
            //初始化方法
            Init();
        }

        /// <summary>
        /// 球队绑定数据集合
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModel;
        public ObservableCollection<Teamrank> TeamRanksModel
        {
            get { return teamRanksModel; }

            set { teamRanksModel = value; this.RaisePropertyChanged(nameof(TeamRanksModel)); }
        }




        /// <summary>
        /// 球队绑定数据集合A
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModelA;
        public ObservableCollection<Teamrank> TeamRanksModelA
        {
            get { return teamRanksModelA; }

            set { teamRanksModelA = value; this.RaisePropertyChanged(nameof(TeamRanksModelA)); }
        }


        /// <summary>
        /// 球队绑定数据集合B
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModelB;
        public ObservableCollection<Teamrank> TeamRanksModelB
        {
            get { return teamRanksModelB; }

            set { teamRanksModelB = value; this.RaisePropertyChanged(nameof(TeamRanksModelB)); }
        }

        /// <summary>
        /// 球队绑定数据集合C
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModelC;
        public ObservableCollection<Teamrank> TeamRanksModelC
        {
            get { return teamRanksModelC; }

            set { teamRanksModelC = value; this.RaisePropertyChanged(nameof(TeamRanksModelC)); }
        }

        /// <summary>
        /// 球队绑定数据集合D
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModelD;
        public ObservableCollection<Teamrank> TeamRanksModelD
        {
            get { return teamRanksModelD; }

            set { teamRanksModelD = value; this.RaisePropertyChanged(nameof(TeamRanksModelD)); }
        }


        /// <summary>
        /// 球队绑定数据集合E
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModelE;
        public ObservableCollection<Teamrank> TeamRanksModelE
        {
            get { return teamRanksModelE; }

            set { teamRanksModelE = value; this.RaisePropertyChanged(nameof(TeamRanksModelE)); }
        }



        /// <summary>
        /// 球队绑定数据集合F
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModelF;
        public ObservableCollection<Teamrank> TeamRanksModelF
        {
            get { return teamRanksModelF; }

            set { teamRanksModelF = value; this.RaisePropertyChanged(nameof(TeamRanksModelF)); }
        }


        /// <summary>
        /// 球队绑定数据集合G
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModelG;
        public ObservableCollection<Teamrank> TeamRanksModelG
        {
            get { return teamRanksModelG; }

            set { teamRanksModelG = value; this.RaisePropertyChanged(nameof(TeamRanksModelG)); }
        }





        /// <summary>
        /// 球队绑定数据集合H
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModelH;
        public ObservableCollection<Teamrank> TeamRanksModelH
        {
            get { return teamRanksModelH; }

            set { teamRanksModelH = value; this.RaisePropertyChanged(nameof(TeamRanksModelH)); }
        }



        public VCommand BtnCmd { get; set; }


        TeamRanks teamStands = null;


        /// <summary>
        /// 刷新球队积分排名
        /// </summary>
        private async void BtmCommand()
        {
            teamStands = new TeamRanks();
            TeamRanksModel = new ObservableCollection<Teamrank>();

            // "A组","B组","C组","D组","E组","F组","G组","H组"
            teamStands = await JsonModel.PostTeamScoreData_Path("A组");

            if (teamStands == null) return;
            TeamRanksModelA = new ObservableCollection<Teamrank>();

            foreach (var teamRank in teamStands.teamstats)
            {
                //teamRank.teamLogo = teamRank.teamName;

                TeamRanksModelA.Add(teamRank);
                TeamRanksModel.Add(teamRank);

            }


            teamStands = await JsonModel.PostTeamScoreData_Path("B组");

            if (teamStands == null) return;
            TeamRanksModelB = new ObservableCollection<Teamrank>();

            foreach (var teamRank in teamStands.teamstats)
            {
                //teamRank.teamLogo = teamRank.teamName;

                TeamRanksModelB.Add(teamRank);
                TeamRanksModel.Add(teamRank);

            }



            teamStands = await JsonModel.PostTeamScoreData_Path("C组");

            if (teamStands == null) return;
            TeamRanksModelC = new ObservableCollection<Teamrank>();

            foreach (var teamRank in teamStands.teamstats)
            {
                //teamRank.teamLogo = teamRank.teamName;

                TeamRanksModelC.Add(teamRank);
                TeamRanksModel.Add(teamRank);

            }



            teamStands = await JsonModel.PostTeamScoreData_Path("D组");

            if (teamStands == null) return;
            TeamRanksModelD = new ObservableCollection<Teamrank>();

            foreach (var teamRank in teamStands.teamstats)
            {
                //teamRank.teamLogo = teamRank.teamName;

                TeamRanksModelD.Add(teamRank);
                TeamRanksModel.Add(teamRank);

            }


            teamStands = await JsonModel.PostTeamScoreData_Path("E组");

            if (teamStands == null) return;
            TeamRanksModelE = new ObservableCollection<Teamrank>();

            foreach (var teamRank in teamStands.teamstats)
            {
                //teamRank.teamLogo = teamRank.teamName;

                TeamRanksModelE.Add(teamRank);
                TeamRanksModel.Add(teamRank);

            }



            teamStands = await JsonModel.PostTeamScoreData_Path("F组");

            if (teamStands == null) return;
            TeamRanksModelF = new ObservableCollection<Teamrank>();

            foreach (var teamRank in teamStands.teamstats)
            {
                //teamRank.teamLogo = teamRank.teamName;

                TeamRanksModelF.Add(teamRank);
                TeamRanksModel.Add(teamRank);

            }




            teamStands = await JsonModel.PostTeamScoreData_Path("G组");

            if (teamStands == null) return;
            TeamRanksModelG = new ObservableCollection<Teamrank>();

            foreach (var teamRank in teamStands.teamstats)
            {
                //teamRank.teamLogo = teamRank.teamName;

                TeamRanksModelG.Add(teamRank);
                TeamRanksModel.Add(teamRank);

            }



            teamStands = await JsonModel.PostTeamScoreData_Path("H组");

            if (teamStands == null) return;
            TeamRanksModelH = new ObservableCollection<Teamrank>();

            foreach (var teamRank in teamStands.teamstats)
            {
                //teamRank.teamLogo = teamRank.teamName;

                TeamRanksModelH.Add(teamRank);
                TeamRanksModel.Add(teamRank);

            }



        }

        /// <summary>
        /// 组装积分排名数据上传
        /// </summary>
        /// <returns></returns>
        public string CombineTeamStandingData()
        {
            try
            {

                string data = "";

                data += title;

                data += "&";


                data += "A组";
                foreach (var tempTeamRankModel in TeamRanksModelA)
                {
                    
                    data += "*";
                    data += tempTeamRankModel.teamName;
                    data += "*";
                    data += tempTeamRankModel.score;
                }
                data += ";";

                data += "B组";
                foreach (var tempTeamRankModel in TeamRanksModelB)
                {
                   
                    data += "*";
                    data += tempTeamRankModel.teamName;
                    data += "*";
                    data += tempTeamRankModel.score;
                }
                data += ";";

                data += "C组";
                foreach (var tempTeamRankModel in TeamRanksModelC)
                {
                   
                    data += "*";
                    data += tempTeamRankModel.teamName;
                    data += "*";
                    data += tempTeamRankModel.score;
                }
                data += ";";


                data += "D组";
                foreach (var tempTeamRankModel in TeamRanksModelD)
                {
                   
                    data += "*";
                    data += tempTeamRankModel.teamName;
                    data += "*";
                    data += tempTeamRankModel.score;
                }
                data += ";";

                data += "E组";
                foreach (var tempTeamRankModel in TeamRanksModelE)
                {
                   
                    data += "*";
                    data += tempTeamRankModel.teamName;
                    data += "*";
                    data += tempTeamRankModel.score;
                }
                data += ";";


                data += "F组";
                foreach (var tempTeamRankModel in TeamRanksModelF)
                {
                   
                    data += "*";
                    data += tempTeamRankModel.teamName;
                    data += "*";
                    data += tempTeamRankModel.score;
                }
                data += ";";

                data += "G组";
                foreach (var tempTeamRankModel in TeamRanksModelG)
                {
                  
                    data += "*";
                    data += tempTeamRankModel.teamName;
                    data += "*";
                    data += tempTeamRankModel.score;
                }
                data += ";";

                data += "H组";
                foreach (var tempTeamRankModel in TeamRanksModelH)
                {
                   
                    data += "*";
                    data += tempTeamRankModel.teamName;
                    data += "*";
                    data += tempTeamRankModel.score;
                }

                Log.Info("全量小组积分发送数据====>" + data);
                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }


        private string title = "积分榜";

        public string Title
        {
            get { return title; }
            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }


     

        /// <summary>
        /// 初始话
        /// </summary>
        private void Init()
        {
            BtnCmd = new VCommand(BtmCommand);

            PromptCommand = new VCommand(PromptCmd);

            ColumnChoiceCommand = new VCommand(ColumnChoice);
            ShowGridMenuCommand = new VCommand<GridMenuEventArgs>(ShowGridMenu);

            //FoolballType = DateHeaderViewModel.FoolballType;
            //SeasonId = DateHeaderViewModel.SeasonId;

        }


        #region IsColumnChooserVisible -- 是否显示列选择器

        private bool isColumnChooserVisible;
        /// <summary>
        /// 是否显示列选择器
        /// </summary>
        public bool IsColumnChooserVisible
        {
            get { return isColumnChooserVisible; }
            set { isColumnChooserVisible = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible)); }
        }

        #endregion


        #region ColumnChoiceCommand -- 列选择命令

        /// <summary>
        /// 列选择命令
        /// </summary>
        public VCommand ColumnChoiceCommand { get; set; }

        /// <summary>
        /// 列选择
        /// </summary>
        private void ColumnChoice()
        {
            this.IsColumnChooserVisible = true;
        }

        #endregion


        #region ShowGridMenuCommand -- 显示列命令

        /// <summary>
        /// 显示列命令
        /// </summary>
        public VCommand<GridMenuEventArgs> ShowGridMenuCommand { get; set; }

        /// <summary>
        /// 显示列
        /// </summary>
        /// <param name="e">事件参数</param>
        private void ShowGridMenu(GridMenuEventArgs e)
        {
            GridControlHelper.RemoveAllDefaultMenuItem(e);
        }

        #endregion

        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {

            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
            if (teamStands != null)
            {
                string LastDate = $"女足世界杯积分接口更新时间：{teamStands.LastPushDataDateTime}";
                vm.OnErrorLogMessage(LastDate);
            }


            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;
        }

        #endregion
    }
}
