﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Module;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.WMCUP.Module
{
    /// <summary>
    /// FSinglePlayerView.xaml 的交互逻辑
    /// </summary>
    public partial class FSinglePlayerView : UserControl, IPluginView
    {

        FSinglePlayerViewModel vm = new FSinglePlayerViewModel();

        private static ILog Log = LogManager.GetLogger(typeof(FSinglePlayerViewModel));



        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        public FSinglePlayerView()
        {
            InitializeComponent();

            WPFHelper.BindingViewModel(this, vm);
            FSinglePlayerViewModel.FSinglePlayerInstance.Add(vm);


            this.Loaded += NewSinglePlayerView_Loaded;
            this.IsVisibleChanged += NewSinglePlayerView_IsVisibleChanged;


        }


        private void NewSinglePlayerView_IsVisibleChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            if (!string.IsNullOrEmpty(vm.homeTeamId) && !string.IsNullOrEmpty(vm.visitTeamId))
            {
                vm.SetTeamData();
            }
        }

        private void NewSinglePlayerView_Loaded(object sender, RoutedEventArgs e)
        {
            var service = ApplicationDomainEx.ServiceManager.GetService<IPluginService>(ViewServiceKeys.PLUGIN_SERVICE);
            if (service == null)
                return;
            vm.page = service.GetPageModelFromView(this);

        }

        public void Dispose()
        {

        }

        public void PreviewContinue(ConnModel conn)
        {

        }

        public void PreviewIn(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_PREVIEW_PLAY);
            if (conn.IsConnected)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamComData()));
                Log.Info("已经发送命令===>" + vm.CombineTeamComData());
                
            }
        }

        public void PreviewOut(ConnModel conn)
        {
            //if(conn.IsConnected)
            // {
            //     conn.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            // }
        }

        public void TakeContinue(ConnModel conns)
        {

        }

        public void TakeOut(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_OUT);
            if (conns.IsConnected)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        public void TakeUpdate(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_UPDATE);
            if (conns.IsConnected)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamComData()));
            }
        }

        public void TakIn(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_TAKE);
            if (conns.IsConnected)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamComData()));
            }
        }


      
     

        public void PageOpend(ConnModel conn, PageModel page)
        {
            if (conn.IsConnected)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamComData()));
            }
        }

        public void PreviewUpdate(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_PREVIEW_UPDATE);
            if (conn.IsConnected)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamComData()));
            }
        }






    }
}
