﻿using DevExpress.Xpf.Grid;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Common;

namespace VIZ.TVP.WMCUP.Module
{
    /// <summary>
    /// 积分排名
    /// </summary>
    public class FTeamStandingViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(FTeamStandingViewModel));

        /// <summary>
        /// 
        /// </summary>
        public static FTeamStandingViewModel FTeamStandingViewModelInstance = new FTeamStandingViewModel();
        public FTeamStandingViewModel()
        {
            //初始化方法
            Init();
        }

        /// <summary>
        /// 球队绑定数据集合
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModel;
        public ObservableCollection<Teamrank> TeamRanksModel
        {
            get { return teamRanksModel; }

            set { teamRanksModel = value; this.RaisePropertyChanged(nameof(TeamRanksModel)); }
        }

        public VCommand BtnCmd { get; set; }


        TeamRanks teamStands = null;


        /// <summary>
        /// 刷新球队积分排名
        /// </summary>
        private async void BtmCommand()
        {
            teamStands = new TeamRanks();

           
            teamStands = await JsonModel.PostTeamScoreData_Path(SelectGroupItem);

            if (teamStands == null) return;
            TeamRanksModel = new ObservableCollection<Teamrank>();

            foreach (var teamRank in teamStands.teamstats)
            {
                teamRank.teamLogo = teamRank.teamName;

                TeamRanksModel.Add(teamRank);

            }
        }

        /// <summary>
        /// 组装积分排名数据上传
        /// </summary>
        /// <returns></returns>
        public string CombineTeamStandingData()
        {
            try
            {

                string data = "";

                data += title;

                data += "&";

                

                foreach (var tempTeamRankModel in TeamRanksModel)
                {
                    //i++;
                    //data += tempTeamRankModel.rank.ToString().Replace(" ", "");

                    data += tempTeamRankModel.nationName.Replace(" ", "");

                    data += "*";
                    data += tempTeamRankModel.teamName.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.matchNum.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.winNum.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.drawNum.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.loseNum.ToString().Replace(" ", "");


                    data += "*";

                    if (string.IsNullOrEmpty(tempTeamRankModel.goaldifference))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempTeamRankModel.goaldifference.Replace(" ", "");
                    }


                    data += "*";

                    if (string.IsNullOrEmpty(tempTeamRankModel.score))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempTeamRankModel.score.Replace(" ", "");
                    }

                    data += "*";
                    data += tempTeamRankModel.rank.ToString().Replace(" ", "");
                    data += ";";

                }

                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }


        private string title = "积分榜";

        public string Title
        {
            get { return title; }
            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }


        /// <summary>
        /// 小组积分分组
        /// </summary>

        private ObservableCollection<string> groupItems;
        public ObservableCollection<string> GroupItems
        {
            get {return groupItems;}
            set { groupItems = value;this.RaisePropertyChanged(nameof(GroupItems)); }
        }


        /// <summary>
        /// 选中的分组
        /// </summary>
        private string  selectGroupItem="A组";

        public string SelectGroupItem
        {
            get { return selectGroupItem; }
            set { selectGroupItem = value; this.RaisePropertyChanged(nameof(SelectGroupItem)); }
        }



        /// <summary>
        /// 足球赛事类型
        /// </summary>
        public string FoolballType = "";

        /// <summary>
        /// 赛季ID
        /// </summary>
        public string SeasonId = "";


        /// <summary>
        /// 初始话
        /// </summary>
        private void Init()
        {
            BtnCmd = new VCommand(BtmCommand);

            PromptCommand = new VCommand(PromptCmd);

            ColumnChoiceCommand = new VCommand(ColumnChoice);
            ShowGridMenuCommand = new VCommand<GridMenuEventArgs>(ShowGridMenu);

            //FoolballType = DateHeaderViewModel.FoolballType;
            //SeasonId = DateHeaderViewModel.SeasonId;

            GroupItems = new ObservableCollection<string>()
            {
                "A组","B组","C组","D组","E组","F组","G组","H组"
            };
        }


        #region IsColumnChooserVisible -- 是否显示列选择器

        private bool isColumnChooserVisible;
        /// <summary>
        /// 是否显示列选择器
        /// </summary>
        public bool IsColumnChooserVisible
        {
            get { return isColumnChooserVisible; }
            set { isColumnChooserVisible = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible)); }
        }

        #endregion


        #region ColumnChoiceCommand -- 列选择命令

        /// <summary>
        /// 列选择命令
        /// </summary>
        public VCommand ColumnChoiceCommand { get; set; }

        /// <summary>
        /// 列选择
        /// </summary>
        private void ColumnChoice()
        {
            this.IsColumnChooserVisible = true;
        }

        #endregion


        #region ShowGridMenuCommand -- 显示列命令

        /// <summary>
        /// 显示列命令
        /// </summary>
        public VCommand<GridMenuEventArgs> ShowGridMenuCommand { get; set; }

        /// <summary>
        /// 显示列
        /// </summary>
        /// <param name="e">事件参数</param>
        private void ShowGridMenu(GridMenuEventArgs e)
        {
            GridControlHelper.RemoveAllDefaultMenuItem(e);
        }

        #endregion

        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {

            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
            if (teamStands != null)
            {
                string LastDate = $"女足世界杯积分接口更新时间：{teamStands.LastPushDataDateTime}";
                vm.OnErrorLogMessage(LastDate);
            }


            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;
        }

        #endregion

    }
}
