﻿using DevExpress.Mvvm.POCO;
using DevExpress.Xpf.Grid;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Common;
using VIZ.Package.Domain;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.WMCUP.Module
{
    /// <summary>
    /// 足球查看界面配置
    /// </summary>
    public class DateHeaderViewModel : ViewModelBase
    {

        public DateHeaderViewModel()
        {

            matchDate = DateTime.Today.ToShortDateString();


            UpDateCmd = new VCommand(UpDate);
            DownDateCmd = new VCommand(DownDate);


            InitRound();


            //InitTeam();
            //InitShoot();
        }


        /// <summary>
        /// 记录log日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(DateHeaderViewModel));


        private static AppSetup_InitLiteDB appSetup_InitCBALiteDB = AppSetup_InitLiteDB.CreateInstance;

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        public static string HomeTeamId;

        public static string VisitTeamId;


        public static string HomeNationName;

        public static string VisitingNationName;


        public static string HomeTeamName;

        public static string VisitingTeamName;

        public static string MatchId;

        /// <summary>
        /// 主数据库连接
        /// </summary>
        private bool mainDataConnection = true;
        public bool MainDataConnection
        {
            get { return mainDataConnection; }
            set
            {
                this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看主数据连接");

                mainDataConnection = value;
                this.RaisePropertyChanged(nameof(MainDataConnection));

                if (mainDataConnection)
                {
                    //JsonModel.strUrl = AppSetup_InitLiteDB.HttpUrlConfigEntity.Url;
                    //JsonModel.appKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppKey;
                    //JsonModel.appID = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppId;
                    JsonModel.dataFromSource = true;
                    JsonModel.GethttpUrl();
                }
            }
        }



        private Dayschedule selectMatchData;

        public Dayschedule SelectMatchData
        {
            get { return selectMatchData; }

            set
            {
                selectMatchData = value;
                this.RaisePropertyChanged(nameof(SelectMatchData));

                if (value == null)
                {
                    this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "女足世界杯查看界面赛事没有选中一条赛事记录");
                    //ClearData();
                    return;
                }
                this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "女足世界杯查看选择赛程：" + value.homeTeamName + "VS" + value.visitingTeamName);



                //onAirDataModel = JsonModel.PostOnAirData_Path(selectMatchData.ScheduleID);

                //SetTeamStatsData();
                //GetSeasonData();

                //TeamHName = value.HomeTeamName;

                // TeamAName = value.VisitingTeamName;


                //ScheduleID = selectMatchData.ScheduleID;
                //Matchtypeid = selectMatchData.ScheduleTypeID;

                #region 球队统计信息



                HomeTeamId = selectMatchData.homeTeamId;
                VisitTeamId= selectMatchData.visitTeamId;

                MatchId = selectMatchData.matchId;

                if (FTeamHistoryCompareViewModel.TeamStatsHistoryInstance.Count > 0)
                {
                    // Log.Error(string.Format("TeamStatsViewModel.CreateInstance Count:{0}", TeamStatsViewModel.TeamStatsViewModelInstance.Count));
                    foreach (var tempTeamStatsViewModel in FTeamHistoryCompareViewModel.TeamStatsHistoryInstance)
                    {
                        // if(ApplicationDomainEx.CurrentPage == page;
                        // TeamStatsViewModel teamStatsViewModel = tempTeamStatsViewModel;
                        // Log.Error("DateHeaderViewModel_CreateTeamStatsViewModel");


                        tempTeamStatsViewModel.homeTeamId = selectMatchData.homeTeamId;
                        tempTeamStatsViewModel.visitTeamId = selectMatchData.visitTeamId;




                        // Log.Error(string.Format("DateHeader_ScheduleId:{0}", selectMatchData.ScheduleID));
                        //Log.Error(string.Format("DateHeader_ScheduleTypeId:{0}", selectMatchData.ScheduleTypeID));

                        if (tempTeamStatsViewModel.page != null && ApplicationDomainEx.CurrentPage == tempTeamStatsViewModel.page)
                        {
                            tempTeamStatsViewModel.SetTeamData();
                        }
                    }

                }


                // if (NewTeamStatsViewModel.TeamStatsViewModelInstance.Count > 0)
                {
                    //foreach (var tempTeamStatsViewModel in NewTeamStatsViewModel.TeamStatsViewModelInstance)
                    //{
                    //    tempTeamStatsViewModel.ScheduleID = selectMatchData.ScheduleID;
                    //    tempTeamStatsViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                    //    if (tempTeamStatsViewModel.page != null && ApplicationDomainEx.CurrentPage == tempTeamStatsViewModel.page)
                    //    {


                    //        tempTeamStatsViewModel.SetTeamData();
                    //    }

                    //}
                }


                #endregion



                #region 球队任务统计信息


                //if (TeamStatsViewModel.TeamStatsViewModelInstance.Count>0)
                //{
                //   // Log.Error(string.Format("TeamStatsViewModel.CreateInstance Count:{0}", TeamStatsViewModel.TeamStatsViewModelInstance.Count));
                //    foreach(var tempTeamStatsViewModel in TeamStatsViewModel.TeamStatsViewModelInstance)
                //    {
                //       // if(ApplicationDomainEx.CurrentPage == page;
                //        // TeamStatsViewModel teamStatsViewModel = tempTeamStatsViewModel;
                //        // Log.Error("DateHeaderViewModel_CreateTeamStatsViewModel");
                //        tempTeamStatsViewModel.ScheduleID = selectMatchData.ScheduleID;
                //        tempTeamStatsViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                //       // Log.Error(string.Format("DateHeader_ScheduleId:{0}", selectMatchData.ScheduleID));
                //        //Log.Error(string.Format("DateHeader_ScheduleTypeId:{0}", selectMatchData.ScheduleTypeID));
                //        tempTeamStatsViewModel.SetTeamData();
                //    }

                //}


                //if (TeamStatsTaskViewModel.TeamStatsTaskViewModelInstance.Count > 0)
                //{
                //    foreach (var tempTeamStatsViewModel in TeamStatsTaskViewModel.TeamStatsTaskViewModelInstance)
                //    {
                //        tempTeamStatsViewModel.ScheduleID = selectMatchData.ScheduleID;
                //        tempTeamStatsViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                //        if (tempTeamStatsViewModel.page != null && ApplicationDomainEx.CurrentPage == tempTeamStatsViewModel.page)
                //        {


                //            tempTeamStatsViewModel.SetTeamData();
                //        }

                //    }
                //}


                #endregion

                #region 单个球员信息

                //if(SinglePlayerViewModel.SinglePlayerViewModelInstance.Count>0)
                //{

                //    foreach(var tempSinglePlayerViewModel in SinglePlayerViewModel.SinglePlayerViewModelInstance)
                //    {
                //        tempSinglePlayerViewModel.ScheduleID = selectMatchData.ScheduleID;
                //        tempSinglePlayerViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                //        tempSinglePlayerViewModel.SetSingleData();
                //    }

                //}


                HomeNationName= selectMatchData.homeNationName;
                VisitingNationName= selectMatchData.visitingNationName;

                HomeTeamName = selectMatchData.homeTeamName;
                VisitingTeamName = selectMatchData.visitingTeamName;    


                if (FSinglePlayerViewModel.FSinglePlayerInstance.Count > 0)
                {
                    Log.Info("单球员开始时间");
                    foreach (var tempSinglePlayerViewModel in FSinglePlayerViewModel.FSinglePlayerInstance)
                    {
                        // tempSinglePlayerViewModel.ScheduleID = selectMatchData.ScheduleID;
                        // tempSinglePlayerViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;


                        tempSinglePlayerViewModel.homeTeamId = selectMatchData.homeTeamId;
                        tempSinglePlayerViewModel.visitTeamId = selectMatchData.visitTeamId;

                        //主队国家名称
                        tempSinglePlayerViewModel.homeNationTeam = selectMatchData.homeNationName;
                        //客队国家名称
                        tempSinglePlayerViewModel.awayNationTeam = selectMatchData.visitingNationName;

                        //比赛id

                        tempSinglePlayerViewModel.matchId = selectMatchData.matchId;    


                        if(tempSinglePlayerViewModel.TeamItems!=null)
                        {
                            tempSinglePlayerViewModel.TeamItems.Clear();
                        }
                        tempSinglePlayerViewModel.TeamItems = new ObservableCollection<string>();


                        tempSinglePlayerViewModel.TeamItems.Add(selectMatchData.homeTeamName);
                        tempSinglePlayerViewModel.TeamItems.Add(selectMatchData.visitingTeamName);

                        tempSinglePlayerViewModel.SelectedIndex = 0;



                        if (tempSinglePlayerViewModel.page != null && ApplicationDomainEx.CurrentPage == tempSinglePlayerViewModel.page)
                        {

                            tempSinglePlayerViewModel.SetTeamData();
                        }

                    }

                    Log.Info("单球员开始结束时间");
                }



                #endregion

                #region Mvp球员信息

                //if (MvpPlayerViewModel.MvpPlayerViewModelInstance.Count > 0)
                //{
                //    foreach (var tempSinglePlayerViewModel in MvpPlayerViewModel.MvpPlayerViewModelInstance)
                //    {
                //        tempSinglePlayerViewModel.ScheduleID = selectMatchData.ScheduleID;
                //        tempSinglePlayerViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                //        if (tempSinglePlayerViewModel.page != null && ApplicationDomainEx.CurrentPage == tempSinglePlayerViewModel.page)
                //        {

                //            tempSinglePlayerViewModel.SetSingleData();
                //        }

                //    }
                //}

                #endregion

                #region 球员对比信息


                if(FComparePlayerViewModel.PlayerCompareViewModelInstance.Count>0)
                {

                    Log.Info("开始球员对比信息");
                    foreach (var tempSinglePlayerViewModel in FComparePlayerViewModel.PlayerCompareViewModelInstance)
                    {
                        // tempSinglePlayerViewModel.ScheduleID = selectMatchData.ScheduleID;
                        // tempSinglePlayerViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;


                        tempSinglePlayerViewModel.homeTeamId = selectMatchData.homeTeamId;
                        tempSinglePlayerViewModel.visitTeamId = selectMatchData.visitTeamId;

                        //主队国家名称
                        tempSinglePlayerViewModel.homeNationTeam = selectMatchData.homeNationName;
                        //客队国家名称
                        tempSinglePlayerViewModel.awayNationTeam = selectMatchData.visitingNationName;

                        //主队客数据对比
                        tempSinglePlayerViewModel.HName = selectMatchData.homeTeamName;
                        tempSinglePlayerViewModel.AName = selectMatchData.visitingTeamName;

                        //比赛赛事Id
                        tempSinglePlayerViewModel.matchId = selectMatchData.matchId;    

                        if (tempSinglePlayerViewModel.page != null && ApplicationDomainEx.CurrentPage == tempSinglePlayerViewModel.page)
                        {
                            tempSinglePlayerViewModel.SetTeamData();
                        }

                    }
                    Log.Info("结束球员对比信息");
                }

                //if(PlayerCompareViewModel.PlayerCompareViewModelInstance.Count>0)
                //{
                //    foreach(var playerCompareViewModel in PlayerCompareViewModel.PlayerCompareViewModelInstance)
                //    {
                //        //PlayerCompareViewModel playerCompareViewModel = PlayerCompareViewModel.CreateInstance;

                //        playerCompareViewModel.ScheduleID = selectMatchData.ScheduleID;
                //        playerCompareViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                //        playerCompareViewModel.SetCompareData();
                //    }

                //}


                //if (NewPlayerComPareViewModel.PlayerCompareViewModelInstance.Count > 0)
                //{
                //    foreach (var playerCompareViewModel in NewPlayerComPareViewModel.PlayerCompareViewModelInstance)
                //    {
                //        playerCompareViewModel.ScheduleID = selectMatchData.ScheduleID;
                //        playerCompareViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                //        //PlayerCompareViewModel playerCompareViewModel = PlayerCompareViewModel.CreateInstance;
                //        if (playerCompareViewModel.page != null && ApplicationDomainEx.CurrentPage == playerCompareViewModel.page)
                //        {

                //            playerCompareViewModel.SetCompareData();
                //        }
                //    }

                //}

                //#region  双球员————任务

                //if (PlayerComPareViewModelTask.PlayerCompareViewModelTaskInstance.Count > 0)
                //{
                //    foreach (var playerCompareViewModel in PlayerComPareViewModelTask.PlayerCompareViewModelTaskInstance)
                //    {
                //        playerCompareViewModel.ScheduleID = selectMatchData.ScheduleID;
                //        playerCompareViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                //        //PlayerCompareViewModel playerCompareViewModel = PlayerCompareViewModel.CreateInstance;
                //        if (playerCompareViewModel.page != null && ApplicationDomainEx.CurrentPage == playerCompareViewModel.page)
                //        {

                //            playerCompareViewModel.SetCompareData();
                //        }
                //    }

                //}

                #endregion 双球员---任务


                #region 首发队员

                if(FFormationViewModel.FFormationViewModelInstance!=null)
                {
                    FFormationViewModel.FFormationViewModelInstance.homeTeamId = selectMatchData.homeTeamId;
                    FFormationViewModel.FFormationViewModelInstance.visitTeamId = selectMatchData.visitTeamId;

                    //主队国家名称
                    FFormationViewModel.FFormationViewModelInstance.homeNationTeam = selectMatchData.homeNationName;
                    //客队国家名称
                    FFormationViewModel.FFormationViewModelInstance.awayNationTeam = selectMatchData.visitingNationName;

                    FFormationViewModel.FFormationViewModelInstance.matchId = selectMatchData.matchId;

                    FFormationViewModel.FFormationViewModelInstance.TeamItems = new ObservableCollection<string>();

                    FFormationViewModel.FFormationViewModelInstance.TeamItems.Add(selectMatchData.homeTeamName);
                    FFormationViewModel.FFormationViewModelInstance.TeamItems.Add(selectMatchData.visitingTeamName);

                    FFormationViewModel.FFormationViewModelInstance.SelectedIndex = 0;

                    if (FFormationViewModel.FFormationViewModelInstance.page != null && ApplicationDomainEx.CurrentPage == FFormationViewModel.FFormationViewModelInstance.page)
                    {
                        FFormationViewModel.FFormationViewModelInstance.SetTeamData();
                    }

                }

                #endregion

                //设置球队赛季数据
                // GetTeamSeasonData();
                // #endregion
            }
        }




        /// <summary>
        /// 备份数据连接
        /// </summary>
        private bool backDataConnection;

        public bool BackDataConnection
        {
            get { return backDataConnection; }
            set
            {
                this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "女足世界杯查看备数据连接");
                backDataConnection = value;
                this.RaisePropertyChanged(nameof(BackDataConnection));
                if (backDataConnection)
                {
                    //JsonModel.strUrl = AppSetup_InitLiteDB.HttpUrlConfigEntity.BUrl;
                    //JsonModel.appKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.BAppKey;
                    //JsonModel.appID = AppSetup_InitLiteDB.HttpUrlConfigEntity.BAppId;
                    JsonModel.dataFromSource = false;
                    JsonModel.GethttpUrl();
                }
            }
        }




        /// <summary>
        /// 足球赛事类型
        /// </summary>
        public static string FoolballType = "";

        /// <summary>
        /// 赛季ID
        /// </summary>
        public static string SeasonId = "";


        ///// <summary>
        ///// 足球类型选择
        ///// </summary>
        //private ObservableCollection<string> footballTypes;

        //public ObservableCollection<string> FootballTypes
        //{
        //    get { return footballTypes; }
        //    set { footballTypes = value; this.RaisePropertyChanged(nameof(FootballTypes)); }
        //}


        ///// <summary>
        /////  选择的足球比赛
        ///// </summary>
        //private string selectFootballType;

        //public string SelectFootballType
        //{
        //    get { return selectFootballType; }
        //    set
        //    {
        //        selectFootballType = value;
        //        this.RaisePropertyChanged(nameof(SelectFootballType));

        //        this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看选择比赛类型:" + selectFootballType);

        //        //FDayMatchViewModel.FDayMatchViewModelInstance.FoolballType = selectFootballType;
        //        //FTeamStandingViewModel.FTeamStandingViewModelInstance.FoolballType = selectFootballType;
        //        //ShootPlayerRankViewModel.ShootPlayerRanklInstance.FoolballType = selectFootballType;
        //        FoolballType = selectFootballType;

        //    }
        //}


        #region 轮次赛程


        /// <summary>
        /// 比赛日期
        /// </summary>

        private string matchDate;

        public string MatchDate
        {
            get { return matchDate; }
            set
            {
                matchDate = value;
                this.RaisePropertyChanged(nameof(MatchDate));
               // GetSchedule();
            }
        }



        /// <summary>
        /// 上一天
        /// </summary>
        public VCommand UpDateCmd { get; set; }


        /// <summary>
        /// 下一天
        /// </summary>
        public VCommand DownDateCmd { get; set; }


        /// <summary>
        /// 上一天
        /// </summary>
        private void UpDate()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "女足世界杯查看赛程上一天：" + PluginConstant.Operate_Load);
            MatchDate = Convert.ToDateTime(MatchDate).AddDays(-1).ToShortDateString();
            GetSchedule();

        }

        /// <summary>
        /// 下一天
        /// </summary>
        private void DownDate()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "女足世界杯查看赛程下一天：" + PluginConstant.Operate_Load);
            MatchDate = Convert.ToDateTime(MatchDate).AddDays(1).ToShortDateString();
            GetSchedule();
        }





        private async void GetSchedule()
        {

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Http, RecordLogTrigger.Human, "女足世界杯获取赛程接口：" + PluginConstant.Operate_Load);
            try

            {
               // MatchItems = new ObservableCollection<string>();
                string date = Convert.ToDateTime(matchDate).ToString("yyyy-MM-dd");

                var dayschedules = await JsonModel.PostTomorrowMatch_Path(date);

                if (dayschedules == null) return;
                matchData.AddRange(dayschedules.dayschedule);
                MatchData = new ObservableCollection<Dayschedule>();

                if (dayschedules != null)
                {
                    dayschedules.dayschedule = dayschedules.dayschedule.OrderBy(a => Convert.ToDateTime(a.time)).ToList();
                }

                foreach (var dayschedule in dayschedules.dayschedule)
                {

                    //dayschedule.homeTeamLogo = dayschedule.homeTeamName;
                    //dayschedule.visitingTeamLogo = dayschedule.visitingTeamLogo;
                    //if (dayschedule.Status == "1")
                    //{
                    //    dayschedule.Status = "未开赛";
                    //}
                    //else if (dayschedule.Status == "2")
                    //{
                    //    dayschedule.Status = "进行中";
                    //}
                    //else if (dayschedule.Status == "3")
                    //{
                    //    dayschedule.Status = "进行中";
                    //}
                    //else if (dayschedule.Status == "4")
                    //{
                    //    dayschedule.Status = "已结束";
                    //}
                    //else if (dayschedule.Status == "5")
                    //{
                    //    dayschedule.Status = "延期";
                    //}

                    //if (!SetMatchDict.ContainsKey(dayschedule.time + dayschedule.HomeTeamName
                    //            + "VS" + dayschedule.VisitingTeamName))
                    //{
                    //    SetMatchDict.Add(dayschedule.time + dayschedule.HomeTeamName
                    //                + "VS" + dayschedule.VisitingTeamName, dayschedule.ScheduleID);
                    //}

                    ////Matchtypeid = dayschedule.ScheduleTypeID;

                    //MatchItems.Add(dayschedule.time + dayschedule.HomeTeamName
                    //            + "VS" + dayschedule.VisitingTeamName);

                    MatchData.Add(dayschedule);

                }
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
            }
        }




        /// <summary>
        /// 今日赛程轮次
        /// </summary>
        public VCommand BtnRoundCmd { get; set; }



        Dayschedules RoundMatchData = null;
        /// <summary>
        /// 添加轮次刷新
        /// </summary>
        private  void BtmRoundCommand()
        {


            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "女足世界杯查看赛程：" + PluginConstant.Operate_Load);
            GetSchedule();


            // SetRoundMatchData();

            //this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "获取比赛轮次:" + roundMatchItem.ToString() + " " + selectFootballType);

            //RoundMatchData = await JsonModel.PostTomorrowMatch_Path(roundMatchItem.ToString(), FoolballType);


            //if (RoundMatchData == null) return;



            //MatchData = new ObservableCollection<Dayschedule>();



            //foreach (var rudData in RoundMatchData.schedulelist)
            //{

            //    Dayschedule d = new Dayschedule();


            //    d.round = rudData.round;
            //    d.dates = rudData.dates;
            //    d.time = rudData.time;
            //    d.homeTeamLogo = rudData.homeTeamName;
            //    d.homeTeamName = rudData.homeTeamName;
            //    d.homeTeamScore = rudData.homeTeamScore;

            //    d.visitingTeamScore = rudData.visitingTeamScore;
            //    d.visitingTeamName = rudData.visitingTeamName;
            //    d.visitingTeamLogo = rudData.visitingTeamName;

            //    d.matchId = rudData.matchId;
            //    d.competitionId = rudData.competitionId;

            //    if (rudData.status == "1")
            //    {
            //        d.status = "未开赛";
            //    }
            //    else if (rudData.status == "2")
            //    {
            //        d.status = "进行中";
            //    }
            //    else if (rudData.status == "3")
            //    {
            //        d.status = "进行中";
            //    }
            //    else if (rudData.status == "4")
            //    {
            //        d.status = "已结束";
            //    }
            //    else if (rudData.status == "5")
            //    {
            //        d.status = "延期";
            //    }


            //    MatchData.Add(d);
            //}


        }

        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        //public VCommand PromptCommand { get; set; }


        //MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        //private void PromptCmd()
        //{

        //    MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;


        //    if (RoundMatchData != null)
        //    {
        //        string teamSeasonLastDate = $"足球轮次接口更新时间:{RoundMatchData.LastPushDataDateTime}";
        //        vm.OnErrorLogMessage(teamSeasonLastDate);
        //    }
        //    messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
        //    messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;

        //    // messageLastRecordDate.ShowDialog();
        //}

        #endregion


        /// <summary>
        /// 轮次赛程信息
        /// </summary>
        private ObservableCollection<Dayschedule> matchData;

        /// <summary>
        /// 绑定数据列表
        /// </summary>
        public ObservableCollection<Dayschedule> MatchData
        {
            get { return matchData; }

            set { matchData = value; this.RaisePropertyChanged(nameof(MatchData)); }
        }



        /// <summary>
        /// 初始化方法
        /// </summary>
        private void InitRound()
        {

            BtnRoundCmd = new VCommand(BtmRoundCommand);
            //PromptCommand = new VCommand(PromptCmd);

            ColumnChoiceCommand = new VCommand(ColumnChoice);
            ShowGridMenuCommand = new VCommand<GridMenuEventArgs>(ShowGridMenu);

            //RoundMatchs = new ObservableCollection<int>();
            //for (int i = 1; i < 39; i++)
            //{
            //    RoundMatchs.Add(i);
            //}

            //roundMatchItem = 1;

        }


        #region IsColumnChooserVisible -- 是否显示列选择器

        private bool isColumnChooserVisible;
        /// <summary>
        /// 是否显示列选择器
        /// </summary>
        public bool IsColumnChooserVisible
        {
            get { return isColumnChooserVisible; }
            set { isColumnChooserVisible = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible)); }
        }

        #endregion


        #region ColumnChoiceCommand -- 列选择命令

        /// <summary>
        /// 列选择命令
        /// </summary>
        public VCommand ColumnChoiceCommand { get; set; }

        /// <summary>
        /// 列选择
        /// </summary>
        private void ColumnChoice()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看轮次赛程显示列表:" + "IsColumnChooserVisible=true");
            this.IsColumnChooserVisible = true;
        }

        #endregion


        #region ShowGridMenuCommand -- 显示列命令

        /// <summary>
        /// 显示列命令
        /// </summary>
        public VCommand<GridMenuEventArgs> ShowGridMenuCommand { get; set; }

        /// <summary>
        /// 显示列
        /// </summary>
        /// <param name="e">事件参数</param>
        private void ShowGridMenu(GridMenuEventArgs e)
        {
            GridControlHelper.RemoveAllDefaultMenuItem(e);
        }

        #endregion

        #endregion



        //#region 足球积分



        ///// <summary>
        ///// 球队绑定数据集合
        ///// </summary>
        //private ObservableCollection<Teamrank> teamRanksModel;
        //public ObservableCollection<Teamrank> TeamRanksModel
        //{
        //    get { return teamRanksModel; }

        //    set { teamRanksModel = value; this.RaisePropertyChanged(nameof(TeamRanksModel)); }
        //}

        //public VCommand BtnCmd1 { get; set; }


        //TeamRanks teamStands = null;


        ///// <summary>
        ///// 刷新球队积分排名
        ///// </summary>
        //private async void BtmCommand1()
        //{
        //    this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看球队积分:" + SeasonId + " " + selectFootballType);

        //    teamStands = new TeamRanks();

          

        //    teamStands = await JsonModel.PostTeamScoreData_Path(FoolballType, SeasonId);
        //    if (teamStands == null) return;
        //    TeamRanksModel = new ObservableCollection<Teamrank>();
        //    //int i = 1;
        //    foreach (var teamRank in teamStands.teamstats)
        //    {
        //        // teamRank.rank = i.ToString();

        //        teamRank.goalAndLoseNums = String.Format("{0}/{1}", teamRank.goalsNum, teamRank.loseGoalsNum);
        //        teamRank.teamLogo = teamRank.teamName;

        //        TeamRanksModel.Add(teamRank);
        //        // i++;
        //    }
        //}



        ///// <summary>
        ///// 初始话
        ///// </summary>
        //private void InitTeam()
        //{
        //    BtnCmd1 = new VCommand(BtmCommand1);

        //    //PromptCommand1 = new VCommand(PromptCmd1);

        //    ColumnChoiceCommand1 = new VCommand(ColumnChoic1e1);

        //    ShowGridMenuCommand1 = new VCommand<GridMenuEventArgs>(ShowGridMenu1);


        //}


        //#region IsColumnChooserVisible -- 是否显示列选择器

        //private bool isColumnChooserVisible1;
        ///// <summary>
        ///// 是否显示列选择器
        ///// </summary>
        //public bool IsColumnChooserVisible1
        //{
        //    get { return isColumnChooserVisible1; }
        //    set { isColumnChooserVisible1 = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible1)); }
        //}

        //#endregion


        //#region ColumnChoiceCommand1 -- 列选择命令

        ///// <summary>
        ///// 列选择命令
        ///// </summary>
        //public VCommand ColumnChoiceCommand1 { get; set; }

        ///// <summary>
        ///// 列选择
        ///// </summary>
        //private void ColumnChoic1e1()
        //{
        //    this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看球队积分显示列表:" + "IsColumnChooserVisible=true");
        //    this.IsColumnChooserVisible1 = true;
        //}

        //#endregion


        //#region ShowGridMenuCommand -- 显示列命令

        ///// <summary>
        ///// 显示列命令
        ///// </summary>
        //public VCommand<GridMenuEventArgs> ShowGridMenuCommand1 { get; set; }

        ///// <summary>
        ///// 显示列
        ///// </summary>
        ///// <param name="e">事件参数</param>
        //private void ShowGridMenu1(GridMenuEventArgs e)
        //{
        //    GridControlHelper.RemoveAllDefaultMenuItem(e);
        //}

        //#endregion

        //#region 打开更新数据时间日志
        ///// <summary>
        ///// 打开数据更新日志
        ///// </summary>
        ////public VCommand PromptCommand1 { get; set; }


        ////MessageLastRecordDate messageLastRecordDate1 = new MessageLastRecordDate();
        ////private void PromptCmd1()
        ////{

        ////    MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
        ////    if (teamStands != null)
        ////    {
        ////        string LastDate = $"足球积分接口更新时间：{teamStands.LastPushDataDateTime}";
        ////        vm.OnErrorLogMessage(LastDate);
        ////    }


        ////    messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
        ////    messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;
        ////}

        //#endregion

        //#endregion

        //#region 射手榜排名

        ///// <summary>
        ///// 球员射手榜绑定数据集合
        ///// </summary>
        //private ObservableCollection<ShootPlayerRank> shootPlayerModel;
        //public ObservableCollection<ShootPlayerRank> ShootPlayerModel
        //{
        //    get { return shootPlayerModel; }

        //    set { shootPlayerModel = value; this.RaisePropertyChanged(nameof(ShootPlayerModel)); }
        //}

        //public VCommand BtnCmd2 { get; set; }


        //ShootPlayerRanks shootPlayerRanks = null;


        ///// <summary>
        ///// 刷新射手排名
        ///// </summary>
        //private async void BtmCommand2()
        //{
        //    shootPlayerRanks = new ShootPlayerRanks();

        //    this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看射手榜排名:" + SeasonId + " " + selectFootballType);

           


        //    shootPlayerRanks = await JsonModel.Post_ShootPlayerRankData(FoolballType, SeasonId, StartOffset, EndOffset);
        //    if (shootPlayerRanks == null) return;
        //    ShootPlayerModel = new ObservableCollection<ShootPlayerRank>();

        //    foreach (var playerRank in shootPlayerRanks.playerstats)
        //    {
        //        playerRank.playerLogo = playerRank.figureName;
        //        playerRank.teamLogo = playerRank.teamName;

        //        if (playerRank.goals != "0")
        //        {
        //            playerRank.goals = playerRank.goals.TrimEnd('0').TrimEnd('.');
        //        }
        //        if (playerRank.penaltyGoals != "0")
        //        {
        //            playerRank.penaltyGoals = playerRank.penaltyGoals.TrimEnd('0').TrimEnd('.');
        //        }
        //        ShootPlayerModel.Add(playerRank);

        //    }
        //}


        ///// <summary>
        ///// 开始条数
        ///// </summary>
        //private string startOffset = "0";
        //public string StartOffset
        //{
        //    get { return startOffset; }
        //    set
        //    {
        //        startOffset = value;
        //        this.RaisePropertyChanged(nameof(StartOffset));
        //    }
        //}

        ///// <summary>
        ///// 结束条数
        ///// </summary>
        //private string endOffset = "10";


        //public string EndOffset
        //{
        //    get { return endOffset; }
        //    set
        //    {
        //        endOffset = value;
        //        this.RaisePropertyChanged(nameof(EndOffset));
        //    }
        //}


        ///// <summary>
        ///// 初始话
        ///// </summary>
        //private void InitShoot()
        //{
        //    BtnCmd2 = new VCommand(BtmCommand2);

        //    // PromptCommand2 = new VCommand(PromptCmd2);

        //    ColumnChoiceCommand2 = new VCommand(ColumnChoice2);
        //    ShowGridMenuCommand2 = new VCommand<GridMenuEventArgs>(ShowGridMenu2);

        //}


        //#region IsColumnChooserVisible2 -- 是否显示列选择器

        //private bool isColumnChooserVisible2;
        ///// <summary>
        ///// 是否显示列选择器
        ///// </summary>
        //public bool IsColumnChooserVisible2
        //{
        //    get { return isColumnChooserVisible2; }
        //    set { isColumnChooserVisible2 = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible2)); }
        //}

        //#endregion


        //#region ColumnChoiceCommand -- 列选择命令

        ///// <summary>
        ///// 列选择命令
        ///// </summary>
        //public VCommand ColumnChoiceCommand2 { get; set; }

        ///// <summary>
        ///// 列选择
        ///// </summary>
        //private void ColumnChoice2()
        //{
        //    this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看射手榜显示列表:" + "IsColumnChooserVisible=true");
        //    this.IsColumnChooserVisible2 = true;
        //}

        //#endregion


        //#region ShowGridMenuCommand -- 显示列命令

        ///// <summary>
        ///// 显示列命令
        ///// </summary>
        //public VCommand<GridMenuEventArgs> ShowGridMenuCommand2 { get; set; }

        ///// <summary>
        ///// 显示列
        ///// </summary>
        ///// <param name="e">事件参数</param>
        //private void ShowGridMenu2(GridMenuEventArgs e)
        //{
        //    GridControlHelper.RemoveAllDefaultMenuItem(e);
        //}

        //#endregion


        //#endregion

    }
}
