﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.TVP.WMCUP.Module
{
    public class MessageLRDateViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(MessageLRDateViewModel));



        public MessageLRDateViewModel()
        {
            //初始化命令
            InitCommand();
        }


        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.ClearCommand = new VCommand(this.Clear);
        }


        // ==================================================================================
        // Command
        // ==================================================================================

        #region ClearCommand -- 清除消息

        /// <summary>
        /// 清除消息
        /// </summary>
        public VCommand ClearCommand { get; set; }

        /// <summary>
        /// 清除
        /// </summary>
        private void Clear()
        {
            MessageLastRecordDate view = this.GetView<MessageLastRecordDate>();
            if (view == null)
                return;

            view.tb.Clear();
        }

        #endregion


        /// <summary>
        /// 错误日志消息
        /// </summary>
        /// <param name="msg">消息</param>
        public void OnErrorLogMessage(string msg)
        {
            WPFHelper.BeginInvoke(() =>
            {
                MessageLastRecordDate view = this.GetView<MessageLastRecordDate>();
                if (view == null)
                    return;

                string log = $"{DateTime.Now.ToString("HH:mm:ss")} {msg}";
                view.tb.AppendText($"{log}\r\n");
                view.tb.ScrollToEnd();
            });
        }
    }
}
