﻿using DevExpress.Xpf.Grid;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Common;

namespace VIZ.TVP.WMCUP.Module
{
    /// <summary>
    /// 射手榜排名
    /// </summary>
    public class ShootPlayerRankViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(ShootPlayerRankViewModel));

        /// <summary>
        /// 
        /// </summary>
        public static ShootPlayerRankViewModel ShootPlayerRanklInstance = new ShootPlayerRankViewModel();


        /// <summary>
        /// 初始话
        /// </summary>
        public ShootPlayerRankViewModel()
        {
            Init();
        }


        /// <summary>
        /// 球员射手榜绑定数据集合
        /// </summary>
        private ObservableCollection<ShootPlayerRank> shootPlayerModel;
        public ObservableCollection<ShootPlayerRank> ShootPlayerModel
        {
            get { return shootPlayerModel; }

            set { shootPlayerModel = value; this.RaisePropertyChanged(nameof(ShootPlayerModel)); }
        }

        public VCommand BtnCmd { get; set; }


        ShootPlayerRanks shootPlayerRanks = null;


        /// <summary>
        /// 刷新球队积分排名
        /// </summary>
        private async void BtmCommand()
        {
            shootPlayerRanks = new ShootPlayerRanks();


            shootPlayerRanks = await JsonModel.Post_ShootPlayerRankData(SeasonId, StartOffset, EndOffset);
            if (shootPlayerRanks == null||shootPlayerRanks.playstatrank==null) return;


            ShootPlayerModel = new ObservableCollection<ShootPlayerRank>();

            ////shootPlayerModel

            //ShootPlayerRank shootPlayerRank = new ShootPlayerRank();

            //shootPlayerRank.rank = "1";
            //shootPlayerRank.figureName = "李霜";
            //shootPlayerRank.teamLogo = "中国";
            //shootPlayerRank.shortTeamName = "中国";
            //shootPlayerRank.games = "5";
            //shootPlayerRank.goals = "10";

            //ShootPlayerModel.Add(shootPlayerRank);  


            //ShootPlayerRank shootPlayerRank1 = new ShootPlayerRank();

            //shootPlayerRank1.rank = "2";
            //shootPlayerRank1.figureName = "沙哈";
            //shootPlayerRank1.teamLogo = "英国";
            //shootPlayerRank1.shortTeamName = "英国";
            //shootPlayerRank1.games = "4";
            //shootPlayerRank1.goals = "9";

            //ShootPlayerModel.Add(shootPlayerRank1);


            //ShootPlayerRank shootPlayerRank2 = new ShootPlayerRank();

            //shootPlayerRank2.rank = "3";
            //shootPlayerRank2.figureName = "萨赫瑞";
            //shootPlayerRank2.teamLogo = "英格兰";
            //shootPlayerRank2.shortTeamName = "英格兰";
            //shootPlayerRank2.games = "5";
            //shootPlayerRank2.goals = "8";

            //ShootPlayerModel.Add(shootPlayerRank2);

            //ShootPlayerRank shootPlayerRank3 = new ShootPlayerRank();

            //shootPlayerRank3.rank = "4";
            //shootPlayerRank3.figureName = "大河";
            //shootPlayerRank3.teamLogo = "新西兰";
            //shootPlayerRank3.shortTeamName = "新西兰";
            //shootPlayerRank3.games = "7";
            //shootPlayerRank3.goals = "7";
            //ShootPlayerModel.Add(shootPlayerRank3);

            //shootPlayerModel.Add(new ShootPlayerRank()
            //{
            //    rank = 1,
            //    figureName="中国",
            //}) ;

            foreach (var playerRank in shootPlayerRanks.playstatrank)
            {
                playerRank.playerLogo = playerRank.figureName; 
                playerRank.teamLogo = playerRank.teamName;
                if (playerRank.goals != "0"&&playerRank.goals!=null)
                {
                    playerRank.goals = playerRank.goals.TrimEnd('0').TrimEnd('.');
                }

                //if (playerRank.penaltyGoals != "0")
                //{
                //    playerRank.penaltyGoals = playerRank.penaltyGoals.TrimEnd('0').TrimEnd('.');
                //}

                ShootPlayerModel.Add(playerRank);

            }
        }

        /// <summary>
        /// 组装积分排名数据上传
        /// </summary>
        /// <returns></returns>
        public string CombineData()
        {
            try
            {


                string data = "";

                data += title;

                data += "&";


                foreach (var tempTeamRankModel in ShootPlayerModel)
                {

                    //data += tempTeamRankModel.rank.ToString().Replace(" ", "");

           

                    //data += "*";

                    if (string.IsNullOrEmpty(tempTeamRankModel.figureName))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempTeamRankModel.figureName.Replace(" ", "");
                    }



                    data += "*";

                    if (string.IsNullOrEmpty(tempTeamRankModel.nationName))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempTeamRankModel.nationName.Replace(" ", "");
                    }




                    data += "*";

                    if (string.IsNullOrEmpty(tempTeamRankModel.teamName))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempTeamRankModel.teamName.Replace(" ", "");
                    }




                    data += "*";

                    if (string.IsNullOrEmpty(tempTeamRankModel.appearances))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempTeamRankModel.appearances.Replace(" ", "");
                    }



                    data += "*";

                    if (string.IsNullOrEmpty(tempTeamRankModel.goals))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempTeamRankModel.goals.Replace(" ", "");
                    }


                    //data += "*";
                    //data += tempTeamRankModel.teamLogo.Replace(" ", "");

                    //data += "*";
                    //data += tempTeamRankModel.figureName.ToString().Replace(" ", "");


                    //data += "*";
                    //data += tempTeamRankModel.goals.ToString().Replace(" ", "");


                    //data += "*";
                    //data += tempTeamRankModel.penaltyGoals.ToString().Replace(" ", "");

                    data += "*";

                    if (string.IsNullOrEmpty(tempTeamRankModel.rank))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempTeamRankModel.rank.ToString().Replace(" ", "");
                    }

                    data += ";";


                }


                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }


        private string title = "射手榜";

        public string Title
        {
            get { return title; }
            set
            {
                title = value;
                this.RaisePropertyChanged(nameof(Title));
            }
        }


        /// <summary>
        /// 开始条数
        /// </summary>
        private string startOffset = "0";
        public string StartOffset
        {
            get { return startOffset; }
            set
            {
                startOffset = value;
                this.RaisePropertyChanged(nameof(StartOffset));
            }
        }

        /// <summary>
        /// 结束条数
        /// </summary>
        private string endOffset = "4";


        public string EndOffset
        {
            get { return endOffset; }
            set
            {
                endOffset = value;
                this.RaisePropertyChanged(nameof(EndOffset));
            }
        }


        /// <summary>
        /// 足球赛事类型
        /// </summary>
        public string FoolballType = "";

        /// <summary>
        /// 赛季ID
        /// </summary>
        public string SeasonId = "";


        /// <summary>
        /// 初始话
        /// </summary>
        private void Init()
        {
            BtnCmd = new VCommand(BtmCommand);

            PromptCommand = new VCommand(PromptCmd);

            ColumnChoiceCommand = new VCommand(ColumnChoice);
            ShowGridMenuCommand = new VCommand<GridMenuEventArgs>(ShowGridMenu);

            FoolballType = DateHeaderViewModel.FoolballType;
            SeasonId = DateHeaderViewModel.SeasonId;
        }


        #region IsColumnChooserVisible -- 是否显示列选择器

        private bool isColumnChooserVisible;
        /// <summary>
        /// 是否显示列选择器
        /// </summary>
        public bool IsColumnChooserVisible
        {
            get { return isColumnChooserVisible; }
            set { isColumnChooserVisible = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible)); }
        }

        #endregion


        #region ColumnChoiceCommand -- 列选择命令

        /// <summary>
        /// 列选择命令
        /// </summary>
        public VCommand ColumnChoiceCommand { get; set; }

        /// <summary>
        /// 列选择
        /// </summary>
        private void ColumnChoice()
        {
            this.IsColumnChooserVisible = true;
        }

        #endregion


        #region ShowGridMenuCommand -- 显示列命令

        /// <summary>
        /// 显示列命令
        /// </summary>
        public VCommand<GridMenuEventArgs> ShowGridMenuCommand { get; set; }

        /// <summary>
        /// 显示列
        /// </summary>
        /// <param name="e">事件参数</param>
        private void ShowGridMenu(GridMenuEventArgs e)
        {
            GridControlHelper.RemoveAllDefaultMenuItem(e);
        }

        #endregion


        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {

            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
            if (shootPlayerRanks != null)
            {
                string LastDate = $"射手榜积分接口更新时间：{shootPlayerRanks.LastPushDataDateTime}";
                vm.OnErrorLogMessage(LastDate);
            }


            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;
        }

        #endregion
    }
}
