﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;


namespace VIZ.TVP.CBA.Module
{
    public static class Utils
    {
        /// <summary>
        /// MD5加密
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string GetMD5(string str)
        {
            //创建MD5对象
            MD5 md5 = new MD5CryptoServiceProvider();
            byte[] buffer = System.Text.Encoding.UTF8.GetBytes(str);
            byte[] MD5Buffer = md5.ComputeHash(buffer);
            string strNew = null;
            for (int i = 0; i < MD5Buffer.Length; i++)
            {
                strNew += MD5Buffer[i].ToString("x2");//可以了解下ToString("")的格式问题 
            }
            return strNew;
        }

        /// <summary>
        /// 艾果的密钥加密
        /// </summary>
        /// <param name="appId"></param>
        /// <param name="appKey"></param>
        /// <returns></returns>

        public static string GetKey(string appId, string appKey)
        {
            int random = new Random().Next(0, 100);

            long timeStamp = DateToTicks(DateTime.Now);

            string key = Convert.ToBase64String(Encoding.UTF8.GetBytes(string.Format("{0},{1},{2},{3}", appId, appKey, timeStamp, random)));

            return key;
        }

        /// <summary>
        /// 获取时间戳
        /// </summary>
        /// <param name="time"></param>
        /// <returns></returns>
        public static long DateToTicks(DateTime? time)
        {
            return ((time.HasValue ? time.Value.Ticks : DateTime.Parse("1990-01-01").Ticks) - 621355968000000000) / 10000;
        }

        /// <summary>
        /// 设置主队和客队球员技术数据统计
        /// </summary>
        /// <param name="mainViewModel"></param>
        /// <param name="selectIndex"></param>
        /// <param name="teamLiveH"></param>
        /// <param name="teamLiveV"></param>
        public static void SetTechStatsInfo(SinglePlayerViewModel mainViewModel, int selectIndex, LivePlayerStatH teamLiveH, LivePlayerStatV teamLiveV)
        {


            if (selectIndex == 0)
            {
                //foreach (var teamLive in mainViewModel.onAirDataModel.livePlayerStatH)
                //{

                Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                CompareItemToNumber.Add("得分", teamLiveH.Points);
                CompareItemToNumber.Add("篮板", teamLiveH.Rebounds);
                CompareItemToNumber.Add("助攻", teamLiveH.Assists);
                CompareItemToNumber.Add("抢断", teamLiveH.Steals);
                CompareItemToNumber.Add("盖帽", teamLiveH.Blocked);
                CompareItemToNumber.Add("上场时间", teamLiveH.Minutes);
                CompareItemToNumber.Add("投篮命中率", (teamLiveH.FieldGoalsPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("两分命中率", (teamLiveH.TwoPointPercentage).ToString("F1") + "%");

                CompareItemToNumber.Add("三分命中率", (teamLiveH.ThreePointPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("罚球命中率", (teamLiveH.FreeThrowsPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("篮下投篮命中率", (teamLiveH.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("中距离投篮命中率", (teamLiveH.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("三分", teamLiveH.ThreePointGoals + "/"
                            + teamLiveH.ThreePointAttempted);


                CompareItemToNumber.Add("两分", teamLiveH.TwoPointGoals + "/"
                            + teamLiveH.TwoPointAttempted);


                CompareItemToNumber.Add("两分区", teamLiveH.TwoPointGoals + "/"
                            + teamLiveH.TwoPointAttempted);
                CompareItemToNumber.Add("三分区", teamLiveH.ThreePointGoals + "/"

             + teamLiveH.ThreePointAttempted);
                //CompareItemToNumber.Add("ThreeArea",);

                CompareItemToNumber.Add("罚球", teamLiveH.FreeThrows + "/"
                            + teamLiveH.FreeThrowsAttempted);
                CompareItemToNumber.Add("失误.g", teamLiveH.Turnovers);

                if (!mainViewModel.MvpHomePlayerCompareNumDictionary.ContainsKey(teamLiveH.CNAlias))
                {
                    mainViewModel.MvpHomePlayerCompareNumDictionary.Add(teamLiveH.CNAlias, CompareItemToNumber);
                }


                //}



            }
            else
            {
                //foreach (var teamLive in mainViewModel.onAirDataModel.livePlayerStatV)
                //{


                Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                CompareItemToNumber.Add("得分", teamLiveV.Points);
                CompareItemToNumber.Add("篮板", teamLiveV.Rebounds);
                CompareItemToNumber.Add("助攻", teamLiveV.Assists);
                CompareItemToNumber.Add("抢断", teamLiveV.Steals);
                CompareItemToNumber.Add("盖帽", teamLiveV.Blocked);
                CompareItemToNumber.Add("上场时间", teamLiveV.Minutes);
                CompareItemToNumber.Add("投篮命中率", (teamLiveV.FieldGoalsPercentage).ToString("F1") + "%");
                CompareItemToNumber.Add("两分命中率", (teamLiveV.TwoPointPercentage).ToString("F1") + "%");

                CompareItemToNumber.Add("三分命中率", (teamLiveV.ThreePointPercentage).ToString("F1") + "%");
                CompareItemToNumber.Add("罚球命中率", (teamLiveV.FreeThrowsPercentage).ToString("F1") + "%");
                CompareItemToNumber.Add("篮下投篮命中率", (teamLiveV.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("中距离投篮命中率", (teamLiveV.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("三分", teamLiveV.ThreePointGoals + "/"
                            + teamLiveV.ThreePointAttempted);


                CompareItemToNumber.Add("两分", teamLiveV.TwoPointGoals + "/"
                            + teamLiveV.TwoPointAttempted);


                CompareItemToNumber.Add("两分区", teamLiveV.TwoPointGoals + "/"
                            + teamLiveV.TwoPointAttempted);
                CompareItemToNumber.Add("三分区", teamLiveV.ThreePointGoals + "/"

             + teamLiveV.ThreePointAttempted);
                //CompareItemToNumber.Add("ThreeArea",);

                CompareItemToNumber.Add("罚球", teamLiveV.FreeThrows + "/"
                            + teamLiveV.FreeThrowsAttempted);
                CompareItemToNumber.Add("失误", teamLiveV.Turnovers);

                if (!mainViewModel.MvpVisitPlayerCompareNumDictionary.ContainsKey(teamLiveV.CNAlias))
                {
                    mainViewModel.MvpVisitPlayerCompareNumDictionary.Add(teamLiveV.CNAlias, CompareItemToNumber);
                }


                // }
            }
        }


        /// <summary>
        /// 设置主队数据
        /// </summary>
        /// <param name="mainViewModel"></param>
        /// <param name="teamStatsViewModel"></param>
        public static void SetHData(TeamStatsViewModel teamStatsViewModel)
        {


            foreach (var teamStats in teamStatsViewModel.MatchStatsNumbers)
            {
                if (teamStatsViewModel.HomeTeamCompareOptionDictionary.ContainsKey(teamStats.TechStatsName.ToString()))
                {
                    teamStats.HomeScore = teamStatsViewModel.HomeTeamCompareOptionDictionary[teamStats.TechStatsName.ToString()];
                }
                else
                {
                    teamStats.HomeScore = "0";
                }
            }




            if (teamStatsViewModel != null)
            {
                //var singlePlayerData = mainViewModel.PlayerSeasonData.PlayerstatsList.Where(a => a.CNAlias == vm.SelectPlayer).FirstOrDefault();

                if (teamStatsViewModel.HomeTeam == null) return;

                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
                    foreach (var teamStats in teamStatsViewModel.MatchStatsNumbers)
                    {
                        if (teamSeasonData.ContainsKey(teamStats.TechStatsName.ToString()))
                        {
                            teamStats.HSeasonScore = teamSeasonData[teamStats.TechStatsName.ToString()];
                        }
                        else
                        {
                            teamStats.HSeasonScore = "0";
                        }
                    }
                }

            }

        }


        /// <summary>
        /// 设置新的主队信息
        /// </summary>
        /// <param name="teamStatsViewModel"></param>

        public static void NewSetHData(NewTeamStatsViewModel teamStatsViewModel)
        {

            if (teamStatsViewModel != null)
            {
                if (teamStatsViewModel.HomeTeam == null) return;
            }

            //第一项

            if (teamStatsViewModel.HomeTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats))
            {
                teamStatsViewModel.HomeScore = teamStatsViewModel.HomeTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats];
            }
            else
            {
                teamStatsViewModel.HomeScore = "0";
            }
            if (teamStatsViewModel != null)
            {
                if (teamStatsViewModel.HomeTeam == null) return;

                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats))
                    {
                        teamStatsViewModel.HSeasonScore = teamSeasonData[teamStatsViewModel.SelectTechStats];
                    }
                    else
                    {
                        teamStatsViewModel.HSeasonScore = "0";
                    }
                }
            }



            //第二项

            if (teamStatsViewModel.HomeTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats1))
            {
                teamStatsViewModel.HomeScore1 = teamStatsViewModel.HomeTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats1];
            }
            else
            {
                teamStatsViewModel.HomeScore1 = "0";
            }
            if (teamStatsViewModel != null)
            {
                if (teamStatsViewModel.HomeTeam == null) return;

                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats1))
                    {
                        teamStatsViewModel.HSeasonScore1 = teamSeasonData[teamStatsViewModel.SelectTechStats1];
                    }
                    else
                    {
                        teamStatsViewModel.HSeasonScore1 = "0";
                    }
                }
            }


            //第三项

            if (teamStatsViewModel.HomeTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats2))
            {
                teamStatsViewModel.HomeScore2 = teamStatsViewModel.HomeTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats2];
            }
            else
            {
                teamStatsViewModel.HomeScore2 = "0";
            }
            if (teamStatsViewModel != null)
            {
                if (teamStatsViewModel.HomeTeam == null) return;

                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats2))
                    {
                        teamStatsViewModel.HSeasonScore2 = teamSeasonData[teamStatsViewModel.SelectTechStats2];
                    }
                    else
                    {
                        teamStatsViewModel.HSeasonScore2 = "0";
                    }
                }
            }


            //第四项

            if (teamStatsViewModel.HomeTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats3))
            {
                teamStatsViewModel.HomeScore3 = teamStatsViewModel.HomeTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats3];
            }
            else
            {
                teamStatsViewModel.HomeScore3 = "0";
            }
            if (teamStatsViewModel != null)
            {
                if (teamStatsViewModel.HomeTeam == null) return;

                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats3))
                    {
                        teamStatsViewModel.HSeasonScore3 = teamSeasonData[teamStatsViewModel.SelectTechStats3];
                    }
                    else
                    {
                        teamStatsViewModel.HSeasonScore3 = "0";
                    }
                }
            }



            //第五项

            if (teamStatsViewModel.HomeTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats3))
            {
                teamStatsViewModel.HomeScore4 = teamStatsViewModel.HomeTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats4];
            }
            else
            {
                teamStatsViewModel.HomeScore4 = "0";
            }
            if (teamStatsViewModel != null)
            {
                if (teamStatsViewModel.HomeTeam == null) return;

                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats4))
                    {
                        teamStatsViewModel.HSeasonScore4 = teamSeasonData[teamStatsViewModel.SelectTechStats4];
                    }
                    else
                    {
                        teamStatsViewModel.HSeasonScore4 = "0";
                    }
                }
            }



            //第六项

            if (teamStatsViewModel.HomeTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats5))
            {
                teamStatsViewModel.HomeScore5 = teamStatsViewModel.HomeTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats5];
            }
            else
            {
                teamStatsViewModel.HomeScore5 = "0";
            }
            if (teamStatsViewModel != null)
            {
                if (teamStatsViewModel.HomeTeam == null) return;

                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats5))
                    {
                        teamStatsViewModel.HSeasonScore5 = teamSeasonData[teamStatsViewModel.SelectTechStats5];
                    }
                    else
                    {
                        teamStatsViewModel.HSeasonScore5 = "0";
                    }
                }
            }



            //第七项

            if (teamStatsViewModel.HomeTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats6))
            {
                teamStatsViewModel.HomeScore6 = teamStatsViewModel.HomeTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats6];
            }
            else
            {
                teamStatsViewModel.HomeScore6 = "0";
            }
            if (teamStatsViewModel != null)
            {
                if (teamStatsViewModel.HomeTeam == null) return;

                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.HomeTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.HomeTeam];
                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats6))
                    {
                        teamStatsViewModel.HSeasonScore6 = teamSeasonData[teamStatsViewModel.SelectTechStats6];
                    }
                    else
                    {
                        teamStatsViewModel.HSeasonScore6 = "0";
                    }
                }
            }

        }



        /// <summary>
        /// 设置客队数据
        /// </summary>
        /// <param name="mainViewModel"></param>
        /// <param name="teamStatsViewModel"></param>
        public static void SetAData(TeamStatsViewModel teamStatsViewModel)
        {


            foreach (var teamStats in teamStatsViewModel.MatchStatsNumbers)
            {
                if (teamStatsViewModel.VisitTeamCompareOptionDictionary.ContainsKey(teamStats.TechStatsName.ToString()))
                {
                    teamStats.AwayScore = teamStatsViewModel.VisitTeamCompareOptionDictionary[teamStats.TechStatsName.ToString()];
                }
                else
                {
                    teamStats.AwayScore = "0";
                }
            }




            if (teamStatsViewModel != null)
            {
                //var singlePlayerData = mainViewModel.PlayerSeasonData.PlayerstatsList.Where(a => a.CNAlias == vm.SelectPlayer).FirstOrDefault();


                if (teamStatsViewModel.AwayTeam == null) return;
                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];
                    foreach (var teamStats in teamStatsViewModel.MatchStatsNumbers)
                    {
                        if (teamSeasonData.ContainsKey(teamStats.TechStatsName.ToString()))
                        {
                            teamStats.ASeasonScore = teamSeasonData[teamStats.TechStatsName.ToString()];
                        }
                        else
                        {
                            teamStats.ASeasonScore = "0";
                        }
                    }
                }

            }

        }



        /// <summary>
        /// 设置新的主队信息
        /// </summary>
        /// <param name="teamStatsViewModel"></param>
        public static void NewSetAData(NewTeamStatsViewModel teamStatsViewModel)
        {

            if (teamStatsViewModel != null)
            {

                if (teamStatsViewModel.AwayTeam == null) return;
            }

                //第一项
                if (teamStatsViewModel.VisitTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats))
            {
                teamStatsViewModel.AwayScore = teamStatsViewModel.VisitTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats];
            }
            else
            {
                teamStatsViewModel.AwayScore = "0";
            }

            if (teamStatsViewModel != null)
            {

                if (teamStatsViewModel.AwayTeam == null) return;
                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats))
                    {
                        teamStatsViewModel.ASeasonScore = teamSeasonData[teamStatsViewModel.SelectTechStats];
                    }
                    else
                    {
                        teamStatsViewModel.ASeasonScore = "0";
                    }

                }

            }


            //第二项
            if (teamStatsViewModel.VisitTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats1))
            {
                teamStatsViewModel.AwayScore1 = teamStatsViewModel.VisitTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats1];
            }
            else
            {
                teamStatsViewModel.AwayScore1 = "0";
            }

            if (teamStatsViewModel != null)
            {

                if (teamStatsViewModel.AwayTeam == null) return;
                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats1))
                    {
                        teamStatsViewModel.ASeasonScore1 = teamSeasonData[teamStatsViewModel.SelectTechStats1];
                    }
                    else
                    {
                        teamStatsViewModel.ASeasonScore1 = "0";
                    }

                }

            }


            //第三项
            if (teamStatsViewModel.VisitTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats2))
            {
                teamStatsViewModel.AwayScore2 = teamStatsViewModel.VisitTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats2];
            }
            else
            {
                teamStatsViewModel.AwayScore2 = "0";
            }

            if (teamStatsViewModel != null)
            {

                if (teamStatsViewModel.AwayTeam == null) return;
                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats2))
                    {
                        teamStatsViewModel.ASeasonScore2 = teamSeasonData[teamStatsViewModel.SelectTechStats2];
                    }
                    else
                    {
                        teamStatsViewModel.ASeasonScore2 = "0";
                    }

                }

            }


            //第四项
            if (teamStatsViewModel.VisitTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats3))
            {
                teamStatsViewModel.AwayScore3 = teamStatsViewModel.VisitTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats3];
            }
            else
            {
                teamStatsViewModel.AwayScore3 = "0";
            }

            if (teamStatsViewModel != null)
            {

                if (teamStatsViewModel.AwayTeam == null) return;
                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats3))
                    {
                        teamStatsViewModel.ASeasonScore3 = teamSeasonData[teamStatsViewModel.SelectTechStats3];
                    }
                    else
                    {
                        teamStatsViewModel.ASeasonScore3 = "0";
                    }

                }

            }



            //第五项
            if (teamStatsViewModel.VisitTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats4))
            {
                teamStatsViewModel.AwayScore4 = teamStatsViewModel.VisitTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats4];
            }
            else
            {
                teamStatsViewModel.AwayScore4 = "0";
            }

            if (teamStatsViewModel != null)
            {

                if (teamStatsViewModel.AwayTeam == null) return;
                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats4))
                    {
                        teamStatsViewModel.ASeasonScore4 = teamSeasonData[teamStatsViewModel.SelectTechStats4];
                    }
                    else
                    {
                        teamStatsViewModel.ASeasonScore4 = "0";
                    }

                }

            }


            //第六项
            if (teamStatsViewModel.VisitTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats5))
            {
                teamStatsViewModel.AwayScore5 = teamStatsViewModel.VisitTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats5];
            }
            else
            {
                teamStatsViewModel.AwayScore5 = "0";
            }

            if (teamStatsViewModel != null)
            {

                if (teamStatsViewModel.AwayTeam == null) return;
                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats5))
                    {
                        teamStatsViewModel.ASeasonScore5 = teamSeasonData[teamStatsViewModel.SelectTechStats5];
                    }
                    else
                    {
                        teamStatsViewModel.ASeasonScore5 = "0";
                    }

                }

            }


            //第七项
            if (teamStatsViewModel.VisitTeamCompareOptionDictionary.ContainsKey(teamStatsViewModel.SelectTechStats6))
            {
                teamStatsViewModel.AwayScore6 = teamStatsViewModel.VisitTeamCompareOptionDictionary[teamStatsViewModel.SelectTechStats6];
            }
            else
            {
                teamStatsViewModel.AwayScore6 = "0";
            }

            if (teamStatsViewModel != null)
            {

                if (teamStatsViewModel.AwayTeam == null) return;
                if (teamStatsViewModel.CNAliasVisitSportsDictionary.ContainsKey(teamStatsViewModel.AwayTeam))
                {
                    var teamSeasonData = teamStatsViewModel.CNAliasVisitSportsDictionary[teamStatsViewModel.AwayTeam];

                    if (teamSeasonData.ContainsKey(teamStatsViewModel.SelectTechStats6))
                    {
                        teamStatsViewModel.ASeasonScore6 = teamSeasonData[teamStatsViewModel.SelectTechStats6];
                    }
                    else
                    {
                        teamStatsViewModel.ASeasonScore6 = "0";
                    }

                }

            }


        }


        /// <summary>
        /// 设置主队技术统计得分
        /// </summary>
        /// <param name="mainViewModel"></param>
        public static void SetHomeTeamDictionary(TeamStatsViewModel mainViewModel)
        {
            mainViewModel.HomeTeamCompareOptionDictionary.Clear();

            mainViewModel.HomeTeamCompareOptionDictionary.Add("得分", mainViewModel.onAirDataModel.liveTeamStatH.Points);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("篮板", mainViewModel.onAirDataModel.liveTeamStatH.Rebounds);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("助攻", mainViewModel.onAirDataModel.liveTeamStatH.Assists);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("抢断", mainViewModel.onAirDataModel.liveTeamStatH.Steals);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("盖帽", mainViewModel.onAirDataModel.liveTeamStatH.Blocked);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("失误", mainViewModel.onAirDataModel.liveTeamStatH.Turnovers);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("犯规", mainViewModel.onAirDataModel.liveTeamStatH.PersonalFouls);
            //HomeTeamCompareOptionDictionary.Add(TeamDataCompareOptionChinese[7], Json_OnAirData.liveTeamStatH.FlagrantFouls);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("罚球命中率", (mainViewModel.onAirDataModel.liveTeamStatH.FreeThrowsPercentage * 100).ToString("F1") + "%");
            mainViewModel.HomeTeamCompareOptionDictionary.Add("两分命中率", (mainViewModel.onAirDataModel.liveTeamStatH.TwoPointPercentage * 100).ToString("F1") + "%");
            mainViewModel.HomeTeamCompareOptionDictionary.Add("三分命中率", (mainViewModel.onAirDataModel.liveTeamStatH.ThreePointPercentage * 100).ToString("F1") + "%");
            mainViewModel.HomeTeamCompareOptionDictionary.Add("投篮命中率", (mainViewModel.onAirDataModel.liveTeamStatH.FieldGoalsPercentage * 100).ToString("F1") + "%");
            mainViewModel.HomeTeamCompareOptionDictionary.Add("篮下投篮命中率", (mainViewModel.onAirDataModel.liveTeamStatH.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
            mainViewModel.HomeTeamCompareOptionDictionary.Add("中距离投篮命中率", (mainViewModel.onAirDataModel.liveTeamStatH.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
            mainViewModel.HomeTeamCompareOptionDictionary.Add("三分", mainViewModel.onAirDataModel.liveTeamStatH.ThreePointGoals + "/"
                + mainViewModel.onAirDataModel.liveTeamStatH.ThreePointAttempted);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("两分", mainViewModel.onAirDataModel.liveTeamStatH.TwoPointGoals + "/"
                + mainViewModel.onAirDataModel.liveTeamStatH.TwoPointAttempted);
            //HomeTeamCompareOptionDictionary.Add(TeamDataCompareOptionChinese[16], Json_OnAirData.liveTeamStatH.FastBreakPoints);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("三分得分", (Convert.ToInt32(mainViewModel.onAirDataModel.liveTeamStatH.ThreePointGoals) * 3).ToString());


        }


        /// <summary>
        /// 设置新的主队技术统计得分
        /// </summary>
        /// <param name="mainViewModel"></param>
        public static void NewSetHomeTeamDictionary(NewTeamStatsViewModel mainViewModel)
        {
            mainViewModel.HomeTeamCompareOptionDictionary.Clear();

            mainViewModel.HomeTeamCompareOptionDictionary.Add("得分", mainViewModel.onAirDataModel.liveTeamStatH.Points);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("篮板", mainViewModel.onAirDataModel.liveTeamStatH.Rebounds);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("助攻", mainViewModel.onAirDataModel.liveTeamStatH.Assists);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("抢断", mainViewModel.onAirDataModel.liveTeamStatH.Steals);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("盖帽", mainViewModel.onAirDataModel.liveTeamStatH.Blocked);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("失误", mainViewModel.onAirDataModel.liveTeamStatH.Turnovers);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("犯规", mainViewModel.onAirDataModel.liveTeamStatH.PersonalFouls);
            //HomeTeamCompareOptionDictionary.Add(TeamDataCompareOptionChinese[7], Json_OnAirData.liveTeamStatH.FlagrantFouls);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("罚球命中率", (mainViewModel.onAirDataModel.liveTeamStatH.FreeThrowsPercentage * 100).ToString("F1") + "%");
            mainViewModel.HomeTeamCompareOptionDictionary.Add("两分命中率", (mainViewModel.onAirDataModel.liveTeamStatH.TwoPointPercentage * 100).ToString("F1") + "%");
            mainViewModel.HomeTeamCompareOptionDictionary.Add("三分命中率", (mainViewModel.onAirDataModel.liveTeamStatH.ThreePointPercentage * 100).ToString("F1") + "%");
            mainViewModel.HomeTeamCompareOptionDictionary.Add("投篮命中率", (mainViewModel.onAirDataModel.liveTeamStatH.FieldGoalsPercentage * 100).ToString("F1") + "%");
            mainViewModel.HomeTeamCompareOptionDictionary.Add("篮下投篮命中率", (mainViewModel.onAirDataModel.liveTeamStatH.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
            mainViewModel.HomeTeamCompareOptionDictionary.Add("中距离投篮命中率", (mainViewModel.onAirDataModel.liveTeamStatH.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
            mainViewModel.HomeTeamCompareOptionDictionary.Add("三分", mainViewModel.onAirDataModel.liveTeamStatH.ThreePointGoals + "/"
                + mainViewModel.onAirDataModel.liveTeamStatH.ThreePointAttempted);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("两分", mainViewModel.onAirDataModel.liveTeamStatH.TwoPointGoals + "/"
                + mainViewModel.onAirDataModel.liveTeamStatH.TwoPointAttempted);
            //HomeTeamCompareOptionDictionary.Add(TeamDataCompareOptionChinese[16], Json_OnAirData.liveTeamStatH.FastBreakPoints);
            mainViewModel.HomeTeamCompareOptionDictionary.Add("三分得分", (Convert.ToInt32(mainViewModel.onAirDataModel.liveTeamStatH.ThreePointGoals) * 3).ToString());


        }

        /// <summary>
        /// 设置客队技术统计得分
        /// </summary>
        /// <param name="mainViewModel"></param>
        public static void SetVisitTeamDictionary(TeamStatsViewModel mainViewModel)
        {
            mainViewModel.VisitTeamCompareOptionDictionary.Clear();

            mainViewModel.VisitTeamCompareOptionDictionary.Add("得分", mainViewModel.onAirDataModel.liveTeamStatV.Points);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("篮板", mainViewModel.onAirDataModel.liveTeamStatV.Rebounds);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("助攻", mainViewModel.onAirDataModel.liveTeamStatV.Assists);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("抢断", mainViewModel.onAirDataModel.liveTeamStatV.Blocked);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("盖帽", mainViewModel.onAirDataModel.liveTeamStatV.Steals);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("失误", mainViewModel.onAirDataModel.liveTeamStatV.Turnovers);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("犯规", mainViewModel.onAirDataModel.liveTeamStatV.PersonalFouls);
            //HomeTeamCompareOptionDictionary.Add(TeamDataCompareOptionChinese[7], Json_OnAirData.liveTeamStatH.FlagrantFouls);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("罚球命中率", (mainViewModel.onAirDataModel.liveTeamStatV.FreeThrowsPercentage * 100).ToString("F1") + "%");
            mainViewModel.VisitTeamCompareOptionDictionary.Add("两分命中率", (mainViewModel.onAirDataModel.liveTeamStatV.TwoPointPercentage * 100).ToString("F1") + "%");
            mainViewModel.VisitTeamCompareOptionDictionary.Add("三分命中率", (mainViewModel.onAirDataModel.liveTeamStatV.ThreePointPercentage * 100).ToString("F1") + "%");
            mainViewModel.VisitTeamCompareOptionDictionary.Add("投篮命中率", (mainViewModel.onAirDataModel.liveTeamStatV.FieldGoalsPercentage * 100).ToString("F1") + "%");
            mainViewModel.VisitTeamCompareOptionDictionary.Add("篮下投篮命中率", (mainViewModel.onAirDataModel.liveTeamStatV.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
            mainViewModel.VisitTeamCompareOptionDictionary.Add("中距离投篮命中率", (mainViewModel.onAirDataModel.liveTeamStatV.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
            mainViewModel.VisitTeamCompareOptionDictionary.Add("三分", mainViewModel.onAirDataModel.liveTeamStatV.ThreePointGoals + "/"
                + mainViewModel.onAirDataModel.liveTeamStatV.ThreePointAttempted);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("两分", mainViewModel.onAirDataModel.liveTeamStatV.TwoPointGoals + "/"
                + mainViewModel.onAirDataModel.liveTeamStatV.TwoPointAttempted);
            //HomeTeamCompareOptionDictionary.Add(TeamDataCompareOptionChinese[16], Json_OnAirData.liveTeamStatH.FastBreakPoints);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("三分得分", (Convert.ToInt32(mainViewModel.onAirDataModel.liveTeamStatV.ThreePointGoals) * 3).ToString());
        }



        /// <summary>
        /// 设置新的客队技术统计
        /// </summary>
        /// <param name="mainViewModel"></param>
        public static void NewSetVisitTeamDictionary(NewTeamStatsViewModel mainViewModel)
        {
            mainViewModel.VisitTeamCompareOptionDictionary.Clear();

            mainViewModel.VisitTeamCompareOptionDictionary.Add("得分", mainViewModel.onAirDataModel.liveTeamStatV.Points);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("篮板", mainViewModel.onAirDataModel.liveTeamStatV.Rebounds);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("助攻", mainViewModel.onAirDataModel.liveTeamStatV.Assists);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("抢断", mainViewModel.onAirDataModel.liveTeamStatV.Blocked);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("盖帽", mainViewModel.onAirDataModel.liveTeamStatV.Steals);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("失误", mainViewModel.onAirDataModel.liveTeamStatV.Turnovers);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("犯规", mainViewModel.onAirDataModel.liveTeamStatV.PersonalFouls);
            //HomeTeamCompareOptionDictionary.Add(TeamDataCompareOptionChinese[7], Json_OnAirData.liveTeamStatH.FlagrantFouls);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("罚球命中率", (mainViewModel.onAirDataModel.liveTeamStatV.FreeThrowsPercentage * 100).ToString("F1") + "%");
            mainViewModel.VisitTeamCompareOptionDictionary.Add("两分命中率", (mainViewModel.onAirDataModel.liveTeamStatV.TwoPointPercentage * 100).ToString("F1") + "%");
            mainViewModel.VisitTeamCompareOptionDictionary.Add("三分命中率", (mainViewModel.onAirDataModel.liveTeamStatV.ThreePointPercentage * 100).ToString("F1") + "%");
            mainViewModel.VisitTeamCompareOptionDictionary.Add("投篮命中率", (mainViewModel.onAirDataModel.liveTeamStatV.FieldGoalsPercentage * 100).ToString("F1") + "%");
            mainViewModel.VisitTeamCompareOptionDictionary.Add("篮下投篮命中率", (mainViewModel.onAirDataModel.liveTeamStatV.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
            mainViewModel.VisitTeamCompareOptionDictionary.Add("中距离投篮命中率", (mainViewModel.onAirDataModel.liveTeamStatV.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
            mainViewModel.VisitTeamCompareOptionDictionary.Add("三分", mainViewModel.onAirDataModel.liveTeamStatV.ThreePointGoals + "/"
                + mainViewModel.onAirDataModel.liveTeamStatV.ThreePointAttempted);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("两分", mainViewModel.onAirDataModel.liveTeamStatV.TwoPointGoals + "/"
                + mainViewModel.onAirDataModel.liveTeamStatV.TwoPointAttempted);
            //HomeTeamCompareOptionDictionary.Add(TeamDataCompareOptionChinese[16], Json_OnAirData.liveTeamStatH.FastBreakPoints);
            mainViewModel.VisitTeamCompareOptionDictionary.Add("三分得分", (Convert.ToInt32(mainViewModel.onAirDataModel.liveTeamStatV.ThreePointGoals) * 3).ToString());
        }

    }
}
