﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Plugin;
using VIZ.Package.Domain;
using VIZ.Package.Module;

namespace VIZ.TVP.CBA.Module.DayMatch
{
    /// <summary>
    /// 比赛日期插件
    /// </summary>
    public class DayMatchPlugin : IPluginLifeCycle
    {
        /// <summary>
        /// 插件ID
        /// </summary>
        /// <remarks>
        /// 插件ID不能包含点号
        /// </remarks>
        public const string PLUGIN_ID = "DayMatchView";

        /// <summary>
        /// 插件显示名称
        /// </summary>
        public const string PLUGIN_NAME = "今日赛程";

        public void Dispose()
        {

        }

        public PluginInfo Register()
        {
            PluginInfo info = new PluginInfo();
            info.Group = PluginConstant.GroupName;
            info.ID = PLUGIN_ID;
            info.Name = PLUGIN_NAME;
            info.PluginType = PluginType.Page;
            info.ViewType = typeof(DayMatchView);

            //info.SettingViewType = typeof(DayMatchUI);
            return info;
        }
    }
}
