﻿using DevExpress.Xpf.Core;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Module;

namespace VIZ.TVP.CBA.Module
{
    /// <summary>
    /// Interaction logic for DayMatchUI.xaml
    /// </summary>
    public partial class DayMatchView : UserControl, IPluginView
    {

        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(DayMatchView));

        DayMatchViewModel vm = null;

        public DayMatchView()
        {
            InitializeComponent();

            WPFHelper.BindingViewModel(this, new DayMatchViewModel());
            vm=this.DataContext as DayMatchViewModel;
            task_Start.IsEnabled = true;
            task_Stop.IsEnabled = false;
            task_continue.IsEnabled = false;


        }

      
        /// <summary>
        /// 上版
        /// </summary>
        /// <param name="conns">连接</param>
        public void TakIn(ConnModel conns)
        {
            //DayMatchViewModel vm = thi DayMatchViewModel
            //ApplicationDomainEx.PreviewConn.EndpointManager.Send("");

            if (conns.IsConnected && vm.MatchData != null)
            {
                //SCRIPT_INVOKE
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }


        }

        /// <summary>
        /// 继续
        /// </summary>
        /// <param name="conns">连接</param>
        public void TakeContinue(ConnModel conns)
        {
            if(conns.IsConnected && vm.MatchData != null)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        /// <summary>
        /// 下版子
        /// </summary>
        /// <param name="conns">连接</param>
        public void TakeOut(ConnModel conns)
        {

        }

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="conns">连接</param>
        public void TakeUpdate(ConnModel conns)
        {
            if (conns.IsConnected&& vm.MatchData!=null)
            {
                //SCRIPT_INVOKE
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }
        }

        /// <summary>
        /// 预览上版子
        /// </summary>
        /// <param name="conn">连接</param>
        public void PreviewIn(ConnModel conn)
        {
            if(conn.IsConnected && vm.MatchData != null)
            {
                //SCRIPT_INVOKE
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE,"Data",vm.CombineMatchData()));
            }
        }

        /// <summary>
        /// 预览继续
        /// </summary>
        /// <param name="conn">连接</param>
        public void PreviewContinue(ConnModel conn)
        {

        }

        /// <summary>
        /// 预览下版
        /// </summary>
        /// <param name="conn">连接</param>
        public void PreviewOut(ConnModel conn)
        {
            //if(conn.IsConnected)
            //{
            //    conn.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            //}
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {

        }

        /// <summary>
        /// 任务模型
        /// </summary>
        public PackageTaskModel task;
        /// <summary>
        /// 注册服务
        /// </summary>
        IPackageTaskService service;

        /// <summary>
        /// 注册任务
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void DayMatchView_TaskInit()
        {
            if (task != null)
                return;

            task = new PackageTaskModel(this);
            task.PreviewUpdateAction = OnPreviewUpdate;
            task.TakeUpdateAction = OnTakeUpdate;

            task.IsPreviewEnabled = true;
            task.IsTakeEnabled = true;

            task.IsRunning = true;
            task.Name = "今日赛程";

            service = ApplicationDomainEx.ServiceManager.GetService<IPackageTaskService>(ViewServiceKeys.PACKAGE_TASK_SERVICE);
            if (service == null)
                return;

            service.Register(task);
           

        }




        private void OnPreviewUpdate(ConnModel conn)
        {
            if (conn.IsConnected)
            {
                vm.GetSchedule();
                //task.CanExecute = vm.flag;
                //SCRIPT_INVOKE
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }
        }

        private void OnTakeUpdate(ConnModel conn)
        {
            if (conn.IsConnected)
            {
                vm.GetSchedule();
              
                //SCRIPT_INVOKE
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data",vm. CombineMatchData()));
            }
        }


        private void task_Start_Click(object sender, RoutedEventArgs e)
        {
            DayMatchView_TaskInit();
            task_Start.IsEnabled = false;
            task_Stop.IsEnabled = true;
            task_continue.IsEnabled = true;
        }

        private void task_continue_Click(object sender, RoutedEventArgs e)
        {

            if(task.IsRunning)
            {
                task.IsRunning = false;
                task_continue.Content = "任务继续";
            }
            else
            {
                task.IsRunning = true;
                task_continue.Content = "任务暂停";
            }
            task_Start.IsEnabled = false;
            task_Stop.IsEnabled = true;
         
        }

        private void task_Stop_Click(object sender, RoutedEventArgs e)
        {
            service.Cancel(task);

            task = null;
            task_Start.IsEnabled = true;
            task_continue.Content = "任务暂停";
            task_continue.IsEnabled = false;
            task_Stop.IsEnabled = false;
        }
    }
}
