﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using log4net;
using VIZ.Package.Domain;

namespace VIZ.TVP.CBA.Module
{
    public class DayMatchViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log= LogManager.GetLogger(typeof(DayMatchViewModel));   


        public DayMatchViewModel()
        {
            
            BtnCmd = new VCommand(BtnCommand);
            BtnMatchDayUp = new VCommand(BtnMatchDayUpData);
            matchDate = DateTime.Today.ToShortDateString();
            GetSchedule();
        }

        private string matchDate;


        /// <summary>
        ///获取日期
        /// </summary>
        public string MatchDate
        {
            get { return matchDate; }
            set { matchDate = value; this.RaisePropertyChanged(nameof(MatchDate)); }
        }

        public VCommand BtnCmd { get; set; }

        public VCommand BtnMatchDayUp { get; set; }


        /// <summary>
        /// 获取今日赛程
        /// </summary>
        private void BtnCommand()
        {
            GetSchedule();
        }


        /// <summary>
        /// 构造指定日期赛程的数据
        /// </summary>
        private void BtnMatchDayUpData()
        {
            Log.Info("比赛日期上版和数据:"+ CombineMatchData());
            //ApplicationDomainEx.VizEngineModel.STAGE_START("Default/JRSCBEN", "Data", CombineMatchData());
        }


        /// <summary>
        /// 今日赛程信息
        /// </summary>
        private ObservableCollection<Dayschedule> matchData;

        /// <summary>
        /// 绑定数据列表
        /// </summary>
        public ObservableCollection<Dayschedule> MatchData
        {
            get { return matchData; }

            set { matchData = value; this.RaisePropertyChanged(nameof(MatchData)); }
        }


        //private ObservableCollection<string> lightHigts=new ObservableCollection<string>()
        //{
        //    "不高亮",
        //    "高亮"
        //};


        //public ObservableCollection<string> LightHigts
        //{
        //    get
        //    {
        //        return lightHigts;
        //    }
        //    set { lightHigts = value; this.RaisePropertyChanged(nameof(LightHigts)); }

        //}

        //private string light;

        //public string Light
        //{
        //    get { return light; }
        //    set { light=value; this.RaisePropertyChanged(nameof(Light)); }
        //}


        private string title = "今日赛程";

        /// <summary>
        /// 标题
        /// </summary>
        public string Title
        {
            get { return title; }
            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }

        /// <summary>
        /// 是否执行成功
        /// </summary>
        public bool flag = false;
        /// <summary>
        /// 获取赛程信息
        /// </summary>
        public async void GetSchedule()
        {
            
            try
            {


                string date = Convert.ToDateTime(matchDate).ToString("yyyy-MM-dd");
                flag = false;
                var dayschedules =  await JsonModel.PostTomorrowMatch_Path(date);

                if (dayschedules == null) return ;

            
                // matchData.AddRange(dayschedules.dayschedule);

                MatchData = new ObservableCollection<Dayschedule>();
                foreach (var dayschedule in dayschedules.dayschedule)
                {
                    if (dayschedule.Status == "1")
                    {
                        dayschedule.Status = "未开赛";
                    }
                    else if (dayschedule.Status == "2")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "3")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "4")
                    {
                        dayschedule.Status = "已结束";
                    }
                    else if (dayschedule.Status == "5")
                    {
                        dayschedule.Status = "延期";
                    }

                    MatchData.Add(dayschedule);
                }
                flag = true;


                
            }
            catch(Exception ex)
            {
               
                Log.Error(ex.Message);
            }

        }




        /// <summary>
        /// 组装往包装发送得数据
        /// </summary>
        /// <returns></returns>
        public string CombineMatchData()
        {
            try

            {
                string data = "";
                data += title + "&";


                foreach (var tempMatchData in matchData)
                {
                    if (tempMatchData.SelectLight == "不高亮")
                    {
                        data += "0";
                    }
                    else
                    {
                        data += "1";
                    }

                    data += "*";
                    if (string.IsNullOrEmpty(tempMatchData.dates))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.dates.Replace(" ", "");
                    }


                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.time))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.time.Replace(" ", "");
                    }

                    data += "*";

                    data += tempMatchData.HomeTeamName.Replace(" ", "");

                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.HomeTeamScore))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.HomeTeamScore.Replace(" ", "");
                    }


                    data += "*";
                    data += tempMatchData.VisitingTeamName.Replace(" ", "");

                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.VisitingTeamScore))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.VisitingTeamScore.Replace(" ", "");
                    }


                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.Status))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.Status.Replace(" ", "");
                    }
                    data += ";";

                }

                return data;
            }
            catch(Exception ex)
            {
                Log.Error(ex.ToString());
                return "";
            }
        }

    }
}
