﻿using DevExpress.Mvvm.POCO;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.TVP.CBA.Module
{
    public class DayMatchNewViewModel : ViewModelBase
    {

        public DayMatchNewViewModel()
        {

            GetSchedule();
            visiblity = "Hidden";

        }

        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(DayMatchNewViewModel));

        private ObservableCollection<Dayschedule> matchData;

        /// <summary>
        /// 绑定数据列表
        /// </summary>
        public ObservableCollection<Dayschedule> MatchData
        {
            get { return matchData; }

            set { matchData = value; this.RaisePropertyChanged(nameof(MatchData)); }
        }

        private string visiblity;

        public string Visiblity
        {
            get { return visiblity; }
            set { visiblity = value; this.RaisePropertyChanged(nameof(Visiblity)); }
        }

        private async void GetSchedule()
        {
            try
            {


                string date = "2023-1-4";
                    //Convert.ToDateTime("20").ToString("yyyy-MM-dd");

                var dayschedules = await JsonModel.TomorrowMatch_Path(date);

                if (dayschedules == null) return;

                // matchData.AddRange(dayschedules.dayschedule);

                MatchData = new ObservableCollection<Dayschedule>();
                foreach (var dayschedule in dayschedules.dayschedule)
                {
                    if (dayschedule.Status == "1")
                    {
                        dayschedule.Status = "未开赛";
                    }
                    else if (dayschedule.Status == "2")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "3")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "4")
                    {
                        dayschedule.Status = "已结束";
                    }
                    else if (dayschedule.Status == "5")
                    {
                        dayschedule.Status = "延期";
                    }

                    MatchData.Add(dayschedule);
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
            }

        }


    }
}
