﻿using DevExpress.Emf;
using DevExpress.Xpf.Editors.Helpers;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Module;

namespace VIZ.TVP.CBA.Module
{
    /// <summary>
    /// 日期头部放在前面
    /// </summary>
    public class DateHeaderViewModel : ViewModelBase
    {
        /// <summary>
        /// 初始化构造函数
        /// </summary>
        public DateHeaderViewModel()
        {
            matchDate = DateTime.Today.ToShortDateString();

            BtnCmd = new VCommand(BtmCommand);
            RefreshCommand = new VCommand(RefreshTeamStats);
         
            GetSchedule();
            BtmCommand();

            PlayerHCommand = new VCommand(SetHPlayerStats);
            PlayerACommand = new VCommand(SetAPlayerStats);
            RefreshPlayerCommand = new VCommand(RefreshPlayer);
        }


        #region 今日赛程
        /// <summary>
        /// 记录log日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(DateHeaderViewModel));

        private ObservableCollection<string> matchItems;

        /// <summary>
        /// 下拉框绑定得赛程详细信息
        /// </summary>
        public ObservableCollection<string> MatchItems
        {
            get { return matchItems; }
            set { matchItems = value; this.RaisePropertyChanged(nameof(MatchItems)); }
        }

        //private string selectMatchItems;

        ///// <summary>
        ///// 选中得赛程信息
        ///// </summary>
        //public string SelectMatchItems
        //{
        //    get { return selectMatchItems; }
        //    set
        //    {
        //        selectMatchItems = value;
        //        this.RaisePropertyChanged(nameof(SelectMatchItems));
        //        if (selectMatchItems == null) return;
        //        //SetCompareData();
        //        ScheduleID = SetMatchDict[SelectMatchItems];
        //    }
        //}
        /// <summary>
        /// 比赛状态
        /// </summary>
        private string matchStatus;

        public string MatchStatus
        {
            get { return matchStatus; }

            set
            {
                matchStatus = value;
                this.RaisePropertyChanged(nameof(MatchStatus));
            }
        }


        //球员赛季数据
        public string Matchtypeid = "";
        //比赛赛程Id
        public string ScheduleID = "";


        /// <summary>
        /// 比赛日期
        /// </summary>

        private string matchDate;

        public string MatchDate
        {
            get { return matchDate; }
            set
            {
                matchDate = value;
                this.RaisePropertyChanged(nameof(MatchDate));
                GetSchedule();
            }
        }


 

        /// <summary>
        /// 设置一个比赛赛程集合
        /// </summary>
        public Dictionary<string, string> SetMatchDict = new Dictionary<string, string>();

        /// <summary>
        /// 根据日期获取赛程
        /// </summary>

        private async void GetSchedule()
        {
            try

            {
                MatchItems = new ObservableCollection<string>();
                string date = Convert.ToDateTime(matchDate).ToString("yyyy-MM-dd");

                var dayschedules = await JsonModel.PostTomorrowMatch_Path(date);

                if (dayschedules == null) return;
                matchData.AddRange(dayschedules.dayschedule);
                MatchData = new ObservableCollection<Dayschedule>();

                if (dayschedules != null)
                {
                    dayschedules.dayschedule = dayschedules.dayschedule.OrderBy(a => Convert.ToDateTime(a.time)).ToList();
                }

                SetMatchDict.Clear();
                MatchItems.Clear();

                foreach (var dayschedule in dayschedules.dayschedule)
                {
                    if (dayschedule.Status == "1")
                    {
                        dayschedule.Status = "未开赛";
                    }
                    else if (dayschedule.Status == "2")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "3")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "4")
                    {
                        dayschedule.Status = "已结束";
                    }
                    else if (dayschedule.Status == "5")
                    {
                        dayschedule.Status = "延期";
                    }

                    if (!SetMatchDict.ContainsKey(dayschedule.time + dayschedule.HomeTeamName
                                + "VS" + dayschedule.VisitingTeamName))
                    {
                        SetMatchDict.Add(dayschedule.time + dayschedule.HomeTeamName
                                    + "VS" + dayschedule.VisitingTeamName, dayschedule.ScheduleID);
                    }

                    Matchtypeid = dayschedule.ScheduleTypeID;

                    MatchItems.Add(dayschedule.time + dayschedule.HomeTeamName
                                + "VS" + dayschedule.VisitingTeamName);

                    MatchData.Add(dayschedule);

                }
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
            }
        }




        private Dayschedule selectMatchData;

        public Dayschedule SelectMatchData
        {
            get { return selectMatchData; }

            set 
            { 
                selectMatchData = value;
                this.RaisePropertyChanged(nameof(SelectMatchData)); 

                if(value==null)
                {
                    return;
                }

                onAirDataModel = JsonModel.PostOnAirData_Path(selectMatchData.ScheduleID);

                SetTeamStatsData();

                TeamHName = value.HomeTeamName;
           
                TeamAName = value.VisitingTeamName;



                #region 球员统计信息

              
                if(TeamStatsViewModel.TeamStatsViewModelInstance.Count>0)
                {
                   // Log.Error(string.Format("TeamStatsViewModel.CreateInstance Count:{0}", TeamStatsViewModel.TeamStatsViewModelInstance.Count));
                    foreach(var tempTeamStatsViewModel in TeamStatsViewModel.TeamStatsViewModelInstance)
                    {
                       // TeamStatsViewModel teamStatsViewModel = tempTeamStatsViewModel;
                       // Log.Error("DateHeaderViewModel_CreateTeamStatsViewModel");
                        tempTeamStatsViewModel.ScheduleID = selectMatchData.ScheduleID;
                        tempTeamStatsViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                       // Log.Error(string.Format("DateHeader_ScheduleId:{0}", selectMatchData.ScheduleID));
                        //Log.Error(string.Format("DateHeader_ScheduleTypeId:{0}", selectMatchData.ScheduleTypeID));
                        tempTeamStatsViewModel.SetTeamData();
                    }
          
                }
            

                if(NewTeamStatsViewModel.TeamStatsViewModelInstance.Count>0)
                {
                    foreach (var tempTeamStatsViewModel in NewTeamStatsViewModel.TeamStatsViewModelInstance)
                    {
               
                        tempTeamStatsViewModel.ScheduleID = selectMatchData.ScheduleID;
                        tempTeamStatsViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
            
                        tempTeamStatsViewModel.SetTeamData();
                    }
                }


                #endregion



                #region 单个球员信息

                if(SinglePlayerViewModel.SinglePlayerViewModelInstance.Count>0)
                {

                    foreach(var tempSinglePlayerViewModel in SinglePlayerViewModel.SinglePlayerViewModelInstance)
                    {
                        tempSinglePlayerViewModel.ScheduleID = selectMatchData.ScheduleID;
                        tempSinglePlayerViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                        tempSinglePlayerViewModel.SetSingleData();
                    }

                }


                #endregion

                #region 球员对比信息

                if(PlayerCompareViewModel.PlayerCompareViewModelInstance.Count>0)
                {
                    foreach(var playerCompareViewModel in PlayerCompareViewModel.PlayerCompareViewModelInstance)
                    {
                        //PlayerCompareViewModel playerCompareViewModel = PlayerCompareViewModel.CreateInstance;

                        playerCompareViewModel.ScheduleID = selectMatchData.ScheduleID;
                        playerCompareViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                        playerCompareViewModel.SetCompareData();
                    }



                }


                if(NewPlayerComPareViewModel.PlayerCompareViewModelInstance.Count>0)
                {
                    foreach (var playerCompareViewModel in NewPlayerComPareViewModel.PlayerCompareViewModelInstance)
                    {
                        //PlayerCompareViewModel playerCompareViewModel = PlayerCompareViewModel.CreateInstance;

                        playerCompareViewModel.ScheduleID = selectMatchData.ScheduleID;
                        playerCompareViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                        playerCompareViewModel.SetCompareData();
                    }

                }

                #endregion
            }
        }


        /// <summary>
        /// 今日赛程日期
        /// </summary>
        private ObservableCollection<Dayschedule> matchData;

        /// <summary>
        /// 绑定数据列表
        /// </summary>
        public ObservableCollection<Dayschedule> MatchData
        {
            get { return matchData; }

            set { matchData = value; this.RaisePropertyChanged(nameof(MatchData)); }
        }

        #endregion

        #region 球队积分排行榜


        public VCommand BtnCmd { get; set; }
        /// <summary>
        /// 球队积分排名
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModel;

        public ObservableCollection<Teamrank> TeamRanksModel
        {
            get { return teamRanksModel; }

            set { teamRanksModel = value; this.RaisePropertyChanged(nameof(TeamRanksModel)); }
        }


        private void BtmCommand()
        {
            var teamStands = JsonModel.PostTeamScoreData_Path();
            if (teamStands == null) return;
            TeamRanksModel = new ObservableCollection<Teamrank>();
            int i = 1;
            foreach (var teamRank in teamStands.teamrank)
            {
                teamRank.Id = i;

                teamRank.WinningPercentageStr = (teamRank.WinningPercentage * 100).ToString("F1") + "%";

                if (teamRank.StreakType == 1)
                {
                    teamRank.StreakName = "连胜";
                }
                else if (teamRank.StreakType == 0)
                {
                    teamRank.StreakName = "连败";
                }
                TeamRanksModel.Add(teamRank);
                i++;
            }
        }




        #endregion

        #region 球队数据


        /// <summary>
        /// 刷新球队数据
        /// </summary>
        public VCommand RefreshCommand { get; set; }


        private void RefreshTeamStats()
        {
            if (selectMatchData != null)
            {
                onAirDataModel = JsonModel.PostOnAirData_Path(selectMatchData.ScheduleID);

                SetTeamStatsData();
            }
           
           
        }

        /// <summary>
        /// 实时直播数据
        /// </summary>
        public OnAirDataModel onAirDataModel = new OnAirDataModel();

        /// <summary>
        /// 球队数据
        /// </summary>
        private ObservableCollection<ShowTeamStats> showInfoTeamStats;

        public ObservableCollection<ShowTeamStats> ShowInfoTeamStats
        {
            get { return showInfoTeamStats; }

            set { showInfoTeamStats = value; this.RaisePropertyChanged(nameof(ShowInfoTeamStats)); }
        }


        private void SetTeamStatsData()
        {

            ShowInfoTeamStats = new ObservableCollection<ShowTeamStats>();

            ShowTeamStats showTeamStatsHome = new ShowTeamStats();

            ShowTeamStats showTeamStatsAway = new ShowTeamStats();

            //主队技术统计
            showTeamStatsHome.TeamName = selectMatchData.HomeTeamName;
            showTeamStatsHome.Goal = onAirDataModel.liveTeamStatH.Points;
            showTeamStatsHome.Rebounds = onAirDataModel.liveTeamStatH.Rebounds;
            showTeamStatsHome.Assists = onAirDataModel.liveTeamStatH.Assists;
            showTeamStatsHome.Blocks = onAirDataModel.liveTeamStatH.Blocked;
            showTeamStatsHome.Steals = onAirDataModel.liveTeamStatH.Steals;
            showTeamStatsHome.Error = onAirDataModel.liveTeamStatH.Turnovers;
            showTeamStatsHome.Foul = onAirDataModel.liveTeamStatH.PersonalFouls;
            showTeamStatsHome.FreeThrowP= (onAirDataModel.liveTeamStatH.FreeThrowsPercentage * 100).ToString("F1") + "%";
            showTeamStatsHome.TwoShootingGoalP = (onAirDataModel.liveTeamStatH.TwoPointPercentage * 100).ToString("F1") + "%";
            showTeamStatsHome.ThreeShootingGoalP= (onAirDataModel.liveTeamStatH.ThreePointPercentage * 100).ToString("F1") + "%";
            showTeamStatsHome.ShootingGoalP= (onAirDataModel.liveTeamStatH.FieldGoalsPercentage * 100).ToString("F1") + "%";
            showTeamStatsHome.ShootingUnderBaketP= (onAirDataModel.liveTeamStatH.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%";
            showTeamStatsHome.MidShootingP = (onAirDataModel.liveTeamStatH.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%";
            showTeamStatsHome.ThreeScore = onAirDataModel.liveTeamStatH.ThreePointGoals + "/"
                + onAirDataModel.liveTeamStatH.ThreePointAttempted;
            showTeamStatsHome.TwoScore= onAirDataModel.liveTeamStatH.TwoPointGoals + "/"
                + onAirDataModel.liveTeamStatH.TwoPointAttempted;
            showTeamStatsHome.ThreeGoals = (Convert.ToInt32(onAirDataModel.liveTeamStatH.ThreePointGoals) * 3).ToString();

            ShowInfoTeamStats.Add(showTeamStatsHome);

            //客队技术统计
            showTeamStatsAway.TeamName = selectMatchData.VisitingTeamName;
            showTeamStatsAway.Goal = onAirDataModel.liveTeamStatV.Points;
            showTeamStatsAway.Rebounds = onAirDataModel.liveTeamStatV.Rebounds;
            showTeamStatsAway.Assists = onAirDataModel.liveTeamStatV.Assists;
            showTeamStatsAway.Blocks = onAirDataModel.liveTeamStatV.Blocked;
            showTeamStatsAway.Steals = onAirDataModel.liveTeamStatV.Steals;
            showTeamStatsAway.Error = onAirDataModel.liveTeamStatV.Turnovers;
            showTeamStatsAway.Foul = onAirDataModel.liveTeamStatV.PersonalFouls;
            showTeamStatsAway.FreeThrowP = (onAirDataModel.liveTeamStatV.FreeThrowsPercentage * 100).ToString("F1") + "%";
            showTeamStatsAway.TwoShootingGoalP = (onAirDataModel.liveTeamStatV.TwoPointPercentage * 100).ToString("F1") + "%";
            showTeamStatsAway.ThreeShootingGoalP = (onAirDataModel.liveTeamStatV.ThreePointPercentage * 100).ToString("F1") + "%";
            showTeamStatsAway.ShootingGoalP = (onAirDataModel.liveTeamStatV.FieldGoalsPercentage * 100).ToString("F1") + "%";

            showTeamStatsAway.ShootingUnderBaketP = (onAirDataModel.liveTeamStatV.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%";
            showTeamStatsAway.MidShootingP = (onAirDataModel.liveTeamStatV.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%";
            showTeamStatsAway.ThreeScore = onAirDataModel.liveTeamStatV.ThreePointGoals + "/"
                + onAirDataModel.liveTeamStatV.ThreePointAttempted;
            showTeamStatsAway.TwoScore = onAirDataModel.liveTeamStatV.TwoPointGoals + "/"
                + onAirDataModel.liveTeamStatV.TwoPointAttempted;
            showTeamStatsAway.ThreeGoals = (Convert.ToInt32(onAirDataModel.liveTeamStatV.ThreePointGoals) * 3).ToString();

            ShowInfoTeamStats.Add(showTeamStatsAway);

        }

        #endregion

        #region 球员数据


        public VCommand RefreshPlayerCommand { get; set; }

        /// <summary>
        /// 总得分
        /// </summary>
        private double totalScore;

        public double TotalScore
        {
            get { return totalScore; }
            set
            {
                totalScore = value;
                this.RaisePropertyChanged(nameof(TotalScore));
            }
        }

        /// <summary>
        /// 总篮板
        /// </summary>
        private double totalRebounds;

        public double TotalRebounds
        {
            get { return totalRebounds; }
            set
            {
                totalRebounds = value;
                this.RaisePropertyChanged(nameof(TotalRebounds));
            }
        }


        /// <summary>
        /// 总助攻
        /// </summary>
        private double totalAssists;

        public double TotalAssists
        {
            get { return totalAssists; }
            set
            {
                totalAssists = value;
                this.RaisePropertyChanged(nameof(TotalAssists));
            }
        }


        /// <summary>
        /// 总盖帽
        /// </summary>
        private double totalBlocks;

        public double TotalBlocks
        {
            get { return totalBlocks; }
            set
            {
                totalBlocks = value;
                this.RaisePropertyChanged(nameof(TotalBlocks));
            }
        }

        private int flag = -1;

        private void RefreshPlayer()
        {
            if(flag==0)
            {
                SetHPlayerStats();
            }
            else if(flag==1)
            {
                SetAPlayerStats();
            }
        }
        /// <summary>
        /// 球员查看信息
        /// </summary>
        private ObservableCollection<PlayersStats> showInfoPlayersStats;

        public ObservableCollection<PlayersStats> ShowInfoPlayersStats
        {
            get { return showInfoPlayersStats; }

            set { showInfoPlayersStats = value; this.RaisePropertyChanged(nameof(ShowInfoPlayersStats)); }
        }


        /// <summary>
        /// 主队名称
        /// </summary>
        private string teamHName;

        public string TeamHName
        {
            get { return teamHName; }

            set { teamHName = value;this.RaisePropertyChanged(nameof(TeamHName)); }
        }


        /// <summary>
        /// 客队名称
        /// </summary>
        private string teamAName;

        public string TeamAName
        {
            get { return teamAName; }

            set { teamAName = value; this.RaisePropertyChanged(nameof(TeamAName)); }
        }



        public VCommand PlayerHCommand { get; set; }

        public VCommand PlayerACommand { get; set; }



        /// <summary>
        /// 设置主队员数据统计
        /// </summary>
        private void SetHPlayerStats()
        {
            if (SelectMatchData == null) return;
            flag = 0;
            ShowInfoPlayersStats = new ObservableCollection<PlayersStats>();

            double scores = 0;
            double rebounds=0;
            double assists = 0;
            double blocks = 0;
            foreach (var playerStat in  onAirDataModel.livePlayerStatH)
            {
                PlayersStats player = new PlayersStats();

                player.PlayerName = playerStat.CNAlias;
                scores += Convert.ToDouble(playerStat.Points);
                player.Goal = playerStat.Points;
                rebounds += Convert.ToDouble(playerStat.Rebounds);
                player.Rebounds = playerStat.Rebounds;
                player.Assists = playerStat.Assists;
                assists += Convert.ToDouble(playerStat.Assists);
                player.Steals = playerStat.Steals;
                blocks += Convert.ToDouble(playerStat.Blocked);
                player.Blocks = playerStat.Blocked;
                player.PlayTime = playerStat.Minutes;
                player.ShootingGoalP = (playerStat.FieldGoalsPercentage*100).ToString("F1") + "%";
                player.TwoShootingGoalP = (playerStat.TwoPointPercentage).ToString("F1") + "%";
                player.ThreeShootingGoalP = (playerStat.ThreePointPercentage*100).ToString("F1") + "%";
                player.FreeThrowP = (playerStat.FreeThrowsPercentage*100).ToString("F1") + "%";
                player.ShootingUnderBaketP= (playerStat.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%";
                player.MidShootingP = (playerStat.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%";

                player.ThreeScore = playerStat.ThreePointGoals + "/"
                                + playerStat.ThreePointAttempted;
                player.TwoScore = playerStat.TwoPointGoals + "/"
                                + playerStat.TwoPointAttempted;
                player.TwoArea = playerStat.TwoPointGoals + "/"
                                + playerStat.TwoPointAttempted;
                player.ThreeArea = playerStat.ThreePointGoals + "/"
                                  + playerStat.ThreePointAttempted;
                player.FreeThrow = playerStat.FreeThrows + "/"
                                + playerStat.FreeThrowsAttempted;
                player.Error = playerStat.Turnovers;

                ShowInfoPlayersStats.Add(player);
            }

            ShowInfoPlayersStats = ShowInfoPlayersStats.OrderByDescending(a => Convert.ToInt32(a.Goal)).ToObservableCollection();
            TotalScore = scores;
            TotalRebounds = rebounds;
            TotalAssists = assists;
            TotalBlocks = blocks;

        }

        /// <summary>
        /// 设置客队员数据统计
        /// </summary>
        private void SetAPlayerStats()
        {
            if (SelectMatchData == null) return;
            flag = 1;
            ShowInfoPlayersStats = new ObservableCollection<PlayersStats>();

            double scores = 0;
            double rebounds = 0;
            double assists = 0;
            double blocks = 0;
            foreach (var playerStat in onAirDataModel.livePlayerStatV)
            {
                PlayersStats player = new PlayersStats();

                player.PlayerName = playerStat.CNAlias;
                scores += Convert.ToDouble(playerStat.Points);
                player.Goal = playerStat.Points;
                rebounds += Convert.ToDouble(playerStat.Rebounds);
                player.Rebounds = playerStat.Rebounds;
                assists += Convert.ToDouble(playerStat.Assists);
                player.Assists = playerStat.Assists;
                player.Steals = playerStat.Steals;
                blocks += Convert.ToDouble(playerStat.Blocked);
                player.Blocks = playerStat.Blocked;
                player.PlayTime = playerStat.Minutes;
                player.ShootingGoalP = (playerStat.FieldGoalsPercentage).ToString("F1") + "%";
                player.TwoShootingGoalP = (playerStat.TwoPointPercentage).ToString("F1") + "%";
                player.ThreeShootingGoalP = (playerStat.ThreePointPercentage).ToString("F1") + "%";
                player.FreeThrowP = (playerStat.FreeThrowsPercentage).ToString("F1") + "%";
                player.ShootingUnderBaketP = (playerStat.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%";
                player.MidShootingP = (playerStat.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%";

                player.ThreeScore = playerStat.ThreePointGoals + "/"
                                + playerStat.ThreePointAttempted;
                player.TwoScore = playerStat.TwoPointGoals + "/"
                                + playerStat.TwoPointAttempted;
                player.TwoArea = playerStat.TwoPointGoals + "/"
                                + playerStat.TwoPointAttempted;
                player.ThreeArea = playerStat.ThreePointGoals + "/"
                                  + playerStat.ThreePointAttempted;
                player.FreeThrow = playerStat.FreeThrows + "/"
                                + playerStat.FreeThrowsAttempted;
                player.Error = playerStat.Turnovers;

                ShowInfoPlayersStats.Add(player);
            }

            ShowInfoPlayersStats = ShowInfoPlayersStats.OrderByDescending(a => Convert.ToInt32(a.Goal)).ToObservableCollection();

            TotalScore = scores;
            TotalRebounds = rebounds;
            TotalAssists = assists;
            TotalBlocks = blocks;

        }

        #endregion

    }
}
