﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Module;

namespace VIZ.TVP.CBA.Module
{
    /// <summary>
    /// Interaction logic for PlayerComPareUI.xaml
    /// </summary>
    public partial class PlayerComPareView : UserControl, IPluginView
    {
        public PlayerCompareViewModel vm = new PlayerCompareViewModel();


        public PlayerComPareView()
        {
            InitializeComponent();

            PlayerCompareViewModel.PlayerCompareViewModelInstance.Add(vm);
            WPFHelper.BindingViewModel(this, vm);

            task_Start.IsEnabled = true;
            task_Stop.IsEnabled = false;
            task_continue.IsEnabled = false;

        }

        public void Dispose()
        {
            
        }

        public void PreviewContinue(ConnModel conn)
        {
            
        }

        public void PreviewIn(ConnModel conn)
        {
            if(conn.IsConnected&& vm.PlayerComModels!=null)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombinePlayerCommand()));
            }
        }

        public void PreviewOut(ConnModel conn)
        {
           //if(conn.IsConnected)
           // {
           //     conn.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
           // }
        }

        public void TakeContinue(ConnModel conns)
        {
           
        }

        public void TakeOut(ConnModel conns)
        {
           if(conns.IsConnected && vm.PlayerComModels != null)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE );
            }
        }

        public void TakeUpdate(ConnModel conns)
        {
            if (conns.IsConnected && vm.PlayerComModels != null)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombinePlayerCommand()));
            }
        }

        public void TakIn(ConnModel conns)
        {
            if (conns.IsConnected && vm.PlayerComModels != null)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombinePlayerCommand()));
            }
        }



        /// <summary>
        /// 注册任务
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void PlayerComPareView_Init()
        {
            if (task != null)
                return;

            task = new PackageTaskModel(this);
            task.PreviewUpdateAction = OnPreviewUpdate;
            task.TakeUpdateAction = OnTakeUpdate;

            task.IsPreviewEnabled = true;
            task.IsTakeEnabled = true;
            task.IsRunning = true;

            task.Name = "球员对比";


            service = ApplicationDomainEx.ServiceManager.GetService<IPackageTaskService>(ViewServiceKeys.PACKAGE_TASK_SERVICE);
            if (service == null)
                return;

            service.Register(task);

        }


        /// <summary>
        /// 任务模型
        /// </summary>
        public PackageTaskModel task;

        IPackageTaskService service;

        private void OnPreviewUpdate(ConnModel conn)
        {
            if (conn.IsConnected)
            {
                vm.BtnCmd();
                //task.CanExecute = vm.flag;
                //SCRIPT_INVOKE
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombinePlayerCommand()));
            }
        }

        private void OnTakeUpdate(ConnModel conn)
        {
            if (conn.IsConnected)
            {
                vm.BtnCmd();

                //SCRIPT_INVOKE
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombinePlayerCommand()));
            }
        }

        private void task_Start_Click(object sender, RoutedEventArgs e)
        {
            PlayerComPareView_Init();
            task_Start.IsEnabled = false;
            task_Stop.IsEnabled = true;
            task_continue.IsEnabled = true;
        }

        private void task_continue_Click(object sender, RoutedEventArgs e)
        {
            if (task.IsRunning)
            {
                task.IsRunning = false;
                task_continue.Content = "任务继续";
            }
            else
            {
                task.IsRunning = true;
                task_continue.Content = "任务暂停";
            }
            task_Start.IsEnabled = false;
            task_Stop.IsEnabled = true;
        }

        private void task_Stop_Click(object sender, RoutedEventArgs e)
        {
            service.Cancel(task);

            task = null;
            task_Start.IsEnabled = true;
            task_continue.Content = "任务暂停";
            task_continue.IsEnabled = false;
            task_Stop.IsEnabled = false;
        }
    }
}
