﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using DevExpress.Mvvm.POCO;
using System.ComponentModel;
using log4net;
using System.Windows.Media.Imaging;
using System.Windows.Media;

namespace VIZ.TVP.CBA.Module
{
    public class PlayerCompareViewModel : ViewModelBase
    {

        private static ILog Log=LogManager.GetLogger(typeof(PlayerCompareViewModel));   
        //private static PlayerCompareViewModel _createInstance = null;

        public static List<PlayerCompareViewModel> PlayerCompareViewModelInstance = new List<PlayerCompareViewModel>();
        //{
        //    get
        //    {
        //        if (null == _createInstance)
        //        {
        //            _createInstance = new PlayerCompareViewModel();
        //        }
        //        return _createInstance;
        //    }
        //}


        public PlayerCompareViewModel()
        {
            matchStatsIds = new ObservableCollection<int>()
            {
                5,
                6,
                7
            };

            playerComModels = new ObservableCollection<PlayerComModel>();

            PlayerComModel PlayGoal = new PlayerComModel();
            PlayGoal.TechStatsName = "得分";
            PlayGoal.PropertyChanged += OnModelChanged;
            playerComModels.Add(PlayGoal);

            PlayerComModel Rebounds = new PlayerComModel();
            Rebounds.TechStatsName = "篮板";
            Rebounds.PropertyChanged += OnModelChanged;
            playerComModels.Add(Rebounds);

            PlayerComModel Assists = new PlayerComModel();
            Assists.TechStatsName = "助攻";
            Assists.PropertyChanged += OnModelChanged;
            playerComModels.Add(Assists);

            PlayerComModel Blocks = new PlayerComModel();
            Blocks.TechStatsName = "盖帽";
            Blocks.PropertyChanged += OnModelChanged;
            playerComModels.Add(Blocks);

            PlayerComModel Steals = new PlayerComModel();
            Steals.TechStatsName = "抢断";
            Steals.PropertyChanged += OnModelChanged;
            playerComModels.Add(Steals);

            PlayerComModel ShootingGoalP = new PlayerComModel();
            ShootingGoalP.TechStatsName = "投篮命中率";
            ShootingGoalP.PropertyChanged += OnModelChanged;
            playerComModels.Add(ShootingGoalP);

            PlayerComModel ThreeShootingGoalP = new PlayerComModel();
            ThreeShootingGoalP.TechStatsName = "三分命中率";
            ThreeShootingGoalP.PropertyChanged += OnModelChanged;
            playerComModels.Add(ThreeShootingGoalP);


            BtnCommand = new VCommand(BtnCmd);
            PlayerComCommand = new VCommand(playerComCommand);

            MatchCmd = new VCommand(MatchTechCmd);
            matchDate = DateTime.Today.ToShortDateString();
         
          //  GetSchedule();
           // GetSeasonData();
         
        }

        /// <summary>
        /// 主队球员的名字和球衣号码
        /// </summary>
        public Dictionary<string, string> HNameNums = new Dictionary<string, string>();

        /// <summary>
        /// 客队球员的名字和球衣号码
        /// </summary>
        public Dictionary<string, string> VNameNums = new Dictionary<string, string>();


        /// <summary>
        /// 主队球员技术统计数据
        /// </summary>
        public Dictionary<string, Dictionary<string, string>> MvpHomePlayerCompareNumDictionary
      = new Dictionary<string, Dictionary<string, string>>();

        /// <summary>
        /// 客队球员技术统计数据
        /// </summary>
        public Dictionary<string, Dictionary<string, string>> MvpVisitPlayerCompareNumDictionary
              = new Dictionary<string, Dictionary<string, string>>();

        /// <summary>
        /// 设置球员信息
        /// </summary>
        /// <param name="flag"></param>
        public void SetPlayer(bool flag = true)
        {
            MvpHomePlayerCompareNumDictionary.Clear();
            MvpVisitPlayerCompareNumDictionary.Clear();

            if (flag)
            {
                HPlayers = new ObservableCollection<string>();
                APlayers = new ObservableCollection<string>();
            }
            foreach (var teamLive in onAirDataModel.livePlayerStatH)
            {
                if (flag)
                {
                    HPlayers.Add(teamLive.CNAlias);
                }
                if (!HNameNums.ContainsKey(teamLive.CNAlias))
                {
                    HNameNums.Add(teamLive.CNAlias, teamLive.Number);
                }

                Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                CompareItemToNumber.Add("得分", teamLive.Points);
                CompareItemToNumber.Add("篮板", teamLive.Rebounds);
                CompareItemToNumber.Add("助攻", teamLive.Assists);
                CompareItemToNumber.Add("抢断", teamLive.Steals);
                CompareItemToNumber.Add("盖帽", teamLive.Blocked);
                CompareItemToNumber.Add("上场时间", teamLive.Minutes);
                CompareItemToNumber.Add("投篮命中率", (teamLive.FieldGoalsPercentage*100).ToString("F1") + "%");
                CompareItemToNumber.Add("两分命中率", (teamLive.TwoPointPercentage).ToString("F1") + "%");

                CompareItemToNumber.Add("三分命中率", (teamLive.ThreePointPercentage*100).ToString("F1") + "%");
                CompareItemToNumber.Add("罚球命中率", (teamLive.FreeThrowsPercentage*100).ToString("F1") + "%");
                CompareItemToNumber.Add("篮下投篮命中率", (teamLive.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("中距离投篮命中率", (teamLive.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("三分", teamLive.ThreePointGoals + "/"
                            + teamLive.ThreePointAttempted);


                CompareItemToNumber.Add("两分", teamLive.TwoPointGoals + "/"
                            + teamLive.TwoPointAttempted);


                CompareItemToNumber.Add("两分区", teamLive.TwoPointGoals + "/"
                            + teamLive.TwoPointAttempted);
                CompareItemToNumber.Add("三分区", teamLive.ThreePointGoals + "/"

             + teamLive.ThreePointAttempted);
                //CompareItemToNumber.Add("ThreeArea",);

                CompareItemToNumber.Add("罚球", teamLive.FreeThrows + "/"
                            + teamLive.FreeThrowsAttempted);
                CompareItemToNumber.Add("失误", teamLive.Turnovers);
                if (!MvpHomePlayerCompareNumDictionary.ContainsKey(teamLive.CNAlias))
                {
                    MvpHomePlayerCompareNumDictionary.Add(teamLive.CNAlias, CompareItemToNumber);
                }
                
            }


            foreach (var teamLive in onAirDataModel.livePlayerStatV)
            {

                if (flag)
                {
                    APlayers.Add(teamLive.CNAlias.ToString());
                }

                if (!VNameNums.ContainsKey(teamLive.CNAlias))
                {
                    VNameNums.Add(teamLive.CNAlias, teamLive.Number);
                }



                Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                CompareItemToNumber.Add("得分", teamLive.Points);
                CompareItemToNumber.Add("篮板", teamLive.Rebounds);
                CompareItemToNumber.Add("助攻", teamLive.Assists);
                CompareItemToNumber.Add("抢断", teamLive.Steals);
                CompareItemToNumber.Add("盖帽", teamLive.Blocked);
                CompareItemToNumber.Add("上场时间", teamLive.Minutes);
                CompareItemToNumber.Add("投篮命中率", (teamLive.FieldGoalsPercentage*100).ToString("F1") + "%");
                CompareItemToNumber.Add("两分命中率", (teamLive.TwoPointPercentage).ToString("F1") + "%");

                CompareItemToNumber.Add("三分命中率", (teamLive.ThreePointPercentage*100).ToString("F1") + "%");
                CompareItemToNumber.Add("罚球命中率", (teamLive.FreeThrowsPercentage*100).ToString("F1") + "%");
                CompareItemToNumber.Add("篮下投篮命中率", (teamLive.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("中距离投篮命中率", (teamLive.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("三分", teamLive.ThreePointGoals + "/"
                            + teamLive.ThreePointAttempted);


                CompareItemToNumber.Add("两分", teamLive.TwoPointGoals + "/"
                            + teamLive.TwoPointAttempted);


                CompareItemToNumber.Add("两分区", teamLive.TwoPointGoals + "/"
                            + teamLive.TwoPointAttempted);
                CompareItemToNumber.Add("三分区", teamLive.ThreePointGoals + "/"

             + teamLive.ThreePointAttempted);
                //CompareItemToNumber.Add("ThreeArea",);

                CompareItemToNumber.Add("罚球", teamLive.FreeThrows + "/"
                            + teamLive.FreeThrowsAttempted);
                CompareItemToNumber.Add("失误", teamLive.Turnovers);

                if(!MvpVisitPlayerCompareNumDictionary.ContainsKey(teamLive.CNAlias))
                {
                    MvpVisitPlayerCompareNumDictionary.Add(teamLive.CNAlias, CompareItemToNumber);
                }
         


            }




        }

        /// <summary>
        /// 技术统计
        /// </summary>
        private string matchStatsId;

        private void OnModelChanged(object sender, PropertyChangedEventArgs e)
        {
            if (e.PropertyName == "TechStatsName")
            {
                SetHData();
                SetAData();
            }
                //NotifyPropertyChanged("AuthResult");
        }


        /// <summary>
        /// 技术统计Id
        /// </summary>
        public string MatchStatsId
        {
            get { return matchStatsId; }

            set
            {
                matchStatsId = value;
                this.RaisePropertyChanged(nameof(MatchStatsId));


                if (Convert.ToInt32(MatchStatsId) == 7)
                {
                    PlayerComModels = new ObservableCollection<PlayerComModel>();

                    PlayerComModel PlayGoal = new PlayerComModel();
                    PlayGoal.TechStatsName = "得分";
                    PlayGoal.PropertyChanged += OnModelChanged;
                    playerComModels.Add(PlayGoal);

                    PlayerComModel Rebounds = new PlayerComModel();
                    Rebounds.TechStatsName = "篮板";
                    Rebounds.PropertyChanged += OnModelChanged;
                    playerComModels.Add(Rebounds);

                    PlayerComModel Assists = new PlayerComModel();
                    Assists.TechStatsName = "助攻";
                    Assists.PropertyChanged += OnModelChanged;
                    playerComModels.Add(Assists);

                    PlayerComModel Blocks = new PlayerComModel();
                    Blocks.TechStatsName = "盖帽";
                    Blocks.PropertyChanged += OnModelChanged;
                    playerComModels.Add(Blocks);

                    PlayerComModel Steals = new PlayerComModel();
                    Steals.TechStatsName = "抢断";
                    Steals.PropertyChanged += OnModelChanged;
                    playerComModels.Add(Steals);

                    PlayerComModel ShootingGoalP = new PlayerComModel();
                    ShootingGoalP.TechStatsName = "投篮命中率";
                    ShootingGoalP.PropertyChanged += OnModelChanged;
                    playerComModels.Add(ShootingGoalP);

                    PlayerComModel ThreeShootingGoalP = new PlayerComModel();
                    ThreeShootingGoalP.TechStatsName = "三分命中率";
                    ThreeShootingGoalP.PropertyChanged += OnModelChanged;
                    playerComModels.Add(ThreeShootingGoalP);



                }

                else if (Convert.ToInt32(MatchStatsId) == 6)
                {
                    PlayerComModels = new ObservableCollection<PlayerComModel>();
                    PlayerComModel PlayGoal = new PlayerComModel();
                    PlayGoal.TechStatsName = "得分";
                    PlayGoal.PropertyChanged += OnModelChanged;
                    playerComModels.Add(PlayGoal);

                    PlayerComModel Rebounds = new PlayerComModel();
                    Rebounds.TechStatsName = "篮板";
                    Rebounds.PropertyChanged += OnModelChanged;
                    playerComModels.Add(Rebounds);

                    PlayerComModel Assists = new PlayerComModel();
                    Assists.TechStatsName = "助攻";
                    Assists.PropertyChanged += OnModelChanged;
                    playerComModels.Add(Assists);

                    PlayerComModel Blocks = new PlayerComModel();
                    Blocks.TechStatsName = "盖帽";
                    Blocks.PropertyChanged += OnModelChanged;
                    playerComModels.Add(Blocks);

                    PlayerComModel Steals = new PlayerComModel();
                    Steals.TechStatsName = "抢断";
                    Steals.PropertyChanged += OnModelChanged;
                    playerComModels.Add(Steals);

                    PlayerComModel ShootingGoalP = new PlayerComModel();
                    ShootingGoalP.TechStatsName = "投篮命中率";
                    ShootingGoalP.PropertyChanged += OnModelChanged;
                    playerComModels.Add(ShootingGoalP);
                }

                else if (Convert.ToInt32(MatchStatsId) == 5)
                {

                    PlayerComModels = new ObservableCollection<PlayerComModel>();

                    PlayerComModel PlayGoal = new PlayerComModel();
                    PlayGoal.TechStatsName = "得分";
                    PlayGoal.PropertyChanged += OnModelChanged;
                    playerComModels.Add(PlayGoal);

                    PlayerComModel Rebounds = new PlayerComModel();
                    Rebounds.TechStatsName = "篮板";
                    Rebounds.PropertyChanged += OnModelChanged;
                    playerComModels.Add(Rebounds);

                    PlayerComModel Assists = new PlayerComModel();
                    Assists.TechStatsName = "助攻";
                    Assists.PropertyChanged += OnModelChanged;
                    playerComModels.Add(Assists);

                    PlayerComModel Blocks = new PlayerComModel();
                    Blocks.TechStatsName = "盖帽";
                    Blocks.PropertyChanged += OnModelChanged;
                    playerComModels.Add(Blocks);

                    PlayerComModel Steals = new PlayerComModel();
                    Steals.TechStatsName = "抢断";
                    Steals.PropertyChanged += OnModelChanged;
                    playerComModels.Add(Steals);

                }


                SetHData();
                SetAData();
            }
        }



        private string matchDate;

        public string MatchDate
        {
            get { return matchDate; }
            set
            {
                matchDate = value;
                this.RaisePropertyChanged(nameof(MatchDate));
             
                
                GetSchedule();
                //GetSeasonData();
                
            }
        }




        private ObservableCollection<string> matchItems;

        /// <summary>
        /// 下拉框绑定得赛程详细信息
        /// </summary>
        public ObservableCollection<string> MatchItems
        {
            get { return matchItems; }
            set { matchItems = value; this.RaisePropertyChanged(nameof(MatchItems)); }
        }



        private string selectMatchItems;

        /// <summary>
        /// 选中得赛程信息
        /// </summary>
        public string SelectMatchItems
        {
            get { return selectMatchItems; }
            set
            {
                selectMatchItems = value;
                this.RaisePropertyChanged(nameof(SelectMatchItems));
                if (selectMatchItems == null) return;
                SetCompareData();
            }
        }




        private ObservableCollection<int> matchStatsIds;

        public ObservableCollection<int> MatchStatsIds
        {
            get { return matchStatsIds; }

            set { matchStatsIds = value; this.RaisePropertyChanged(nameof(MatchStatsIds)); }
        }


        private ObservableCollection<PlayerComModel> playerComModels;

        /// <summary>
        /// 球员比较信息的集合
        /// </summary>
        public ObservableCollection<PlayerComModel> PlayerComModels
        {
            get { return playerComModels; }
            set 
            {
                playerComModels = value; 
                this.RaisePropertyChanged(nameof(PlayerComModels));
            }
        }

        private PlayerComModel playerComModel;

        public PlayerComModel PlayerComModel
        {
            get { return playerComModel; }
            set
            {
                playerComModel = value;
                this.RaisePropertyChanged(nameof(PlayerComModel));
            }
        }


        private ObservableCollection<string> hPlayers;

        /// <summary>
        /// 主队球员信息
        /// </summary>
        public ObservableCollection<string> HPlayers
        {
            get { return hPlayers; }

            set { hPlayers = value; this.RaisePropertyChanged(nameof(HPlayers)); }
        }

        private ObservableCollection<string> aPlayers;

        /// <summary>
        /// 客队球员信息
        /// </summary>
        public ObservableCollection<string> APlayers
        {
            get { return aPlayers; }
            set { aPlayers = value; this.RaisePropertyChanged(nameof(APlayers)); }
        }


        /// <summary>
        /// 主队球员图片
        /// </summary>
        private ImageSource hPlayerLogo;

        public ImageSource HPlayerLogo
        {
            get { return hPlayerLogo; }
            set { hPlayerLogo = value;this.RaisePropertyChanged(nameof(HPlayerLogo)); }
        }




        string baesePath = AppDomain.CurrentDomain.BaseDirectory;

        private string aPlayer;

        public string APlayer
        {
            get { return aPlayer; }
            set
            {
                aPlayer = value;
                this.RaisePropertyChanged(nameof(APlayer));

                if (APlayer == null) return;

                if(AName== "北京控股666")
                {
                    APlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));
                }
                else
                {
                    APlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, AName)));
                }
              
                if (VNameNums.ContainsKey(APlayer))
                {
                    ANums = VNameNums[APlayer];
                }
                SetAData();
            }
        }

        /// <summary>
        /// 客队球员图片
        /// </summary>
        private ImageSource aPlayerLogo;
        public ImageSource APlayerLogo
        {
            get { return aPlayerLogo; }
            set { aPlayerLogo = value;this.RaisePropertyChanged(nameof(APlayerLogo)); }
        }


        private string hPlayer;

        public string HPlayer
        {
            get { return hPlayer; }
            set
            {
                hPlayer = value;
                this.RaisePropertyChanged(nameof(HPlayer));
                if (HPlayer == null) return;
                if (HName == "北京控股666")
                {
                    HPlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));
                }
                else
                {
                    HPlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, HName)));
                }
              
                if (HNameNums.ContainsKey(HPlayer))
                {
                    HNums = HNameNums[HPlayer];
                }
                SetHData();
            }
        }

        private string hName;

        public string HName
        {
            get { return hName; }
            set
            {
                hName = value;
                this.RaisePropertyChanged(nameof(HName));


            }
        }


        private string aName;

        public string AName
        {
            get { return aName; }
            set { aName = value; this.RaisePropertyChanged(nameof(AName)); }
        }


        private string hNums;

        public string HNums
        {
            get { return hNums; }

            set { hNums = value; this.RaisePropertyChanged(nameof(HNums)); }
        }


        private string aNums;

        public string ANums
        {
            get { return aNums; }

            set { aNums = value; this.RaisePropertyChanged(nameof(ANums)); }
        }

        private string title = "球员对比数据";

        public string Title
        {
            get { return title; }

            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }


        private string matchStatus;

        public string MatchStatus
        {
            get { return matchStatus; }

            set
            {
                matchStatus = value;
                this.RaisePropertyChanged(nameof(MatchStatus));
            }
        }

        public VCommand BtnCommand { get; set; }

        public VCommand PlayerComCommand { get; set; }


        public VCommand MatchCmd { get; set; }


        //球员赛季数据
        public string Matchtypeid = "";
        //比赛赛程Id
        public string ScheduleID = "";

        /// <summary>
        /// 球员赛季数据
        /// </summary>
        public PlayerSeasonData PlayerSeasonData = new PlayerSeasonData();

        /// <summary>
        /// 队伍赛程信息
        /// </summary>
        public TeamSeasonData TeamSeasonData = new TeamSeasonData();

        public OnAirDataModel onAirDataModel = new OnAirDataModel();

        //向字典中个人选手增加整个赛季的分数值
        public Dictionary<string, Dictionary<string, string>> CNAliasPlayerSportsDictionary
            = new Dictionary<string, Dictionary<string, string>>();


        /// <summary>
        /// 设置一个比赛赛程集合
        /// </summary>
        public Dictionary<string, string> SetMatchDict = new Dictionary<string, string>();


        private void playerComCommand()
        {
            if (matchStatsId == null)
            {
                MessageBox.Show("请选择几行对比项");
            }
            else
            {
                Log.Info("球员对比上版和数据："+ CombinePlayerCommand());
               // ApplicationDomainEx.VizEngineModel.STAGE_START("Default/SQY", "dqyData", CombinePlayerCommand());
                // CombinePlayerCommand();
            }
        }


        /// <summary>
        /// 组装包装发送的球员信息
        /// </summary>
        /// <returns></returns>
        public string CombinePlayerCommand()
        {
            try
            {



                string data = "";
                if (matchStatsId != null)
                {
                    data += matchStatsId.Replace(" ", "") + "*";
                }
                else
                {
                    data += "7*";
                }

                data += title.Replace(" ", "") + "*";

                if (!string.IsNullOrEmpty(HName))
                {
                    data += HName.Replace(" ", "") + "*";
                }
                else
                {
                    data += "" + "*";
                }

                if (!string.IsNullOrEmpty(HPlayer))
                {
                    data += HPlayer.Replace(" ", "") + "*";
                }
                else
                {
                    data += "" + "*";
                }

                if (!string.IsNullOrEmpty(AName))
                {
                    data += AName.Replace(" ", "") + "*";
                }
                else
                {
                    data += "" + "*";
                }

                if (!string.IsNullOrEmpty(APlayer))
                {
                    data += APlayer.Replace(" ", "") + "&";
                }
                else
                {
                    data += "" + "&";
                }


                foreach (var tempPlayerComModel in playerComModels)
                {
                    if (tempPlayerComModel.SelectLight == "不高亮")
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(tempPlayerComModel.HScore))
                    {
                        data += tempPlayerComModel.HScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(tempPlayerComModel.HSeasonScore))
                    {
                        data += tempPlayerComModel.HSeasonScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    data += tempPlayerComModel.TechStatsName.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(tempPlayerComModel.AScore))
                    {
                        data += tempPlayerComModel.AScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(tempPlayerComModel.ASeasonScore))
                    {
                        data += tempPlayerComModel.ASeasonScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }



                }

                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }

        }


        public void BtnCmd()
        {
            onAirDataModel = JsonModel.PostOnAirData_Path(ScheduleID);
            if (onAirDataModel == null) return;
            SetPlayer(false);
            SetAData();
            SetHData();
        }


        private void MatchTechCmd()
        {

        }

        /// <summary>
        /// 根据日期获取赛程
        /// </summary>

        private async void GetSchedule()
        {
            try

            {
                MatchItems = new ObservableCollection<string>();
                string date = Convert.ToDateTime(matchDate).ToString("yyyy-MM-dd");

                var dayschedules = await JsonModel.PostTomorrowMatch_Path(date);

                if (dayschedules == null) return;
                // matchData.AddRange(dayschedules.dayschedule);
                //MatchData = new ObservableCollection<Dayschedule>();

                //if (dayschedules != null)
                //{
                dayschedules.dayschedule = dayschedules.dayschedule.OrderBy(a => Convert.ToDateTime(a.time)).ToList();
                // }

                SetMatchDict.Clear();
                MatchItems.Clear();

                foreach (var dayschedule in dayschedules.dayschedule)
                {
                    if (dayschedule.Status == "1")
                    {
                        dayschedule.Status = "未开赛";
                    }
                    else if (dayschedule.Status == "2")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "3")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "4")
                    {
                        dayschedule.Status = "已结束";
                    }
                    else if (dayschedule.Status == "5")
                    {
                        dayschedule.Status = "延期";
                    }

                    if (!SetMatchDict.ContainsKey(dayschedule.time + dayschedule.HomeTeamName
                                + "VS" + dayschedule.VisitingTeamName))
                    {
                        SetMatchDict.Add(dayschedule.time + dayschedule.HomeTeamName
                                    + "VS" + dayschedule.VisitingTeamName, dayschedule.ScheduleID);
                    }

                    Matchtypeid = dayschedule.ScheduleTypeID;

                    MatchItems.Add(dayschedule.time + dayschedule.HomeTeamName
                                + "VS" + dayschedule.VisitingTeamName);
                    GetSeasonData();

                }
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
            }
        }

        /// <summary>
        /// 获得赛季球队数据
        /// </summary>
        private async void GetSeasonData()
        {
            try

            {
                PlayerSeasonData = await JsonModel.PostPlayerSeasonData_Path(Matchtypeid);

                TeamSeasonData = await JsonModel.PostTeamSeasonData_Path(Matchtypeid);


                CNAliasPlayerSportsDictionary.Clear();
                if (PlayerSeasonData == null) return;
                foreach (var tempSeasonData in PlayerSeasonData.playerstats)
                {
                    Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                    CompareItemToNumber.Add("得分", tempSeasonData.PointsAverage);
                    CompareItemToNumber.Add("篮板", tempSeasonData.ReboundsAverage);
                    CompareItemToNumber.Add("助攻", tempSeasonData.AssistsAverage);
                    CompareItemToNumber.Add("抢断", tempSeasonData.StealsAverage);
                    CompareItemToNumber.Add("盖帽", tempSeasonData.BlockedAverage);
                    CompareItemToNumber.Add("上场时间", tempSeasonData.MinutesAverage);
                    CompareItemToNumber.Add("投篮命中率", (tempSeasonData.FieldGoalsPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("两分命中率", (tempSeasonData.TwoPointPercentageAverage).ToString("F1") + "%");

                    CompareItemToNumber.Add("三分命中率", (tempSeasonData.ThreePointPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("罚球命中率", (tempSeasonData.FreeThrowsPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("篮下投篮命中率", (tempSeasonData.FieldGoalsAtRimPercentageAverage * 100).ToString("F1") + "%");
                    CompareItemToNumber.Add("中距离投篮命中率", (tempSeasonData.FieldGoalsMidRangePercentageAverage * 100).ToString("F1") + "%");
                    CompareItemToNumber.Add("三分", tempSeasonData.ThreePointGoalsAverage + "/"
                                + tempSeasonData.ThreePointAttemptedAverage);


                    CompareItemToNumber.Add("两分", tempSeasonData.TwoPointGoalsAverage + "/"
                                + tempSeasonData.TwoPointAttemptedAverage);


                    CompareItemToNumber.Add("两分区", tempSeasonData.TwoPointGoalsAverage + "/"
                                + tempSeasonData.TwoPointAttemptedAverage);
                    CompareItemToNumber.Add("三分区", tempSeasonData.ThreePointGoalsAverage + "/"

                 + tempSeasonData.ThreePointAttemptedAverage);
                    //CompareItemToNumber.Add("ThreeArea",);

                    CompareItemToNumber.Add("罚球", tempSeasonData.FreeThrowsAverage + "/"
                                + tempSeasonData.FreeThrowsAttemptedAverage);
                    CompareItemToNumber.Add("失误", tempSeasonData.TurnoversAverage);

                    if (!CNAliasPlayerSportsDictionary.ContainsKey(tempSeasonData.CNAlias))
                    {
                        CNAliasPlayerSportsDictionary.Add(tempSeasonData.CNAlias, CompareItemToNumber);
                    }

                }
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
            }
        }



        public void SetCompareData()
        {
            //if (SelectMatchItems == null) return;
            //ScheduleID = SetMatchDict[SelectMatchItems];
            GetSeasonData();
            onAirDataModel = JsonModel.PostOnAirData_Path(ScheduleID);


            if (onAirDataModel == null) return;
            if (onAirDataModel != null)
            {

                if (onAirDataModel.liveTeamInfo.StatusCNName == "")
                {
                    MatchStatus = "未开始";
                }
                else if (onAirDataModel.liveTeamInfo.StatusCNName != "")
                {
                    MatchStatus = onAirDataModel.liveTeamInfo.StatusCNName;
                }
            }
            else
            {
                MatchStatus = "未开始";
            }


            HName = onAirDataModel.liveTeamInfo.HomeTeamCNAlias;

            AName = onAirDataModel.liveTeamInfo.VisitingTeamCNAlias;
            SetPlayer();
        }

        /// <summary>
        /// 设置主队球员技术统计信息
        /// </summary>

        public void SetHData()
        {

            if (hPlayer == null) return;
            if (MvpHomePlayerCompareNumDictionary.ContainsKey(HPlayer))
            {
                var playSeaSonData = MvpHomePlayerCompareNumDictionary[HPlayer];

                foreach (var teamPlayer in PlayerComModels)
                {
                    if (playSeaSonData.ContainsKey(teamPlayer.TechStatsName.ToString()))
                    {
                        teamPlayer.HScore = playSeaSonData[teamPlayer.TechStatsName.ToString()];
                    }
                    else
                    {
                        teamPlayer.HScore = "0";
                    }
                }
            }



            //if (vm != null)
            //{
            //var singlePlayerData = mainViewModel.PlayerSeasonData.PlayerstatsList.Where(a => a.CNAlias == vm.SelectPlayer).FirstOrDefault();

            if (CNAliasPlayerSportsDictionary.ContainsKey(HPlayer))
            {
                var playSeaSonData = CNAliasPlayerSportsDictionary[HPlayer];

                foreach (var teamPlayer in PlayerComModels)
                {
                    if (playSeaSonData.ContainsKey(teamPlayer.TechStatsName.ToString()))
                    {
                        teamPlayer.HSeasonScore = playSeaSonData[teamPlayer.TechStatsName.ToString()];
                    }
                    else
                    {
                        teamPlayer.HSeasonScore = "0";
                    }
                }
            }
            //}

        }


        /// <summary>
        /// 设置客队球员技术统计信息
        /// </summary>
        public void SetAData()
        {
            if (APlayer == null) return;
            if (MvpVisitPlayerCompareNumDictionary.ContainsKey(APlayer))
            {
                var playSeaSonData = MvpVisitPlayerCompareNumDictionary[APlayer];

                foreach (var teamPlayer in PlayerComModels)
                {
                    if (playSeaSonData.ContainsKey(teamPlayer.TechStatsName.ToString()))
                    {
                        teamPlayer.AScore = playSeaSonData[teamPlayer.TechStatsName.ToString()];
                    }
                    else
                    {
                        teamPlayer.AScore = "0";
                    }
                }
            }

            //if (vm != null)
            //{
            //var singlePlayerData = mainViewModel.PlayerSeasonData.PlayerstatsList.Where(a => a.CNAlias == vm.SelectPlayer).FirstOrDefault();

            if (CNAliasPlayerSportsDictionary.ContainsKey(APlayer))
            {
                var playSeaSonData = CNAliasPlayerSportsDictionary[APlayer];

                foreach (var teamPlayer in PlayerComModels)
                {
                    if (playSeaSonData.ContainsKey(teamPlayer.TechStatsName.ToString()))
                    {
                        teamPlayer.ASeasonScore = playSeaSonData[teamPlayer.TechStatsName.ToString()];
                    }
                    else
                    {
                        teamPlayer.ASeasonScore = "0";
                    }
                }
            }
            //}
        }

    }
}
