﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Module;

namespace VIZ.TVP.CBA.Module
{
    /// <summary>
    /// Interaction logic for RoundMatchUI.xaml
    /// </summary>
    public partial class RoundMatchView : UserControl, IPluginView
    {
        RoundMatchViewModel vm = null;
        public RoundMatchView()
        {
            InitializeComponent();

            WPFHelper.BindingViewModel(this,new RoundMatchViewModel());
            vm = this.DataContext as RoundMatchViewModel;
            this.Loaded += RoundMatchView_Load;
        }

        public void Dispose()
        {
            
        }

        public void PreviewContinue(ConnModel conn)
        {
            
        }

        public void PreviewIn(ConnModel conn)
        {
            if(conn.IsConnected&& vm.RoundMatchData!=null)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }
        }

        public void PreviewOut(ConnModel conn)
        {
           //if(conn.IsConnected)
           //{
           //     conn.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
           //}
        }

        public void TakeContinue(ConnModel conns)
        {
            
        }

        public void TakeOut(ConnModel conns)
        {
            if(conns.IsConnected&&vm.RoundMatchData!=null)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        public void TakeUpdate(ConnModel conns)
        {
            if (conns.IsConnected && vm.RoundMatchData != null)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }
        }

        public void TakIn(ConnModel conns)
        {
            if (conns.IsConnected && vm.RoundMatchData != null)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }
        }



        /// <summary>
        /// 注册任务
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void RoundMatchView_Load(object sender, RoutedEventArgs e)
        {
            if (task != null)
                return;

            task = new PackageTaskModel(this);
            task.PreviewUpdateAction = OnPreviewUpdate;
            task.TakeUpdateAction = OnTakeUpdate;
            task.Name = "比赛轮次";

            IPackageTaskService service = ApplicationDomainEx.ServiceManager.GetService<IPackageTaskService>(ViewServiceKeys.PACKAGE_TASK_SERVICE);
            if (service == null)
                return;

            service.Register(task);

        }


        /// <summary>
        /// 任务模型
        /// </summary>
        public PackageTaskModel task;

        private void OnPreviewUpdate(ConnModel conn)
        {
            if (conn.IsConnected)
            {
                vm.SetRoundMatchData();
                //task.CanExecute = vm.flag;
                //SCRIPT_INVOKE
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }
        }

        private void OnTakeUpdate(ConnModel conn)
        {
            if (conn.IsConnected)
            {
                vm.SetRoundMatchData();

                //SCRIPT_INVOKE
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineMatchData()));
            }
        }



    }
}
