﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using log4net;

namespace VIZ.TVP.CBA.Module
{
    public class RoundMatchViewModel: ViewModelBase
    {

        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log=LogManager.GetLogger(typeof(RoundMatchViewModel));  

        public RoundMatchViewModel()
        {
            RoundMatchs = new ObservableCollection<int>();
            for (int i = 1; i < 43; i++)
            {
                RoundMatchs.Add(i);
            }

            roundMatchItem = 1;



            //roundMatchData = new ObservableCollection<RoundSchedule>()
            //{
            //    new RoundSchedule()
            //    {
            //        Round="1",
            //        ScheduleID="12345",
            //        ScheduleTypeID="常规赛",
            //        mon="11",
            //        day="12",
            //        VisitingTeamName="火龙",
            //        HomeTeamName="热火",
            //        HomeTeamScore="10",
            //        VisitingTeamScore="30",
            //        dates="2022-12-8",
            //        time="18:00",
            //        Status="未开始"
            //    },
            //    new RoundSchedule()
            //    {
            //        Round="1",
            //        ScheduleID="12345",
            //        ScheduleTypeID="常规赛",
            //        mon="11",
            //        day="12",
            //        VisitingTeamName="火龙1",
            //        HomeTeamName="热火1",
            //        HomeTeamScore="101",
            //        VisitingTeamScore="301",
            //        dates="2022-12-9",
            //        time="18:00",
            //        Status="未开始"
            //    },

            //    new RoundSchedule()
            //    {
            //        Round="1",
            //        ScheduleID="12345",
            //        ScheduleTypeID="常规赛",
            //        VisitingTeamName="火龙",
            //        HomeTeamName="热火",
            //        HomeTeamScore="10",
            //        VisitingTeamScore="30",
            //        dates="2022-12-8",
            //        time="18:00",
            //        Status="进行中"

            //    },
            //    new RoundSchedule()
            //    {
            //        Round="1",
            //        ScheduleID="12345",
            //        ScheduleTypeID="常规赛",
            //        VisitingTeamName="火龙1",
            //        HomeTeamName="热火1",
            //        HomeTeamScore="101",
            //        VisitingTeamScore="301",
            //        dates="2022-12-9",
            //        time="18:00",
            //        Status="进行中"
            //    },
            //     new RoundSchedule()
            //    {
            //        Round="1",
            //        ScheduleID="12345",
            //        ScheduleTypeID="常规赛",
            //        VisitingTeamName="火龙",
            //        HomeTeamName="热火",
            //        HomeTeamScore="10",
            //        VisitingTeamScore="30",
            //        dates="2022-12-8",
            //        time="18:00",
            //        Status="已结束"
            //    },
            //    new RoundSchedule()
            //    {
            //        Round="1",
            //        ScheduleID="12345",
            //        ScheduleTypeID="常规赛",
            //        VisitingTeamName="火龙1",
            //        HomeTeamName="热火1",
            //        HomeTeamScore="101",
            //        VisitingTeamScore="301",
            //        dates="2022-12-9",
            //        time="18:00",
            //        Status="已结束"
            //    }
            //};

            BtnCmd = new VCommand(BtnCommand);
            BtnCmdUp = new VCommand(BtnCmdDataUp);
        }

        private int roundMatchItem;

        public int RoundMatchItem
        {
            get { return roundMatchItem; }
            set { roundMatchItem = value; this.RaisePropertyChanged(nameof(RoundMatchItem)); }
        }


        private ObservableCollection<int> roundMatch;

        public ObservableCollection<int> RoundMatchs
        {
            get { return roundMatch; }
            set { roundMatch = value; this.RaisePropertyChanged(nameof(RoundMatchs)); }
        }

        private string title="本轮赛程";


        public string Title
        {
            get { return title; }
            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }

        public VCommand BtnCmd { get; set; }


        public VCommand BtnCmdUp { get; set; }

        private void BtnCmdDataUp()
        {
            Log.Info("轮次比赛上版信息和数据:" + CombineMatchData());
            //ApplicationDomainEx.VizEngineModel.STAGE_START("Default/JRSCBEN", "Data", CombineMatchData());
           
        }


        public string CombineMatchData()
        {
            try
            {


                string data = "";
                data += title;
                data += "&";

                foreach (var tempRoundMatchData in RoundMatchData)
                {
                    if (tempRoundMatchData.SelectLight == "不高亮")
                    {
                        data += "0";
                        data += "*";
                    }
                    else
                    {
                        data += "1";
                        data += "*";
                    }

                    data += tempRoundMatchData.dates.Replace(" ", "");

                    data += "*";
                    data += tempRoundMatchData.time.Replace(" ", "");

                    data += "*";
                    data += tempRoundMatchData.HomeTeamName.Replace(" ", "");

                    data += "*";
                    data += tempRoundMatchData.HomeTeamScore.Replace(" ", "");

                    data += "*";
                    data += tempRoundMatchData.VisitingTeamName.Replace(" ", "");

                    data += "*";
                    data += tempRoundMatchData.VisitingTeamScore.Replace(" ", "");

                    data += "*";
                    data += tempRoundMatchData.Status.Replace(" ", "");

                    data += ";";

                }

                return data;
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }


        public void BtnCommand()
        {

            SetRoundMatchData();

        }


        public void SetRoundMatchData()
        {
            var roundSchedules = JsonModel.PostGetGameRound_Path(roundMatchItem.ToString());

            if (roundSchedules == null) return;
            RoundMatchData = new ObservableCollection<RoundSchedule>();

            foreach (var rudData in roundSchedules.schedulelist)
            {
                if (rudData.Status == "1")
                {
                    rudData.Status = "未开赛";
                }
                else if (rudData.Status == "2")
                {
                    rudData.Status = "进行中";
                }
                else if (rudData.Status == "3")
                {
                    rudData.Status = "进行中";
                }
                else if (rudData.Status == "4")
                {
                    rudData.Status = "已结束";
                }
                else if (rudData.Status == "5")
                {
                    rudData.Status = "延期";
                }

                RoundMatchData.Add(rudData);
            }

            RoundMatchData = RoundMatchData.OrderBy(a => a.MatchGTM8Time).ToObservableCollection();
        }

        private ObservableCollection<RoundSchedule> roundMatchData;
        public ObservableCollection<RoundSchedule> RoundMatchData
        {
            get { return roundMatchData; }

            set { roundMatchData = value; this.RaisePropertyChanged(nameof(RoundMatchData)); }
        }


        //private ObservableCollection<string> lightHigts;


        //public ObservableCollection<string> LightHigts
        //{
        //    get
        //    {
        //        return lightHigts;
        //    }
        //    set { lightHigts = value; this.RaisePropertyChanged(nameof(LightHigts)); }

        //}

        //private string light;

        //public string Light
        //{
        //    get { return light; }
        //    set { light = value; this.RaisePropertyChanged(nameof(Light)); }
        //}

    }
}
