﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Domain;
using VIZ.Package.Module;

namespace VIZ.TVP.CBA.Module
{
   /// <summary>
   /// 数据访问配置
   /// </summary>
    public class HttpUrlPluginLifeCycle : IPluginLifeCycle
    {
        /// <summary>
        /// 插件ID
        /// </summary>
        /// <remarks>
        /// 插件ID不能包含点号
        /// </remarks>
        public const string PLUGIN_ID = "HttpUrlConfigView";

        /// <summary>
        /// 插件名称
        /// </summary>
        public const string PLUGIN_NAME = "数据访问配置";

        /// <summary>
        /// 注册
        /// </summary>
        /// <returns>插件信息</returns>
        public PluginInfo Register()
        {
            PluginInfo info = new PluginInfo();
            info.ID = PLUGIN_ID;
            info.Name = PLUGIN_NAME;
            info.Group = PluginConstant.GroupName;
            info.PluginType = PluginType.Setting;
            info.ViewType  = typeof(HttpUrlConfigView);
            return info;
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {

        }
    }
}
