﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using System.ComponentModel;
using log4net;
using System.Windows.Media.Imaging;
using System.Windows.Media;

namespace VIZ.TVP.CBA.Module
{
    public class SinglePlayerViewModel: ViewModelBase
    {

        private static ILog Log= LogManager.GetLogger(typeof(SinglePlayerViewModel));   

        //private static SinglePlayerViewModel _createInstance = null;

        public static List<SinglePlayerViewModel> SinglePlayerViewModelInstance =new List<SinglePlayerViewModel>();
        //{
        //    get
        //    {
        //        if (null == _createInstance)
        //        {
        //            _createInstance = new SinglePlayerViewModel();
        //        }
        //        return _createInstance;
        //    }
        //}


        public SinglePlayerViewModel()
        {

            matchStatsIds = new ObservableCollection<int>()
            {
                3,
                4,
                5,
                6,
                7
            };

            BtnCmd = new VCommand(BtnCommand);
            SingleCommand = new VCommand(singleCommand);

            MVPCommand = new VCommand(mvpCommand);
            matchDate = DateTime.Today.ToShortDateString();
            //GetSchedule();
      

            singlePlayerData = new ObservableCollection<SinglePlayerModel>();

            SinglePlayerModel PlayGoal = new SinglePlayerModel();
            PlayGoal.TechStatsName = "得分";
            PlayGoal.PropertyChanged += OnModelChanged;
            singlePlayerData.Add(PlayGoal);

            SinglePlayerModel Rebounds = new SinglePlayerModel();
            Rebounds.TechStatsName = "篮板";
            Rebounds.PropertyChanged += OnModelChanged;
            singlePlayerData.Add(Rebounds);

            SinglePlayerModel Assists = new SinglePlayerModel();
            Assists.TechStatsName = "助攻";
            Assists.PropertyChanged += OnModelChanged;
            singlePlayerData.Add(Assists);

            SinglePlayerModel Blocks = new SinglePlayerModel();
            Blocks.TechStatsName = "盖帽";
            Blocks.PropertyChanged += OnModelChanged;
            singlePlayerData.Add(Blocks);

            SinglePlayerModel Steals = new SinglePlayerModel();
            Steals.TechStatsName = "抢断";
            Steals.PropertyChanged += OnModelChanged;
            singlePlayerData.Add(Steals);

            SinglePlayerModel ShootingGoalP = new SinglePlayerModel();
            ShootingGoalP.TechStatsName = "投篮命中率";
            ShootingGoalP.PropertyChanged += OnModelChanged;
            singlePlayerData.Add(ShootingGoalP);

            SinglePlayerModel ThreeShootingGoalP = new SinglePlayerModel();
            ThreeShootingGoalP.TechStatsName = "三分命中率";
            ThreeShootingGoalP.PropertyChanged += OnModelChanged;
            singlePlayerData.Add(ThreeShootingGoalP);


            //{
            //    new  SinglePlayerModel()
            //    {
            //       // TechStats=TechStats.Goal,

            //        TechStatsName="得分"

            //    },
            //    new  SinglePlayerModel()
            //    {
            //       //TechStats=TechStats.Rebounds,
            //        TechStatsName="篮板"
            //    },
            //    new  SinglePlayerModel()
            //    {
            //      // TechStats=TechStats.Assists,

            //       TechStatsName="助攻"

            //    },

            //    new SinglePlayerModel()
            //    {
            //       // TechStats=TechStats.Blocks,
            //        TechStatsName="盖帽"
            //    },
            //     new SinglePlayerModel()
            //    {
            //       // TechStats=TechStats.Steals,
            //        TechStatsName="抢断"
            //    },

            //    new SinglePlayerModel()
            //    {
            //       // TechStats=TechStats.ShootingGoalP,
            //        TechStatsName="投篮命中率"
            //    },

            //    new SinglePlayerModel()
            //    {
            //        //TechStats=TechStats.ThreeShootingGoalP,

            //        TechStatsName="三分命中率"
            //    }


            //};

            //TechStatsIds = new ObservableCollection<string>()
            //{
            //    "Goal",
            //    "Rebounds",
            //    "Assists",
            //    "Steals",
            //    "Blocks",
            //    "",

            //};
        }


       public ObservableCollection<string> PlayerDataCompareOptionChinese = new ObservableCollection<string> { "得分","篮板","助攻", "抢断", "盖帽","上场时间","投篮命中率","两分命中率","三分命中率","罚球命中率",
            "篮下投篮命中率","中距离投篮命中率","三分","两分","两分区","三分区","三秒区","罚球","失误"};


        private string matchStatsId;

        public string MatchStatsId
        {
            get { return matchStatsId; }

            set
            {
                matchStatsId = value; 
                this.RaisePropertyChanged(nameof(MatchStatsId));

                SetTechStats();
            }
        }



        private string matchDate;

        public string MatchDate
        {
            get { return matchDate; }
            set
            { 
                matchDate = value; 
                this.RaisePropertyChanged(nameof(MatchDate));
                GetSchedule();
                //GetSeasonData();
            }
        }

        private ObservableCollection<int> matchStatsIds;

        public ObservableCollection<int> MatchStatsIds
        {
            get { return matchStatsIds; }

            set { matchStatsIds = value; this.RaisePropertyChanged(nameof(MatchStatsIds)); }
        }

        private SinglePlayerModel singlePlayer;

        public SinglePlayerModel SinglePlayer
        {
            get { return singlePlayer; }    
            set { singlePlayer = value; this.RaisePropertyChanged(nameof(SinglePlayer)); }  
        }


        private ObservableCollection<SinglePlayerModel> singlePlayerData;

        public ObservableCollection<SinglePlayerModel> SinglePlayerData
        {
            get { return singlePlayerData; }
            set { singlePlayerData = value; this.RaisePropertyChanged(nameof(SinglePlayerData)); }
        }


        public ObservableCollection<string> playerItems;

        public ObservableCollection<string> PlayerItems
        {
            get { return playerItems; }

            set { playerItems = value;this.RaisePropertyChanged(nameof(PlayerItems)); }
        }

        private string selectPlayer;

        public string SelectPlayer
        {
            get { return selectPlayer; }
            set
            {
                selectPlayer = value;
                this.RaisePropertyChanged(nameof(SelectPlayer));

                if (selectedIndex < 0||selectPlayer==null)
                    return;


                string baesePath = AppDomain.CurrentDomain.BaseDirectory;



                if (selectedIndex==0)
                {
                    if(HNameNums.ContainsKey(selectPlayer))
                    {
                        PlayNum = HNameNums[selectPlayer];

                        if (TeamItems[selectedIndex] == "北京控股666")
                        {
                            PlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));
                        }
                        else
                        {
                            PlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, TeamItems[selectedIndex])));
                        }
                            
                    }
                }
                else
                {
                    if(VNameNums.ContainsKey(selectPlayer))
                    {
                        PlayNum = VNameNums[selectPlayer];

                        if (TeamItems[selectedIndex] == "北京控股666")
                        {
                            PlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));
                        }
                        else
                        {
                            PlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, TeamItems[selectedIndex])));
                        }
                        
                    }
                }

                SetData();
            }
        }


        private ObservableCollection<string> teamItems;

        public ObservableCollection<string> TeamItems
        {
            get { return teamItems; }
            set { teamItems = value;this.RaisePropertyChanged(nameof(TeamItems)); } 
        }

        private string selectTeamItem;

        public  string SelectTeamItem
        {
            get { return selectTeamItem;}
            set
            { 
                selectTeamItem = value;
                this.RaisePropertyChanged(nameof(SelectTeamItem));
             

            }  
        }


        private string playNum;

        public string PlayNum
        {
            get { return playNum; }
            set { playNum=value;this.RaisePropertyChanged(nameof(PlayNum)); }
        }

        private int selectedIndex;

        

        /// <summary>
        /// 0 是主队 1 是客队
        /// </summary>

        public int SelectedIndex
        {
            get { return selectedIndex;}    
            set 
            { 
                selectedIndex = value;

                this.RaisePropertyChanged(nameof(SelectedIndex));
                SetPlayer(selectedIndex);
            } 
        }


        private ImageSource playerLogo;

       public ImageSource PlayerLogo
        {
            get { return playerLogo; }
            set
            {
                playerLogo = value;this.RaisePropertyChanged(nameof(PlayerLogo));
            }
        }

        public VCommand BtnCmd { get; set; }

        public VCommand TeamSelectCommand { get; set; }



        private string title = "单个球员";

        public string Title
        {
            get { return title; }

            set { title = value;this.RaisePropertyChanged(nameof(Title)); }
        }

        public VCommand SingleCommand { get; set; }

        public VCommand MVPCommand { get; set; }

        public Dictionary<string, string> HNameNums = new Dictionary<string, string>();

        public Dictionary<string, string> VNameNums = new Dictionary<string, string>();

        /// <summary>
        /// 主队球员技术统计数据
        /// </summary>
        public Dictionary<string, Dictionary<string, string>> MvpHomePlayerCompareNumDictionary
      = new Dictionary<string, Dictionary<string, string>>();

        /// <summary>
        /// 客队球员技术统计数据
        /// </summary>
        public Dictionary<string, Dictionary<string, string>> MvpVisitPlayerCompareNumDictionary
              = new Dictionary<string, Dictionary<string, string>>();

        //向字典中个人选手增加整个赛季的分数值
        public Dictionary<string, Dictionary<string, string>> CNAliasPlayerSportsDictionary
            = new Dictionary<string, Dictionary<string, string>>();

        private void SetPlayer(int index)
        {

            if (index < 0) return;
            MvpHomePlayerCompareNumDictionary.Clear();
            MvpVisitPlayerCompareNumDictionary.Clear();

            PlayerItems = new System.Collections.ObjectModel.ObservableCollection<string>();

            if (index == 0)
            {
                foreach (var teamLive in onAirDataModel.livePlayerStatH)
                {
     

                    PlayerItems.Add(teamLive.CNAlias);

                    if (!HNameNums.ContainsKey(teamLive.CNAlias))
                    {
                        HNameNums.Add(teamLive.CNAlias, teamLive.Number);
                    }


                    //   Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                    //   CompareItemToNumber.Add("Goal", teamLive.Points);
                    //   CompareItemToNumber.Add("Rebounds", teamLive.Rebounds);
                    //   CompareItemToNumber.Add("Assists", teamLive.Assists);
                    //   CompareItemToNumber.Add("Steals", teamLive.Steals);
                    //   CompareItemToNumber.Add("Blocks", teamLive.Blocked);
                    //   CompareItemToNumber.Add("PlayTime", teamLive.Minutes);
                    //   CompareItemToNumber.Add("ShootingGoalP", (teamLive.FieldGoalsPercentage).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("TwoShootingGoalP", (teamLive.TwoPointPercentage).ToString("F1") + "%");

                    //   CompareItemToNumber.Add("ThreeShootingGoalP", (teamLive.ThreePointPercentage).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("FreeThrowP", (teamLive.FreeThrowsPercentage).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("ShootingUnderBaketP", (teamLive.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("MidShootingP", (teamLive.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("ThreeScore", teamLive.ThreePointGoals + "/"
                    //               + teamLive.ThreePointAttempted);


                    //   CompareItemToNumber.Add("TwoScore", teamLive.TwoPointGoals + "/"
                    //               + teamLive.TwoPointAttempted);


                    //   CompareItemToNumber.Add("TwoArea", teamLive.TwoPointGoals + "/"
                    //               + teamLive.TwoPointAttempted);
                    //   CompareItemToNumber.Add("ThreeArea", teamLive.ThreePointGoals + "/"

                    //+ teamLive.ThreePointAttempted);
                    //   //CompareItemToNumber.Add("ThreeArea",);

                    //   CompareItemToNumber.Add("FreeThrow", teamLive.FreeThrows + "/"
                    //               + teamLive.FreeThrowsAttempted);
                    //   CompareItemToNumber.Add("Error", teamLive.Turnovers);

                    //   mainViewModel.MvpHomePlayerCompareNumDictionary.Add(teamLive.CNAlias, CompareItemToNumber);

                    Utils.SetTechStatsInfo(this, index, teamLive, null);



                }



            }
            else
            {
                foreach (var teamLive in onAirDataModel.livePlayerStatV)
                {

                    PlayerItems.Add(teamLive.CNAlias);

                    if (!VNameNums.ContainsKey(teamLive.CNAlias))
                    {
                        VNameNums.Add(teamLive.CNAlias, teamLive.Number);
                    }

                    Utils.SetTechStatsInfo(this, index, null, teamLive);

                    //   Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                    //   CompareItemToNumber.Add("Goal", teamLive.Points);
                    //   CompareItemToNumber.Add("Rebounds", teamLive.Rebounds);
                    //   CompareItemToNumber.Add("Assists", teamLive.Assists);
                    //   CompareItemToNumber.Add("Steals", teamLive.Steals);
                    //   CompareItemToNumber.Add("Blocks", teamLive.Blocked);
                    //   CompareItemToNumber.Add("PlayTime", teamLive.Minutes);
                    //   CompareItemToNumber.Add("ShootingGoalP", (teamLive.FieldGoalsPercentage).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("TwoShootingGoalP", (teamLive.TwoPointPercentage).ToString("F1") + "%");

                    //   CompareItemToNumber.Add("ThreeShootingGoalP", (teamLive.ThreePointPercentage).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("FreeThrowP", (teamLive.FreeThrowsPercentage).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("ShootingUnderBaketP", (teamLive.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("MidShootingP", (teamLive.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("ThreeScore", teamLive.ThreePointGoals + "/"
                    //               + teamLive.ThreePointAttempted);


                    //   CompareItemToNumber.Add("TwoScore", teamLive.TwoPointGoals + "/"
                    //               + teamLive.TwoPointAttempted);


                    //   CompareItemToNumber.Add("TwoArea", teamLive.TwoPointGoals + "/"
                    //               + teamLive.TwoPointAttempted);
                    //   CompareItemToNumber.Add("ThreeArea", teamLive.ThreePointGoals + "/"

                    //+ teamLive.ThreePointAttempted);
                    //   //CompareItemToNumber.Add("ThreeArea",);

                    //   CompareItemToNumber.Add("FreeThrow", teamLive.FreeThrows + "/"
                    //               + teamLive.FreeThrowsAttempted);
                    //   CompareItemToNumber.Add("Error", teamLive.Turnovers);
                    //   mainViewModel.MvpVisitPlayerCompareNumDictionary.Add(teamLive.CNAlias, CompareItemToNumber);

                }
            }
        }


        private void SetTechStats()
        {
            SinglePlayerData.Clear();

            if (Convert.ToInt32(MatchStatsId) == 3)
            {
                SinglePlayerData = new ObservableCollection<SinglePlayerModel>();


                SinglePlayerModel PlayGoal = new SinglePlayerModel();
                PlayGoal.TechStatsName = "得分";
                PlayGoal.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(PlayGoal);

                SinglePlayerModel Rebounds = new SinglePlayerModel();
                Rebounds.TechStatsName = "篮板";
                Rebounds.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Rebounds);

                SinglePlayerModel Assists = new SinglePlayerModel();
                Assists.TechStatsName = "助攻";
                Assists.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Assists);

                //{
                //    new  SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.Goal,

                //        TechStatsName="得分"

                //    },
                //    new  SinglePlayerModel()
                //    {
                //       //TechStats=TechStats.Rebounds,
                //        TechStatsName="篮板"
                //    },
                //    new  SinglePlayerModel()
                //    {
                //      // TechStats=TechStats.Assists,

                //       TechStatsName="助攻"

                //    },
                //};
            }

            else if (Convert.ToInt32(MatchStatsId) == 4)
            {
                SinglePlayerData = new ObservableCollection<SinglePlayerModel>();

                SinglePlayerModel PlayGoal = new SinglePlayerModel();
                PlayGoal.TechStatsName = "得分";
                PlayGoal.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(PlayGoal);

                SinglePlayerModel Rebounds = new SinglePlayerModel();
                Rebounds.TechStatsName = "篮板";
                Rebounds.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Rebounds);

                SinglePlayerModel Assists = new SinglePlayerModel();
                Assists.TechStatsName = "助攻";
                Assists.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Assists);

                SinglePlayerModel Blocks = new SinglePlayerModel();
                Blocks.TechStatsName = "盖帽";
                Blocks.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Blocks);

                //{
                //    new  SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.Goal,

                //        TechStatsName="得分"

                //    },
                //    new  SinglePlayerModel()
                //    {
                //       //TechStats=TechStats.Rebounds,
                //        TechStatsName="篮板"
                //    },
                //    new  SinglePlayerModel()
                //    {
                //      // TechStats=TechStats.Assists,

                //       TechStatsName="助攻"

                //    },

                //    new SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.Blocks,
                //        TechStatsName="盖帽"
                //    }



                //};
            }

            else if (Convert.ToInt32(MatchStatsId) == 5)
            {
                SinglePlayerData = new ObservableCollection<SinglePlayerModel>();
                SinglePlayerModel PlayGoal = new SinglePlayerModel();
                PlayGoal.TechStatsName = "得分";
                PlayGoal.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(PlayGoal);

                SinglePlayerModel Rebounds = new SinglePlayerModel();
                Rebounds.TechStatsName = "篮板";
                Rebounds.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Rebounds);

                SinglePlayerModel Assists = new SinglePlayerModel();
                Assists.TechStatsName = "助攻";
                Assists.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Assists);

                SinglePlayerModel Blocks = new SinglePlayerModel();
                Blocks.TechStatsName = "盖帽";
                Blocks.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Blocks);

                SinglePlayerModel Steals = new SinglePlayerModel();
                Steals.TechStatsName = "抢断";
                Steals.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Steals);

                //{
                //    new  SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.Goal,

                //        TechStatsName="得分"

                //    },
                //    new  SinglePlayerModel()
                //    {
                //       //TechStats=TechStats.Rebounds,
                //        TechStatsName="篮板"
                //    },
                //    new  SinglePlayerModel()
                //    {
                //      // TechStats=TechStats.Assists,

                //       TechStatsName="助攻"

                //    },

                //    new SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.Blocks,
                //        TechStatsName="盖帽"
                //    },
                //     new SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.Steals,
                //        TechStatsName="抢断"
                //    }



           // };

            }
            else if (Convert.ToInt32(MatchStatsId) == 6)
            {
                SinglePlayerData = new ObservableCollection<SinglePlayerModel>();

                SinglePlayerModel PlayGoal = new SinglePlayerModel();
                PlayGoal.TechStatsName = "得分";
                PlayGoal.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(PlayGoal);

                SinglePlayerModel Rebounds = new SinglePlayerModel();
                Rebounds.TechStatsName = "篮板";
                Rebounds.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Rebounds);

                SinglePlayerModel Assists = new SinglePlayerModel();
                Assists.TechStatsName = "助攻";
                Assists.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Assists);

                SinglePlayerModel Blocks = new SinglePlayerModel();
                Blocks.TechStatsName = "盖帽";
                Blocks.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Blocks);

                SinglePlayerModel Steals = new SinglePlayerModel();
                Steals.TechStatsName = "抢断";
                Steals.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Steals);

                SinglePlayerModel ShootingGoalP = new SinglePlayerModel();
                ShootingGoalP.TechStatsName = "投篮命中率";
                ShootingGoalP.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(ShootingGoalP);

      
                //{
                //    new  SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.Goal,

                //        TechStatsName="得分"

                //    },
                //    new  SinglePlayerModel()
                //    {
                //       //TechStats=TechStats.Rebounds,
                //        TechStatsName="篮板"
                //    },
                //    new  SinglePlayerModel()
                //    {
                //      // TechStats=TechStats.Assists,

                //       TechStatsName="助攻"

                //    },

                //    new SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.Blocks,
                //        TechStatsName="盖帽"
                //    },
                //     new SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.Steals,
                //        TechStatsName="抢断"
                //    },

                //    new SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.ShootingGoalP,
                //        TechStatsName="投篮命中率"
                //    }


            //};



            }
            else
            {
                SinglePlayerData = new ObservableCollection<SinglePlayerModel>();
                SinglePlayerModel PlayGoal = new SinglePlayerModel();
                PlayGoal.TechStatsName = "得分";
                PlayGoal.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(PlayGoal);

                SinglePlayerModel Rebounds = new SinglePlayerModel();
                Rebounds.TechStatsName = "篮板";
                Rebounds.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Rebounds);

                SinglePlayerModel Assists = new SinglePlayerModel();
                Assists.TechStatsName = "助攻";
                Assists.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Assists);

                SinglePlayerModel Blocks = new SinglePlayerModel();
                Blocks.TechStatsName = "盖帽";
                Blocks.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Blocks);

                SinglePlayerModel Steals = new SinglePlayerModel();
                Steals.TechStatsName = "抢断";
                Steals.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(Steals);

                SinglePlayerModel ShootingGoalP = new SinglePlayerModel();
                ShootingGoalP.TechStatsName = "投篮命中率";
                ShootingGoalP.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(ShootingGoalP);

                SinglePlayerModel ThreeShootingGoalP = new SinglePlayerModel();
                ThreeShootingGoalP.TechStatsName = "三分命中率";
                ThreeShootingGoalP.PropertyChanged += OnModelChanged;
                singlePlayerData.Add(ThreeShootingGoalP);
                //{
                //    new  SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.Goal,

                //        TechStatsName="得分"

                //    },
                //    new  SinglePlayerModel()
                //    {
                //       //TechStats=TechStats.Rebounds,
                //        TechStatsName="篮板"
                //    },
                //    new  SinglePlayerModel()
                //    {
                //      // TechStats=TechStats.Assists,

                //       TechStatsName="助攻"

                //    },

                //    new SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.Blocks,
                //        TechStatsName="盖帽"
                //    },
                //     new SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.Steals,
                //        TechStatsName="抢断"
                //    },

                //    new SinglePlayerModel()
                //    {
                //       // TechStats=TechStats.ShootingGoalP,
                //        TechStatsName="投篮命中率"
                //    },

                //    new SinglePlayerModel()
                //    {
                //        //TechStats=TechStats.ThreeShootingGoalP,

                //        TechStatsName="三分命中率"
                //    }


                //};
            }

            SetData();
        }

        /// <summary>
        /// 单个球员数据
        /// </summary>
        private void singleCommand()
        {
            if(matchStatsId==null)
            {
                MessageBox.Show("请选择几行对比项");
            }

            else if(Convert.ToInt32(matchStatsId)<5)
            {
                MessageBox.Show("单人球员只能选择5-7项");
            }
            else
            {
                Log.Info("单人球员数据："+ CombineSingleData());
                //ApplicationDomainEx.VizEngineModel.STAGE_START("Default/DQY", "dqyData", CombineSingleData());
                
            }
        }

        /// <summary>
        /// mvp球员数据
        /// </summary>
        private void mvpCommand()
        {
            if (matchStatsId == null)
            {
                MessageBox.Show("请选择几行对比项");
            }

            else if (Convert.ToInt32(matchStatsId) > 5)
            {
                MessageBox.Show("单人球员只能选择5-7项");
            }
            else
            {
                Log.Info("MVP球员数据："+ CombineSingleData());
                //ApplicationDomainEx.VizEngineModel.STAGE_START("Default/DQY", "dqyData", CombineSingleData());
            }
        }

        /// <summary>
        /// 下拉框绑定得赛程详细信息
        /// </summary>

        private ObservableCollection<string> matchItems;

        public ObservableCollection<string> MatchItems
        {
            get { return matchItems; }
            set { matchItems = value; this.RaisePropertyChanged(nameof(MatchItems)); }
        }


        /// <summary>
        /// 选中得赛程信息
        /// </summary>
        private string selectMatchItems;


        public string SelectMatchItems
        {
            get { return selectMatchItems; }
            set
            {
                selectMatchItems = value;
                this.RaisePropertyChanged(nameof(SelectMatchItems));
                SetSingleData();
            }
        }

        /// <summary>
        ///比赛状态
        /// </summary>
        private string matchStatus;

        public string MatchStatus
        {
            get { return matchStatus; }

            set
            {
                matchStatus = value;
                this.RaisePropertyChanged(nameof(MatchStatus));
            }
        }

        //球员赛季数据
        public string Matchtypeid = "";
        //比赛赛程Id
        public string ScheduleID = "";

        /// <summary>
        /// 球员赛季数据
        /// </summary>
        public PlayerSeasonData PlayerSeasonData = new PlayerSeasonData();

        /// <summary>
        /// 队伍赛程信息
        /// </summary>
        public TeamSeasonData TeamSeasonData = new TeamSeasonData();

        public OnAirDataModel onAirDataModel = new OnAirDataModel();


        /// <summary>
        /// 设置一个比赛赛程集合
        /// </summary>
        public Dictionary<string, string> SetMatchDict = new Dictionary<string, string>();


        /// <summary>
        /// 设置单个球员相关的信息
        /// </summary>
        public void SetSingleData()
        {
            //if (SelectMatchItems == null) return;
            //ScheduleID = SetMatchDict[SelectMatchItems];

            GetSeasonData();
            onAirDataModel = JsonModel.PostOnAirData_Path(ScheduleID);
            if (onAirDataModel == null) return;
            if (onAirDataModel != null)
            {

                if (onAirDataModel.liveTeamInfo.StatusCNName == "")
                {
                    MatchStatus = "未开始";
                }
                else if (onAirDataModel.liveTeamInfo.StatusCNName != "")
                {
                    MatchStatus = onAirDataModel.liveTeamInfo.StatusCNName;
                }
            }
            else
            {
                MatchStatus = "未开始";
            }

            TeamItems = new System.Collections.ObjectModel.ObservableCollection<string>();
            TeamItems.Add(onAirDataModel.liveTeamInfo.HomeTeamCNAlias);
            TeamItems.Add(onAirDataModel.liveTeamInfo.VisitingTeamCNAlias);
            SetPlayer(selectedIndex);

            //PlayerCompareViewModel.HName = vm.onAirDataModel.liveTeamInfo.HomeTeamCNAlias;
            //PlayerCompareViewModel.AName = vm.onAirDataModel.liveTeamInfo.VisitingTeamCNAlias;

            //teamStatsViewModel.HomeTeam = vm.onAirDataModel.liveTeamInfo.HomeTeamCNAlias;

            //teamStatsViewModel.AwayTeam = vm.onAirDataModel.liveTeamInfo.VisitingTeamCNAlias;


            //PlayerCompareViewModel.SetPlayer();


        }


        private void OnModelChanged(object sender, PropertyChangedEventArgs e)
        {
            if (e.PropertyName == "TechStatsName")
            {
                SetData();
            
            }
            //NotifyPropertyChanged("AuthResult");
        }




        /// <summary>
        /// 获取日期类型
        /// </summary>

        private async void GetSchedule()
        {
            try
            {
                MatchItems = new ObservableCollection<string>();
                string date = Convert.ToDateTime(matchDate).ToString("yyyy-MM-dd");

                var dayschedules = await JsonModel.PostTomorrowMatch_Path(date);

                if (dayschedules == null) return;

                // matchData.AddRange(dayschedules.dayschedule);
                //MatchData = new ObservableCollection<Dayschedule>();

                //if (dayschedules != null)
                //{
                dayschedules.dayschedule = dayschedules.dayschedule.OrderBy(a => Convert.ToDateTime(a.time)).ToList();
                //}

                SetMatchDict.Clear();
                MatchItems.Clear();

                foreach (var dayschedule in dayschedules.dayschedule)
                {
                    if (dayschedule.Status == "1")
                    {
                        dayschedule.Status = "未开赛";
                    }
                    else if (dayschedule.Status == "2")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "3")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "4")
                    {
                        dayschedule.Status = "已结束";
                    }
                    else if (dayschedule.Status == "5")
                    {
                        dayschedule.Status = "延期";
                    }

                    if (!SetMatchDict.ContainsKey(dayschedule.time + dayschedule.HomeTeamName
                                + "VS" + dayschedule.VisitingTeamName))
                    {
                        SetMatchDict.Add(dayschedule.time + dayschedule.HomeTeamName
                                    + "VS" + dayschedule.VisitingTeamName, dayschedule.ScheduleID);
                    }

                    Matchtypeid = dayschedule.ScheduleTypeID;

                    MatchItems.Add(dayschedule.time + dayschedule.HomeTeamName
                                + "VS" + dayschedule.VisitingTeamName);

                    GetSeasonData();

                }
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
            }

        }






        /// <summary>
        /// 获得赛季数据
        /// </summary>
        private async void GetSeasonData()
        {
            try
            {
                PlayerSeasonData = await JsonModel.PostPlayerSeasonData_Path(Matchtypeid);

                TeamSeasonData = await JsonModel.PostTeamSeasonData_Path(Matchtypeid);

                if (PlayerSeasonData == null) return;
                CNAliasPlayerSportsDictionary.Clear();
                foreach (var tempSeasonData in PlayerSeasonData.playerstats)
                {
                    Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                    CompareItemToNumber.Add("得分", tempSeasonData.PointsAverage);
                    CompareItemToNumber.Add("篮板", tempSeasonData.ReboundsAverage);
                    CompareItemToNumber.Add("助攻", tempSeasonData.AssistsAverage);
                    CompareItemToNumber.Add("抢断", tempSeasonData.StealsAverage);
                    CompareItemToNumber.Add("盖帽", tempSeasonData.BlockedAverage);
                    CompareItemToNumber.Add("上场时间", tempSeasonData.MinutesAverage);
                    CompareItemToNumber.Add("投篮命中率", (tempSeasonData.FieldGoalsPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("两分命中率", (tempSeasonData.TwoPointPercentageAverage).ToString("F1") + "%");

                    CompareItemToNumber.Add("三分命中率", (tempSeasonData.ThreePointPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("罚球命中率", (tempSeasonData.FreeThrowsPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("篮下投篮命中率", (tempSeasonData.FieldGoalsAtRimPercentageAverage * 100).ToString("F1") + "%");
                    CompareItemToNumber.Add("中距离投篮命中率", (tempSeasonData.FieldGoalsMidRangePercentageAverage * 100).ToString("F1") + "%");
                    CompareItemToNumber.Add("三分", tempSeasonData.ThreePointGoalsAverage + "/"
                                + tempSeasonData.ThreePointAttemptedAverage);


                    CompareItemToNumber.Add("两分", tempSeasonData.TwoPointGoalsAverage + "/"
                                + tempSeasonData.TwoPointAttemptedAverage);


                    CompareItemToNumber.Add("两分区", tempSeasonData.TwoPointGoalsAverage + "/"
                                + tempSeasonData.TwoPointAttemptedAverage);
                    CompareItemToNumber.Add("三分区", tempSeasonData.ThreePointGoalsAverage + "/"

                 + tempSeasonData.ThreePointAttemptedAverage);
                    //CompareItemToNumber.Add("ThreeArea",);

                    CompareItemToNumber.Add("罚球", tempSeasonData.FreeThrowsAverage + "/"
                                + tempSeasonData.FreeThrowsAttemptedAverage);
                    CompareItemToNumber.Add("失误", tempSeasonData.TurnoversAverage);

                    if (!CNAliasPlayerSportsDictionary.ContainsKey(tempSeasonData.CNAlias))
                    {
                        CNAliasPlayerSportsDictionary.Add(tempSeasonData.CNAlias, CompareItemToNumber);
                    }

                }
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
            }
        }

        /// <summary>
        /// 组装数据
        /// </summary>
        /// <returns></returns>
        public string CombineSingleData()
        {
            try
            {


                string data = "";

                if (matchStatsId != null)
                {
                    data += matchStatsId.Replace(" ", "") + "*";
                }
                else
                {
                    data += "7*";
                }


                data += title.Replace(" ", "") + "*";
                if (!string.IsNullOrEmpty(selectTeamItem))
                {
                    data += selectTeamItem.Replace(" ", "") + "*";
                }
                else
                {
                    data += "" + "*";
                }

                if (!string.IsNullOrEmpty(SelectPlayer))
                {
                    data += SelectPlayer.Replace(" ", "") + "&";
                }
                else
                {
                    data += "" + "&";
                }


                foreach (var tempSingleData in SinglePlayerData)
                {
                    if (tempSingleData.SelectLight == "不高亮")
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += tempSingleData.TechStatsName.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(tempSingleData.Score))
                    {
                        data += tempSingleData.Score.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(tempSingleData.SeasonScore))
                    {
                        data += tempSingleData.SeasonScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }

                }
                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }

        /// <summary>
        /// 上MVP球员数据
        /// </summary>
        /// <returns></returns>
        private string CombineMVPData()
        {
            string data = "";
            return data;
        }

        /// <summary>
        /// 刷新数据
        /// </summary>
        public void BtnCommand()
        {
            onAirDataModel = JsonModel.PostOnAirData_Path(ScheduleID);
            if (onAirDataModel == null) return;
            MvpHomePlayerCompareNumDictionary.Clear();
            MvpVisitPlayerCompareNumDictionary.Clear();
           // PlayerItems = new System.Collections.ObjectModel.ObservableCollection<string>();
            if (SelectedIndex == 0)
            {
                foreach (var teamLive in onAirDataModel.livePlayerStatH)
                {

                    //PlayerItems.Add(teamLive.CNAlias);

                    //if (!HNameNums.ContainsKey(teamLive.CNAlias))
                    //{
                    //    HNameNums.Add(teamLive.CNAlias, teamLive.Number);
                    //}


                    //   Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                    //   CompareItemToNumber.Add("Goal", teamLive.Points);
                    //   CompareItemToNumber.Add("Rebounds", teamLive.Rebounds);
                    //   CompareItemToNumber.Add("Assists", teamLive.Assists);
                    //   CompareItemToNumber.Add("Steals", teamLive.Steals);
                    //   CompareItemToNumber.Add("Blocks", teamLive.Blocked);
                    //   CompareItemToNumber.Add("PlayTime", teamLive.Minutes);
                    //   CompareItemToNumber.Add("ShootingGoalP", (teamLive.FieldGoalsPercentage).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("TwoShootingGoalP", (teamLive.TwoPointPercentage).ToString("F1") + "%");

                    //   CompareItemToNumber.Add("ThreeShootingGoalP", (teamLive.ThreePointPercentage).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("FreeThrowP", (teamLive.FreeThrowsPercentage).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("ShootingUnderBaketP", (teamLive.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("MidShootingP", (teamLive.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("ThreeScore", teamLive.ThreePointGoals + "/"
                    //               + teamLive.ThreePointAttempted);


                    //   CompareItemToNumber.Add("TwoScore", teamLive.TwoPointGoals + "/"
                    //               + teamLive.TwoPointAttempted);


                    //   CompareItemToNumber.Add("TwoArea", teamLive.TwoPointGoals + "/"
                    //               + teamLive.TwoPointAttempted);
                    //   CompareItemToNumber.Add("ThreeArea", teamLive.ThreePointGoals + "/"

                    //+ teamLive.ThreePointAttempted);
                    //   //CompareItemToNumber.Add("ThreeArea",);

                    //   CompareItemToNumber.Add("FreeThrow", teamLive.FreeThrows + "/"
                    //               + teamLive.FreeThrowsAttempted);
                    //   CompareItemToNumber.Add("Error", teamLive.Turnovers);

                    //   mainViewModel.MvpHomePlayerCompareNumDictionary.Add(teamLive.CNAlias, CompareItemToNumber);

                    Utils.SetTechStatsInfo(this, SelectedIndex, teamLive, null);



                }



            }
            else
            {
                foreach (var teamLive in onAirDataModel.livePlayerStatV)
                {

                    //PlayerItems.Add(teamLive.CNAlias);

                    //if (!VNameNums.ContainsKey(teamLive.CNAlias))
                    //{
                    //    VNameNums.Add(teamLive.CNAlias, teamLive.Number);
                    //}

                    Utils.SetTechStatsInfo(this, SelectedIndex, null, teamLive);

                    //   Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                    //   CompareItemToNumber.Add("Goal", teamLive.Points);
                    //   CompareItemToNumber.Add("Rebounds", teamLive.Rebounds);
                    //   CompareItemToNumber.Add("Assists", teamLive.Assists);
                    //   CompareItemToNumber.Add("Steals", teamLive.Steals);
                    //   CompareItemToNumber.Add("Blocks", teamLive.Blocked);
                    //   CompareItemToNumber.Add("PlayTime", teamLive.Minutes);
                    //   CompareItemToNumber.Add("ShootingGoalP", (teamLive.FieldGoalsPercentage).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("TwoShootingGoalP", (teamLive.TwoPointPercentage).ToString("F1") + "%");

                    //   CompareItemToNumber.Add("ThreeShootingGoalP", (teamLive.ThreePointPercentage).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("FreeThrowP", (teamLive.FreeThrowsPercentage).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("ShootingUnderBaketP", (teamLive.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("MidShootingP", (teamLive.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
                    //   CompareItemToNumber.Add("ThreeScore", teamLive.ThreePointGoals + "/"
                    //               + teamLive.ThreePointAttempted);


                    //   CompareItemToNumber.Add("TwoScore", teamLive.TwoPointGoals + "/"
                    //               + teamLive.TwoPointAttempted);


                    //   CompareItemToNumber.Add("TwoArea", teamLive.TwoPointGoals + "/"
                    //               + teamLive.TwoPointAttempted);
                    //   CompareItemToNumber.Add("ThreeArea", teamLive.ThreePointGoals + "/"

                    //+ teamLive.ThreePointAttempted);
                    //   //CompareItemToNumber.Add("ThreeArea",);

                    //   CompareItemToNumber.Add("FreeThrow", teamLive.FreeThrows + "/"
                    //               + teamLive.FreeThrowsAttempted);
                    //   CompareItemToNumber.Add("Error", teamLive.Turnovers);
                    //   mainViewModel.MvpVisitPlayerCompareNumDictionary.Add(teamLive.CNAlias, CompareItemToNumber);

                }
            }

            SetData();



        }


        /// <summary>
        /// 设置数据得分
        /// </summary>
        private void SetData()
        {

            if (SelectPlayer == null) return;
            if (SelectedIndex == 0)
            {
                //if (HNameNums.ContainsKey(vm?.SelectPlayer))
                //{
                //    vm.PlayNum = HNameNums[vm.SelectPlayer];
                //}

                if (MvpHomePlayerCompareNumDictionary.ContainsKey(SelectPlayer))
                {
                    var playSeaSonData = MvpHomePlayerCompareNumDictionary[SelectPlayer];

                    foreach (var teamPlayer in SinglePlayerData)
                    {
                        if (playSeaSonData.ContainsKey(teamPlayer.TechStatsName.ToString()))
                        {
                            teamPlayer.Score = playSeaSonData[teamPlayer.TechStatsName.ToString()];
                        }
                        else
                        {
                            teamPlayer.Score = "0";
                        }
                    }
                }


            }
            else
            {
                //if (VNameNums.ContainsKey(vm?.SelectPlayer))
                //{
                //    vm.PlayNum = VNameNums[vm.SelectPlayer];
                //}


                if (MvpVisitPlayerCompareNumDictionary.ContainsKey(SelectPlayer))
                {
                    var playSeaSonData = MvpVisitPlayerCompareNumDictionary[SelectPlayer];

                    foreach (var teamPlayer in SinglePlayerData)
                    {
                        if (playSeaSonData.ContainsKey(teamPlayer.TechStatsName.ToString()))
                        {
                            teamPlayer.Score = playSeaSonData[teamPlayer.TechStatsName.ToString()];
                        }
                        else
                        {
                            teamPlayer.Score = "0";
                        }
                    }
                }


            }

            if (SelectPlayer != null)
            {
                //var singlePlayerData = mainViewModel.PlayerSeasonData.PlayerstatsList.Where(a => a.CNAlias == vm.SelectPlayer).FirstOrDefault();

                if (CNAliasPlayerSportsDictionary.ContainsKey(SelectPlayer))
                {
                    var playSeaSonData = CNAliasPlayerSportsDictionary[SelectPlayer];

                    foreach (var teamPlayer in SinglePlayerData)
                    {
                        if (playSeaSonData.ContainsKey(teamPlayer.TechStatsName.ToString()))
                        {
                            teamPlayer.SeasonScore = playSeaSonData[teamPlayer.TechStatsName.ToString()];
                        }
                        else
                        {
                            teamPlayer.SeasonScore = "0";
                        }
                    }
                }
            }

        }

    }
}
