﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.TVP.CBA.Module
{
    /// <summary>
    /// Interaction logic for TeamStandingUI.xaml
    /// </summary>
    public partial class TeamStandingView : UserControl, IPluginView
    {
        TeamStandingViewModel vm = null;
        public TeamStandingView()
        {
            InitializeComponent();

            WPFHelper.BindingViewModel(this,new TeamStandingViewModel());
            vm = this.DataContext as TeamStandingViewModel;
        }

        public void Dispose()
        {
           
        }

        public void PreviewContinue(ConnModel conn)
        {
            //if(conn.IsConnected)
            //{
            //    conn.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            //}
        }

        public void PreviewIn(ConnModel conn)
        {
            //Data
            if (conn.IsConnected&&vm.TeamRanksModel!=null)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamStandingData()));
            }

        }

        public void PreviewOut(ConnModel conn)
        {
            
        }

        public void TakeContinue(ConnModel conns)
        {
            if (conns.IsConnected && vm.TeamRanksModel != null)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        public void TakeOut(ConnModel conns)
        {
            if (conns.IsConnected && vm.TeamRanksModel != null)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        public void TakeUpdate(ConnModel conns)
        {
            if (conns.IsConnected && vm.TeamRanksModel != null)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamStandingData()));
            }
        }

        public void TakIn(ConnModel conns)
        {
            if (conns.IsConnected && vm.TeamRanksModel != null)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "Data", vm.CombineTeamStandingData()));
            }
        }
    }
}
