﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using log4net;

namespace VIZ.TVP.CBA.Module
{
    public class TeamStandingViewModel: ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log= LogManager.GetLogger(typeof(TeamStandingViewModel));   

        /// <summary>
        /// 球队排名初始化排名
        /// </summary>
        public TeamStandingViewModel()
        {
            //TeamRanksModel = new ObservableCollection<Model.Teamrank>()
            //{
            //    new Model.Teamrank()
            //    {
            //        Id = 1,
            //        Wins=5,
            //        TeamCNAlias="热火1",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    },

            //    new Model.Teamrank()
            //    {
            //        Id = 2,
            //        Wins=5,
            //        TeamCNAlias="热火2",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    },


            //    new Model.Teamrank()
            //    {
            //        Id = 3,
            //        Wins=5,
            //        TeamCNAlias="热火3",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    },

            //    new Model.Teamrank()
            //    {
            //        Id = 4,
            //        Wins=5,
            //        TeamCNAlias="热火4",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    },
            //    new Model.Teamrank()
            //    {
            //        Id = 5,
            //        Wins=5,
            //        TeamCNAlias="热火5",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    },
            //    new Model.Teamrank()
            //    {
            //        Id = 6,
            //        Wins=5,
            //        TeamCNAlias="热火6",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    },
            //    new Model.Teamrank()
            //    {
            //        Id = 7,
            //        Wins=5,
            //        TeamCNAlias="热火7",
            //        Losses=2,
            //        CBARank=1,
            //        WinningPercentage=80,
            //        TeamID="123",
            //        TotalPoints=635,
            //        StreakType=1,
            //        StreakNumber=2,
            //        Integral=10
            //    }
            //};
            BtnCmd = new VCommand(BtmCommand);
            BtnCmdTeamStandingUp = new VCommand(BtnCmdTeamStandingUpData);
            BtnCmdNextPage = new VCommand(BtnCmdNextPageData);
        }


        private ObservableCollection<Teamrank> teamRanksModel;
        public ObservableCollection<Teamrank> TeamRanksModel
        {
            get { return teamRanksModel; }

            set { teamRanksModel = value; this.RaisePropertyChanged(nameof(TeamRanksModel)); }
        }

        public VCommand BtnCmd { get; set; }


        private void BtmCommand()
        {
            var teamStands = JsonModel.PostTeamScoreData_Path();
            if (teamStands == null) return;
            TeamRanksModel = new ObservableCollection<Teamrank>();
            int i = 1;
            foreach(var teamRank in teamStands.teamrank)
            {
                teamRank.Id = i;

                teamRank.WinningPercentageStr = (teamRank.WinningPercentage * 100).ToString("F1") + "%";

                if(teamRank.StreakType==1)
                {
                    teamRank.StreakName = "连胜";
                }
                else if(teamRank.StreakType==0)
                {
                    teamRank.StreakName = "连败";
                }
                TeamRanksModel.Add(teamRank);
                i++;
            }
        }



        public VCommand BtnCmdTeamStandingUp { get; set; }


        private void BtnCmdTeamStandingUpData()
        {
            if(TeamRanksModel!=null)
            {
                Log.Info("球队排名上版信息和数据："+ CombineTeamStandingData());
                //ApplicationDomainEx.VizEngineModel.STAGE_START("Default/JFB", "Data", CombineTeamStandingData());
            }
        }



        public VCommand BtnCmdNextPage { get; set; }


        private void BtnCmdNextPageData()
        {
           // ApplicationDomainEx.VizEngineModel.CONTINUE();
        }

        public string CombineTeamStandingData()
        {
            try
            {


                string data = "";

                data += title;

                data += "&";

                foreach (var tempTeamRankModel in TeamRanksModel)
                {
                    data += tempTeamRankModel.Id.ToString().Replace(" ", "");

                    data += "*";
                    data += tempTeamRankModel.TeamCNAlias.Replace(" ", "");

                    data += "*";
                    data += tempTeamRankModel.Wins.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.Losses.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.WinningPercentageStr.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.Integral.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.StreakNumber.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.StreakName.Replace(" ", "");
                    data += ";";
                }

                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }


        private string title = "球队积分排名";

        public string Title
        {
            get { return title;}
            set { title = value;this.RaisePropertyChanged(nameof(Title)); }   
        }

    }
}
