﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Module;

namespace VIZ.TVP.CBA.Module
{
    /// <summary>
    /// Interaction logic for NewTeamStatsView.xaml
    /// </summary>
    public partial class NewTeamStatsView : UserControl, IPluginView
    {
        public NewTeamStatsViewModel vm = new NewTeamStatsViewModel();
        public NewTeamStatsView()
        {
            InitializeComponent();

            NewTeamStatsViewModel.TeamStatsViewModelInstance.Add(vm);
            WPFHelper.BindingViewModel(this, vm);

            task_Start.IsEnabled = true;
            task_Stop.IsEnabled = false;
            task_continue.IsEnabled = false;
        }


        public void Dispose()
        {

        }

        public void PreviewContinue(ConnModel conn)
        {

        }

        public void PreviewIn(ConnModel conn)
        {
            if (conn.IsConnected)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombineTeamComData()));
            }
        }

        public void PreviewOut(ConnModel conn)
        {
            //if(conn.IsConnected)
            //{
            //    conn.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            //}
        }

        public void TakeContinue(ConnModel conns)
        {

        }

        public void TakeOut(ConnModel conns)
        {
            if (conns.IsConnected)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        public void TakeUpdate(ConnModel conns)
        {
            if (conns.IsConnected)
            {
                conns.EndpointManager.Send(string.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombineTeamComData()));
            }
        }

        public void TakIn(ConnModel conns)
        {
            if (conns.IsConnected)
            {
                conns.EndpointManager.Send(string.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombineTeamComData()));
            }
        }


        private void OnPreviewUpdate(ConnModel conn)
        {
            if (conn.IsConnected)
            {
                vm.BtnCmd();
                //task.CanExecute = vm.flag;
                //SCRIPT_INVOKE
                conn.EndpointManager.Send(string.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombineTeamComData()));
            }
        }

        private void OnTakeUpdate(ConnModel conn)
        {
            if (conn.IsConnected)
            {
                vm.BtnCmd();

                //SCRIPT_INVOKE
                conn.EndpointManager.Send(string.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombineTeamComData()));
            }
        }



        private void task_Start_Click(object sender, RoutedEventArgs e)
        {
            TeamStatsView_Init();
            task_Start.IsEnabled = false;
            task_Stop.IsEnabled = true;
            task_continue.IsEnabled = true;
        }

        private void task_continue_Click(object sender, RoutedEventArgs e)
        {
            if (task.IsRunning)
            {
                task.IsRunning = false;
                task_continue.Content = "任务继续";
            }
            else
            {
                task.IsRunning = true;
                task_continue.Content = "任务暂停";
            }
            task_Start.IsEnabled = false;
            task_Stop.IsEnabled = true;
        }

        private void task_Stop_Click(object sender, RoutedEventArgs e)
        {
            service.Cancel(task);

            task = null;
            task_Start.IsEnabled = true;
            task_continue.Content = "任务暂停";
            task_continue.IsEnabled = false;
            task_Stop.IsEnabled = false;
        }



        /// <summary>
        /// 任务模型
        /// </summary>
        public PackageTaskModel task;
        /// <summary>
        /// 服务
        /// </summary>
        IPackageTaskService service;

        /// <summary>
        /// 注册任务
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void TeamStatsView_Init()
        {
            if (task != null)
                return;

            task = new PackageTaskModel(this);
            task.PreviewUpdateAction = OnPreviewUpdate;
            task.TakeUpdateAction = OnTakeUpdate;
            task.IsPreviewEnabled = true;
            task.IsTakeEnabled = true;
            task.IsRunning = true;

            task.Name = "球队对比数据";
            service = ApplicationDomainEx.ServiceManager.GetService<IPackageTaskService>(ViewServiceKeys.PACKAGE_TASK_SERVICE);
            if (service == null)
                return;
            service.Register(task);

        }
    }
}
