﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using System.ComponentModel;
using log4net;

using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace VIZ.TVP.CBA.Module
{
    public class TeamStatsViewModel : ViewModelBase
    {

        private static ILog Log=LogManager.GetLogger(typeof(TeamStatsViewModel));

        // private static TeamStatsViewModel _createInstance = null;

        public static List<TeamStatsViewModel> TeamStatsViewModelInstance = new List<TeamStatsViewModel>();
        //{
        //    get
        //    {

        //        //if (null == _createInstance)
        //        //{
        //            Log.Error("CreateInstance");
        //            _createInstance = new TeamStatsViewModel();
        //        //}
        //        Log.Error("CreatedInstance");
        //        return _createInstance;
        //    }
        //}

        public TeamStatsViewModel()
        {
            BtnCommand = new VCommand(BtnCmd);

            BtnCmdUpData = new VCommand(BtnCmdTeamComUpData);
            matchStatsNumbers = new ObservableCollection<MatchStatsNumbers>();

            MatchStatsNumbers PlayGoal = new MatchStatsNumbers();
            PlayGoal.TechStatsName = "得分";
            PlayGoal.PropertyChanged += OnModelChanged;
            matchStatsNumbers.Add(PlayGoal);

            MatchStatsNumbers Rebounds = new MatchStatsNumbers();
            Rebounds.TechStatsName = "篮板";
            Rebounds.PropertyChanged += OnModelChanged;
            matchStatsNumbers.Add(Rebounds);

            MatchStatsNumbers Assists = new MatchStatsNumbers();
            Assists.TechStatsName = "助攻";
            Assists.PropertyChanged += OnModelChanged;
            matchStatsNumbers.Add(Assists);

            MatchStatsNumbers Blocks = new MatchStatsNumbers();
            Blocks.TechStatsName = "盖帽";
            Blocks.PropertyChanged += OnModelChanged;
            matchStatsNumbers.Add(Blocks);

            MatchStatsNumbers Steals = new MatchStatsNumbers();
            Steals.TechStatsName = "抢断";
            Steals.PropertyChanged += OnModelChanged;
            matchStatsNumbers.Add(Steals);

            MatchStatsNumbers ShootingGoalP = new MatchStatsNumbers();
            ShootingGoalP.TechStatsName = "投篮命中率";
            ShootingGoalP.PropertyChanged += OnModelChanged;
            matchStatsNumbers.Add(ShootingGoalP);

            MatchStatsNumbers ThreeShootingGoalP = new MatchStatsNumbers();
            ThreeShootingGoalP.TechStatsName = "三分命中率";
            ThreeShootingGoalP.PropertyChanged += OnModelChanged;
            matchStatsNumbers.Add(ThreeShootingGoalP);

            //{
            //    new MatchStatsNumbers()
            //    {
            //       // TechStats=TechStats.Goal
            //       TechStatsName="得分"
            //    },

            //    new  MatchStatsNumbers()
            //    {
            //       //TechStats=TechStats.Rebounds,

            //        TechStatsName="篮板"
            //    },
            //    new  MatchStatsNumbers()
            //    {
            //       //TechStats=TechStats.Assists,
            //       TechStatsName="助攻"

            //    },

            //    new MatchStatsNumbers()
            //    {
            //        //TechStats=TechStats.Blocks,
            //        TechStatsName="盖帽"
            //    },
            //     new MatchStatsNumbers()
            //    {
            //        //TechStats=TechStats.Steals,
            //        TechStatsName="抢断"
            //    },

            //    new MatchStatsNumbers()
            //    {
            //        //TechStats=TechStats.ShootingGoalP,
            //        TechStatsName="投篮命中率"
            //    },

            //    new MatchStatsNumbers()
            //    {
            //       // TechStats=TechStats.ThreeShootingGoalP,
            //        TechStatsName="三分命中率"
            //    }
            //};

            matchStatsIds = new ObservableCollection<int>()
            {
                5,
                6,
                7
            };

      
            matchDate = DateTime.Today.ToShortDateString();
           // GetSchedule();

        }


        public void SelectMatchNumbersCommand()
        {

        }



        private ObservableCollection<string> matchItems;

        /// <summary>
        /// 下拉框绑定得赛程详细信息
        /// </summary>
        public ObservableCollection<string> MatchItems
        {
            get { return matchItems; }
            set { matchItems = value; this.RaisePropertyChanged(nameof(MatchItems)); }
        }



        private string selectMatchItems;

        /// <summary>
        /// 选中得赛程信息
        /// </summary>
        public string SelectMatchItems
        {
            get { return selectMatchItems; }
            set
            {
                selectMatchItems = value;
                this.RaisePropertyChanged(nameof(SelectMatchItems));
                if (selectMatchItems == null) return;
                //SetSingleData();
                SetTeamData();
            }
        }

        private string matchStatus;

        public string MatchStatus
        {
            get { return matchStatus; }

            set
            {
                matchStatus = value;
                this.RaisePropertyChanged(nameof(MatchStatus));
            }
        }



        private string matchDate;

        public string MatchDate
        {
            get { return matchDate; }
            set
            {
                matchDate = value;
                this.RaisePropertyChanged(nameof(MatchDate));
                GetSchedule();
                //GetSeasonData();


            }
        }

        /// <summary>
        /// 主队队伍图标
        /// </summary>
        private ImageSource homeTeamLogo;

        public ImageSource HomeTeamLogo
        {
            get { return homeTeamLogo; }
            set { homeTeamLogo = value;this.RaisePropertyChanged(nameof(HomeTeamLogo)); }
        }



        /// <summary>
        /// 客队队伍图标
        /// </summary>
        private ImageSource awayTeamLogo;

        public ImageSource AwayTeamLogo
        {
            get { return awayTeamLogo; }
            set { awayTeamLogo = value; this.RaisePropertyChanged(nameof(AwayTeamLogo)); }
        }


        //球员赛季数据
        public string Matchtypeid = "";
        //比赛赛程Id
        public string ScheduleID = "";

        //创建【球队】数据对比时的字典---主队球员数据与对比项的一一对应【主队-例如:得分--读取接口得分数据】
        public Dictionary<string, string> HomeTeamCompareOptionDictionary = new Dictionary<string, string>();
        //创建【球队】数据对比时的字典---客队球员数据与对比项的一一对应【客队队-例如:得分--读取接口得分数据】
        public Dictionary<string, string> VisitTeamCompareOptionDictionary = new Dictionary<string, string>();

        public Dictionary<string, Dictionary<string, string>> CNAliasVisitSportsDictionary
= new Dictionary<string, Dictionary<string, string>>();

        /// <summary>
        /// 球员赛季数据
        /// </summary>
        public PlayerSeasonData PlayerSeasonData = new PlayerSeasonData();

        /// <summary>
        /// 队伍赛程信息
        /// </summary>
        public TeamSeasonData TeamSeasonData = new TeamSeasonData();

        /// <summary>
        /// 实时直播数据
        /// </summary>
        public OnAirDataModel onAirDataModel = new OnAirDataModel();

        /// <summary>
        /// 技术统计项
        /// </summary>
        private string matchStatsId;

        public string MatchStatsId
        {
            get { return matchStatsId; }

            set
            {

                matchStatsId = value;
                this.RaisePropertyChanged(nameof(MatchStatsId));


                if (Convert.ToInt32(MatchStatsId) == 7)
                {

                    MatchStatsNumbers = new ObservableCollection<MatchStatsNumbers>();

                    MatchStatsNumbers PlayGoal = new MatchStatsNumbers();
                    PlayGoal.TechStatsName = "得分";
                    PlayGoal.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(PlayGoal);

                    MatchStatsNumbers Rebounds = new MatchStatsNumbers();
                    Rebounds.TechStatsName = "篮板";
                    Rebounds.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(Rebounds);

                    MatchStatsNumbers Assists = new MatchStatsNumbers();
                    Assists.TechStatsName = "助攻";
                    Assists.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(Assists);

                    MatchStatsNumbers Blocks = new MatchStatsNumbers();
                    Blocks.TechStatsName = "盖帽";
                    Blocks.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(Blocks);

                    MatchStatsNumbers Steals = new MatchStatsNumbers();
                    Steals.TechStatsName = "抢断";
                    Steals.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(Steals);

                    MatchStatsNumbers ShootingGoalP = new MatchStatsNumbers();
                    ShootingGoalP.TechStatsName = "投篮命中率";
                    ShootingGoalP.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(ShootingGoalP);

                    MatchStatsNumbers ThreeShootingGoalP = new MatchStatsNumbers();
                    ThreeShootingGoalP.TechStatsName = "三分命中率";
                    ThreeShootingGoalP.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(ThreeShootingGoalP);

                }

                else if (Convert.ToInt32(MatchStatsId) == 6)
                {
                    MatchStatsNumbers = new ObservableCollection<MatchStatsNumbers>();

                    MatchStatsNumbers PlayGoal = new MatchStatsNumbers();
                    PlayGoal.TechStatsName = "得分";
                    PlayGoal.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(PlayGoal);

                    MatchStatsNumbers Rebounds = new MatchStatsNumbers();
                    Rebounds.TechStatsName = "篮板";
                    Rebounds.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(Rebounds);

                    MatchStatsNumbers Assists = new MatchStatsNumbers();
                    Assists.TechStatsName = "助攻";
                    Assists.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(Assists);

                    MatchStatsNumbers Blocks = new MatchStatsNumbers();
                    Blocks.TechStatsName = "盖帽";
                    Blocks.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(Blocks);

                    MatchStatsNumbers Steals = new MatchStatsNumbers();
                    Steals.TechStatsName = "抢断";
                    Steals.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(Steals);

                    MatchStatsNumbers ShootingGoalP = new MatchStatsNumbers();
                    ShootingGoalP.TechStatsName = "投篮命中率";
                    ShootingGoalP.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(ShootingGoalP);

                }

                else if (Convert.ToInt32(MatchStatsId) == 5)
                {
                    MatchStatsNumbers = new ObservableCollection<MatchStatsNumbers>();

                    MatchStatsNumbers PlayGoal = new MatchStatsNumbers();
                    PlayGoal.TechStatsName = "得分";
                    PlayGoal.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(PlayGoal);

                    MatchStatsNumbers Rebounds = new MatchStatsNumbers();
                    Rebounds.TechStatsName = "篮板";
                    Rebounds.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(Rebounds);

                    MatchStatsNumbers Assists = new MatchStatsNumbers();
                    Assists.TechStatsName = "助攻";
                    Assists.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(Assists);

                    MatchStatsNumbers Blocks = new MatchStatsNumbers();
                    Blocks.TechStatsName = "盖帽";
                    Blocks.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(Blocks);

                    MatchStatsNumbers Steals = new MatchStatsNumbers();
                    Steals.TechStatsName = "抢断";
                    Steals.PropertyChanged += OnModelChanged;
                    matchStatsNumbers.Add(Steals);
                }

                Utils.SetHData(this);
                Utils.SetAData(this);

            }
        }


        private ObservableCollection<MatchStatsNumbers> matchStatsNumbers;


        public ObservableCollection<MatchStatsNumbers> MatchStatsNumbers
        {
            get { return matchStatsNumbers; }

            set { matchStatsNumbers = value; this.RaisePropertyChanged(nameof(MatchStatsNumbers)); }
        }


        private ObservableCollection<int> matchStatsIds;

        public ObservableCollection<int> MatchStatsIds
        {
            get { return matchStatsIds; }

            set { matchStatsIds = value; this.RaisePropertyChanged(nameof(MatchStatsIds)); }
        }

        private string homeTeam;

        public string HomeTeam
        {
            get { return homeTeam; }
            set { homeTeam = value; this.RaisePropertyChanged(nameof(HomeTeam)); }
        }


        private string awayTeam;

        public string AwayTeam
        {
            get { return awayTeam; }

            set { awayTeam = value; this.RaisePropertyChanged(nameof(AwayTeam)); }
        }

        private string title = "球队对比数据";

        public string Title
        {
            get { return title; }

            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }

        public VCommand BtnCommand { get; set; }


        public VCommand BtnCmdUpData { get; set; }

        /// <summary>
        /// 上传球队对比数据
        /// </summary>
        private void BtnCmdTeamComUpData()
        {
            //CombineTeamComData();

            Log.Info("球队对比数据："+CombineTeamComData());

            //ApplicationDomainEx.VizEngineModel.STAGE_START("Default/SQD", "dqyData", CombineTeamComData());
        }


        public string CombineTeamComData()
        {
            try
            {
                string data = "";

                if (matchStatsId != null)
                {
                    data += matchStatsId.ToString().Replace(" ", "") + "*";
                }
                else
                {
                    data += "7*";
                }
                data += title.ToString().Replace(" ", "") + "*";

                if (!string.IsNullOrEmpty(homeTeam))
                {
                    data += homeTeam.Replace(" ", "") + "*";
                }
                else
                {
                    data += "" + "*";
                }

                if (!string.IsNullOrEmpty(awayTeam))
                {
                    data += awayTeam.Replace(" ", "") + "&";
                }
                else
                {
                    data += "" + "&";
                }



                foreach (var tempMatchStats in MatchStatsNumbers)
                {
                    if (tempMatchStats.SelectLight == "不高亮")
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(tempMatchStats.HomeScore))
                    {
                        data += tempMatchStats.HomeScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(tempMatchStats.HSeasonScore))
                    {
                        data += tempMatchStats.HSeasonScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    data += tempMatchStats.TechStatsName.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(tempMatchStats.AwayScore))
                    {
                        data += tempMatchStats.AwayScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(tempMatchStats.ASeasonScore))
                    {
                        data += tempMatchStats.ASeasonScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                }
                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }


        private void OnModelChanged(object sender, PropertyChangedEventArgs e)
        {
            if (e.PropertyName == "TechStatsName")
            {
                Utils.SetHData(this);
                Utils.SetAData(this);
            }
            //NotifyPropertyChanged("AuthResult");
        }


        public void BtnCmd()
        {
            onAirDataModel = JsonModel.PostOnAirData_Path(ScheduleID);
            if (onAirDataModel == null) return;
            Utils.SetHomeTeamDictionary(this);
            Utils.SetVisitTeamDictionary(this);
            Utils.SetHData(this);
            Utils.SetAData(this);
        }



        public async void SetTeamData()
        {
            //if (SelectMatchItems == null) return;
            //ScheduleID = SetMatchDict[SelectMatchItems];

            Log.Error(string.Format("teamStatsViewModel:{0}",ScheduleID));
            onAirDataModel = JsonModel.PostOnAirData_Path(ScheduleID);

            if (onAirDataModel == null) return;
            if (onAirDataModel != null)
            {

                if (onAirDataModel.liveTeamInfo.StatusCNName == "")
                {
                    MatchStatus = "未开始";
                }
                else if (onAirDataModel.liveTeamInfo.StatusCNName != "")
                {
                    MatchStatus = onAirDataModel.liveTeamInfo.StatusCNName;
                }
            }
            else
            {
                MatchStatus = "未开始";
            }



            //PlayerCompareViewModel.HName = vm.onAirDataModel.liveTeamInfo.HomeTeamCNAlias;
            //PlayerCompareViewModel.AName = vm.onAirDataModel.liveTeamInfo.VisitingTeamCNAlias;

            HomeTeam = onAirDataModel.liveTeamInfo.HomeTeamCNAlias;

   
            string baesePath = AppDomain.CurrentDomain.BaseDirectory;
            if (!string.IsNullOrEmpty(HomeTeam))
            {
                if (HomeTeam == "北京控股666")
                {
                    HomeTeamLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));
                }
                else
                {
                    HomeTeamLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, HomeTeam)));
                }
       
            }

            AwayTeam = onAirDataModel.liveTeamInfo.VisitingTeamCNAlias;

            if (!string.IsNullOrEmpty(AwayTeam))
            {
                if (AwayTeam == "北京控股666")
                {
                    AwayTeamLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));
                }
                else
                {
                    AwayTeamLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, AwayTeam)));
                }
            }

            TeamSeasonData = await JsonModel.PostTeamSeasonData_Path(Matchtypeid);
           
            SetTeamSeasonDictionary();

            Utils.SetHomeTeamDictionary(this);
            Utils.SetVisitTeamDictionary(this);
            Utils.SetHData(this);
            Utils.SetAData(this);


        }

        /// <summary>
        /// 设置球队赛季数据字典集合
        /// </summary>
        private void SetTeamSeasonDictionary()
        {
            CNAliasVisitSportsDictionary.Clear();
            if (TeamSeasonData == null) return;
            foreach (var teamSeasonData in TeamSeasonData.teamstats)
            {

                Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                CompareItemToNumber.Add("得分", teamSeasonData.PointsAverage);
                CompareItemToNumber.Add("篮板", teamSeasonData.ReboundsAverage);
                CompareItemToNumber.Add("助攻", teamSeasonData.AssistsAverage);
                CompareItemToNumber.Add("抢断", teamSeasonData.BlockedAverage);
                CompareItemToNumber.Add("盖帽", teamSeasonData.StealsAverage);
                CompareItemToNumber.Add("失误", teamSeasonData.TurnoversAverage);
                CompareItemToNumber.Add("犯规", teamSeasonData.PersonalFoulsAverage);
                //HomeTeamCompareOptionDictionary.Add(TeamDataCompareOptionChinese[7], Json_OnAirData.liveTeamStatH.FlagrantFouls);
                CompareItemToNumber.Add("罚球命中率", (teamSeasonData.FreeThrowsPercentageAverage).ToString("F1") + "%");
                CompareItemToNumber.Add("两分命中率", (teamSeasonData.TwoPointPercentageAverage).ToString("F1") + "%");
                CompareItemToNumber.Add("三分命中率", (teamSeasonData.ThreePointPercentageAverage).ToString("F1") + "%");
                CompareItemToNumber.Add("投篮命中率", (teamSeasonData.FieldGoalsPercentageAverage).ToString("F1") + "%");
                CompareItemToNumber.Add("篮下投篮命中率", (teamSeasonData.FieldGoalsAtRimPercentageAverage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("中距离投篮命中率", (teamSeasonData.FieldGoalsMidRangePercentageAverage * 100).ToString("F1") + "%");

                if(!CNAliasVisitSportsDictionary.ContainsKey(teamSeasonData.TeamCNAlias))
                {
                    CNAliasVisitSportsDictionary.Add(teamSeasonData.TeamCNAlias, CompareItemToNumber);
                }
              
            }


        }


        /// <summary>
        /// 设置一个比赛赛程集合
        /// </summary>
        public Dictionary<string, string> SetMatchDict = new Dictionary<string, string>();

        /// <summary>
        /// 获取日期类型
        /// </summary>

        private async void GetSchedule()
        {
            try

            {
                MatchItems = new ObservableCollection<string>();
                string date = Convert.ToDateTime(matchDate).ToString("yyyy-MM-dd");

                var dayschedules = await JsonModel.PostTomorrowMatch_Path(date);

                if (dayschedules == null) return;
                // matchData.AddRange(dayschedules.dayschedule);
                //MatchData = new ObservableCollection<Dayschedule>();

                //if (dayschedules != null)
                //{
                dayschedules.dayschedule = dayschedules.dayschedule.OrderBy(a => Convert.ToDateTime(a.time)).ToList();
                // }

                SetMatchDict.Clear();
                MatchItems.Clear();

                foreach (var dayschedule in dayschedules.dayschedule)
                {
                    if (dayschedule.Status == "1")
                    {
                        dayschedule.Status = "未开赛";
                    }
                    else if (dayschedule.Status == "2")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "3")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "4")
                    {
                        dayschedule.Status = "已结束";
                    }
                    else if (dayschedule.Status == "5")
                    {
                        dayschedule.Status = "延期";
                    }

                    if (!SetMatchDict.ContainsKey(dayschedule.time + dayschedule.HomeTeamName
                                + "VS" + dayschedule.VisitingTeamName))
                    {
                        SetMatchDict.Add(dayschedule.time + dayschedule.HomeTeamName
                                    + "VS" + dayschedule.VisitingTeamName, dayschedule.ScheduleID);
                    }

                    Matchtypeid = dayschedule.ScheduleTypeID;

                    MatchItems.Add(dayschedule.time + dayschedule.HomeTeamName
                                + "VS" + dayschedule.VisitingTeamName);

                }
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
            }

        }


        //private void GetSeasonData()
        //{
        //    PlayerSeasonData = JsonModel.PlayerSeasonData_Path(Matchtypeid);

        //    TeamSeasonData = JsonModel.TeamSeasonData_Path(Matchtypeid);


        //    CNAliasPlayerSportsDictionary.Clear();
        //    foreach (var tempSeasonData in PlayerSeasonData.playerstats)
        //    {
        //        Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

        //        CompareItemToNumber.Add("得分", tempSeasonData.PointsAverage);
        //        CompareItemToNumber.Add("篮板", tempSeasonData.ReboundsAverage);
        //        CompareItemToNumber.Add("助攻", tempSeasonData.AssistsAverage);
        //        CompareItemToNumber.Add("抢断", tempSeasonData.StealsAverage);
        //        CompareItemToNumber.Add("盖帽", tempSeasonData.BlockedAverage);
        //        CompareItemToNumber.Add("上场时间", tempSeasonData.MinutesAverage);
        //        CompareItemToNumber.Add("投篮命中率", (tempSeasonData.FieldGoalsPercentageAverage).ToString("F1") + "%");
        //        CompareItemToNumber.Add("两分命中率", (tempSeasonData.TwoPointPercentageAverage).ToString("F1") + "%");

        //        CompareItemToNumber.Add("三分命中率", (tempSeasonData.ThreePointPercentageAverage).ToString("F1") + "%");
        //        CompareItemToNumber.Add("罚球命中率", (tempSeasonData.FreeThrowsPercentageAverage).ToString("F1") + "%");
        //        CompareItemToNumber.Add("篮下投篮命中率", (tempSeasonData.FieldGoalsAtRimPercentageAverage * 100).ToString("F1") + "%");
        //        CompareItemToNumber.Add("中距离投篮命中率", (tempSeasonData.FieldGoalsMidRangePercentageAverage * 100).ToString("F1") + "%");
        //        CompareItemToNumber.Add("三分", tempSeasonData.ThreePointGoalsAverage + "/"
        //                    + tempSeasonData.ThreePointAttemptedAverage);


        //        CompareItemToNumber.Add("两分", tempSeasonData.TwoPointGoalsAverage + "/"
        //                    + tempSeasonData.TwoPointAttemptedAverage);


        //        CompareItemToNumber.Add("两分区", tempSeasonData.TwoPointGoalsAverage + "/"
        //                    + tempSeasonData.TwoPointAttemptedAverage);
        //        CompareItemToNumber.Add("三分区", tempSeasonData.ThreePointGoalsAverage + "/"

        //     + tempSeasonData.ThreePointAttemptedAverage);
        //        //CompareItemToNumber.Add("ThreeArea",);

        //        CompareItemToNumber.Add("罚球", tempSeasonData.FreeThrowsAverage + "/"
        //                    + tempSeasonData.FreeThrowsAttemptedAverage);
        //        CompareItemToNumber.Add("失误", tempSeasonData.TurnoversAverage);

        //        if (!CNAliasPlayerSportsDictionary.ContainsKey(tempSeasonData.CNAlias))
        //        {
        //            CNAliasPlayerSportsDictionary.Add(tempSeasonData.CNAlias, CompareItemToNumber);
        //        }

        //    }
        //}


    }
}
