﻿using DevExpress.ClipboardSource.SpreadsheetML;
using DevExpress.DirectX.Common.Direct2D;
using DevExpress.Xpf;
using DevExpress.XtraPrinting;
using log4net;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO.Packaging;
using System.Linq;
using System.Security.Policy;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
using VIZ.Package.Domain;

namespace VIZ.TVP.CBA.Module
{
    public static class JsonModel
    {

        /// <summary>
        /// 添加日志
        /// </summary>
        private static readonly ILog Log = LogManager.GetLogger(typeof(JsonModel));
        //AppConfigUtil.GetAppConfig("url")
        //AppConfigUtil.GetAppConfig("leagueId")

        //读取配置文件
        // public static AppSettingsSection sd = ConfigManage.InitLogConfig()?.AppSettings;
        //读取url
        private static AppSetup_InitCBALiteDB appSetup_InitCBALiteDB = AppSetup_InitCBALiteDB.CreateInstance;

        private static string httpStr = "http://sportsdata.misports.cn/beitai/api/";
        //新的URL
        public static string strUrl= AppSetup_InitCBALiteDB.HttpUrlConfigEntity.Url;
            //ApplicationDomainEx.HttpUrlConfig.Url;
        //ApplicationDomainEx.HttpUrlConfig.Url;
        //sd?.Settings["url"].Value.ToString();

        /// <summary>
        /// 读取艾果的数据平台的配置项
        /// </summary>
        public static string appID = AppSetup_InitCBALiteDB.HttpUrlConfigEntity.AppId;
        //sd.Settings["AppID"].Value.ToString();
        public static string appKey = AppSetup_InitCBALiteDB.HttpUrlConfigEntity.AppKey;
        //sd.Settings["AppKey"].Value.ToString();
        // private static string strUrl = sd.Settings["newUrl"].Value.ToString();

        private static string leagueid = "401";
        private static string customer = "migu";
        private static string key = "migu";
        private static string encrypted = "JU^MKceci";
        private static int random = new Random().Next(0, 100);

        //public static string TommorrowMatch_Path(string date);

        /// <summary>
        /// 明日赛程数据服务器接口
        /// </summary>
        /// <returns></returns>
        public async  static Task<Dayschedules> TomorrowMatch_Path(string date)
        {

            //Dictionary<string, string> dict = new Dictionary<string, string>();
            //dict.Add("leagueid", "401");
            //dict.Add("date", "2022-12-17");
            //dict.Add("customer", "migu");
            //dict.Add("key", "migu");
            //dict.Add("random", "4");
            //dict.Add("encrypted", "6587d013da014c99032f7d17b096ad73");
            //string newKey = Utils.GetKey(appID,appKey);
            //var str = JsonHelper.Post(strUrl, dict, newKey);

            Dayschedules dayschedules = new Dayschedules();
            try

            {
                await Task.Run(() =>
                {
                    string TomorrowMatchPath = httpStr + "schedule/getdayschedule?leagueid="
+ leagueid + "&date=" + date + "&customer=" + customer + "&key=" + key + "&encrypted="
+ Utils.GetMD5(key + encrypted + random) + "&random=" + random;
                    //MessageBox.Show(TomorrowMatchPath);
                    Console.WriteLine("明日赛程数据接口新新:=======>:" + TomorrowMatchPath);

                    string result = JsonHelper.GetResult(TomorrowMatchPath);

                    Log.Info("明日赛程数据接口新:=======>:" + result);
                    JsonSerializerSettings settings = new JsonSerializerSettings();
                    settings.NullValueHandling = NullValueHandling.Ignore;
                    dayschedules = JsonConvert.DeserializeObject<Dayschedules>(result, settings);

                    // Dayschedules aguodayschedules = JsonConvert.DeserializeObject<Dayschedules>(str,settings);
                });

                return dayschedules;

            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }

        }



        /// <summary>
        /// 艾果平台的明日赛程数据服务器接口
        /// </summary>
        /// <returns></returns>
        public async static Task<Dayschedules> PostTomorrowMatch_Path(string date)
        {

            //Dictionary<string, string> dict = new Dictionary<string, string>();
            //dict.Add("leagueid", "401");
            //dict.Add("date", "2022-12-17");
            //dict.Add("customer", "migu");
            //dict.Add("key", "migu");
            //dict.Add("random", "4");
            //dict.Add("encrypted", "6587d013da014c99032f7d17b096ad73");
            //string newKey = Utils.GetKey(appID,appKey);
            //var str = JsonHelper.Post(strUrl, dict, newKey);

            Dayschedules dayschedules = new Dayschedules();
            try

            {
                await Task.Run(() =>
                {
                    string TomorrowMatchPath = strUrl + "schedule/getdayschedule";
                    //+ leagueid + "&date=" + date + "&customer=" + customer + "&key=" + key + "&encrypted="
                    //+ Utils.GetMD5(key + encrypted + random) + "&random=" + random;
                    //                    //MessageBox.Show(TomorrowMatchPath);
                    //                    Console.WriteLine("明日赛程数据接口新新:=======>:" + TomorrowMatchPath);

                    //                    string result = JsonHelper.GetResult(TomorrowMatchPath);

                    //                    Log.Info("明日赛程数据接口新:=======>:" + result);
                    //                    JsonSerializerSettings settings = new JsonSerializerSettings();
                    //                    settings.NullValueHandling = NullValueHandling.Ignore;
                    //                    dayschedules = JsonConvert.DeserializeObject<Dayschedules>(result, settings);

                    // Dayschedules aguodayschedules = JsonConvert.DeserializeObject<Dayschedules>(str,settings);

                    Dictionary<string, string> dict = new Dictionary<string, string>();
                    dict.Add("leagueid", "401");
                    dict.Add("date", date);

                    string newKey = Utils.GetKey(appID, appKey);
                    var str = JsonHelper.Post(TomorrowMatchPath, dict, newKey);


                    Log.Info("明日赛程数据接口新:=======>:" + str);

                    JsonSerializerSettings settings = new JsonSerializerSettings();
                    settings.NullValueHandling = NullValueHandling.Ignore;
                    dayschedules = JsonConvert.DeserializeObject<Dayschedules>(str, settings);

                    dayschedules.dayschedule= dayschedules.dayschedule.OrderBy(a=>a.time).ToList();

                });

                return dayschedules;

            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }

        }
        /// <summary>
        /// 球队列表数据服务器接口地址
        /// </summary>
        /// <returns></returns>
        public static string TeamList_Path(string MatchtypeId)
        {
            try
            {
                string TeamListPath = httpStr + "schedule/load?leagueid="
    + leagueid + "&matchtypeid=" + MatchtypeId + "&customer=" + customer + "&key=" + key + "&encrypted="
    + Utils.GetMD5(key + encrypted + random) + "&random=" + random;

                Console.WriteLine("球队列表数据库服务器接口地址=====>:" + TeamListPath);

                Log.Info(TeamListPath);
                return TeamListPath;
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }

        }
        /// <summary>
        /// 球队球员单节数据服务器接口地址
        /// </summary>
        /// <returns></returns>
        public static string PlayerTeam_Path(string scheduleid)
        {
            string PlayerTeamPath = httpStr + "live/getlivequarterstats?leagueid="
                + leagueid + "&scheduleid=" + scheduleid + "&customer=" + customer + "&key=" + key + "&encrypted="
                + Utils.GetMD5(key + encrypted + random) + "&random=" + random;
            Console.WriteLine("一个赛程有多少球员信息和两个球队接口地址=======>:" + PlayerTeamPath);
            return PlayerTeamPath;
        }
        /// <summary>
        /// 球员列表数据服务器接口地址
        /// </summary>
        /// <returns></returns>
        public static string PlayerList_Path(string teamid)
        {
            string PlayerListPath = httpStr + "player?leagueid="
                 + leagueid + "&teamid=" + teamid + "&customer=" + customer + "&key=" + key + "&encrypted="
                 + Utils.GetMD5(key + encrypted + random) + "&random=" + random;
            Console.WriteLine("球员列表数据服务器接口地址=====>:" + PlayerListPath);
            return PlayerListPath;
        }
        /// <summary>
        /// 球员赛季数据服务器接口地址
        /// </summary>
        /// <param name="matchtypeid"></param>
        /// <returns></returns>
        public async static Task<PlayerSeasonData> PlayerSeasonData_Path(string matchtypeid)
        {
            PlayerSeasonData playerSeasonData = new PlayerSeasonData();
            try
            {

              await  Task.Run(() =>
                {
                    string PlayerSeasonDataPath = httpStr + "player/getplayerstats?leagueid="
     + leagueid + "&matchtypeid=" + matchtypeid + "&customer=" + customer + "&key=" + key + "&encrypted="
     + Utils.GetMD5(key + encrypted + random) + "&random=" + random;
                    //MessageBox.Show(PlayerSeasonDataPath);
                    Console.WriteLine("球员赛季数据的服务器接口地址====>:" + PlayerSeasonDataPath);

                    string result = JsonHelper.GetResult(PlayerSeasonDataPath);
                    JsonSerializerSettings settings = new JsonSerializerSettings();
                    settings.NullValueHandling = NullValueHandling.Ignore;

                    playerSeasonData = JsonConvert.DeserializeObject<PlayerSeasonData>(result,settings);

                    Log.Info(result);
                });

                return playerSeasonData;
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }
        }


        /// <summary>
        /// 球员赛季数据服务器接口地址
        /// </summary>
        /// <param name="matchtypeid"></param>
        /// <returns></returns>
        public async static Task<PlayerSeasonData> PostPlayerSeasonData_Path(string matchtypeid)
        {
            PlayerSeasonData playerSeasonData = new PlayerSeasonData();
            try
            {

                await Task.Run(() =>
                {
                    string PlayerSeasonDataPath = strUrl + "player/getplayerstats";
     
                    //MessageBox.Show(PlayerSeasonDataPath);
                    Console.WriteLine("球员赛季数据的服务器接口地址====>:" + PlayerSeasonDataPath);


                    Dictionary<string, string> dict = new Dictionary<string, string>();
                    dict.Add("leagueid", "401");
                    dict.Add("matchtypeid", matchtypeid);

                    string newKey = Utils.GetKey(appID, appKey);

                    string result = JsonHelper.Post(PlayerSeasonDataPath,dict,newKey);
                    JsonSerializerSettings settings = new JsonSerializerSettings();
                    settings.NullValueHandling = NullValueHandling.Ignore;
                    playerSeasonData = JsonConvert.DeserializeObject<PlayerSeasonData>(result,settings);

                    Log.Info("球员赛季数据的服务器接口地址====>:"+result);
                });

                return playerSeasonData;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }
        }


        /// <summary>
        /// 指定轮数的赛程的服务器接口地址
        /// </summary>
        /// <param name="matchtypeid"></param>
        /// <returns></returns>
        public static RoundSchedules GetGameRound_Path(string round)
        {
            try
            {
                string GameRoundDataPath = httpStr + "schedule/getschedulelist?leagueid="
                     + leagueid + "&round=" + round + "&customer=" + customer + "&key=" + key + "&encrypted="
                     + Utils.GetMD5(key + encrypted + random) + "&random=" + random;
                //MessageBox.Show(PlayerSeasonDataPath);
                Console.WriteLine("指定轮数的赛程的服务器接口地址====>:" + GameRoundDataPath);


                string result = JsonHelper.GetResult(GameRoundDataPath);

                Log.Info("指定轮数的赛程的服务器接口地址====>:"+result);
                JsonSerializerSettings settings = new JsonSerializerSettings();
                settings.NullValueHandling = NullValueHandling.Ignore;

                RoundSchedules roundSchedules = JsonConvert.DeserializeObject<RoundSchedules>(result, settings);
                return roundSchedules;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }
        }

        /// <summary>
        /// 指定轮数的赛程的服务器接口地址
        /// </summary>
        /// <param name="matchtypeid"></param>
        /// <returns></returns>
        public static RoundSchedules PostGetGameRound_Path(string round)
        {
            try
            {
                string GameRoundDataPath = strUrl + "schedule/getschedulelist";
                    
                //MessageBox.Show(PlayerSeasonDataPath);
                Console.WriteLine("指定轮数的赛程的服务器接口地址====>:" + GameRoundDataPath);


                Dictionary<string, string> dict = new Dictionary<string, string>();
                dict.Add("leagueid", "401");
                dict.Add("round", round);

                string newKey = Utils.GetKey(appID, appKey);

                string result = JsonHelper.Post(GameRoundDataPath,dict,newKey);

                Log.Info("指定轮数的赛程的服务器接口地址====>:" + result);
                JsonSerializerSettings settings = new JsonSerializerSettings();
                settings.NullValueHandling = NullValueHandling.Ignore;

                RoundSchedules roundSchedules = JsonConvert.DeserializeObject<RoundSchedules>(result, settings);
                return roundSchedules;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }
        }


        /// <summary>
        /// 全量直播数据
        /// </summary>
        /// <param name="scheduleid"></param>
        /// <returns></returns>
        public static OnAirDataModel OnAirData_Path(string scheduleid)
        {
            try
            {


                string OnAirDataPath = httpStr + "live?leagueid="
                    + leagueid + "&scheduleid=" + scheduleid + "&customer=" + customer + "&key=" + key + "&encrypted="
                    + Utils.GetMD5(key + encrypted + random) + "&random=" + random;
                //MessageBox.Show(OnAirDataPath);
                Console.WriteLine("全量直播数据==>:" + OnAirDataPath);
                string result = JsonHelper.GetResult(OnAirDataPath);
                Log.Info("全量直播数据==>:"+result);
                JsonSerializerSettings settings = new JsonSerializerSettings();
                settings.NullValueHandling = NullValueHandling.Ignore;

                OnAirDataModel onAirDataModel = JsonConvert.DeserializeObject<OnAirDataModel>(result, settings);

                return onAirDataModel;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }
        }


        /// <summary>
        /// 全量直播数据
        /// </summary>
        /// <param name="scheduleid"></param>
        /// <returns></returns>
        public static OnAirDataModel PostOnAirData_Path(string scheduleid)
        {
            try
            {


                string OnAirDataPath = strUrl + "live";
                //MessageBox.Show(OnAirDataPath);
                Console.WriteLine("全量直播数据==>:" + OnAirDataPath);


                Dictionary<string, string> dict = new Dictionary<string, string>();
                dict.Add("leagueid", "401");
                dict.Add("scheduleid", scheduleid);

                string newKey = Utils.GetKey(appID, appKey);

                string result = JsonHelper.Post(OnAirDataPath,dict,newKey);
                Log.Info("全量直播数据==>:" + result);
                JsonSerializerSettings settings = new JsonSerializerSettings();
                settings.NullValueHandling = NullValueHandling.Ignore;

                OnAirDataModel onAirDataModel = JsonConvert.DeserializeObject<OnAirDataModel>(result, settings);

                return onAirDataModel;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }
        }


        /// <summary>
        /// 球队赛季数据服务器地址
        /// </summary>
        /// <returns></returns>
        public async static Task<TeamSeasonData> TeamSeasonData_Path(string matchtypeid)
        {
            TeamSeasonData teamSeasonData = new TeamSeasonData(); 

            try

            {

               await Task.Run(() =>
                {
                    string TeamSeasonDataPath = httpStr + "team/getteamstats?leagueid="
    + leagueid + "&matchtypeid=" + matchtypeid + "&customer=" + customer + "&key=" + key + "&encrypted="
    + Utils.GetMD5(key + encrypted + random) + "&random=" + random;
                    Console.WriteLine("球队赛季接口数据==>:" + TeamSeasonDataPath);

                    string result = JsonHelper.GetResult(TeamSeasonDataPath);
                    Log.Info(result);

                    JsonSerializerSettings settings = new JsonSerializerSettings();
                    settings.NullValueHandling = NullValueHandling.Ignore;
                    teamSeasonData = JsonConvert.DeserializeObject<TeamSeasonData>(result, settings);
                });

                return teamSeasonData;
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }
        }


        /// <summary>
        /// 球队赛季数据服务器地址
        /// </summary>
        /// <returns></returns>
        public async static Task<TeamSeasonData> PostTeamSeasonData_Path(string matchtypeid)
        {
            TeamSeasonData teamSeasonData = new TeamSeasonData();

            try

            {

                await Task.Run(() =>
                {
                    string TeamSeasonDataPath = strUrl + "team/getteamstats";
                    Console.WriteLine("球队赛季接口数据==>:" + TeamSeasonDataPath);

                    Dictionary<string, string> dict = new Dictionary<string, string>();
                    dict.Add("leagueid", "401");
                    dict.Add("matchtypeid", matchtypeid);

                    string newKey = Utils.GetKey(appID, appKey);


                    string result = JsonHelper.Post(TeamSeasonDataPath,dict,newKey);
                    Log.Info("球队赛季接口数据==>:" + result);

                    JsonSerializerSettings settings = new JsonSerializerSettings();
                    settings.NullValueHandling = NullValueHandling.Ignore;
                    teamSeasonData = JsonConvert.DeserializeObject<TeamSeasonData>(result, settings);
                });

                return teamSeasonData;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }
        }


        /// <summary>
        ///球队积分数据服务器地址
        /// </summary>
        /// <returns></returns>
        public static TeamRanks TeamScoreData_Path()
        {
            try
            {
                string TeamScoreDataPath = httpStr + "team/getteamstanding?leagueid="
                    + leagueid + "&customer=" + customer + "&key=" + key + "&encrypted="
                    + Utils.GetMD5(key + encrypted + random) + "&random=" + random;

                string result = JsonHelper.GetResult(TeamScoreDataPath);

                Log.Info(result);
                JsonSerializerSettings settings = new JsonSerializerSettings();
                settings.NullValueHandling = NullValueHandling.Ignore;

                TeamRanks teamRanks = JsonConvert.DeserializeObject<TeamRanks>(result, settings);

                Console.WriteLine("球队积分排行数据============>:" + TeamScoreDataPath);

                return teamRanks;
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }
        }


        /// <summary>
        ///球队积分数据服务器地址
        /// </summary>
        /// <returns></returns>
        public static TeamRanks PostTeamScoreData_Path()
        {
            try
            {
                string TeamScoreDataPath = strUrl + "team/getteamstanding";


                Dictionary<string, string> dict = new Dictionary<string, string>();
                dict.Add("leagueid", "401");


                string newKey = Utils.GetKey(appID, appKey);

                string result = JsonHelper.Post(TeamScoreDataPath,dict,newKey);

                Log.Info("球队积分排行数据==>:" + result);
                JsonSerializerSettings settings = new JsonSerializerSettings();
                settings.NullValueHandling = NullValueHandling.Ignore;

                TeamRanks teamRanks = JsonConvert.DeserializeObject<TeamRanks>(result, settings);
                var sortRanks = teamRanks.teamrank.OrderBy(a => a.CBARank).ToList();
                teamRanks.teamrank=sortRanks ;
                
                Console.WriteLine("球队积分排行数据============>:" + TeamScoreDataPath);

                return teamRanks;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }
        }
        /// <summary>
        /// 比赛小节数据
        /// </summary>
        /// <param name="scheduleid"></param>
        /// <returns></returns>
        public static string KnobbleData_Path(string scheduleid)
        {
            string KnobbleDataPath = httpStr + "live/getlivequarterstats?leagueid="
                  + leagueid + "&scheduleid=" + scheduleid + "&customer=" + customer + "&key=" + key + "&encrypted="
                  + Utils.GetMD5(key + encrypted + random) + "&random=" + random;
            //Console.WriteLine(KnobbleDataPath);

            Console.WriteLine("比赛小节数据=======>:" + KnobbleDataPath);
            return KnobbleDataPath;
        }

        /// <summary>
        /// 历史交锋记录服务器地址
        /// </summary>
        /// <returns></returns>
        public static string HistoricalRecordData_Path(string scheduleid)
        {
            string HistoricalRecordDataPath = httpStr + "schedule/headtohead?customer="
                 + customer + "&key=" + key + "&encrypted=" + Utils.GetMD5(key + encrypted + random) + "&random=" + random + "&scheduleid=" + scheduleid;
            //Console.WriteLine(HistoricalRecordDataPath);

            Console.WriteLine("历史交锋记录服务器地址=======>:" + HistoricalRecordDataPath);
            return HistoricalRecordDataPath;
        }

        /// <summary>
        /// 对阵图数据地址
        /// </summary>
        /// <returns></returns>
        public static string EncounterPictureData_Path()
        {
            //旧对阵图
            //EncounterPictureDataPath = "http://sportsdata.misports.cn/beitai/api/schedule/getpostseason?leagueid="
            //  + leagueid + "&customer=" + customer + "&key=" + key +"&season=2019"+ "&encrypted=" + GetMD5(key+encrypted + random) + "&random=" + random;
            string EncounterPictureDataPath = httpStr + "schedule/getpostseason?leagueid="
             + leagueid + "&customer=" + customer + "&key=" + key + "&encrypted=" + Utils.GetMD5(key + encrypted + random) + "&random=" + random;
            Console.WriteLine("对阵图数据地址======>:" + EncounterPictureDataPath);
            return EncounterPictureDataPath;
        }


        /// <summary>
        /// 获取CBA赛季数据接口
        /// </summary>
        /// <returns></returns>
        public static Seasons Post_MatchSeasonData_Path(string selectFootballType)
        {
            try
            {
                string MatchDataPath = strUrl + "matchSeason";
                Dictionary<string, string> dict = new Dictionary<string, string>();

                dict.Add("competitionId", selectFootballType);

                string newKey = Utils.GetKey(appID, appKey);
                string result = JsonHelper.Post(MatchDataPath, dict, newKey);

                Log.Info("足球赛季数据==>" + result);
                JsonSerializerSettings settings = new JsonSerializerSettings();
                settings.NullValueHandling = NullValueHandling.Ignore;

                Seasons seasons = JsonConvert.DeserializeObject<Seasons>(result, settings);
                var sortSeason = seasons.matchseason.OrderByDescending(a => a.seasonName).ToList();
                seasons.matchseason = sortSeason;
                Console.WriteLine("足球赛季数据=========>" + MatchDataPath);
                return seasons;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }


        }

    }
}
