﻿using DevExpress.Emf;
using DevExpress.Xpf.Editors.Helpers;
using DevExpress.Xpo.DB;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Module;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.CBA.Module
{
    /// <summary>
    /// 日期头部放在前面
    /// </summary>
    public class DateHeaderViewModel : ViewModelBase
    {

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();
        /// <summary>
        /// 初始化构造函数
        /// </summary>

        public DateHeaderViewModel()
        {
            matchDate = DateTime.Today.ToShortDateString();

            BtnCmd = new VCommand(BtmCommand);
            RefreshCommand = new VCommand(RefreshTeamStats);

            GetSchedule();
            BtmCommand();

            RefreshDayMatchCmd = new VCommand(RefreshDayMatch);

            PlayerHCommand = new VCommand(SetHPlayerStats);
            PlayerACommand = new VCommand(SetAPlayerStats);
            RefreshPlayerCommand = new VCommand(RefreshPlayer);

            UpDateCmd = new VCommand(UpDate);
            DownDateCmd = new VCommand(DownDate);


            RefreshTeamSeasonCommand = new VCommand(GetTeamSeasonData);

            PlayerSeasonHCommand = new VCommand(this.SetHPlayerSeasonStats);
            PlayerSeasonACommand = new VCommand(this.SetAPlayerSeasonStats);
            RefreshPlayerSeasonCommand = new VCommand(this.RefreshSeasonPlayer);

        }


        //public static string ScheduleID = "";

        //public static string 

        #region 今日赛程
        /// <summary>
        /// 记录log日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(DateHeaderViewModel));

        private ObservableCollection<string> matchItems;

        public VCommand RefreshDayMatchCmd { get; set; }

        /// <summary>
        /// 下拉框绑定得赛程详细信息
        /// </summary>
        public ObservableCollection<string> MatchItems
        {
            get { return matchItems; }
            set { matchItems = value; this.RaisePropertyChanged(nameof(MatchItems)); }
        }

        //private string selectMatchItems;

        ///// <summary>
        ///// 选中得赛程信息
        ///// </summary>
        //public string SelectMatchItems
        //{
        //    get { return selectMatchItems; }
        //    set
        //    {
        //        selectMatchItems = value;
        //        this.RaisePropertyChanged(nameof(SelectMatchItems));
        //        if (selectMatchItems == null) return;
        //        //SetCompareData();
        //        ScheduleID = SetMatchDict[SelectMatchItems];
        //    }
        //}
        /// <summary>
        /// 比赛状态
        /// </summary>
        private string matchStatus;

        public string MatchStatus
        {
            get { return matchStatus; }

            set
            {
                matchStatus = value;
                this.RaisePropertyChanged(nameof(MatchStatus));
            }
        }


        ////球员赛季数据
        public  static string Matchtypeid = "";
        ////比赛赛程Id
        public static string ScheduleID = "";


        /// <summary>
        /// 比赛日期
        /// </summary>

        private string matchDate;

        public string MatchDate
        {
            get { return matchDate; }
            set
            {
                matchDate = value;
                this.RaisePropertyChanged(nameof(MatchDate));
                GetSchedule();
            }
        }


        /// <summary>
        /// 主数据库连接
        /// </summary>
        private bool mainDataConnection=true;
        public bool MainDataConnection
        {
            get { return mainDataConnection; }
            set
            {
                this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看主数据连接");

                mainDataConnection = value;
                this.RaisePropertyChanged(nameof(MainDataConnection));

                if(mainDataConnection)
                {
                    JsonModel.strUrl = AppSetup_InitCBALiteDB.HttpUrlConfigEntity.Url;
                    JsonModel.appKey = AppSetup_InitCBALiteDB.HttpUrlConfigEntity.AppKey;
                    JsonModel.appID = AppSetup_InitCBALiteDB.HttpUrlConfigEntity.AppId;
                }
            }
        }


        /// <summary>
        /// 备份数据连接
        /// </summary>
        private bool backDataConnection;

        public bool BackDataConnection
        {
            get { return backDataConnection; }
            set
            {
                this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看备数据连接");
                backDataConnection = value;
                this.RaisePropertyChanged(nameof(BackDataConnection));
                if(backDataConnection)
                {
                    JsonModel.strUrl = AppSetup_InitCBALiteDB.HttpUrlConfigEntity.BUrl;
                    JsonModel.appKey = AppSetup_InitCBALiteDB.HttpUrlConfigEntity.BAppKey;
                    JsonModel.appID = AppSetup_InitCBALiteDB.HttpUrlConfigEntity.BAppId;
                }
            }
        }




        /// <summary>
        /// 上一天
        /// </summary>
        public VCommand UpDateCmd { get; set; }


        /// <summary>
        /// 下一天
        /// </summary>
        public VCommand DownDateCmd { get; set; }


        /// <summary>
        /// 上一天
        /// </summary>
        private void UpDate()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看赛程上一天：" + PluginConstant.Operate_Load);
            MatchDate = Convert.ToDateTime(MatchDate).AddDays(-1).ToShortDateString();
            GetSchedule();

        }

        /// <summary>
        /// 下一天
        /// </summary>
        private void DownDate()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看赛程下一天：" + PluginConstant.Operate_Load);
            MatchDate = Convert.ToDateTime(MatchDate).AddDays(1).ToShortDateString();
            GetSchedule();
        }

        /// <summary>
        /// 设置一个比赛赛程集合
        /// </summary>
        public Dictionary<string, string> SetMatchDict = new Dictionary<string, string>();

        /// <summary>
        /// 根据日期获取赛程
        /// </summary>

        private async void GetSchedule()
        {

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Http, RecordLogTrigger.Human, "CBA获取赛程接口：" + PluginConstant.Operate_Load);
            try

            {
                MatchItems = new ObservableCollection<string>();
                string date = Convert.ToDateTime(matchDate).ToString("yyyy-MM-dd");

                var dayschedules = await JsonModel.PostTomorrowMatch_Path(date);

                if (dayschedules == null) return;
                matchData.AddRange(dayschedules.dayschedule);
                MatchData = new ObservableCollection<Dayschedule>();

                if (dayschedules != null)
                {
                    dayschedules.dayschedule = dayschedules.dayschedule.OrderBy(a => Convert.ToDateTime(a.time)).ToList();
                }

                SetMatchDict.Clear();
                MatchItems.Clear();

                foreach (var dayschedule in dayschedules.dayschedule)
                {
                    if (dayschedule.Status == "1")
                    {
                        dayschedule.Status = "未开赛";
                    }
                    else if (dayschedule.Status == "2")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "3")
                    {
                        dayschedule.Status = "进行中";
                    }
                    else if (dayschedule.Status == "4")
                    {
                        dayschedule.Status = "已结束";
                    }
                    else if (dayschedule.Status == "5")
                    {
                        dayschedule.Status = "延期";
                    }

                    if (!SetMatchDict.ContainsKey(dayschedule.time + dayschedule.HomeTeamName
                                + "VS" + dayschedule.VisitingTeamName))
                    {
                        SetMatchDict.Add(dayschedule.time + dayschedule.HomeTeamName
                                    + "VS" + dayschedule.VisitingTeamName, dayschedule.ScheduleID);
                    }

                    //Matchtypeid = dayschedule.ScheduleTypeID;

                    MatchItems.Add(dayschedule.time + dayschedule.HomeTeamName
                                + "VS" + dayschedule.VisitingTeamName);

                    MatchData.Add(dayschedule);

                }
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
            }
        }


        private void RefreshDayMatch()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看赛程：" + PluginConstant.Operate_Load);
            GetSchedule();
        }




        private Dayschedule selectMatchData;

        public Dayschedule SelectMatchData
        {
            get { return selectMatchData; }

            set 
            { 
                selectMatchData = value;
                this.RaisePropertyChanged(nameof(SelectMatchData));

                if (value==null)
                {
                    this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看界面赛事没有选中一条赛事记录");
                    ClearData();
                    return;
                }
                this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看选择赛程：" + value.HomeTeamName + "VS" + value.VisitingTeamName);
                onAirDataModel = JsonModel.PostOnAirData_Path(selectMatchData.ScheduleID);

                SetTeamStatsData();
                GetSeasonData();

                TeamHName = value.HomeTeamName;
           
                TeamAName = value.VisitingTeamName;


                ScheduleID = selectMatchData.ScheduleID;
                Matchtypeid = selectMatchData.ScheduleTypeID;

                #region 球员统计信息


                //if (TeamStatsViewModel.TeamStatsViewModelInstance.Count>0)
                //{
                //   // Log.Error(string.Format("TeamStatsViewModel.CreateInstance Count:{0}", TeamStatsViewModel.TeamStatsViewModelInstance.Count));
                //    foreach(var tempTeamStatsViewModel in TeamStatsViewModel.TeamStatsViewModelInstance)
                //    {
                //       // if(ApplicationDomainEx.CurrentPage == page;
                //        // TeamStatsViewModel teamStatsViewModel = tempTeamStatsViewModel;
                //        // Log.Error("DateHeaderViewModel_CreateTeamStatsViewModel");
                //        tempTeamStatsViewModel.ScheduleID = selectMatchData.ScheduleID;
                //        tempTeamStatsViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                //       // Log.Error(string.Format("DateHeader_ScheduleId:{0}", selectMatchData.ScheduleID));
                //        //Log.Error(string.Format("DateHeader_ScheduleTypeId:{0}", selectMatchData.ScheduleTypeID));
                //        tempTeamStatsViewModel.SetTeamData();
                //    }
          
                //}
            

                if(NewTeamStatsViewModel.TeamStatsViewModelInstance.Count>0)
                {
                    foreach (var tempTeamStatsViewModel in NewTeamStatsViewModel.TeamStatsViewModelInstance)
                    {
                        tempTeamStatsViewModel.ScheduleID = selectMatchData.ScheduleID;
                        tempTeamStatsViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                        if (tempTeamStatsViewModel.page!=null&& ApplicationDomainEx.CurrentPage == tempTeamStatsViewModel.page)
                        {
 

                            tempTeamStatsViewModel.SetTeamData();
                        }

                    }
                }


                #endregion

                #region 单个球员信息

                //if(SinglePlayerViewModel.SinglePlayerViewModelInstance.Count>0)
                //{

                //    foreach(var tempSinglePlayerViewModel in SinglePlayerViewModel.SinglePlayerViewModelInstance)
                //    {
                //        tempSinglePlayerViewModel.ScheduleID = selectMatchData.ScheduleID;
                //        tempSinglePlayerViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                //        tempSinglePlayerViewModel.SetSingleData();
                //    }

                //}


                if(NewSinglePlayerViewModel.SinglePlayerViewModelInstance.Count>0)
                {
                    foreach (var tempSinglePlayerViewModel in NewSinglePlayerViewModel.SinglePlayerViewModelInstance)
                    {
                        tempSinglePlayerViewModel.ScheduleID = selectMatchData.ScheduleID;
                        tempSinglePlayerViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                        if (tempSinglePlayerViewModel.page != null && ApplicationDomainEx.CurrentPage == tempSinglePlayerViewModel.page)
                        {
       
                            tempSinglePlayerViewModel.SetSingleData();
                        }

                    }
                }



                #endregion

                #region Mvp球员信息

                if(MvpPlayerViewModel.MvpPlayerViewModelInstance.Count>0)
                {
                    foreach (var tempSinglePlayerViewModel in MvpPlayerViewModel.MvpPlayerViewModelInstance)
                    {
                        tempSinglePlayerViewModel.ScheduleID = selectMatchData.ScheduleID;
                        tempSinglePlayerViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                        if (tempSinglePlayerViewModel.page != null && ApplicationDomainEx.CurrentPage == tempSinglePlayerViewModel.page)
                        {

                            tempSinglePlayerViewModel.SetSingleData();
                        }

                    }
                }

                #endregion

                #region 球员对比信息

                //if(PlayerCompareViewModel.PlayerCompareViewModelInstance.Count>0)
                //{
                //    foreach(var playerCompareViewModel in PlayerCompareViewModel.PlayerCompareViewModelInstance)
                //    {
                //        //PlayerCompareViewModel playerCompareViewModel = PlayerCompareViewModel.CreateInstance;

                //        playerCompareViewModel.ScheduleID = selectMatchData.ScheduleID;
                //        playerCompareViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                //        playerCompareViewModel.SetCompareData();
                //    }

                //}


                if (NewPlayerComPareViewModel.PlayerCompareViewModelInstance.Count>0)
                {
                    foreach (var playerCompareViewModel in NewPlayerComPareViewModel.PlayerCompareViewModelInstance)
                    {
                        playerCompareViewModel.ScheduleID = selectMatchData.ScheduleID;
                        playerCompareViewModel.Matchtypeid = selectMatchData.ScheduleTypeID;
                        //PlayerCompareViewModel playerCompareViewModel = PlayerCompareViewModel.CreateInstance;
                        if (playerCompareViewModel.page != null && ApplicationDomainEx.CurrentPage == playerCompareViewModel.page)
                        {
          
                            playerCompareViewModel.SetCompareData();
                        }
                    }

                }

                //设置球队赛季数据
                GetTeamSeasonData();
                #endregion
            }
        }

        private void ClearData()
        {
            #region 球员统计信息

            if (NewTeamStatsViewModel.TeamStatsViewModelInstance.Count > 0)
            {
                foreach (var tempTeamStatsViewModel in NewTeamStatsViewModel.TeamStatsViewModelInstance)
                {
                    tempTeamStatsViewModel.ScheduleID = "";
                    tempTeamStatsViewModel.Matchtypeid = "";
                    if (tempTeamStatsViewModel.page != null && ApplicationDomainEx.CurrentPage == tempTeamStatsViewModel.page)
                    {

                        tempTeamStatsViewModel.SetTeamData();
                    }

                }
            }


            #endregion

            #region 单个球员信息



            if (NewSinglePlayerViewModel.SinglePlayerViewModelInstance.Count > 0)
            {
                foreach (var tempSinglePlayerViewModel in NewSinglePlayerViewModel.SinglePlayerViewModelInstance)
                {
                    tempSinglePlayerViewModel.ScheduleID = "";
                    tempSinglePlayerViewModel.Matchtypeid = "";
                    if (tempSinglePlayerViewModel.page != null && ApplicationDomainEx.CurrentPage == tempSinglePlayerViewModel.page)
                    {

                        tempSinglePlayerViewModel.SetSingleData();
                    }

                }
            }



            #endregion

            #region Mvp球员信息

            if (MvpPlayerViewModel.MvpPlayerViewModelInstance.Count > 0)
            {
                foreach (var tempSinglePlayerViewModel in MvpPlayerViewModel.MvpPlayerViewModelInstance)
                {
                    tempSinglePlayerViewModel.ScheduleID = "";
                    tempSinglePlayerViewModel.Matchtypeid = "";
                    if (tempSinglePlayerViewModel.page != null && ApplicationDomainEx.CurrentPage == tempSinglePlayerViewModel.page)
                    {

                        tempSinglePlayerViewModel.SetSingleData();
                    }

                }
            }

            #endregion

            #region 球员对比信息



            if (NewPlayerComPareViewModel.PlayerCompareViewModelInstance.Count > 0)
            {
                foreach (var playerCompareViewModel in NewPlayerComPareViewModel.PlayerCompareViewModelInstance)
                {
                    playerCompareViewModel.ScheduleID = "";
                    playerCompareViewModel.Matchtypeid = "";
                    //PlayerCompareViewModel playerCompareViewModel = PlayerCompareViewModel.CreateInstance;
                    if (playerCompareViewModel.page != null && ApplicationDomainEx.CurrentPage == playerCompareViewModel.page)
                    {

                        playerCompareViewModel.SetCompareData();
                    }
                }

            }
            #endregion
        }


        /// <summary>
        /// 今日赛程日期
        /// </summary>
        private ObservableCollection<Dayschedule> matchData;

        /// <summary>
        /// 绑定数据列表
        /// </summary>
        public ObservableCollection<Dayschedule> MatchData
        {
            get { return matchData; }

            set { matchData = value; this.RaisePropertyChanged(nameof(MatchData)); }
        }

        #endregion

        #region 球队积分排行榜


        public VCommand BtnCmd { get; set; }
        /// <summary>
        /// 球队积分排名
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModel;

        public ObservableCollection<Teamrank> TeamRanksModel
        {
            get { return teamRanksModel; }

            set { teamRanksModel = value; this.RaisePropertyChanged(nameof(TeamRanksModel)); }
        }


        private void BtmCommand()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看球队积分：" + PluginConstant.Operate_Load);


            var teamStands = JsonModel.PostTeamScoreData_Path();
            if (teamStands == null) return;
            TeamRanksModel = new ObservableCollection<Teamrank>();
            int i = 1;
            foreach (var teamRank in teamStands.teamrank)
            {
                teamRank.Id = i;

                teamRank.WinningPercentageStr = (teamRank.WinningPercentage * 100).ToString("F1") + "%";

                if (teamRank.StreakType == 1)
                {
                    teamRank.StreakName = "连胜";
                }
                else if (teamRank.StreakType == 0)
                {
                    teamRank.StreakName = "连败";
                }
                TeamRanksModel.Add(teamRank);
                i++;
            }
        }


        #endregion

        #region 球队数据


        /// <summary>
        /// 刷新球队数据
        /// </summary>
        public VCommand RefreshCommand { get; set; }


        private void RefreshTeamStats()
        {

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看球队：" + PluginConstant.Operate_Load);


            if (selectMatchData != null)
            {
                onAirDataModel = JsonModel.PostOnAirData_Path(selectMatchData.ScheduleID);

                SetTeamStatsData();
            }
           
           
        }

        /// <summary>
        /// 实时直播数据
        /// </summary>
        public OnAirDataModel onAirDataModel = new OnAirDataModel();

        /// <summary>
        /// 球队数据
        /// </summary>
        private ObservableCollection<ShowTeamStats> showInfoTeamStats;

        public ObservableCollection<ShowTeamStats> ShowInfoTeamStats
        {
            get { return showInfoTeamStats; }

            set { showInfoTeamStats = value; this.RaisePropertyChanged(nameof(ShowInfoTeamStats)); }
        }


        private void SetTeamStatsData()
        {
            if (onAirDataModel == null) return;

            ShowInfoTeamStats = new ObservableCollection<ShowTeamStats>();

            ShowTeamStats showTeamStatsHome = new ShowTeamStats();

            ShowTeamStats showTeamStatsAway = new ShowTeamStats();

            //主队技术统计
            showTeamStatsHome.TeamName = selectMatchData.HomeTeamName;
            showTeamStatsHome.Goal = onAirDataModel.liveTeamStatH.Points;
            showTeamStatsHome.Rebounds = onAirDataModel.liveTeamStatH.Rebounds;
            showTeamStatsHome.Assists = onAirDataModel.liveTeamStatH.Assists;
            showTeamStatsHome.Blocks = onAirDataModel.liveTeamStatH.Blocked;
            showTeamStatsHome.Steals = onAirDataModel.liveTeamStatH.Steals;
            showTeamStatsHome.Error = onAirDataModel.liveTeamStatH.Turnovers;
            showTeamStatsHome.Foul = onAirDataModel.liveTeamStatH.PersonalFouls;
            showTeamStatsHome.FreeThrowP= (onAirDataModel.liveTeamStatH.FreeThrowsPercentage * 100).ToString("F1") + "%";
            showTeamStatsHome.TwoShootingGoalP = (onAirDataModel.liveTeamStatH.TwoPointPercentage * 100).ToString("F1") + "%";
            showTeamStatsHome.ThreeShootingGoalP= (onAirDataModel.liveTeamStatH.ThreePointPercentage * 100).ToString("F1") + "%";
            showTeamStatsHome.ShootingGoalP= (onAirDataModel.liveTeamStatH.FieldGoalsPercentage * 100).ToString("F1") + "%";
            showTeamStatsHome.ShootingUnderBaketP= (onAirDataModel.liveTeamStatH.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%";
            showTeamStatsHome.MidShootingP = (onAirDataModel.liveTeamStatH.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%";
            showTeamStatsHome.ThreeScore = onAirDataModel.liveTeamStatH.ThreePointGoals + "/"
                + onAirDataModel.liveTeamStatH.ThreePointAttempted;
            showTeamStatsHome.TwoScore= onAirDataModel.liveTeamStatH.TwoPointGoals + "/"
                + onAirDataModel.liveTeamStatH.TwoPointAttempted;
            showTeamStatsHome.ThreeGoals = (Convert.ToInt32(onAirDataModel.liveTeamStatH.ThreePointGoals) * 3).ToString();

            ShowInfoTeamStats.Add(showTeamStatsHome);

            //客队技术统计
            showTeamStatsAway.TeamName = selectMatchData.VisitingTeamName;
            showTeamStatsAway.Goal = onAirDataModel.liveTeamStatV.Points;
            showTeamStatsAway.Rebounds = onAirDataModel.liveTeamStatV.Rebounds;
            showTeamStatsAway.Assists = onAirDataModel.liveTeamStatV.Assists;
            showTeamStatsAway.Blocks = onAirDataModel.liveTeamStatV.Blocked;
            showTeamStatsAway.Steals = onAirDataModel.liveTeamStatV.Steals;
            showTeamStatsAway.Error = onAirDataModel.liveTeamStatV.Turnovers;
            showTeamStatsAway.Foul = onAirDataModel.liveTeamStatV.PersonalFouls;
            showTeamStatsAway.FreeThrowP = (onAirDataModel.liveTeamStatV.FreeThrowsPercentage * 100).ToString("F1") + "%";
            showTeamStatsAway.TwoShootingGoalP = (onAirDataModel.liveTeamStatV.TwoPointPercentage * 100).ToString("F1") + "%";
            showTeamStatsAway.ThreeShootingGoalP = (onAirDataModel.liveTeamStatV.ThreePointPercentage * 100).ToString("F1") + "%";
            showTeamStatsAway.ShootingGoalP = (onAirDataModel.liveTeamStatV.FieldGoalsPercentage * 100).ToString("F1") + "%";

            showTeamStatsAway.ShootingUnderBaketP = (onAirDataModel.liveTeamStatV.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%";
            showTeamStatsAway.MidShootingP = (onAirDataModel.liveTeamStatV.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%";
            showTeamStatsAway.ThreeScore = onAirDataModel.liveTeamStatV.ThreePointGoals + "/"
                + onAirDataModel.liveTeamStatV.ThreePointAttempted;
            showTeamStatsAway.TwoScore = onAirDataModel.liveTeamStatV.TwoPointGoals + "/"
                + onAirDataModel.liveTeamStatV.TwoPointAttempted;
            showTeamStatsAway.ThreeGoals = (Convert.ToInt32(onAirDataModel.liveTeamStatV.ThreePointGoals) * 3).ToString();

            ShowInfoTeamStats.Add(showTeamStatsAway);

        }

        #endregion

        #region 球员数据


        public VCommand RefreshPlayerCommand { get; set; }

        /// <summary>
        /// 总得分
        /// </summary>
        private double totalScore;

        public double TotalScore
        {
            get { return totalScore; }
            set
            {
                totalScore = value;
                this.RaisePropertyChanged(nameof(TotalScore));
            }
        }

        /// <summary>
        /// 总篮板
        /// </summary>
        private double totalRebounds;

        public double TotalRebounds
        {
            get { return totalRebounds; }
            set
            {
                totalRebounds = value;
                this.RaisePropertyChanged(nameof(TotalRebounds));
            }
        }


        /// <summary>
        /// 总助攻
        /// </summary>
        private double totalAssists;

        public double TotalAssists
        {
            get { return totalAssists; }
            set
            {
                totalAssists = value;
                this.RaisePropertyChanged(nameof(TotalAssists));
            }
        }


        /// <summary>
        /// 总盖帽
        /// </summary>
        private double totalBlocks;

        public double TotalBlocks
        {
            get { return totalBlocks; }
            set
            {
                totalBlocks = value;
                this.RaisePropertyChanged(nameof(TotalBlocks));
            }
        }

        private int flag = -1;

        private void RefreshPlayer()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看球队球员数据：" + PluginConstant.Opeate_Refresh);
            if (flag==0)
            {
                SetHPlayerStats();
            }
            else if(flag==1)
            {
                SetAPlayerStats();
            }
        }
        /// <summary>
        /// 球员查看信息
        /// </summary>
        private ObservableCollection<PlayersStats> showInfoPlayersStats;

        public ObservableCollection<PlayersStats> ShowInfoPlayersStats
        {
            get { return showInfoPlayersStats; }

            set { showInfoPlayersStats = value; this.RaisePropertyChanged(nameof(ShowInfoPlayersStats)); }
        }


        /// <summary>
        /// 主队名称
        /// </summary>
        private string teamHName;

        public string TeamHName
        {
            get { return teamHName; }

            set { teamHName = value;this.RaisePropertyChanged(nameof(TeamHName)); }
        }


        /// <summary>
        /// 客队名称
        /// </summary>
        private string teamAName;

        public string TeamAName
        {
            get { return teamAName; }

            set { teamAName = value; this.RaisePropertyChanged(nameof(TeamAName)); }
        }



        /// <summary>
        /// 主队球员命令
        /// </summary>
        public VCommand PlayerHCommand { get; set; }

        /// <summary>
        /// 客队球员命令
        /// </summary>
        public VCommand PlayerACommand { get; set; }



        /// <summary>
        /// 设置主队员数据统计
        /// </summary>
        private void SetHPlayerStats()
        {

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看主队球员：" + PluginConstant.Operate_Load);
            if (SelectMatchData == null) return;
            flag = 0;
            ShowInfoPlayersStats = new ObservableCollection<PlayersStats>();

            double scores = 0;
            double rebounds=0;
            double assists = 0;
            double blocks = 0;
            foreach (var playerStat in  onAirDataModel.livePlayerStatH)
            {
                PlayersStats player = new PlayersStats();

                player.PlayerName = playerStat.CNAlias;
                scores += Convert.ToDouble(playerStat.Points);
                player.Goal = Convert.ToDouble(playerStat.Points);
                rebounds += Convert.ToDouble(playerStat.Rebounds);
                player.Rebounds = Convert.ToDouble(playerStat.Rebounds);
                player.Assists = playerStat.Assists;
                assists += Convert.ToDouble(playerStat.Assists);
                player.Steals = playerStat.Steals;
                blocks += Convert.ToDouble(playerStat.Blocked);
                player.Blocks =playerStat.Blocked;
                player.PlayTime = playerStat.Minutes;
                player.ShootingGoalP = (playerStat.FieldGoalsPercentage*100).ToString("F1") + "%";
                player.TwoShootingGoalP = (playerStat.TwoPointPercentage).ToString("F1") + "%";
                player.ThreeShootingGoalP = (playerStat.ThreePointPercentage*100).ToString("F1") + "%";
                player.FreeThrowP = (playerStat.FreeThrowsPercentage*100).ToString("F1") + "%";
                player.ShootingUnderBaketP= (playerStat.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%";
                player.MidShootingP = (playerStat.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%";

                player.ThreeScore = playerStat.ThreePointGoals + "/"
                                + playerStat.ThreePointAttempted;
                player.TwoScore = playerStat.TwoPointGoals + "/"
                                + playerStat.TwoPointAttempted;
                player.TwoArea = playerStat.TwoPointGoals + "/"
                                + playerStat.TwoPointAttempted;
                player.ThreeArea = playerStat.ThreePointGoals + "/"
                                  + playerStat.ThreePointAttempted;
                player.FreeThrow = playerStat.FreeThrows + "/"
                                + playerStat.FreeThrowsAttempted;
                player.Error = playerStat.Turnovers;

                ShowInfoPlayersStats.Add(player);
            }

            ShowInfoPlayersStats = ShowInfoPlayersStats.OrderByDescending(a => Convert.ToInt32(a.Goal)).ToObservableCollection();
            TotalScore = scores;
            TotalRebounds = rebounds;
            TotalAssists = assists;
            TotalBlocks = blocks;

        }

        /// <summary>
        /// 设置客队员数据统计
        /// </summary>
        private void SetAPlayerStats()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看客队球员：" + PluginConstant.Operate_Load);
            if (SelectMatchData == null) return;
            flag = 1;
            ShowInfoPlayersStats = new ObservableCollection<PlayersStats>();

            double scores = 0;
            double rebounds = 0;
            double assists = 0;
            double blocks = 0;
            foreach (var playerStat in onAirDataModel.livePlayerStatV)
            {
                PlayersStats player = new PlayersStats();

                player.PlayerName = playerStat.CNAlias;
                scores += Convert.ToDouble(playerStat.Points);
                player.Goal = Convert.ToDouble(playerStat.Points);
                rebounds += Convert.ToDouble(playerStat.Rebounds);
                player.Rebounds =  Convert.ToDouble(playerStat.Rebounds);
                assists += Convert.ToDouble(playerStat.Assists);
                player.Assists =playerStat.Assists;
                player.Steals = playerStat.Steals;
                blocks += Convert.ToDouble(playerStat.Blocked);
                player.Blocks = playerStat.Blocked;
                player.PlayTime = playerStat.Minutes;
                player.ShootingGoalP = (playerStat.FieldGoalsPercentage*100).ToString("F1") + "%";
                player.TwoShootingGoalP = (playerStat.TwoPointPercentage).ToString("F1") + "%";
                player.ThreeShootingGoalP = (playerStat.ThreePointPercentage*100).ToString("F1") + "%";
                player.FreeThrowP = (playerStat.FreeThrowsPercentage*100).ToString("F1") + "%";
                player.ShootingUnderBaketP = (playerStat.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%";
                player.MidShootingP = (playerStat.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%";

                player.ThreeScore = playerStat.ThreePointGoals + "/"
                                + playerStat.ThreePointAttempted;
                player.TwoScore = playerStat.TwoPointGoals + "/"
                                + playerStat.TwoPointAttempted;
                player.TwoArea = playerStat.TwoPointGoals + "/"
                                + playerStat.TwoPointAttempted;
                player.ThreeArea = playerStat.ThreePointGoals + "/"
                                  + playerStat.ThreePointAttempted;
                player.FreeThrow = playerStat.FreeThrows + "/"
                                + playerStat.FreeThrowsAttempted;
                player.Error = playerStat.Turnovers;

                ShowInfoPlayersStats.Add(player);
            }

            ShowInfoPlayersStats = ShowInfoPlayersStats.OrderByDescending(a => Convert.ToInt32(a.Goal)).ToObservableCollection();

            TotalScore = scores;
            TotalRebounds = rebounds;
            TotalAssists = assists;
            TotalBlocks = blocks;

        }

        #endregion


        #region 球员赛季数据

        /// <summary>
        /// 主队球员命令
        /// </summary>
        public VCommand PlayerSeasonHCommand { get; set; }

        /// <summary>
        /// 客队球员命令
        /// </summary>
        public VCommand PlayerSeasonACommand { get; set; }

        /// <summary>
        /// 刷新球员赛季数据
        /// </summary>
        public VCommand RefreshPlayerSeasonCommand { get; set; }



        /// <summary>
        /// 显示球员赛季数据
        /// </summary>
        private ObservableCollection<ShowPlayerStatsSeason> showPlayerStatsSeasonsData;

        public  ObservableCollection<ShowPlayerStatsSeason> ShowPlayerStatsSeasonsData
        {
            get { return showPlayerStatsSeasonsData; }
            set { showPlayerStatsSeasonsData = value;this.RaisePropertyChanged(nameof(ShowPlayerStatsSeasonsData)); } 
        }


        //向字典中个人选手增加整个赛季的分数值
        public Dictionary<string, Dictionary<string, string>> CNAliasPlayerSportsDictionary
            = new Dictionary<string, Dictionary<string, string>>();


        private int flagSeason = -1;

        private void RefreshSeasonPlayer()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看球员赛季数据：" + PluginConstant.Opeate_Refresh);
            if (flagSeason == 0)
            {
                SetHPlayerSeasonStats();
            }
            else if (flagSeason == 1)
            {
                SetAPlayerSeasonStats();
            }
        }
        /// 
        /// <summary>
        /// 获得赛季球队球员数据
        /// </summary>
        private async void GetSeasonData()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Http, RecordLogTrigger.Human, "CBA获取球队球员赛季接口：" + PluginConstant.Operate_Load);
            try

            {
               var PlayerSeasonData = await JsonModel.PostPlayerSeasonData_Path(Matchtypeid);


                CNAliasPlayerSportsDictionary.Clear();
                if (PlayerSeasonData == null) return;
                foreach (var tempSeasonData in PlayerSeasonData.playerstats)
                {
                    Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                    CompareItemToNumber.Add("PointsAverage", tempSeasonData.PointsAverage);
                    CompareItemToNumber.Add("ReboundsAverage", tempSeasonData.ReboundsAverage);
                    CompareItemToNumber.Add("AssistsAverage", tempSeasonData.AssistsAverage);
                    CompareItemToNumber.Add("StealsAverage", tempSeasonData.StealsAverage);
                    CompareItemToNumber.Add("BlockedAverage", tempSeasonData.BlockedAverage);
                    CompareItemToNumber.Add("MinutesAverage", tempSeasonData.MinutesAverage);
                    CompareItemToNumber.Add("FieldGoalsPercentageAverage", (tempSeasonData.FieldGoalsPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("TwoPointPercentageAverage", (tempSeasonData.TwoPointPercentageAverage).ToString("F1") + "%");

                    CompareItemToNumber.Add("ThreePointPercentageAverage", (tempSeasonData.ThreePointPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("FreeThrowsPercentageAverage", (tempSeasonData.FreeThrowsPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("FieldGoalsAtRimPercentageAverage", (tempSeasonData.FieldGoalsAtRimPercentageAverage * 100).ToString("F1") + "%");
                    CompareItemToNumber.Add("FieldGoalsMidRangePercentageAverage", (tempSeasonData.FieldGoalsMidRangePercentageAverage * 100).ToString("F1") + "%");
                    CompareItemToNumber.Add("ThreePointGoalsAverage", tempSeasonData.ThreePointGoalsAverage + "/"
                                + tempSeasonData.ThreePointAttemptedAverage);


                    CompareItemToNumber.Add("TwoPointGoalsAverage", tempSeasonData.TwoPointGoalsAverage + "/"
                                + tempSeasonData.TwoPointAttemptedAverage);


                    CompareItemToNumber.Add("TwoPointGoalsAverageArea", tempSeasonData.TwoPointGoalsAverage + "/"
                                + tempSeasonData.TwoPointAttemptedAverage);
                    CompareItemToNumber.Add("ThreePointGoalsAverageArea", tempSeasonData.ThreePointGoalsAverage + "/"

                 + tempSeasonData.ThreePointAttemptedAverage);
            

                    CompareItemToNumber.Add("FreeThrowsAverage", tempSeasonData.FreeThrowsAverage + "/"
                                + tempSeasonData.FreeThrowsAttemptedAverage);
                    CompareItemToNumber.Add("TurnoversAverage", tempSeasonData.TurnoversAverage);

                    if (!CNAliasPlayerSportsDictionary.ContainsKey(tempSeasonData.CNAlias))
                    {
                        CNAliasPlayerSportsDictionary.Add(tempSeasonData.CNAlias, CompareItemToNumber);
                    }



                }
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
            }
        }




        /// <summary>
        /// 设置主队员赛季数据统计
        /// </summary>
        private void SetHPlayerSeasonStats()
        {

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看主队球员赛季：" + PluginConstant.Operate_Load);
            if (SelectMatchData == null) return;
            flagSeason = 0;
            ShowPlayerStatsSeasonsData = new ObservableCollection<ShowPlayerStatsSeason>();

            double scores = 0;
            double rebounds = 0;
            double assists = 0;
            double blocks = 0;

            if (onAirDataModel == null) return;
            foreach (var playerStat in onAirDataModel.livePlayerStatH)
            {



                if(CNAliasPlayerSportsDictionary.ContainsKey(playerStat.CNAlias))
                {
                    var playerSportsDictionary = CNAliasPlayerSportsDictionary[playerStat.CNAlias];
                    ShowPlayerStatsSeason player = new ShowPlayerStatsSeason();

                    player.CNAlias = playerStat.CNAlias;

                    player.PointsAverage = Convert.ToDouble(playerSportsDictionary[nameof(player.PointsAverage)]);
                    player.ReboundsAverage= Convert.ToDouble(playerSportsDictionary[nameof(player.ReboundsAverage)]);
                    player.AssistsAverage= playerSportsDictionary[nameof(player.AssistsAverage)];

                    player.StealsAverage = playerSportsDictionary[nameof(player.StealsAverage)];
                    player.BlockedAverage = playerSportsDictionary[nameof(player.BlockedAverage)];
                    player.MinutesAverage = playerSportsDictionary[nameof(player.MinutesAverage)];

                    player.FieldGoalsPercentageAverage = playerSportsDictionary[nameof(player.FieldGoalsPercentageAverage)];
                    player.TwoPointPercentageAverage = playerSportsDictionary[nameof(player.TwoPointPercentageAverage)];
                    player.ThreePointPercentageAverage = playerSportsDictionary[nameof(player.ThreePointPercentageAverage)];
                    player.FreeThrowsPercentageAverage = playerSportsDictionary[nameof(player.FreeThrowsPercentageAverage)];


                    //player.FieldGoalsAtRimPercentageAverage = playerSportsDictionary[nameof(player.FieldGoalsAtRimPercentageAverage)];
                    //player.FieldGoalsMidRangePercentageAverage = playerSportsDictionary[nameof(player.FieldGoalsMidRangePercentageAverage)];


                    player.ThreePointGoalsAverage = playerSportsDictionary[nameof(player.ThreePointGoalsAverage)];
                    player.TwoPointGoalsAverage = playerSportsDictionary[nameof(player.TwoPointGoalsAverage)];
                    player.TwoPointGoalsAverageArea = playerSportsDictionary[nameof(player.TwoPointGoalsAverageArea)];
                    player.ThreePointGoalsAverageArea = playerSportsDictionary[nameof(player.ThreePointGoalsAverageArea)];

                    player.FreeThrowsAverage = playerSportsDictionary[nameof(player.FreeThrowsAverage)];
                    player.TurnoversAverage = playerSportsDictionary[nameof(player.TurnoversAverage)];


                    ShowPlayerStatsSeasonsData.Add(player);

                }


                   
            }

            ShowPlayerStatsSeasonsData = ShowPlayerStatsSeasonsData.OrderByDescending(a => Convert.ToDouble(a.PointsAverage)).ToObservableCollection();
           // ShowInfoPlayersStats = ShowInfoPlayersStats.OrderByDescending(a => Convert.ToInt32(a.Goal)).ToObservableCollection();
           // TotalScore = scores;
           //  TotalRebounds = rebounds;
           // TotalAssists = assists;
           //TotalBlocks = blocks;

        }

        /// <summary>
        /// 设置客队赛季球员数据统计
        /// </summary>
        private void SetAPlayerSeasonStats()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看客队赛季球员：" + PluginConstant.Operate_Load);
            if (SelectMatchData == null) return;
            flagSeason = 1;
            ShowPlayerStatsSeasonsData = new ObservableCollection<ShowPlayerStatsSeason>();

            double scores = 0;
            double rebounds = 0;
            double assists = 0;
            double blocks = 0;

            if (onAirDataModel == null) return;
            foreach (var playerStat in onAirDataModel.livePlayerStatV)
            {
                if (CNAliasPlayerSportsDictionary.ContainsKey(playerStat.CNAlias))
                {
                    var playerSportsDictionary = CNAliasPlayerSportsDictionary[playerStat.CNAlias];
                    ShowPlayerStatsSeason player = new ShowPlayerStatsSeason();

                    player.CNAlias = playerStat.CNAlias;

                    player.PointsAverage = Convert.ToDouble(playerSportsDictionary[nameof(player.PointsAverage)]);
                    player.ReboundsAverage = Convert.ToDouble(playerSportsDictionary[nameof(player.ReboundsAverage)]);
                    player.AssistsAverage = playerSportsDictionary[nameof(player.AssistsAverage)];

                    player.StealsAverage = playerSportsDictionary[nameof(player.StealsAverage)];
                    player.BlockedAverage = playerSportsDictionary[nameof(player.BlockedAverage)];
                    player.MinutesAverage = playerSportsDictionary[nameof(player.MinutesAverage)];

                    player.FieldGoalsPercentageAverage = playerSportsDictionary[nameof(player.FieldGoalsPercentageAverage)];
                    player.TwoPointPercentageAverage = playerSportsDictionary[nameof(player.TwoPointPercentageAverage)];
                    player.ThreePointPercentageAverage = playerSportsDictionary[nameof(player.ThreePointPercentageAverage)];
                    player.FreeThrowsPercentageAverage = playerSportsDictionary[nameof(player.FreeThrowsPercentageAverage)];


                    //player.FieldGoalsAtRimPercentageAverage = playerSportsDictionary[nameof(player.FieldGoalsAtRimPercentageAverage)];
                    //player.FieldGoalsMidRangePercentageAverage = playerSportsDictionary[nameof(player.FieldGoalsMidRangePercentageAverage)];


                    player.ThreePointGoalsAverage = playerSportsDictionary[nameof(player.ThreePointGoalsAverage)];
                    player.TwoPointGoalsAverage = playerSportsDictionary[nameof(player.TwoPointGoalsAverage)];
                    player.TwoPointGoalsAverageArea = playerSportsDictionary[nameof(player.TwoPointGoalsAverageArea)];
                    player.ThreePointGoalsAverageArea = playerSportsDictionary[nameof(player.ThreePointGoalsAverageArea)];

                    player.FreeThrowsAverage = playerSportsDictionary[nameof(player.FreeThrowsAverage)];
                    player.TurnoversAverage = playerSportsDictionary[nameof(player.TurnoversAverage)];


                    ShowPlayerStatsSeasonsData.Add(player);

                }

            }

            ShowPlayerStatsSeasonsData = ShowPlayerStatsSeasonsData.OrderByDescending(a => Convert.ToDouble(a.PointsAverage)).ToObservableCollection();

            //ShowInfoPlayersStats = ShowInfoPlayersStats.OrderByDescending(a => Convert.ToInt32(a.Goal)).ToObservableCollection();

            //TotalScore = scores;
            // TotalRebounds = rebounds;
            // TotalAssists = assists;
            // TotalBlocks = blocks;

        }


        #endregion


        #region 球队赛季数据



        public VCommand RefreshTeamSeasonCommand { get; set; }

        private ObservableCollection<ShowTeamStatsSeason> showTeamStatsSeasonsData;

        public ObservableCollection<ShowTeamStatsSeason> ShowTeamStatsSeasonsData
        {
            get { return showTeamStatsSeasonsData; }

            set { showTeamStatsSeasonsData = value;this.RaisePropertyChanged(nameof(ShowTeamStatsSeasonsData)); }
        }


        private async void GetTeamSeasonData()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看赛程球队赛季数据：" + PluginConstant.Operate_Load);

            var TeamSeasonData = await JsonModel.PostTeamSeasonData_Path(Matchtypeid);

            //CNAliasVisitSportsDictionary.Clear();
            if (TeamSeasonData == null) return;

            ShowTeamStatsSeasonsData = new ObservableCollection<ShowTeamStatsSeason>();
            foreach (var teamSeasonData in TeamSeasonData.teamstats)
            {

                ShowTeamStatsSeason showTeamStatsSeason = new ShowTeamStatsSeason();
               
                if(teamHName== teamSeasonData.TeamCNAlias|| teamAName == teamSeasonData.TeamCNAlias)
                {
                    showTeamStatsSeason.TeamCNAlias = teamSeasonData.TeamCNAlias;   
                    showTeamStatsSeason.PointsAverage = teamSeasonData.PointsAverage;
                    showTeamStatsSeason.ReboundsAverage = teamSeasonData.ReboundsAverage;

                    showTeamStatsSeason.AssistsAverage = teamSeasonData.AssistsAverage;
                    showTeamStatsSeason.StealsAverage = teamSeasonData.StealsAverage;
                    showTeamStatsSeason.BlockedAverage = teamSeasonData.BlockedAverage;

                    showTeamStatsSeason.TurnoversAverage = teamSeasonData.TurnoversAverage;
                    showTeamStatsSeason.PersonalFoulsAverage = teamSeasonData.PersonalFoulsAverage;

                    showTeamStatsSeason.FreeThrowsPercentageAverage = (teamSeasonData.FreeThrowsPercentageAverage).ToString("F1") + "%";
                    showTeamStatsSeason.TwoPointPercentageAverage = (teamSeasonData.TwoPointPercentageAverage).ToString("F1") + "%";
                    showTeamStatsSeason.ThreePointPercentageAverage = (teamSeasonData.ThreePointPercentageAverage).ToString("F1") + "%";
                    showTeamStatsSeason.FieldGoalsPercentageAverage = (teamSeasonData.FieldGoalsPercentageAverage).ToString("F1") + "%";

                    ShowTeamStatsSeasonsData.Add(showTeamStatsSeason);

                }

            }
        }

        #endregion

    }
}
