﻿using DevExpress.Mvvm.POCO;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media.Imaging;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using System.Windows.Media;
using System.IO;
using VIZ.TVP.CBA.Module.Message.ViewModel;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.CBA.Module
{
    public class MvpPlayerViewModel : ViewModelBase
    {
        private static ILog Log = LogManager.GetLogger(typeof(NewSinglePlayerViewModel));

        //private static SinglePlayerViewModel _createInstance = null;


        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        public static List<MvpPlayerViewModel> MvpPlayerViewModelInstance = new List<MvpPlayerViewModel>();
        //{
        //    get
        //    {
        //        if (null == _createInstance)
        //        {
        //            _createInstance = new SinglePlayerViewModel();
        //        }
        //        return _createInstance;
        //    }
        //}


        public MvpPlayerViewModel()
        {

            matchStatsIds = new ObservableCollection<int>()
            {
                3,
                4,
                5
   
            };

            BtnCmd = new VCommand(BtnCommand);

            PromptCommand = new VCommand(PromptCmd);

            ScheduleID = DateHeaderViewModel.ScheduleID;
            Matchtypeid = DateHeaderViewModel.Matchtypeid;

            SetSingleData();

            //GetSchedule();




        }

        //初始话界面
        public PageModel page = null;

        public ObservableCollection<string> PlayerDataCompareOptionChinese = new ObservableCollection<string> { "得分","篮板","助攻", "抢断", "盖帽","上场时间","投篮命中率","两分命中率","三分命中率","罚球命中率",
            "篮下投篮命中率","中距离投篮命中率","三分","两分","两分区","三分区","罚球","失误"};


        private int matchStatsId = 5;

        public int MatchStatsId
        {
            get { return matchStatsId; }

            set
            {
                matchStatsId = value;
                this.RaisePropertyChanged(nameof(MatchStatsId));

                SetTechStats();
            }
        }


        private ObservableCollection<int> matchStatsIds;

        public ObservableCollection<int> MatchStatsIds
        {
            get { return matchStatsIds; }

            set { matchStatsIds = value; this.RaisePropertyChanged(nameof(MatchStatsIds)); }
        }

        private SinglePlayerModel singlePlayer;

        public SinglePlayerModel SinglePlayer
        {
            get { return singlePlayer; }
            set { singlePlayer = value; this.RaisePropertyChanged(nameof(SinglePlayer)); }
        }





        public ObservableCollection<string> playerItems;

        public ObservableCollection<string> PlayerItems
        {
            get { return playerItems; }

            set { playerItems = value; this.RaisePropertyChanged(nameof(PlayerItems)); }
        }

        private string selectPlayer;

        public string SelectPlayer
        {
            get { return selectPlayer; }
            set
            {
                selectPlayer = value;
                this.RaisePropertyChanged(nameof(SelectPlayer));

                if (selectedIndex < 0 || selectPlayer == null)
                    return;


                string baesePath = AppDomain.CurrentDomain.BaseDirectory;



                if (selectedIndex == 0)
                {
                    if (HNameNums.ContainsKey(selectPlayer))
                    {
                        PlayNum = HNameNums[selectPlayer];

                        //if (TeamItems[selectedIndex] == "北京控股666")
                        //{
                        //    if (File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")))
                        //    {
                        //        PlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));
                        //    }

                        //}
                        //else
                        //{
                        //    if (File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, TeamItems[selectedIndex])))
                        //    {
                        //        PlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, TeamItems[selectedIndex])));
                        //    }

                        //}

                    }
                }
                else
                {
                    if (VNameNums.ContainsKey(selectPlayer))
                    {
                        PlayNum = VNameNums[selectPlayer];

                        //if (TeamItems[selectedIndex] == "北京控股666")
                        //{
                        //    if (File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")))
                        //    {
                        //        PlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));

                        //    }
                        //}
                        //else
                        //{
                        //    if (File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, TeamItems[selectedIndex])))
                        //    {
                        //        PlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, TeamItems[selectedIndex])));
                        //    }

                        //}

                    }
                }

                SetData(0);
            }
        }


        private ObservableCollection<string> teamItems;

        public ObservableCollection<string> TeamItems
        {
            get { return teamItems; }
            set { teamItems = value; this.RaisePropertyChanged(nameof(TeamItems)); }
        }

        private string selectTeamItem;

        public string SelectTeamItem
        {
            get { return selectTeamItem; }
            set
            {
                selectTeamItem = value;
                this.RaisePropertyChanged(nameof(SelectTeamItem));

            }
        }


        private string playNum;

        public string PlayNum
        {
            get { return playNum; }
            set { playNum = value; this.RaisePropertyChanged(nameof(PlayNum)); }
        }

        private int selectedIndex;



        /// <summary>
        /// 0 是主队 1 是客队
        /// </summary>

        public int SelectedIndex
        {
            get { return selectedIndex; }
            set
            {
                selectedIndex = value;

                this.RaisePropertyChanged(nameof(SelectedIndex));
                SetPlayer(selectedIndex);
            }
        }


        private ImageSource playerLogo;

        public ImageSource PlayerLogo
        {
            get { return playerLogo; }
            set
            {
                playerLogo = value; this.RaisePropertyChanged(nameof(PlayerLogo));
            }
        }

        public VCommand BtnCmd { get; set; }

        public VCommand TeamSelectCommand { get; set; }



        private string title = "MVP球员";

        public string Title
        {
            get { return title; }

            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }

        public VCommand SingleCommand { get; set; }

        public VCommand MVPCommand { get; set; }

        public Dictionary<string, string> HNameNums = new Dictionary<string, string>();

        public Dictionary<string, string> VNameNums = new Dictionary<string, string>();

        /// <summary>
        /// 主队球员技术统计数据
        /// </summary>
        public Dictionary<string, Dictionary<string, string>> MvpHomePlayerCompareNumDictionary
      = new Dictionary<string, Dictionary<string, string>>();

        /// <summary>
        /// 客队球员技术统计数据
        /// </summary>
        public Dictionary<string, Dictionary<string, string>> MvpVisitPlayerCompareNumDictionary
              = new Dictionary<string, Dictionary<string, string>>();

        //向字典中个人选手增加整个赛季的分数值
        public Dictionary<string, Dictionary<string, string>> CNAliasPlayerSportsDictionary
            = new Dictionary<string, Dictionary<string, string>>();

        private void SetPlayer(int index)
        {

            if (index < 0) return;
            MvpHomePlayerCompareNumDictionary.Clear();
            MvpVisitPlayerCompareNumDictionary.Clear();

            PlayerItems = new System.Collections.ObjectModel.ObservableCollection<string>();

            if (index == 0)
            {
                foreach (var teamLive in onAirDataModel.livePlayerStatH)
                {


                    PlayerItems.Add(teamLive.CNAlias);

                    if (!HNameNums.ContainsKey(teamLive.CNAlias))
                    {
                        HNameNums.Add(teamLive.CNAlias, teamLive.Number);
                    }

                    Utils.SetTechStatsInfo(this, index, teamLive, null);


                }



            }
            else
            {
                foreach (var teamLive in onAirDataModel.livePlayerStatV)
                {

                    PlayerItems.Add(teamLive.CNAlias);

                    if (!VNameNums.ContainsKey(teamLive.CNAlias))
                    {
                        VNameNums.Add(teamLive.CNAlias, teamLive.Number);
                    }

                    Utils.SetTechStatsInfo(this, index, null, teamLive);


                }
            }
        }


        private void SetTechStats()
        {

            if (matchStatsId == 3)
            {
                IsCheckVisible3 = Visibility.Hidden;
                TechStatsVisible3 = Visibility.Hidden;
                ScoreVisible3 = Visibility.Hidden;
                SeasonScoreVisible3 = Visibility.Hidden;

                IsCheckVisible4 = Visibility.Hidden;
                TechStatsVisible4 = Visibility.Hidden;
                ScoreVisible4 = Visibility.Hidden;
                SeasonScoreVisible4 = Visibility.Hidden;




            }
            else if (matchStatsId == 4)
            {
                IsCheckVisible3 = Visibility.Visible;
                TechStatsVisible3 = Visibility.Visible;
                ScoreVisible3 = Visibility.Visible;
                SeasonScoreVisible3 = Visibility.Visible;

                IsCheckVisible4 = Visibility.Hidden;
                TechStatsVisible4 = Visibility.Hidden;
                ScoreVisible4 = Visibility.Hidden;
                SeasonScoreVisible4 = Visibility.Hidden;

            }

            else if (matchStatsId == 5)
            {
                IsCheckVisible3 = Visibility.Visible;
                TechStatsVisible3 = Visibility.Visible;
                ScoreVisible3 = Visibility.Visible;
                SeasonScoreVisible3 = Visibility.Visible;

                IsCheckVisible4 = Visibility.Visible;
                TechStatsVisible4 = Visibility.Visible;
                ScoreVisible4 = Visibility.Visible;
                SeasonScoreVisible4 = Visibility.Visible;


            }
           

            SetData(0);
        }


        //球员赛季数据
        public string Matchtypeid = "";
        //比赛赛程Id
        public string ScheduleID = "";

        /// <summary>
        /// 球员赛季数据
        /// </summary>
        public PlayerSeasonData PlayerSeasonData = new PlayerSeasonData();

        /// <summary>
        /// 队伍赛程信息
        /// </summary>
        public TeamSeasonData TeamSeasonData = new TeamSeasonData();

        public OnAirDataModel onAirDataModel = new OnAirDataModel();


        /// <summary>
        /// 设置一个比赛赛程集合
        /// </summary>
        public Dictionary<string, string> SetMatchDict = new Dictionary<string, string>();


        /// <summary>
        /// 设置单个球员相关的信息
        /// </summary>
        public void SetSingleData()
        {
            onAirDataModel = JsonModel.PostOnAirData_Path(ScheduleID);
            ClearData();
            if (onAirDataModel == null) return;
            GetSeasonData();


            TeamItems = new System.Collections.ObjectModel.ObservableCollection<string>();
            TeamItems.Add(onAirDataModel.liveTeamInfo.HomeTeamCNAlias);
            TeamItems.Add(onAirDataModel.liveTeamInfo.VisitingTeamCNAlias);
            SetPlayer(selectedIndex);
        }


        private void ClearData()
        {

            if (onAirDataModel != null) return;
            if (TeamItems!=null)
            {
                TeamItems.Clear();
            }

            if(HNameNums!=null)
            {
                HNameNums.Clear();
            }
          
            if(PlayerItems!=null)
            {
                PlayerItems.Clear();
            }

            SelectPlayer = "";
            PlayNum = "";

            Score = "";
            Score1 = "";
            Score2 = "";
            Score3 = "";
            Score4 = "";

            SeasonScore = "";
            SeasonScore1 = "";
            SeasonScore2 = "";
            SeasonScore3 = "";
            SeasonScore4 = "";

        }


        /// <summary>
        /// 获得赛季数据
        /// </summary>
        private async void GetSeasonData()
        {
            try
            {
                PlayerSeasonData = await JsonModel.PostPlayerSeasonData_Path(Matchtypeid);

                TeamSeasonData = await JsonModel.PostTeamSeasonData_Path(Matchtypeid);

                if (PlayerSeasonData == null) return;
                CNAliasPlayerSportsDictionary.Clear();
                foreach (var tempSeasonData in PlayerSeasonData.playerstats)
                {
                    Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                    CompareItemToNumber.Add("得分", tempSeasonData.PointsAverage);
                    CompareItemToNumber.Add("篮板", tempSeasonData.ReboundsAverage);
                    CompareItemToNumber.Add("助攻", tempSeasonData.AssistsAverage);
                    CompareItemToNumber.Add("抢断", tempSeasonData.StealsAverage);
                    CompareItemToNumber.Add("盖帽", tempSeasonData.BlockedAverage);
                    CompareItemToNumber.Add("上场时间", tempSeasonData.MinutesAverage);
                    CompareItemToNumber.Add("投篮命中率", (tempSeasonData.FieldGoalsPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("两分命中率", (tempSeasonData.TwoPointPercentageAverage).ToString("F1") + "%");

                    CompareItemToNumber.Add("三分命中率", (tempSeasonData.ThreePointPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("罚球命中率", (tempSeasonData.FreeThrowsPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("篮下投篮命中率", (tempSeasonData.FieldGoalsAtRimPercentageAverage * 100).ToString("F1") + "%");
                    CompareItemToNumber.Add("中距离投篮命中率", (tempSeasonData.FieldGoalsMidRangePercentageAverage * 100).ToString("F1") + "%");
                    CompareItemToNumber.Add("三分", tempSeasonData.ThreePointGoalsAverage + "/"
                                + tempSeasonData.ThreePointAttemptedAverage);


                    CompareItemToNumber.Add("两分", tempSeasonData.TwoPointGoalsAverage + "/"
                                + tempSeasonData.TwoPointAttemptedAverage);


                    CompareItemToNumber.Add("两分区", tempSeasonData.TwoPointGoalsAverage + "/"
                                + tempSeasonData.TwoPointAttemptedAverage);
                    CompareItemToNumber.Add("三分区", tempSeasonData.ThreePointGoalsAverage + "/"

                 + tempSeasonData.ThreePointAttemptedAverage);
                    //CompareItemToNumber.Add("ThreeArea",);

                    CompareItemToNumber.Add("罚球", tempSeasonData.FreeThrowsAverage + "/"
                                + tempSeasonData.FreeThrowsAttemptedAverage);
                    CompareItemToNumber.Add("失误", tempSeasonData.TurnoversAverage);

                    if (!CNAliasPlayerSportsDictionary.ContainsKey(tempSeasonData.CNAlias))
                    {
                        CNAliasPlayerSportsDictionary.Add(tempSeasonData.CNAlias, CompareItemToNumber);
                    }

                }
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
            }
        }

        /// <summary>
        /// 组装数据
        /// </summary>
        /// <returns></returns>
        public string CombineSingleData()
        {
            try
            {


                string data = "";

                if (matchStatsId != 0)
                {
                    data += matchStatsId.ToString().Replace(" ", "") + "*";
                }
                else
                {
                    data += "7*";
                }


                data += title.Replace(" ", "") + "*";
                if (!string.IsNullOrEmpty(selectTeamItem))
                {
                    data += selectTeamItem.Replace(" ", "") + "*";
                }
                else
                {
                    data += "" + "*";
                }

                if (!string.IsNullOrEmpty(SelectPlayer))
                {
                    data += SelectPlayer.Replace(" ", "") + "&";
                }
                else
                {
                    data += "" + "&";
                }



                if (matchStatsId == 5)
                {
                    //第一项
                    if (IsHeight == false)
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += selectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(Score))
                    {
                        data += Score.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(SeasonScore))
                    {
                        data += SeasonScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }



                    //第二项
                    if (IsHeight1 == false)
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += selectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(Score1))
                    {
                        data += Score1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(SeasonScore1))
                    {
                        data += SeasonScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第三项
                    if (IsHeight2 == false)
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += selectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(Score2))
                    {
                        data += Score2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(SeasonScore2))
                    {
                        data += SeasonScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第四项
                    if (IsHeight3 == false)
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += selectTechStats3.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(Score3))
                    {
                        data += Score3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(SeasonScore3))
                    {
                        data += SeasonScore3.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第五项
                    if (IsHeight4 == false)
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += selectTechStats4.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(Score4))
                    {
                        data += Score4.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(SeasonScore4))
                    {
                        data += SeasonScore4.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }
                }

                else if (matchStatsId == 4)
                {
                    //第一项
                    if (IsHeight == false)
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += selectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(Score))
                    {
                        data += Score.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(SeasonScore))
                    {
                        data += SeasonScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }



                    //第二项
                    if (IsHeight1 == false)
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += selectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(Score1))
                    {
                        data += Score1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(SeasonScore1))
                    {
                        data += SeasonScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }





                    //第三项
                    if (IsHeight2 == false)
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += selectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(Score2))
                    {
                        data += Score2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(SeasonScore2))
                    {
                        data += SeasonScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第四项
                    if (IsHeight3 == false)
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += selectTechStats3.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(Score3))
                    {
                        data += Score3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(SeasonScore3))
                    {
                        data += SeasonScore3.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }

                }
                else if (matchStatsId == 3)
                {

                    //第一项
                    if (IsHeight == false)
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += selectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(Score))
                    {
                        data += Score.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(SeasonScore))
                    {
                        data += SeasonScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第二项
                    if (IsHeight1 == false)
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += selectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(Score1))
                    {
                        data += Score1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(SeasonScore1))
                    {
                        data += SeasonScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第三项
                    if (IsHeight2 == false)
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    data += selectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(Score2))
                    {
                        data += Score2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(SeasonScore2))
                    {
                        data += SeasonScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }

                }

                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }


        /// <summary>
        /// 刷新数据
        /// </summary>
        public void BtnCommand()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA:MVP球员："+ PluginConstant.Opeate_Refresh);
            onAirDataModel = JsonModel.PostOnAirData_Path(ScheduleID);
            if (onAirDataModel == null) return;
            MvpHomePlayerCompareNumDictionary.Clear();
            MvpVisitPlayerCompareNumDictionary.Clear();
            if (SelectedIndex == 0)
            {
                foreach (var teamLive in onAirDataModel.livePlayerStatH)
                {
                    Utils.SetTechStatsInfo(this, SelectedIndex, teamLive, null);
                }
            }
            else
            {
                foreach (var teamLive in onAirDataModel.livePlayerStatV)
                {
                    Utils.SetTechStatsInfo(this, SelectedIndex, null, teamLive);
                }
            }

            SetData(0);
        }


        /// <summary>
        /// 设置数据得分
        /// </summary>
        private void SetData(int index)
        {

            if (SelectPlayer == null) return;
            if (SelectedIndex == 0)
            {


                if (MvpHomePlayerCompareNumDictionary.ContainsKey(SelectPlayer))
                {
                    var playSeaSonData = MvpHomePlayerCompareNumDictionary[SelectPlayer];

                    if (index == 1)
                    {
                        //第一项
                        if (playSeaSonData.ContainsKey(SelectTechStats))
                        {
                            Score = playSeaSonData[SelectTechStats];
                        }
                        else
                        {
                            Score = "0";
                        }
                    }
                    else if (index == 2)
                    {
                        //第二项
                        if (playSeaSonData.ContainsKey(SelectTechStats1))
                        {
                            Score1 = playSeaSonData[SelectTechStats1];
                        }
                        else
                        {
                            Score1 = "0";
                        }

                    }
                    else if (index == 3)
                    {
                        //第三项
                        if (playSeaSonData.ContainsKey(SelectTechStats2))
                        {
                            Score2 = playSeaSonData[SelectTechStats2];
                        }
                        else
                        {
                            Score2 = "0";
                        }

                    }
                    else if (index == 4)
                    {
                        //第四项
                        if (playSeaSonData.ContainsKey(SelectTechStats3))
                        {
                            Score3 = playSeaSonData[SelectTechStats3];
                        }
                        else
                        {
                            Score3 = "0";
                        }
                    }
                    else if (index == 5)
                    {
                        //第五项
                        if (playSeaSonData.ContainsKey(SelectTechStats4))
                        {
                            Score4 = playSeaSonData[SelectTechStats4];
                        }
                        else
                        {
                            Score4 = "0";
                        }
                    }

                    else
                    {

                        //第一项
                        if (playSeaSonData.ContainsKey(SelectTechStats))
                        {
                            Score = playSeaSonData[SelectTechStats];
                        }
                        else
                        {
                            Score = "0";
                        }

                        //第二项
                        if (playSeaSonData.ContainsKey(SelectTechStats1))
                        {
                            Score1 = playSeaSonData[SelectTechStats1];
                        }
                        else
                        {
                            Score1 = "0";
                        }

                        //第三项
                        if (playSeaSonData.ContainsKey(SelectTechStats2))
                        {
                            Score2 = playSeaSonData[SelectTechStats2];
                        }
                        else
                        {
                            Score2 = "0";
                        }


                        //第四项
                        if (playSeaSonData.ContainsKey(SelectTechStats3))
                        {
                            Score3 = playSeaSonData[SelectTechStats3];
                        }
                        else
                        {
                            Score3 = "0";
                        }

                        //第五项
                        if (playSeaSonData.ContainsKey(SelectTechStats4))
                        {
                            Score4 = playSeaSonData[SelectTechStats4];
                        }
                        else
                        {
                            Score4 = "0";
                        }

                    }

                }

            }
            else
            {



                if (MvpVisitPlayerCompareNumDictionary.ContainsKey(SelectPlayer))
                {
                    var playSeaSonData = MvpVisitPlayerCompareNumDictionary[SelectPlayer];



                    if (index == 1)
                    {
                        //第一项
                        if (playSeaSonData.ContainsKey(selectTechStats))
                        {
                            Score = playSeaSonData[selectTechStats];
                        }
                        else
                        {
                            Score = "0";
                        }
                    }
                    else if (index == 2)
                    {

                        //第二项
                        if (playSeaSonData.ContainsKey(selectTechStats1))
                        {
                            Score1 = playSeaSonData[selectTechStats1];
                        }
                        else
                        {
                            Score1 = "0";
                        }

                    }
                    else if (index == 3)
                    {
                        //第三项
                        if (playSeaSonData.ContainsKey(selectTechStats2))
                        {
                            Score2 = playSeaSonData[selectTechStats2];
                        }
                        else
                        {
                            Score2 = "0";
                        }

                    }
                    else if (index == 4)
                    {
                        //第四项
                        if (playSeaSonData.ContainsKey(selectTechStats3))
                        {
                            Score3 = playSeaSonData[selectTechStats3];
                        }
                        else
                        {
                            Score3 = "0";
                        }

                    }

                    else if (index == 5)
                    {
                        //第五项
                        if (playSeaSonData.ContainsKey(selectTechStats4))
                        {
                            Score4 = playSeaSonData[selectTechStats4];
                        }
                        else
                        {
                            Score4 = "0";
                        }
                    }
      
                    else
                    {

                        //第一项
                        if (playSeaSonData.ContainsKey(selectTechStats))
                        {
                            Score = playSeaSonData[selectTechStats];
                        }
                        else
                        {
                            Score = "0";
                        }

                        //第二项
                        if (playSeaSonData.ContainsKey(selectTechStats1))
                        {
                            Score1 = playSeaSonData[selectTechStats1];
                        }
                        else
                        {
                            Score1 = "0";
                        }


                        //第三项
                        if (playSeaSonData.ContainsKey(selectTechStats2))
                        {
                            Score2 = playSeaSonData[selectTechStats2];
                        }
                        else
                        {
                            Score2 = "0";
                        }


                        //第四项
                        if (playSeaSonData.ContainsKey(selectTechStats3))
                        {
                            Score3 = playSeaSonData[selectTechStats3];
                        }
                        else
                        {
                            Score3 = "0";
                        }


                        //第五项
                        if (playSeaSonData.ContainsKey(selectTechStats4))
                        {
                            Score4 = playSeaSonData[selectTechStats4];
                        }
                        else
                        {
                            Score4 = "0";
                        }

                    }

                }


            }

            if (SelectPlayer != null)
            {


                if (CNAliasPlayerSportsDictionary.ContainsKey(SelectPlayer))
                {
                    var playSeaSonData = CNAliasPlayerSportsDictionary[SelectPlayer];

                    if (index == 1)
                    {
                        //第一项
                        if (playSeaSonData.ContainsKey(selectTechStats))
                        {
                            SeasonScore = playSeaSonData[selectTechStats];
                        }
                        else
                        {
                            SeasonScore = "0";
                        }
                    }
                    else if (index == 2)
                    {


                        //第二项
                        if (playSeaSonData.ContainsKey(selectTechStats1))
                        {
                            SeasonScore1 = playSeaSonData[selectTechStats1];
                        }
                        else
                        {
                            SeasonScore1 = "0";
                        }
                    }
                    else if (index == 3)
                    {


                        //第三项
                        if (playSeaSonData.ContainsKey(selectTechStats2))
                        {
                            SeasonScore2 = playSeaSonData[selectTechStats2];
                        }
                        else
                        {
                            SeasonScore2 = "0";
                        }
                    }
                    else if (index == 4)
                    {

                        //第四项
                        if (playSeaSonData.ContainsKey(selectTechStats3))
                        {
                            SeasonScore3 = playSeaSonData[selectTechStats3];
                        }
                        else
                        {
                            SeasonScore3 = "0";
                        }

                    }

                    else if (index == 5)
                    {
                        //第五项
                        if (playSeaSonData.ContainsKey(selectTechStats4))
                        {
                            SeasonScore4 = playSeaSonData[selectTechStats4];
                        }
                        else
                        {
                            SeasonScore4 = "0";
                        }

                    }
  
                    else
                    {

                        //第一项
                        if (playSeaSonData.ContainsKey(selectTechStats))
                        {
                            SeasonScore = playSeaSonData[selectTechStats];
                        }
                        else
                        {
                            SeasonScore = "0";
                        }


                        //第二项
                        if (playSeaSonData.ContainsKey(selectTechStats1))
                        {
                            SeasonScore1 = playSeaSonData[selectTechStats1];
                        }
                        else
                        {
                            SeasonScore1 = "0";
                        }



                        //第三项
                        if (playSeaSonData.ContainsKey(selectTechStats2))
                        {
                            SeasonScore2 = playSeaSonData[selectTechStats2];
                        }
                        else
                        {
                            SeasonScore2 = "0";
                        }



                        //第四项
                        if (playSeaSonData.ContainsKey(selectTechStats3))
                        {
                            SeasonScore3 = playSeaSonData[selectTechStats3];
                        }
                        else
                        {
                            SeasonScore3 = "0";
                        }


                        //第五项
                        if (playSeaSonData.ContainsKey(selectTechStats4))
                        {
                            SeasonScore4 = playSeaSonData[selectTechStats4];
                        }
                        else
                        {
                            SeasonScore4 = "0";
                        }


                    }


                }
            }

        }



        static ObservableCollection<string> listTechStats = new ObservableCollection<string>() { "得分", "篮板", "助攻", "抢断", "盖帽", "上场时间", "投篮命中率", "两分命中率", "三分命中率", "罚球命中率", "篮下投篮命中率",
                                                                                            "中距离投篮命中率","三分","两分","两分区","三分区","罚球","失误"};//,"犯规","三分得分"


        #region 第一项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight;

        public bool IsHeight
        {
            get { return isHeight; }
            set { isHeight = value; this.RaisePropertyChanged(nameof(IsHeight)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible;
        public Visibility IsCheckVisible
        {
            get { return isCheckVisible; }
            set { isCheckVisible = value; this.RaisePropertyChanged(nameof(IsCheckVisible)); }
        }

        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats = listTechStats;

        public ObservableCollection<string> TechStats
        {
            get { return techStats; }
            set { techStats = value; this.RaisePropertyChanged(nameof(TechStats)); }
        }

        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats = "得分";

        public string SelectTechStats
        {
            get { return selectTechStats; }
            set
            {
                selectTechStats = value;
                this.RaisePropertyChanged(nameof(SelectTechStats));

                SetData(1);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible;


        public Visibility TechStatsVisible
        {
            get { return techStatsVisible; }
            set { techStatsVisible = value; this.RaisePropertyChanged(nameof(TechStatsVisible)); }
        }


        /// <summary>
        /// 得分
        /// </summary>

        private string score;

        public string Score
        {
            get { return score; }
            set { score = value; this.RaisePropertyChanged(nameof(Score)); }
        }


        /// <summary>
        /// 得分是否可见
        /// </summary>
        private Visibility scoreVisible;

        public Visibility ScoreVisible
        {
            get { return scoreVisible; }

            set { scoreVisible = value; this.RaisePropertyChanged(nameof(ScoreVisible)); }
        }


        /// <summary>
        /// 赛季得分
        /// </summary>
        private string seasonScore;

        public string SeasonScore
        {
            get { return seasonScore; }

            set { seasonScore = value; this.RaisePropertyChanged(nameof(SeasonScore)); }
        }

        /// <summary>
        /// 赛季得分是否可见
        /// </summary>
        private Visibility seasonScoreVisible;

        public Visibility SeasonScoreVisible
        {
            get { return seasonScoreVisible; }
            set { seasonScoreVisible = value; this.RaisePropertyChanged(nameof(SeasonScoreVisible)); }
        }

        #endregion


        #region 第二项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight1;

        public bool IsHeight1
        {
            get { return isHeight1; }
            set { isHeight1 = value; this.RaisePropertyChanged(nameof(IsHeight1)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible1;
        public Visibility IsCheckVisible1
        {
            get { return isCheckVisible1; }
            set { isCheckVisible1 = value; this.RaisePropertyChanged(nameof(IsCheckVisible1)); }
        }

        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats1 = listTechStats;

        public ObservableCollection<string> TechStats1
        {
            get { return techStats1; }
            set { techStats1 = value; this.RaisePropertyChanged(nameof(TechStats1)); }
        }

        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats1 = "篮板";

        public string SelectTechStats1
        {
            get { return selectTechStats1; }
            set
            {
                selectTechStats1 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats1));
                SetData(2);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible1;


        public Visibility TechStatsVisible1
        {
            get { return techStatsVisible1; }
            set { techStatsVisible1 = value; this.RaisePropertyChanged(nameof(TechStatsVisible1)); }
        }


        /// <summary>
        /// 得分
        /// </summary>

        private string score1;

        public string Score1
        {
            get { return score1; }
            set { score1 = value; this.RaisePropertyChanged(nameof(Score1)); }
        }


        /// <summary>
        /// 得分是否可见
        /// </summary>
        private Visibility scoreVisible1;

        public Visibility ScoreVisible1
        {
            get { return scoreVisible1; }

            set { scoreVisible1 = value; this.RaisePropertyChanged(nameof(ScoreVisible1)); }
        }


        /// <summary>
        /// 赛季得分
        /// </summary>
        private string seasonScore1;

        public string SeasonScore1
        {
            get { return seasonScore1; }

            set { seasonScore1 = value; this.RaisePropertyChanged(nameof(SeasonScore1)); }
        }

        /// <summary>
        /// 赛季得分是否可见
        /// </summary>
        private Visibility seasonScoreVisible1;

        public Visibility SeasonScoreVisible1
        {
            get { return seasonScoreVisible1; }
            set { seasonScoreVisible1 = value; this.RaisePropertyChanged(nameof(SeasonScoreVisible1)); }
        }

        #endregion


        #region 第三项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight2;

        public bool IsHeight2
        {
            get { return isHeight2; }
            set { isHeight2 = value; this.RaisePropertyChanged(nameof(IsHeight2)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible2;
        public Visibility IsCheckVisible2
        {
            get { return isCheckVisible2; }
            set { isCheckVisible2 = value; this.RaisePropertyChanged(nameof(IsCheckVisible2)); }
        }

        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats2 = listTechStats;

        public ObservableCollection<string> TechStats2
        {
            get { return techStats2; }
            set { techStats2 = value; this.RaisePropertyChanged(nameof(TechStats2)); }
        }

        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats2 = "助攻";

        public string SelectTechStats2
        {
            get { return selectTechStats2; }
            set
            {
                selectTechStats2 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats2));
                SetData(3);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible2;


        public Visibility TechStatsVisible2
        {
            get { return techStatsVisible2; }
            set { techStatsVisible2 = value; this.RaisePropertyChanged(nameof(TechStatsVisible2)); }
        }


        /// <summary>
        /// 得分
        /// </summary>

        private string score2;

        public string Score2
        {
            get { return score2; }
            set { score2 = value; this.RaisePropertyChanged(nameof(Score2)); }
        }


        /// <summary>
        /// 得分是否可见
        /// </summary>
        private Visibility scoreVisible2;

        public Visibility ScoreVisible2
        {
            get { return scoreVisible2; }

            set { scoreVisible2 = value; this.RaisePropertyChanged(nameof(ScoreVisible2)); }
        }


        /// <summary>
        /// 赛季得分
        /// </summary>
        private string seasonScore2;

        public string SeasonScore2
        {
            get { return seasonScore2; }

            set { seasonScore2 = value; this.RaisePropertyChanged(nameof(SeasonScore2)); }
        }

        /// <summary>
        /// 赛季得分是否可见
        /// </summary>
        private Visibility seasonScoreVisible2;

        public Visibility SeasonScoreVisible2
        {
            get { return seasonScoreVisible2; }
            set { seasonScoreVisible2 = value; this.RaisePropertyChanged(nameof(SeasonScoreVisible2)); }
        }

        #endregion


        #region 第四项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight3;

        public bool IsHeight3
        {
            get { return isHeight3; }
            set { isHeight3 = value; this.RaisePropertyChanged(nameof(IsHeight3)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible3;
        public Visibility IsCheckVisible3
        {
            get { return isCheckVisible3; }
            set { isCheckVisible3 = value; this.RaisePropertyChanged(nameof(IsCheckVisible3)); }
        }

        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats3 = listTechStats;

        public ObservableCollection<string> TechStats3
        {
            get { return techStats3; }
            set { techStats3 = value; this.RaisePropertyChanged(nameof(TechStats3)); }
        }

        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats3 = "盖帽";

        public string SelectTechStats3
        {
            get { return selectTechStats3; }
            set
            {
                selectTechStats3 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats3));
                SetData(4);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible3;


        public Visibility TechStatsVisible3
        {
            get { return techStatsVisible3; }
            set { techStatsVisible3 = value; this.RaisePropertyChanged(nameof(TechStatsVisible3)); }
        }


        /// <summary>
        /// 得分
        /// </summary>

        private string score3;

        public string Score3
        {
            get { return score3; }
            set { score3 = value; this.RaisePropertyChanged(nameof(Score3)); }
        }


        /// <summary>
        /// 得分是否可见
        /// </summary>
        private Visibility scoreVisible3;

        public Visibility ScoreVisible3
        {
            get { return scoreVisible3; }

            set { scoreVisible3 = value; this.RaisePropertyChanged(nameof(ScoreVisible3)); }
        }


        /// <summary>
        /// 赛季得分
        /// </summary>
        private string seasonScore3;

        public string SeasonScore3
        {
            get { return seasonScore3; }

            set { seasonScore3 = value; this.RaisePropertyChanged(nameof(SeasonScore3)); }
        }

        /// <summary>
        /// 赛季得分是否可见
        /// </summary>
        private Visibility seasonScoreVisible3;

        public Visibility SeasonScoreVisible3
        {
            get { return seasonScoreVisible3; }
            set { seasonScoreVisible3 = value; this.RaisePropertyChanged(nameof(SeasonScoreVisible3)); }
        }

        #endregion


        #region 第五项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight4;

        public bool IsHeight4
        {
            get { return isHeight4; }
            set { isHeight4 = value; this.RaisePropertyChanged(nameof(IsHeight4)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible4;
        public Visibility IsCheckVisible4
        {
            get { return isCheckVisible4; }
            set { isCheckVisible4 = value; this.RaisePropertyChanged(nameof(IsCheckVisible4)); }
        }

        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats4 = listTechStats;

        public ObservableCollection<string> TechStats4
        {
            get { return techStats4; }
            set { techStats4 = value; this.RaisePropertyChanged(nameof(TechStats4)); }
        }

        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats4 = "抢断";

        public string SelectTechStats4
        {
            get { return selectTechStats4; }
            set
            {
                selectTechStats4 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats4));

                SetData(5);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible4;


        public Visibility TechStatsVisible4
        {
            get { return techStatsVisible4; }
            set { techStatsVisible4 = value; this.RaisePropertyChanged(nameof(TechStatsVisible4)); }
        }


        /// <summary>
        /// 得分
        /// </summary>

        private string score4;

        public string Score4
        {
            get { return score4; }
            set { score4 = value; this.RaisePropertyChanged(nameof(Score4)); }
        }


        /// <summary>
        /// 得分是否可见
        /// </summary>
        private Visibility scoreVisible4;

        public Visibility ScoreVisible4
        {
            get { return scoreVisible4; }

            set { scoreVisible4 = value; this.RaisePropertyChanged(nameof(ScoreVisible4)); }
        }


        /// <summary>
        /// 赛季得分
        /// </summary>
        private string seasonScore4;

        public string SeasonScore4
        {
            get { return seasonScore4; }

            set { seasonScore4 = value; this.RaisePropertyChanged(nameof(SeasonScore4)); }
        }

        /// <summary>
        /// 赛季得分是否可见
        /// </summary>
        private Visibility seasonScoreVisible4;

        public Visibility SeasonScoreVisible4
        {
            get { return seasonScoreVisible4; }
            set { seasonScoreVisible4 = value; this.RaisePropertyChanged(nameof(SeasonScoreVisible4)); }
        }

        #endregion


        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA:MVP球员：" + PluginConstant.Operate_Message);
            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
            if (onAirDataModel != null)
            {
                string onAirLastDate = $"直播接口更新时间：{onAirDataModel.LastPushDataDateTime}";
                vm.OnErrorLogMessage(onAirLastDate);
            }

            if (PlayerSeasonData != null)
            {
                string playerSeasonLastDate = $"球员赛季接口更新时间：{PlayerSeasonData.LastPushDataDateTime}";
                vm.OnErrorLogMessage(playerSeasonLastDate);
            }

            if (TeamSeasonData != null)
            {
                string teamSeasonLastDate = $"球队赛季接口更新时间:{TeamSeasonData.LastPushDataDateTime}";
                vm.OnErrorLogMessage(teamSeasonLastDate);
            }
            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;

            // messageLastRecordDate.ShowDialog();
        }

        #endregion


    }
}
