﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Module;
using VIZ.Package.Service;
using VIZ.Package.Storage;
using VIZ.TVP.CBA.Module;

namespace VIZ.TVP.CBA.Module
{ 
    /// <summary>
    /// Interaction logic for NewPlayerComPareView.xaml
    /// </summary>
    public partial class NewPlayerComPareView : UserControl, IPluginView
    {

        public NewPlayerComPareViewModel vm = new NewPlayerComPareViewModel();

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        public NewPlayerComPareView()
        {
            InitializeComponent();

            NewPlayerComPareViewModel.PlayerCompareViewModelInstance.Add(vm);
            WPFHelper.BindingViewModel(this, vm);


            task_Start.Visibility = Visibility.Hidden;
            task_Stop.Visibility = Visibility.Hidden;
            task_continue.Visibility = Visibility.Hidden;

            task_Start.IsEnabled = true;
            task_Stop.IsEnabled = false;
            task_continue.IsEnabled = false;

            this.Loaded += NewPlayerComPareView_Loaded;
            this.IsVisibleChanged += NewPlayerComPareView_IsVisibleChanged;

        }

        private void NewPlayerComPareView_IsVisibleChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            if (!string.IsNullOrEmpty(vm.ScheduleID) && !string.IsNullOrEmpty(vm.Matchtypeid))
            {
                if(e.NewValue!=null&&Convert.ToBoolean(e.NewValue))
                {
                    vm.SetCompareData();
                }
 
            }
        }

        private void NewPlayerComPareView_Loaded(object sender, RoutedEventArgs e)
        {
            var service = ApplicationDomainEx.ServiceManager.GetService<IPluginService>(ViewServiceKeys.PLUGIN_SERVICE);
            if (service == null)
                return;
            vm.page = service.GetPageModelFromView(this);
        }

        public void Dispose()
        {

        }

        public void PreviewContinue(ConnModel conn)
        {

        }

        public void PreviewIn(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_PREVIEW_PLAY);
            if (conn.IsConnected)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombinePlayerCommand()));
            }
        }

        public void PreviewOut(ConnModel conn)
        {
            //if(conn.IsConnected)
            // {
            //     conn.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            // }
        }

        public void TakeContinue(ConnModel conns)
        {

        }

        public void TakeOut(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_OUT);
            if (conns.IsConnected )
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        public void TakeUpdate(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_UPDATE);
            if (conns.IsConnected)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombinePlayerCommand()));
            }
        }

        public void TakIn(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_TAKE);
            if (conns.IsConnected)
            {
                conns.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombinePlayerCommand()));
            }
        }



        /// <summary>
        /// 注册任务
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void PlayerComPareView_Init()
        {
            if (task != null)
                return;

            task = new PackageTaskModel(this);
            task.PreviewUpdateAction = OnPreviewUpdate;
            task.TakeUpdateAction = OnTakeUpdate;

            task.IsPreviewEnabled = true;
            task.IsTakeEnabled = true;
            task.IsRunning = true;

            task.Name = "球员对比";


            service = ApplicationDomainEx.ServiceManager.GetService<IPackageTaskService>(ViewServiceKeys.PACKAGE_TASK_SERVICE);
            if (service == null)
                return;

            service.Register(task);

        }


        /// <summary>
        /// 任务模型
        /// </summary>
        public PackageTaskModel task;

        IPackageTaskService service;

        private void OnPreviewUpdate(ConnModel conn)
        {
            if (conn.IsConnected)
            {
                vm.BtnCmd();
                //task.CanExecute = vm.flag;
                //SCRIPT_INVOKE
                if(vm.onAirDataModel!=null)
                {
                    conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombinePlayerCommand()));
                }
              
            }
        }

        private void OnTakeUpdate(ConnModel conn)
        {
            if (conn.IsConnected)
            {
                vm.BtnCmd();

                if(vm.onAirDataModel!=null)
                {
                    conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombinePlayerCommand()));
                }
                //SCRIPT_INVOKE
            
            }
        }

        private void task_Start_Click(object sender, RoutedEventArgs e)
        {
            PlayerComPareView_Init();
            task_Start.IsEnabled = false;
            task_Stop.IsEnabled = true;
            task_continue.IsEnabled = true;
        }

        private void task_continue_Click(object sender, RoutedEventArgs e)
        {
            if (task.IsRunning)
            {
                task.IsRunning = false;
                task_continue.Content = "任务继续";
            }
            else
            {
                task.IsRunning = true;
                task_continue.Content = "任务暂停";
            }
            task_Start.IsEnabled = false;
            task_Stop.IsEnabled = true;
        }

        private void task_Stop_Click(object sender, RoutedEventArgs e)
        {
            service.Cancel(task);

            task = null;
            task_Start.IsEnabled = true;
            task_continue.Content = "任务暂停";
            task_continue.IsEnabled = false;
            task_Stop.IsEnabled = false;
        }

        public void PageOpend(ConnModel conn, PageModel page)
        {
            if (conn.IsConnected)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombinePlayerCommand()));
            }
        }

        public void PreviewUpdate(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_PREVIEW_UPDATE);
            if (conn.IsConnected)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombinePlayerCommand()));
            }
        }
    }
}
