﻿using DevExpress.XtraPrinting.Native.WebClientUIControl;
using log4net;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.FTB.Module
{
    public static class JsonModel
    {

        /// <summary>
        /// 添加日志
        /// </summary>
        private static readonly ILog Log = LogManager.GetLogger(typeof(JsonModel));

        //读取url
        private static AppSetup_InitLiteDB appSetup_InitLiteDB = AppSetup_InitLiteDB.CreateInstance;


        //新的URL
        public static string strUrl = AppSetup_InitLiteDB.HttpUrlConfigEntity.Url;

        /// <summary>
        /// 读取艾果的数据平台的配置项
        /// </summary>
        public static string appID = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppId;
        //sd.Settings["AppID"].Value.ToString();
        public static string appKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppKey;

        //public  string type = AppSetup_InitLiteDB.HttpUrlConfigEntity.SelectFootballType;

        //public  string seasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.SeasonId;



        /// <summary>
        /// 艾果平台的明日赛程数据服务器接口
        /// </summary>
        /// <returns></returns>
        public async static Task<Dayschedules> PostTomorrowMatch_Path(string round,string selectFootballType)
        {


            Dayschedules dayschedules = new Dayschedules();
            try

            {
                await Task.Run(() =>
                {
                    string GameRoundDataPath = strUrl + "schedule/getschedulelist";

                    Dictionary<string, string> dict = new Dictionary<string, string>();
                    //dict.Add("leagueid", "401");
                    dict.Add("round", round);
                    dict.Add("competitionId", selectFootballType);
                    

                    string newKey = Utils.GetKey(appID, appKey);
                    var str = JsonHelper.Post(GameRoundDataPath, dict, newKey);

                    Log.Info("轮次数据接口新:=======>:" + str);

                    JsonSerializerSettings settings = new JsonSerializerSettings();
                    settings.NullValueHandling = NullValueHandling.Ignore;
                    dayschedules = JsonConvert.DeserializeObject<Dayschedules>(str, settings);

                    dayschedules.schedulelist = dayschedules.schedulelist.OrderBy(a => a.time).ToList();

                });

                return dayschedules;

            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }

        }


        /// <summary>
        ///球队积分数据服务器地址
        /// </summary>
        /// <returns></returns>
        public static TeamRanks PostTeamScoreData_Path(string footballType,string seasonId)
        {
            try
            {
                string TeamScoreDataPath = strUrl + "team/getteamstats";


                Dictionary<string, string> dict = new Dictionary<string, string>();

                dict.Add("competitionId", footballType);
                dict.Add("seasonId", seasonId);//"110000005454"

                string newKey = Utils.GetKey(appID, appKey);

                string result = JsonHelper.Post(TeamScoreDataPath, dict, newKey);

                Log.Info("球队积分排行数据==>:" + result);
                JsonSerializerSettings settings = new JsonSerializerSettings();
                settings.NullValueHandling = NullValueHandling.Ignore;

                TeamRanks teamRanks = JsonConvert.DeserializeObject<TeamRanks>(result, settings);
                var sortRanks = teamRanks.teamstats.OrderByDescending(a => a.score).ToList();
                teamRanks.teamstats = sortRanks;

                Console.WriteLine("球队积分排行数据============>:" + TeamScoreDataPath);

                return teamRanks;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }
        }


       
        /// <summary>
        /// 获取赛季数据接口
        /// </summary>
        /// <returns></returns>
        public static Seasons Post_MatchSeasonData_Path(string selectFootballType)
        {
            try
            {
                string MatchDataPath = strUrl + "matchSeason";
                Dictionary<string, string> dict = new Dictionary<string, string>();

                dict.Add("competitionId", selectFootballType);

                string newKey = Utils.GetKey(appID, appKey);
                string result = JsonHelper.Post(MatchDataPath, dict, newKey);

                Log.Info("足球赛季数据==>" + result);
                JsonSerializerSettings settings = new JsonSerializerSettings();
                settings.NullValueHandling = NullValueHandling.Ignore;

                Seasons seasons = JsonConvert.DeserializeObject<Seasons>(result, settings);
                var sortSeason = seasons.matchseason.OrderByDescending(a => a.seasonName).ToList();
                seasons.matchseason = sortSeason;
                Console.WriteLine("足球赛季数据=========>" + MatchDataPath);
                return seasons;
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }

        }


        /// <summary>
        /// 获取球队射手榜数据
        /// </summary>
        /// <param name="footballType"></param>
        /// <param name="seasonId"></param>
        /// <returns></returns>
        public static ShootPlayerRanks Post_ShootPlayerRankData(string footballType, string seasonId)
        {
            try
            {
                string shootPath = strUrl + "player/getplayerstats";

                Dictionary<string, string> dict = new Dictionary<string, string>();

                dict.Add("competitionId", footballType);
                dict.Add("seasonId", seasonId);//"110000005454"

                string newKey = Utils.GetKey(appID, appKey);

                Log.Info("访问接口开始时间");
                string result = JsonHelper.Post(shootPath, dict, newKey);

                Log.Info("足球球员射手排行==>"+result);

                JsonSerializerSettings settings = new JsonSerializerSettings();

                settings.NullValueHandling = NullValueHandling.Ignore;

                Log.Info("序列化json开始时间");
                ShootPlayerRanks shootPlayerRanks = JsonConvert.DeserializeObject<ShootPlayerRanks>(result, settings);

                Log.Info("序列化结束时间");

                var sortPlayerShoot = shootPlayerRanks.playerstats.Take(5).ToList();

                shootPlayerRanks.playerstats = sortPlayerShoot;

                return shootPlayerRanks;
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }

        }


    }
}
