﻿using log4net;
using System;
using System.Collections.ObjectModel;
using VIZ.Framework.Core;

namespace VIZ.TVP.FTB.Module
{
    /// <summary>
    /// 足球积分排名ViewModel
    /// </summary>
    public class FTeamStandingViewModel : ViewModelBase
    {

        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(FTeamStandingViewModel));

        /// <summary>
        /// 
        /// </summary>
        public static FTeamStandingViewModel FTeamStandingViewModelInstance = new FTeamStandingViewModel();
        public FTeamStandingViewModel()
        {
            //初始化方法
            Init();
        }

        /// <summary>
        /// 球队绑定数据集合
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModel;
        public ObservableCollection<Teamrank> TeamRanksModel
        {
            get { return teamRanksModel; }

            set { teamRanksModel = value; this.RaisePropertyChanged(nameof(TeamRanksModel)); }
        }

        public VCommand BtnCmd { get; set; }


        TeamRanks teamStands = null;


        /// <summary>
        /// 刷新球队积分排名
        /// </summary>
        private void BtmCommand()
        {
            teamStands = new TeamRanks();

            if (FoolballType == "英超")
            {
                
                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.EPCSeasonId;

            }
            else if (FoolballType == "法甲")
            {
              
                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.FL1SeasonId;
            }
            else if (FoolballType == "意甲")
            {
                
                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.ISASeasonId;
            }
            else if (FoolballType == "德甲")
            {
                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.LIGASeasonId;
            }
            else if (FoolballType == "西甲")
            {
               
                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.SLPSeasonId;
            }

            teamStands = JsonModel.PostTeamScoreData_Path(FoolballType, SeasonId);
            if (teamStands == null) return;
            TeamRanksModel = new ObservableCollection<Teamrank>();
            int i = 1;
            foreach (var teamRank in teamStands.teamstats)
            {
                teamRank.rank = i.ToString();

                teamRank.goalAndLoseNums = String.Format("{0}/{1}", teamRank.goalsNum,teamRank.loseGoalsNum);
                teamRank.teamLogo = teamRank.teamName;

                TeamRanksModel.Add(teamRank);
                i++;
            }
        }

        /// <summary>
        /// 组装积分排名数据上传
        /// </summary>
        /// <returns></returns>
        public string CombineTeamStandingData()
        {
            try
            {


                string data = "";

                data += title;

                data += "&";

                int i = 0;

                foreach (var tempTeamRankModel in TeamRanksModel)
                {
                    i++;
                    data += tempTeamRankModel.rank.ToString().Replace(" ", "");

                    data += "*";
                    data += tempTeamRankModel.teamLogo.Replace(" ", "");

                    data += "*";
                    data += tempTeamRankModel.teamName.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.matchNum.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.winNum.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.drawNum.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.loseNum.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.goalAndLoseNums.Replace(" ", "");
   

                    data += "*";
                    data += tempTeamRankModel.score.Replace(" ", "");
                    data += ";";

                    if (i==10)
                    {
                        data += "#";
                    }
                }

                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }


        private string title = "22/23赛季意大利足球超级联赛积分榜";

        public string Title
        {
            get { return title; }
            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }



        /// <summary>
        /// 足球赛事类型
        /// </summary>
        public string FoolballType = "";

        /// <summary>
        /// 赛季ID
        /// </summary>
        public string SeasonId = "";


        /// <summary>
        /// 初始话
        /// </summary>
        private void Init()
        {
            BtnCmd = new VCommand(BtmCommand);

            PromptCommand = new VCommand(PromptCmd);

            FoolballType = DateHeaderViewModel.FoolballType;
            SeasonId = DateHeaderViewModel.SeasonId;
        }

        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {

            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
            if (teamStands != null)
            {
                string LastDate = $"足球积分接口更新时间：{teamStands.LastPushDataDateTime}";
                vm.OnErrorLogMessage(LastDate);
            }


            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;
        }

        #endregion


    }
}
