﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.FTB.Module
{

    /// <summary>
    /// 足球查看界面配置
    /// </summary>
    public class DateHeaderViewModel : ViewModelBase
    {

        public DateHeaderViewModel()
        {
            FootballTypes = new ObservableCollection<string>()
            {
               "英超","法甲","意甲","德甲","西甲"
            };
            SelectFootballType = "英超";
        }

        private static AppSetup_InitLiteDB appSetup_InitCBALiteDB = AppSetup_InitLiteDB.CreateInstance;

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        /// <summary>
        /// 主数据库连接
        /// </summary>
        private bool mainDataConnection = true;
        public bool MainDataConnection
        {
            get { return mainDataConnection; }
            set
            {
                this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看主数据连接");

                mainDataConnection = value;
                this.RaisePropertyChanged(nameof(MainDataConnection));

                if (mainDataConnection)
                {
                    JsonModel.strUrl = AppSetup_InitLiteDB.HttpUrlConfigEntity.Url;
                    JsonModel.appKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppKey;
                    JsonModel.appID = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppId;
                }
            }
        }


        /// <summary>
        /// 备份数据连接
        /// </summary>
        private bool backDataConnection;

        public bool BackDataConnection
        {
            get { return backDataConnection; }
            set
            {
                this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看备数据连接");
                backDataConnection = value;
                this.RaisePropertyChanged(nameof(BackDataConnection));
                if (backDataConnection)
                {
                    JsonModel.strUrl = AppSetup_InitLiteDB.HttpUrlConfigEntity.BUrl;
                    JsonModel.appKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.BAppKey;
                    JsonModel.appID = AppSetup_InitLiteDB.HttpUrlConfigEntity.BAppId;
                }
            }
        }




        /// <summary>
        /// 足球赛事类型
        /// </summary>
        public static string FoolballType= "";

        /// <summary>
        /// 赛季ID
        /// </summary>
        public static string SeasonId ="";


        /// <summary>
        /// 足球类型选择
        /// </summary>
        private ObservableCollection<string> footballTypes;

        public ObservableCollection<string> FootballTypes
        {
            get { return footballTypes; }
            set { footballTypes = value; this.RaisePropertyChanged(nameof(FootballTypes)); }
        }


        /// <summary>
        ///  选择的足球比赛
        /// </summary>
        private string selectFootballType;

        public string SelectFootballType
        {
            get { return selectFootballType; }
            set
            {
                selectFootballType = value;
                this.RaisePropertyChanged(nameof(SelectFootballType));

                this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看选择比赛类型:"+selectFootballType);

                FDayMatchViewModel.FDayMatchViewModelInstance.FoolballType = selectFootballType;
                FTeamStandingViewModel.FTeamStandingViewModelInstance.FoolballType = selectFootballType;
                ShootPlayerRankViewModel.ShootPlayerRanklInstance.FoolballType = selectFootballType;
                FoolballType = selectFootballType;

            }
        }


    }
}
