﻿using DevExpress.Mvvm.POCO;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Module;

namespace VIZ.TVP.FTB.Module
{
    public class HttpUrlConfigViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(MediaSettingViewModel));


        private static AppSetup_InitLiteDB appSetup_InitCBALiteDB = AppSetup_InitLiteDB.CreateInstance;



        /// <summary>
        /// 媒资库配置设置视图模型
        /// </summary>
        public HttpUrlConfigViewModel()
        {
            // 初始化命令
            this.InitCommand();

            // HttpUrlConfigEntity config = AppSetup_InitCBALiteDB.HttpUrlConfigEntity;

            //FootballTypes = new ObservableCollection<string>()
            //{
            //    "英超","法甲","意甲","德甲","西甲" 
            //};
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);

        }


        // =========================================================================
        // Property
        // =========================================================================

        #region 主数据来源

        #region Url -- 地址

        private string url;
        /// <summary>
        /// 地址
        /// </summary>
        public string Url
        {
            get { return url; }
            set { url = value; this.RaisePropertyChanged(nameof(Url)); }
        }

        #endregion


        #region 应用Id
        /// <summary>
        /// 艾果平台应用Id
        /// </summary>
        private string appId;

        public string AppId
        {
            get { return appId; }
            set { appId = value; this.RaisePropertyChanged(nameof(AppId)); }
        }

        #endregion


        #region 平台Key
        /// <summary>
        /// 艾果应用平台Key
        /// </summary>
        private string appKey;

        public string AppKey
        {
            get { return appKey; }
            set { appKey = value; this.RaisePropertyChanged(nameof(AppKey)); }
        }

        #endregion

        #endregion


        #region 备份数据来源

        #region Url -- 地址

        private string burl;
        /// <summary>
        /// 地址
        /// </summary>
        public string BUrl
        {
            get { return burl; }
            set { burl = value; this.RaisePropertyChanged(nameof(BUrl)); }
        }

        #endregion


        #region 应用Id
        /// <summary>
        /// 艾果平台应用Id
        /// </summary>
        private string bappId;

        public string BAppId
        {
            get { return bappId; }
            set { bappId = value; this.RaisePropertyChanged(nameof(BAppId)); }
        }

        #endregion


        #region 平台Key
        /// <summary>
        /// 艾果应用平台Key
        /// </summary>
        private string bappKey;

        public string BAppKey
        {
            get { return bappKey; }
            set { bappKey = value; this.RaisePropertyChanged(nameof(BAppKey)); }
        }

        #endregion


        #region 

        /// <summary>
        /// 足球类型选择
        /// </summary>
        //private ObservableCollection<string> footballTypes;


        //public ObservableCollection<string> FootballTypes
        //{
        //    get { return footballTypes; }
        //    set { footballTypes = value; this.RaisePropertyChanged(nameof(FootballTypes)); }
        //}


        ///// <summary>
        /////  选择的足球比赛
        ///// </summary>
        //private string selectFootballType="德甲";

        //public string SelectFootballType
        //{
        //    get { return selectFootballType; }
        //    set 
        //    {
        //        selectFootballType = value; 
        //        this.RaisePropertyChanged(nameof(SelectFootballType));
        //        SetSeasonDict();

        //        if (selectSeason == null) return;
        //        if (SeasonDict.ContainsKey(selectSeason))
        //        {
        //            SeasonId = SeasonDict[selectSeason];
        //        }
        //    }
        //}



        /// <summary>
        /// 英超赛季绑定集合
        /// </summary>

        public Dictionary<string, string> EPCSeasonDict = new Dictionary<string, string>();

        private ObservableCollection<string> EPCseasons;


        public ObservableCollection<string> EPCSeasons
        {
            get { return EPCseasons; }
            set { EPCseasons = value;this.RaisePropertyChanged(nameof(EPCSeasons)); }
        }


        private string ePCselectSeason;

        /// <summary>
        /// 英超选中的赛季
        /// </summary>
        public string EPCSelectSeason
        {
            get { return ePCselectSeason; }
            set 
            {
                ePCselectSeason = value;
                this.RaisePropertyChanged(nameof(EPCSelectSeason));

                if (ePCselectSeason == null) return;
                if(EPCSeasonDict.ContainsKey(ePCselectSeason))
                {
                    EPCSeasonId = EPCSeasonDict[ePCselectSeason];
                }

            }
        }



        /// <summary>
        /// 法甲赛季绑定集合
        /// </summary>

        public Dictionary<string, string> FL1SeasonDict = new Dictionary<string, string>();

        private ObservableCollection<string> FL1seasons;


        public ObservableCollection<string> FL1Seasons
        {
            get { return FL1seasons; }
            set { FL1seasons = value; this.RaisePropertyChanged(nameof(FL1Seasons)); }
        }


        private string fL1selectSeason;

        /// <summary>
        /// 法甲选中的赛季
        /// </summary>
        public string FL1SelectSeason
        {
            get { return fL1selectSeason; }
            set
            {
                fL1selectSeason = value;
                this.RaisePropertyChanged(nameof(FL1SelectSeason));

                if (fL1selectSeason == null) return;
                if (FL1SeasonDict.ContainsKey(fL1selectSeason))
                {
                    FL1SeasonId = FL1SeasonDict[fL1selectSeason];
                }

            }
        }




        /// <summary>
        /// 意甲赛季绑定集合
        /// </summary>

        public Dictionary<string, string> ISASeasonDict = new Dictionary<string, string>();

        private ObservableCollection<string> ISAseasons;


        public ObservableCollection<string> ISASeasons
        {
            get { return ISAseasons; }
            set { ISAseasons = value; this.RaisePropertyChanged(nameof(ISASeasons)); }
        }


        private string iSAselectSeason;

        /// <summary>
        /// 意甲选中的赛季
        /// </summary>
        public string ISASelectSeason
        {
            get { return iSAselectSeason; }
            set
            {
                iSAselectSeason = value;
                this.RaisePropertyChanged(nameof(ISASelectSeason));

                if (iSAselectSeason == null) return;
                if (ISASeasonDict.ContainsKey(iSAselectSeason))
                {
                    ISASeasonId = ISASeasonDict[iSAselectSeason];
                }

            }
        }


        /// <summary>
        /// 德甲赛季绑定集合
        /// </summary>

        public Dictionary<string, string> LIGASeasonDict = new Dictionary<string, string>();

        private ObservableCollection<string> LIGAseasons;


        public ObservableCollection<string> LIGASeasons
        {
            get { return LIGAseasons; }
            set { LIGAseasons = value; this.RaisePropertyChanged(nameof(LIGASeasons)); }
        }


        private string lIGAselectSeason;

        /// <summary>
        /// 德甲选中的赛季
        /// </summary>
        public string LIGASelectSeason
        {
            get { return lIGAselectSeason; }
            set
            {
                lIGAselectSeason = value;
                this.RaisePropertyChanged(nameof(LIGASelectSeason));

                if (lIGAselectSeason == null) return;
                if (LIGASeasonDict.ContainsKey(lIGAselectSeason))
                {
                    LIGASeasonId = LIGASeasonDict[lIGAselectSeason];
                }

            }
        }



        /// <summary>
        /// 西甲赛季绑定集合
        /// </summary>

        public Dictionary<string, string> SLPSeasonDict = new Dictionary<string, string>();

        private ObservableCollection<string> SLPseasons;


        public ObservableCollection<string> SLPSeasons
        {
            get { return SLPseasons; }
            set { SLPseasons = value; this.RaisePropertyChanged(nameof(SLPSeasons)); }
        }


        private string sLPselectSeason;

        /// <summary>
        /// 西甲选中的赛季
        /// </summary>
        public string SLPSelectSeason
        {
            get { return sLPselectSeason; }
            set
            {
                sLPselectSeason = value;
                this.RaisePropertyChanged(nameof(SLPSelectSeason));

                if (sLPselectSeason == null) return;
                if (SLPSeasonDict.ContainsKey(sLPselectSeason))
                {
                    SLPSeasonId = SLPSeasonDict[sLPselectSeason];
                }

            }
        }





        /// <summary>
        /// 英超赛季Id
        /// </summary>
        public string EPCSeasonId
        {
            get; set;
        }




        /// <summary>
        /// 法甲赛季Id
        /// </summary>
        public string FL1SeasonId
        {
            get;set;
        }



        /// <summary>
        /// 意甲赛季Id
        /// </summary>
        public string ISASeasonId
        {
            get; set;
        }


        /// <summary>
        /// 德甲赛季Id
        /// </summary>
        public string LIGASeasonId
        {
            get; set;
        }


        /// <summary>
        /// 西甲赛季Id
        /// </summary>
        public string SLPSeasonId
        {
            get; set;
        }




        #endregion



        #endregion

        // =========================================================================
        // Command
        // =========================================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }




        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            this.Url = AppSetup_InitLiteDB.HttpUrlConfigEntity.Url;

            this.AppId = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppId;

            this.AppKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppKey;

            this.BUrl = AppSetup_InitLiteDB.HttpUrlConfigEntity.BUrl;

            this.BAppId = AppSetup_InitLiteDB.HttpUrlConfigEntity.BAppId;

            this.BAppKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.BAppKey;

           // this.SelectFootballType = AppSetup_InitLiteDB.HttpUrlConfigEntity.SelectFootballType;

           // this.SelectSeason = AppSetup_InitLiteDB.HttpUrlConfigEntity.SelectSeason;

            //英超
            this.EPCSeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.EPCSeasonId;

            //法甲
            this.FL1SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.FL1SeasonId;

            //意甲
            this.ISASeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.ISASeasonId;

            //德甲
            this.LIGASeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.LIGASeasonId;

            //西甲
            this.SLPSeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.SLPSeasonId;

            //选择的英超赛季
            this.EPCSelectSeason = AppSetup_InitLiteDB.HttpUrlConfigEntity.SelectEPCSeasonId;

            //选择的法甲赛季
            this.FL1SelectSeason = AppSetup_InitLiteDB.HttpUrlConfigEntity.SelectFL1SeasonId;

            //选择的意甲赛季

            this.ISASelectSeason= AppSetup_InitLiteDB.HttpUrlConfigEntity.SelectISASeasonId;

            //选择的德甲赛季

            this.LIGASelectSeason = AppSetup_InitLiteDB.HttpUrlConfigEntity.SelectLIGASeasonId;

            //选择的西甲赛季

            this.SLPSelectSeason = AppSetup_InitLiteDB.HttpUrlConfigEntity.SelectSLPSeasonId;


            SetSeasonDict();

        }

        #endregion

        // =========================================================================
        // Public Function
        // =========================================================================

        /// <summary>
        /// 保存
        /// </summary>
        public void Save()
        {
            HttpUrlConfigEntity config = AppSetup_InitLiteDB.HttpUrlConfigEntity;
            config.Url = this.Url;
            config.AppId = this.AppId;
            config.AppKey = this.AppKey;

            config.BUrl = this.BUrl;
            config.BAppId = this.BAppId;
            config.BAppKey = this.BAppKey;
            //config.SelectFootballType = this.SelectFootballType;

            // 选择赛事和赛事Id
            //config.SelectSeason = this.SelectSeason;
            config.EPCSeasonId = this.EPCSeasonId;
            config.FL1SeasonId = this.FL1SeasonId;
            config.ISASeasonId = this.ISASeasonId;
            config.LIGASeasonId = this.LIGASeasonId;
            config.SLPSeasonId = this.SLPSeasonId;

          
            //选择的英超赛季
            config.SelectEPCSeasonId = this.EPCSelectSeason;

            //选择的法甲赛季
            config.SelectFL1SeasonId = this.FL1SelectSeason;

            //选择的意甲赛季

            config.SelectISASeasonId = this.ISASelectSeason ;

            //选择的德甲赛季

            config.SelectLIGASeasonId = this.LIGASelectSeason;

            //选择的西甲赛季

            config.SelectSLPSeasonId = this.SLPSelectSeason;


            AppSetup_InitLiteDB.localDbContext.HttpUrlConfig.Upsert(config);
        }




        /// <summary>
        /// 赛季数据
        /// </summary>
       // public Seasons dictSeasons = null;

        /// <summary>
        /// 设置赛季接口
        /// </summary>
        private void SetSeasonDict()
        {

            try
            {
                var EPCDictSeasons = JsonModel.Post_MatchSeasonData_Path("英超");

                if(EPCDictSeasons!=null)
                {
                    foreach (var dict in EPCDictSeasons.matchseason)
                    {
                        string seasonNameKey = $"{dict.seasonName}_{dict.seasonId}";
                        if (!EPCSeasonDict.ContainsKey(seasonNameKey))
                        {
                            EPCSeasonDict.Add(seasonNameKey, dict.seasonId);
                        }
                    }

                    EPCSeasons = new ObservableCollection<string>();

                    EPCSeasons = EPCSeasonDict.Keys.ToObservableCollection();

                }




                var FL1DictSeasons = JsonModel.Post_MatchSeasonData_Path("法甲");

                if(FL1DictSeasons!=null)
                {

                    foreach (var dict in FL1DictSeasons.matchseason)
                    {
                        string seasonNameKey = $"{dict.seasonName}_{dict.seasonId}";
                        if (!FL1SeasonDict.ContainsKey(seasonNameKey))
                        {
                            FL1SeasonDict.Add(seasonNameKey, dict.seasonId);
                        }
                    }

                    FL1Seasons = new ObservableCollection<string>();

                    FL1Seasons = FL1SeasonDict.Keys.ToObservableCollection();
                }



                var ISADictSeasons = JsonModel.Post_MatchSeasonData_Path("意甲");

                if(ISADictSeasons!=null)
                {
                    foreach (var dict in ISADictSeasons.matchseason)
                    {
                        string seasonNameKey = $"{dict.seasonName}_{dict.seasonId}";
                        if (!ISASeasonDict.ContainsKey(seasonNameKey))
                        {
                            ISASeasonDict.Add(seasonNameKey, dict.seasonId);
                        }
                    }

                    ISASeasons = new ObservableCollection<string>();

                    ISASeasons = ISASeasonDict.Keys.ToObservableCollection();

                }



                var LIGADictSeasons = JsonModel.Post_MatchSeasonData_Path("德甲");

                if(LIGADictSeasons!=null)
                {
                    foreach (var dict in LIGADictSeasons.matchseason)
                    {
                        string seasonNameKey = $"{dict.seasonName}_{dict.seasonId}";
                        if (!LIGASeasonDict.ContainsKey(seasonNameKey))
                        {
                            LIGASeasonDict.Add(seasonNameKey, dict.seasonId);
                        }
                    }

                    LIGASeasons = new ObservableCollection<string>();
                    LIGASeasons = LIGASeasonDict.Keys.ToObservableCollection();
                }


                var SLPDictSeasons = JsonModel.Post_MatchSeasonData_Path("西甲");

                if(SLPDictSeasons!=null)
                {
                    foreach (var dict in SLPDictSeasons.matchseason)
                    {
                        string seasonNameKey = $"{dict.seasonName}_{dict.seasonId}";
                        if (!SLPSeasonDict.ContainsKey(seasonNameKey))
                        {
                            SLPSeasonDict.Add(seasonNameKey, dict.seasonId);
                        }
                    }

                    SLPSeasons = new ObservableCollection<string>();
                    SLPSeasons = SLPSeasonDict.Keys.ToObservableCollection();
                }

            }
            catch(Exception ex)
            {
                log.Error(ex.Message);
            }

        }


    }
}
