﻿using DevExpress.Mvvm.POCO;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.TVP.FTB.Module
{
    public class ShootPlayerRankViewModel: ViewModelBase
    {

        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(ShootPlayerRankViewModel));

        /// <summary>
        /// 
        /// </summary>
        public static ShootPlayerRankViewModel ShootPlayerRanklInstance = new ShootPlayerRankViewModel();


        /// <summary>
        /// 初始话
        /// </summary>
        public ShootPlayerRankViewModel()
        {
            Init();
        }


        /// <summary>
        /// 球员射手榜绑定数据集合
        /// </summary>
        private ObservableCollection<ShootPlayerRank> shootPlayerModel;
        public ObservableCollection<ShootPlayerRank> ShootPlayerModel
        {
            get { return shootPlayerModel; }

            set { shootPlayerModel = value; this.RaisePropertyChanged(nameof(ShootPlayerModel)); }
        }

        public VCommand BtnCmd { get; set; }


        ShootPlayerRanks shootPlayerRanks = null;


        /// <summary>
        /// 刷新球队积分排名
        /// </summary>
        private void BtmCommand()
        {
            shootPlayerRanks = new ShootPlayerRanks();

            if (FoolballType == "英超")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.EPCSeasonId;

            }
            else if (FoolballType == "法甲")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.FL1SeasonId;
            }
            else if (FoolballType == "意甲")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.ISASeasonId;
            }
            else if (FoolballType == "德甲")
            {
                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.LIGASeasonId;
            }
            else if (FoolballType == "西甲")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.SLPSeasonId;
            }

            shootPlayerRanks = JsonModel.Post_ShootPlayerRankData(FoolballType, SeasonId);
            if (shootPlayerRanks == null) return;
            ShootPlayerModel = new ObservableCollection<ShootPlayerRank>();
        
            foreach (var playerRank in shootPlayerRanks.playerstats)
            {
                playerRank.playerLogo = playerRank.figureName;
                playerRank.teamLogo = playerRank.teamName;
                ShootPlayerModel.Add(playerRank);
               
            }
        }

        /// <summary>
        /// 组装积分排名数据上传
        /// </summary>
        /// <returns></returns>
        public string CombineData()
        {
            try
            {


                string data = "";

                data += title;

                data += "&";

        

                foreach (var tempTeamRankModel in ShootPlayerModel)
                {
      
                    data += tempTeamRankModel.rank.ToString().Replace(" ", "");

                    data += "*";
                    data += tempTeamRankModel.playerLogo.Replace(" ","");

                    data += "*";
                    data += tempTeamRankModel.teamLogo.Replace(" ", "");

                    data += "*";
                    data += tempTeamRankModel.figureName.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.goals.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.PenaltyGoal.ToString().Replace(" ", "");

         
                    data += ";";

     
                }

                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }


        private string title = "22/23赛季意大利足球超级联赛射手榜";

        public string Title
        {
            get { return title; }
            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }



        /// <summary>
        /// 足球赛事类型
        /// </summary>
        public string FoolballType = "";

        /// <summary>
        /// 赛季ID
        /// </summary>
        public string SeasonId = "";


        /// <summary>
        /// 初始话
        /// </summary>
        private void Init()
        {
            BtnCmd = new VCommand(BtmCommand);

            PromptCommand = new VCommand(PromptCmd);

            FoolballType = DateHeaderViewModel.FoolballType;
            SeasonId = DateHeaderViewModel.SeasonId;
        }

        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {

            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
            if (shootPlayerRanks != null)
            {
                string LastDate = $"射手榜积分接口更新时间：{shootPlayerRanks.LastPushDataDateTime}";
                vm.OnErrorLogMessage(LastDate);
            }


            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;
        }

        #endregion
    }
}
