﻿using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media.Imaging;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;
using VIZ.Package.Storage;
using System.Windows.Media;
using System.IO;

namespace VIZ.TVP.CBA.Module
{
    public class PlayerComPareViewModelTask : ViewModelBase
    {

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();
        public PlayerComPareViewModelTask()
        {
            BtnCommand = new VCommand(BtnCmd);

            matchStatsIds = new ObservableCollection<int>()
            {
                5,
                6,
                7
            };

            ScheduleID = DateHeaderViewModel.ScheduleID;
            Matchtypeid = DateHeaderViewModel.Matchtypeid;

            this.PromptCommand = new VCommand(PromptCmd);
            SetCompareData();

        }

        private static ILog Log = LogManager.GetLogger(typeof(PlayerComPareViewModelTask));

        public static List<PlayerComPareViewModelTask> PlayerCompareViewModelTaskInstance = new List<PlayerComPareViewModelTask>();

        /// <summary>
        /// 主队球员的名字和球衣号码
        /// </summary>
        public Dictionary<string, string> HNameNums = new Dictionary<string, string>();

        /// <summary>
        /// 客队球员的名字和球衣号码
        /// </summary>
        public Dictionary<string, string> VNameNums = new Dictionary<string, string>();


        /// <summary>
        /// 主队球员技术统计数据
        /// </summary>
        public Dictionary<string, Dictionary<string, string>> MvpHomePlayerCompareNumDictionary
      = new Dictionary<string, Dictionary<string, string>>();

        /// <summary>
        /// 客队球员技术统计数据
        /// </summary>
        public Dictionary<string, Dictionary<string, string>> MvpVisitPlayerCompareNumDictionary
              = new Dictionary<string, Dictionary<string, string>>();

        /// <summary>
        /// 设置球员信息
        /// </summary>
        /// <param name="flag"></param>
        public void SetPlayer(bool flag = true)
        {
            MvpHomePlayerCompareNumDictionary.Clear();
            MvpVisitPlayerCompareNumDictionary.Clear();

            HNameNums.Clear();
            VNameNums.Clear();



            if (flag)
            {
                HPlayers = new ObservableCollection<string>();
                APlayers = new ObservableCollection<string>();
            }
            foreach (var teamLive in onAirDataModel.livePlayerStatH)
            {
                if (flag)
                {
                    HPlayers.Add(teamLive.CNAlias);
                }
                if (!HNameNums.ContainsKey(teamLive.CNAlias))
                {
                    HNameNums.Add(teamLive.CNAlias, teamLive.Number);
                }

                Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                CompareItemToNumber.Add("得分", teamLive.Points);
                CompareItemToNumber.Add("篮板", teamLive.Rebounds);
                CompareItemToNumber.Add("助攻", teamLive.Assists);
                CompareItemToNumber.Add("抢断", teamLive.Steals);
                CompareItemToNumber.Add("盖帽", teamLive.Blocked);
                CompareItemToNumber.Add("上场时间", teamLive.Minutes);
                CompareItemToNumber.Add("投篮命中率", (teamLive.FieldGoalsPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("两分命中率", (teamLive.TwoPointPercentage).ToString("F1") + "%");

                CompareItemToNumber.Add("三分命中率", (teamLive.ThreePointPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("罚球命中率", (teamLive.FreeThrowsPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("篮下投篮命中率", (teamLive.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("中距离投篮命中率", (teamLive.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("三分", teamLive.ThreePointGoals + "/"
                            + teamLive.ThreePointAttempted);


                CompareItemToNumber.Add("两分", teamLive.TwoPointGoals + "/"
                            + teamLive.TwoPointAttempted);


                CompareItemToNumber.Add("两分区", teamLive.TwoPointGoals + "/"
                            + teamLive.TwoPointAttempted);
                CompareItemToNumber.Add("三分区", teamLive.ThreePointGoals + "/"
             + teamLive.ThreePointAttempted);

                //这个字段咪咕项目暂时没有
                CompareItemToNumber.Add("三秒区", teamLive.FieldGoalsAtRimMade + "/"
             + teamLive.FieldGoalsAtRimAttempted);
                //CompareItemToNumber.Add("ThreeArea",);

                CompareItemToNumber.Add("罚球", teamLive.FreeThrows + "/"
                            + teamLive.FreeThrowsAttempted);
                CompareItemToNumber.Add("失误", teamLive.Turnovers);
                if (!MvpHomePlayerCompareNumDictionary.ContainsKey(teamLive.CNAlias))
                {
                    MvpHomePlayerCompareNumDictionary.Add(teamLive.CNAlias, CompareItemToNumber);
                }

            }


            foreach (var teamLive in onAirDataModel.livePlayerStatV)
            {

                if (flag)
                {
                    APlayers.Add(teamLive.CNAlias.ToString());
                }

                if (!VNameNums.ContainsKey(teamLive.CNAlias))
                {
                    VNameNums.Add(teamLive.CNAlias, teamLive.Number);
                }



                Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                CompareItemToNumber.Add("得分", teamLive.Points);
                CompareItemToNumber.Add("篮板", teamLive.Rebounds);
                CompareItemToNumber.Add("助攻", teamLive.Assists);
                CompareItemToNumber.Add("抢断", teamLive.Steals);
                CompareItemToNumber.Add("盖帽", teamLive.Blocked);
                CompareItemToNumber.Add("上场时间", teamLive.Minutes);
                CompareItemToNumber.Add("投篮命中率", (teamLive.FieldGoalsPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("两分命中率", (teamLive.TwoPointPercentage).ToString("F1") + "%");

                CompareItemToNumber.Add("三分命中率", (teamLive.ThreePointPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("罚球命中率", (teamLive.FreeThrowsPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("篮下投篮命中率", (teamLive.FieldGoalsAtRimPercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("中距离投篮命中率", (teamLive.FieldGoalsMidRangePercentage * 100).ToString("F1") + "%");
                CompareItemToNumber.Add("三分", teamLive.ThreePointGoals + "/"
                            + teamLive.ThreePointAttempted);


                CompareItemToNumber.Add("两分", teamLive.TwoPointGoals + "/"
                            + teamLive.TwoPointAttempted);


                CompareItemToNumber.Add("两分区", teamLive.TwoPointGoals + "/"
                            + teamLive.TwoPointAttempted);
                CompareItemToNumber.Add("三分区", teamLive.ThreePointGoals + "/"

             + teamLive.ThreePointAttempted);
                //CompareItemToNumber.Add("ThreeArea",);

                //这个字段咪咕项目暂时没有
                CompareItemToNumber.Add("三秒区", teamLive.FieldGoalsAtRimMade + "/"
             + teamLive.FieldGoalsAtRimAttempted);

                CompareItemToNumber.Add("罚球", teamLive.FreeThrows + "/"
                            + teamLive.FreeThrowsAttempted);
                CompareItemToNumber.Add("失误", teamLive.Turnovers);

                if (!MvpVisitPlayerCompareNumDictionary.ContainsKey(teamLive.CNAlias))
                {
                    MvpVisitPlayerCompareNumDictionary.Add(teamLive.CNAlias, CompareItemToNumber);
                }



            }




        }

        /// <summary>
        /// 技术统计
        /// </summary>
        private int matchStatsId = 7;

        /// <summary>
        /// 技术统计Id
        /// </summary>
        public int MatchStatsId
        {
            get { return matchStatsId; }

            set
            {
                matchStatsId = value;
                this.RaisePropertyChanged(nameof(MatchStatsId));

                if (matchStatsId == 5)
                {

                    IsCheckVisible5 = Visibility.Hidden;
                    HScoreVisible5 = Visibility.Hidden;
                    HSeasonScoreVisible5 = Visibility.Hidden;
                    TechStatsVisible5 = Visibility.Hidden;
                    AScoreVisible5 = Visibility.Hidden;
                    ASeasonScoreVisible5 = Visibility.Hidden;

                    IsCheckVisible6 = Visibility.Hidden;
                    HScoreVisible6 = Visibility.Hidden;
                    HSeasonScoreVisible6 = Visibility.Hidden;
                    TechStatsVisible6 = Visibility.Hidden;
                    AScoreVisible6 = Visibility.Hidden;
                    ASeasonScoreVisible6 = Visibility.Hidden;
                }
                else if (matchStatsId == 6)
                {
                    IsCheckVisible5 = Visibility.Visible;
                    HScoreVisible5 = Visibility.Visible;
                    HSeasonScoreVisible5 = Visibility.Visible;
                    TechStatsVisible5 = Visibility.Visible;
                    AScoreVisible5 = Visibility.Visible;
                    ASeasonScoreVisible5 = Visibility.Visible;

                    IsCheckVisible6 = Visibility.Hidden;
                    HScoreVisible6 = Visibility.Hidden;
                    HSeasonScoreVisible6 = Visibility.Hidden;
                    TechStatsVisible6 = Visibility.Hidden;
                    AScoreVisible6 = Visibility.Hidden;
                    ASeasonScoreVisible6 = Visibility.Hidden;

                }
                else if (matchStatsId == 7)
                {
                    IsCheckVisible5 = Visibility.Visible;
                    HScoreVisible5 = Visibility.Visible;
                    HSeasonScoreVisible5 = Visibility.Visible;
                    TechStatsVisible5 = Visibility.Visible;
                    AScoreVisible5 = Visibility.Visible;
                    ASeasonScoreVisible5 = Visibility.Visible;

                    IsCheckVisible6 = Visibility.Visible;
                    HScoreVisible6 = Visibility.Visible;
                    HSeasonScoreVisible6 = Visibility.Visible;
                    TechStatsVisible6 = Visibility.Visible;
                    AScoreVisible6 = Visibility.Visible;
                    ASeasonScoreVisible6 = Visibility.Visible;
                }

                SetHData(0);
                SetAData(0);
            }
        }







        private ObservableCollection<int> matchStatsIds;

        public ObservableCollection<int> MatchStatsIds
        {
            get { return matchStatsIds; }

            set { matchStatsIds = value; this.RaisePropertyChanged(nameof(MatchStatsIds)); }
        }


        private ObservableCollection<string> hPlayers;

        /// <summary>
        /// 主队球员信息
        /// </summary>
        public ObservableCollection<string> HPlayers
        {
            get { return hPlayers; }

            set { hPlayers = value; this.RaisePropertyChanged(nameof(HPlayers)); }
        }

        private ObservableCollection<string> aPlayers;

        /// <summary>
        /// 客队球员信息
        /// </summary>
        public ObservableCollection<string> APlayers
        {
            get { return aPlayers; }
            set { aPlayers = value; this.RaisePropertyChanged(nameof(APlayers)); }
        }


        /// <summary>
        /// 主队球员图片
        /// </summary>
        private ImageSource hPlayerLogo;

        public ImageSource HPlayerLogo
        {
            get { return hPlayerLogo; }
            set { hPlayerLogo = value; this.RaisePropertyChanged(nameof(HPlayerLogo)); }
        }




        // string baesePath = AppDomain.CurrentDomain.BaseDirectory;

        private string aPlayer;

        public string APlayer
        {
            get { return aPlayer; }
            set
            {
                aPlayer = value;
                this.RaisePropertyChanged(nameof(APlayer));

                if (APlayer == null) return;

                //if (AName == "北京控股666")
                //{
                //    if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")))
                //    {
                //        APlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));
                //    }

                //}
                //else
                //{
                //    if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, AName)))
                //    {
                //        APlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, AName)));
                //    }

                //}

                string playPath = string.Format("{0}\\{1}\\{2}.png", AppSetup_InitCBALiteDB.HttpUrlConfigEntity.PlayersLogo, AName, APlayer);
                if (File.Exists(playPath))
                {
                    APlayerLogo = new BitmapImage(new Uri(playPath));
                }
                else
                {
                    APlayerLogo = null;
                }

                if (VNameNums.ContainsKey(APlayer))
                {
                    ANums = VNameNums[APlayer];
                }
                SetAData(0);
            }
        }

        /// <summary>
        /// 客队球员图片
        /// </summary>
        private ImageSource aPlayerLogo;
        public ImageSource APlayerLogo
        {
            get { return aPlayerLogo; }
            set { aPlayerLogo = value; this.RaisePropertyChanged(nameof(APlayerLogo)); }
        }


        private string hPlayer;

        public string HPlayer
        {
            get { return hPlayer; }
            set
            {
                hPlayer = value;
                this.RaisePropertyChanged(nameof(HPlayer));
                if (HPlayer == null) return;
                //if (HName == "北京控股666")
                //{
                //    if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")))
                //    {
                //        HPlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, "北京控股")));
                //    }

                //}
                //else
                //{
                //    if(File.Exists(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, HName)))
                //    {
                //        HPlayerLogo = new BitmapImage(new Uri(string.Format("{0}Image\\Teamlogo\\{1}.png", baesePath, HName)));
                //    }

                //}

                string playPath = string.Format("{0}\\{1}\\{2}.png", AppSetup_InitCBALiteDB.HttpUrlConfigEntity.PlayersLogo, HName, hPlayer);

                if (File.Exists(playPath))
                {
                    HPlayerLogo = new BitmapImage(new Uri(playPath));
                }
                else
                {
                    HPlayerLogo = null;
                }

                if (HNameNums.ContainsKey(HPlayer))
                {
                    HNums = HNameNums[HPlayer];
                }
                SetHData(0);
            }
        }

        private string hName;

        public string HName
        {
            get { return hName; }
            set
            {
                hName = value;
                this.RaisePropertyChanged(nameof(HName));


            }
        }


        private string aName;

        public string AName
        {
            get { return aName; }
            set { aName = value; this.RaisePropertyChanged(nameof(AName)); }
        }


        private string hNums;

        public string HNums
        {
            get { return hNums; }

            set { hNums = value; this.RaisePropertyChanged(nameof(HNums)); }
        }


        private string aNums;

        public string ANums
        {
            get { return aNums; }

            set { aNums = value; this.RaisePropertyChanged(nameof(ANums)); }
        }

        private string title = "球员对比数据";

        public string Title
        {
            get { return title; }

            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }


        private string matchStatus;

        public string MatchStatus
        {
            get { return matchStatus; }

            set
            {
                matchStatus = value;
                this.RaisePropertyChanged(nameof(MatchStatus));
            }
        }

        /// <summary>
        /// 刷新按钮
        /// </summary>
        public VCommand BtnCommand { get; set; }


        //球员赛季数据
        public string Matchtypeid = "";
        //比赛赛程Id
        public string ScheduleID = "";

        /// <summary>
        /// 球员赛季数据
        /// </summary>
        public PlayerSeasonData PlayerSeasonData = new PlayerSeasonData();

        /// <summary>
        /// 队伍赛程信息
        /// </summary>
        public TeamSeasonData TeamSeasonData = new TeamSeasonData();

        public OnAirDataModel onAirDataModel = new OnAirDataModel();

        //向字典中个人选手增加整个赛季的分数值
        public Dictionary<string, Dictionary<string, string>> CNAliasPlayerSportsDictionary
            = new Dictionary<string, Dictionary<string, string>>();


        /// <summary>
        /// 设置一个比赛赛程集合
        /// </summary>
        public Dictionary<string, string> SetMatchDict = new Dictionary<string, string>();

        //初始话页面
        public PageModel page = null;

        /// <summary>
        /// 组装包装发送的球员信息
        /// </summary>
        /// <returns></returns>
        public string CombinePlayerCommand()
        {
            try
            {
                string data = "";



                if (matchStatsId != 0)
                {
                    data += matchStatsId.ToString().Replace(" ", "") + "*";
                }
                else
                {
                    data += "7*";
                }

                data += title.Replace(" ", "") + "*";

                if (!string.IsNullOrEmpty(HName))
                {
                    data += HName.Replace(" ", "") + "*";
                }
                else
                {
                    data += "" + "*";
                }

                if (!string.IsNullOrEmpty(HPlayer))
                {
                    data += HPlayer.Replace(" ", "") + "*";
                }
                else
                {
                    data += "" + "*";
                }

                if (!string.IsNullOrEmpty(AName))
                {
                    data += AName.Replace(" ", "") + "*";
                }
                else
                {
                    data += "" + "*";
                }

                if (!string.IsNullOrEmpty(APlayer))
                {
                    data += APlayer.Replace(" ", "") + "&";
                }
                else
                {
                    data += "" + "&";
                }

                if (MatchStatsId == 7)
                {
                    //第一项数据
                    if (IsHeight == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore))
                    {
                        data += HScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore))
                    {
                        data += HSeasonScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore))
                    {
                        data += AScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore))
                    {
                        data += ASeasonScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第二项数据
                    if (IsHeight1 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore1))
                    {
                        data += HScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore1))
                    {
                        data += HSeasonScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore1))
                    {
                        data += AScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore1))
                    {
                        data += ASeasonScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第三项数据
                    if (IsHeight2 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore2))
                    {
                        data += HScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore2))
                    {
                        data += HSeasonScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore2))
                    {
                        data += AScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore2))
                    {
                        data += ASeasonScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }



                    //第四项数据
                    if (IsHeight3 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore3))
                    {
                        data += HScore3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore3))
                    {
                        data += HSeasonScore3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats3.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore3))
                    {
                        data += AScore3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore3))
                    {
                        data += ASeasonScore3.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第五项数据
                    if (IsHeight4 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore4))
                    {
                        data += HScore4.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore4))
                    {
                        data += HSeasonScore4.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats4.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore4))
                    {
                        data += AScore4.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore4))
                    {
                        data += ASeasonScore4.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }



                    //第六项数据
                    if (IsHeight5 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore5))
                    {
                        data += HScore5.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore5))
                    {
                        data += HSeasonScore5.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats5.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore5))
                    {
                        data += AScore5.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore5))
                    {
                        data += ASeasonScore5.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }



                    //第七项数据
                    if (IsHeight6 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore6))
                    {
                        data += HScore6.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore6))
                    {
                        data += HSeasonScore6.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats6.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore6))
                    {
                        data += AScore6.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore6))
                    {
                        data += ASeasonScore6.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }



                }
                else if (MatchStatsId == 6)
                {
                    //第一项数据
                    if (IsHeight == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore))
                    {
                        data += HScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore))
                    {
                        data += HSeasonScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore))
                    {
                        data += AScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore))
                    {
                        data += ASeasonScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第二项数据
                    if (IsHeight1 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore1))
                    {
                        data += HScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore1))
                    {
                        data += HSeasonScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore1))
                    {
                        data += AScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore1))
                    {
                        data += ASeasonScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第三项数据
                    if (IsHeight2 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore2))
                    {
                        data += HScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore2))
                    {
                        data += HSeasonScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore2))
                    {
                        data += AScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore2))
                    {
                        data += ASeasonScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }



                    //第四项数据
                    if (IsHeight3 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore3))
                    {
                        data += HScore3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore3))
                    {
                        data += HSeasonScore3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats3.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore3))
                    {
                        data += AScore3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore3))
                    {
                        data += ASeasonScore3.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第五项数据
                    if (IsHeight4 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore4))
                    {
                        data += HScore4.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore4))
                    {
                        data += HSeasonScore4.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats4.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore4))
                    {
                        data += AScore4.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore4))
                    {
                        data += ASeasonScore4.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }



                    //第六项数据
                    if (IsHeight5 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore5))
                    {
                        data += HScore5.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore5))
                    {
                        data += HSeasonScore5.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats5.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore5))
                    {
                        data += AScore5.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore5))
                    {
                        data += ASeasonScore5.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }





                }

                else if (MatchStatsId == 5)
                {
                    //第一项数据
                    if (IsHeight == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore))
                    {
                        data += HScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore))
                    {
                        data += HSeasonScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore))
                    {
                        data += AScore.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore))
                    {
                        data += ASeasonScore.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第二项数据
                    if (IsHeight1 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore1))
                    {
                        data += HScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore1))
                    {
                        data += HSeasonScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats1.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore1))
                    {
                        data += AScore1.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore1))
                    {
                        data += ASeasonScore1.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第三项数据
                    if (IsHeight2 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore2))
                    {
                        data += HScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore2))
                    {
                        data += HSeasonScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats2.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore2))
                    {
                        data += AScore2.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore2))
                    {
                        data += ASeasonScore2.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }



                    //第四项数据
                    if (IsHeight3 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore3))
                    {
                        data += HScore3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore3))
                    {
                        data += HSeasonScore3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats3.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore3))
                    {
                        data += AScore3.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore3))
                    {
                        data += ASeasonScore3.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }


                    //第五项数据
                    if (IsHeight4 == false)//tempPlayerComModel.SelectLight == "不高亮"
                    {
                        data += "0" + "*";
                    }
                    else
                    {
                        data += "1" + "*";
                    }

                    if (!string.IsNullOrEmpty(HScore4))
                    {
                        data += HScore4.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }


                    if (!string.IsNullOrEmpty(HSeasonScore4))
                    {
                        data += HSeasonScore4.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    data += SelectTechStats4.Replace(" ", "") + "*";

                    if (!string.IsNullOrEmpty(AScore4))
                    {
                        data += AScore4.Replace(" ", "") + "*";
                    }
                    else
                    {
                        data += "" + "*";
                    }

                    if (!string.IsNullOrEmpty(ASeasonScore4))
                    {
                        data += ASeasonScore4.Replace(" ", "") + ";";
                    }
                    else
                    {
                        data += "" + ";";
                    }
                }


                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }



        }


        public void BtnCmd()
        {

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA球员对比：" + PluginConstant.Opeate_Refresh);

            onAirDataModel = JsonModel.PostOnAirData_Path(ScheduleID);
            if (onAirDataModel == null) return;
            SetPlayer(false);
            SetAData(0);
            SetHData(0);
        }

        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {


            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA球员对比：" + PluginConstant.Operate_Message);

            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
            if (onAirDataModel != null)
            {
                string onAirLastDate = $"直播接口更新时间：{onAirDataModel.LastPushDataDateTime}";
                vm.OnErrorLogMessage(onAirLastDate);
            }

            if (PlayerSeasonData != null)
            {
                string playerSeasonLastDate = $"球员赛季接口更新时间：{PlayerSeasonData.LastPushDataDateTime}";
                vm.OnErrorLogMessage(playerSeasonLastDate);
            }

            if (TeamSeasonData != null)
            {
                string teamSeasonLastDate = $"球队赛季接口更新时间:{TeamSeasonData.LastPushDataDateTime}";
                vm.OnErrorLogMessage(teamSeasonLastDate);
            }
            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;

            // messageLastRecordDate.ShowDialog();
        }

        /// <summary>
        /// 获得赛季球队数据
        /// </summary>messageLastRecordDate
        private async void GetSeasonData()
        {
            try

            {
                PlayerSeasonData = await JsonModel.PostPlayerSeasonData_Path(Matchtypeid);

                TeamSeasonData = await JsonModel.PostTeamSeasonData_Path(Matchtypeid);


                CNAliasPlayerSportsDictionary.Clear();
                if (PlayerSeasonData == null) return;
                foreach (var tempSeasonData in PlayerSeasonData.playerstats)
                {
                    Dictionary<string, string> CompareItemToNumber = new Dictionary<string, string>();

                    CompareItemToNumber.Add("得分", tempSeasonData.PointsAverage);
                    CompareItemToNumber.Add("篮板", tempSeasonData.ReboundsAverage);
                    CompareItemToNumber.Add("助攻", tempSeasonData.AssistsAverage);
                    CompareItemToNumber.Add("抢断", tempSeasonData.StealsAverage);
                    CompareItemToNumber.Add("盖帽", tempSeasonData.BlockedAverage);
                    CompareItemToNumber.Add("上场时间", tempSeasonData.MinutesAverage);
                    CompareItemToNumber.Add("投篮命中率", (tempSeasonData.FieldGoalsPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("两分命中率", (tempSeasonData.TwoPointPercentageAverage).ToString("F1") + "%");

                    CompareItemToNumber.Add("三分命中率", (tempSeasonData.ThreePointPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("罚球命中率", (tempSeasonData.FreeThrowsPercentageAverage).ToString("F1") + "%");
                    CompareItemToNumber.Add("篮下投篮命中率", (tempSeasonData.FieldGoalsAtRimPercentageAverage * 100).ToString("F1") + "%");
                    CompareItemToNumber.Add("中距离投篮命中率", (tempSeasonData.FieldGoalsMidRangePercentageAverage * 100).ToString("F1") + "%");
                    CompareItemToNumber.Add("三分", tempSeasonData.ThreePointGoalsAverage + "/"
                                + tempSeasonData.ThreePointAttemptedAverage);


                    CompareItemToNumber.Add("两分", tempSeasonData.TwoPointGoalsAverage + "/"
                                + tempSeasonData.TwoPointAttemptedAverage);


                    CompareItemToNumber.Add("两分区", tempSeasonData.TwoPointGoalsAverage + "/"
                                + tempSeasonData.TwoPointAttemptedAverage);
                    CompareItemToNumber.Add("三分区", tempSeasonData.ThreePointGoalsAverage + "/"

                 + tempSeasonData.ThreePointAttemptedAverage);
                    //CompareItemToNumber.Add("ThreeArea",);

                    CompareItemToNumber.Add("罚球", tempSeasonData.FreeThrowsAverage + "/"
                                + tempSeasonData.FreeThrowsAttemptedAverage);
                    CompareItemToNumber.Add("失误", tempSeasonData.TurnoversAverage);

                    if (!CNAliasPlayerSportsDictionary.ContainsKey(tempSeasonData.CNAlias))
                    {
                        CNAliasPlayerSportsDictionary.Add(tempSeasonData.CNAlias, CompareItemToNumber);
                    }

                }
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
            }
        }

        public void SetCompareData()
        {
            if (string.IsNullOrEmpty(ScheduleID)) return;
            onAirDataModel = JsonModel.PostOnAirData_Path(ScheduleID);
            ClearData();
            if (onAirDataModel == null) return;

            GetSeasonData();

            if (onAirDataModel != null)
            {

                if (onAirDataModel.liveTeamInfo.StatusCNName == "")
                {
                    MatchStatus = "未开始";
                }
                else if (onAirDataModel.liveTeamInfo.StatusCNName != "")
                {
                    MatchStatus = onAirDataModel.liveTeamInfo.StatusCNName;
                }
            }
            else
            {
                MatchStatus = "未开始";
            }


            HName = onAirDataModel.liveTeamInfo.HomeTeamCNAlias;

            AName = onAirDataModel.liveTeamInfo.VisitingTeamCNAlias;
            SetPlayer();
        }


        private void ClearData()
        {

            if (onAirDataModel != null) return;

            HName = "";
            AName = "";

            if (HPlayers != null)
            {
                HPlayers.Clear();
            }

            if (APlayers != null)
            {
                APlayers.Clear();
            }

            HPlayer = "";
            APlayer = "";

            HNums = "";
            ANums = "";
            APlayerLogo = null;
            HPlayerLogo = null;

            HScore = "";
            HSeasonScore = "";
            AScore = "";
            ASeasonScore = "";

            HScore1 = "";
            HSeasonScore1 = "";
            AScore1 = "";
            ASeasonScore1 = "";


            HScore2 = "";
            HSeasonScore2 = "";
            AScore2 = "";
            ASeasonScore2 = "";


            HScore3 = "";
            HSeasonScore3 = "";
            AScore3 = "";
            ASeasonScore3 = "";



            HScore4 = "";
            HSeasonScore4 = "";
            AScore4 = "";
            ASeasonScore4 = "";

            HScore5 = "";
            HSeasonScore5 = "";
            AScore5 = "";
            ASeasonScore5 = "";



            HScore6 = "";
            HSeasonScore6 = "";
            AScore6 = "";
            ASeasonScore6 = "";


        }

        /// <summary>
        /// 设置主队球员技术统计信息
        /// </summary>

        public void SetHData(int index)
        {

            if (hPlayer == null) return;
            if (MvpHomePlayerCompareNumDictionary.ContainsKey(HPlayer))
            {
                var playSeaSonData = MvpHomePlayerCompareNumDictionary[HPlayer];
                if (index == 1)
                {
                    //第一项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats))
                    {
                        HScore = playSeaSonData[selectTechStats];
                    }
                    else
                    {
                        HScore = "0";
                    }
                }
                else if (index == 2)
                {
                    //第二项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats1))
                    {
                        HScore1 = playSeaSonData[selectTechStats1];
                    }
                    else
                    {
                        HScore1 = "0";
                    }

                }
                else if (index == 3)
                {

                    //第三项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats2))
                    {
                        HScore2 = playSeaSonData[selectTechStats2];
                    }
                    else
                    {
                        HScore2 = "0";
                    }

                }
                else if (index == 4)
                {
                    //第四项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats3))
                    {
                        HScore3 = playSeaSonData[selectTechStats3];
                    }
                    else
                    {
                        HScore3 = "0";
                    }

                }

                else if (index == 5)
                {

                    //第五项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats4))
                    {
                        HScore4 = playSeaSonData[selectTechStats4];
                    }
                    else
                    {
                        HScore4 = "0";
                    }

                }

                else if (index == 6)
                {

                    //第六项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats5))
                    {
                        HScore5 = playSeaSonData[selectTechStats5];
                    }
                    else
                    {
                        HScore5 = "0";
                    }
                }
                else if (index == 7)
                {

                    //第7项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats6))
                    {
                        HScore6 = playSeaSonData[selectTechStats6];
                    }
                    else
                    {
                        HScore6 = "0";
                    }
                }
                else

                {






                    //第一项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats))
                    {
                        HScore = playSeaSonData[selectTechStats];
                    }
                    else
                    {
                        HScore = "0";
                    }

                    //第二项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats1))
                    {
                        HScore1 = playSeaSonData[selectTechStats1];
                    }
                    else
                    {
                        HScore1 = "0";
                    }

                    //第三项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats2))
                    {
                        HScore2 = playSeaSonData[selectTechStats2];
                    }
                    else
                    {
                        HScore2 = "0";
                    }

                    //第四项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats3))
                    {
                        HScore3 = playSeaSonData[selectTechStats3];
                    }
                    else
                    {
                        HScore3 = "0";
                    }

                    //第五项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats4))
                    {
                        HScore4 = playSeaSonData[selectTechStats4];
                    }
                    else
                    {
                        HScore4 = "0";
                    }


                    //第六项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats5))
                    {
                        HScore5 = playSeaSonData[selectTechStats5];
                    }
                    else
                    {
                        HScore5 = "0";
                    }


                    //第7项赋值
                    if (playSeaSonData.ContainsKey(selectTechStats6))
                    {
                        HScore6 = playSeaSonData[selectTechStats6];
                    }
                    else
                    {
                        HScore6 = "0";
                    }
                }



            }


            if (CNAliasPlayerSportsDictionary.ContainsKey(HPlayer))
            {
                var playSeaSonData = CNAliasPlayerSportsDictionary[HPlayer];

                if (index == 1)
                {
                    //第一项
                    if (playSeaSonData.ContainsKey(selectTechStats))
                    {
                        HSeasonScore = playSeaSonData[selectTechStats];
                    }
                    else
                    {
                        HSeasonScore = "0";
                    }
                }
                else if (index == 2)
                {
                    //第二项
                    if (playSeaSonData.ContainsKey(selectTechStats1))
                    {
                        HSeasonScore1 = playSeaSonData[selectTechStats1];
                    }
                    else
                    {
                        HSeasonScore1 = "0";
                    }
                }

                else if (index == 3)
                {

                    //第三项
                    if (playSeaSonData.ContainsKey(selectTechStats2))
                    {
                        HSeasonScore2 = playSeaSonData[selectTechStats2];
                    }
                    else
                    {
                        HSeasonScore2 = "0";
                    }

                }

                else if (index == 4)
                {
                    //第四项
                    if (playSeaSonData.ContainsKey(selectTechStats3))
                    {
                        HSeasonScore3 = playSeaSonData[selectTechStats3];
                    }
                    else
                    {
                        HSeasonScore3 = "0";
                    }
                }

                else if (index == 5)
                {


                    //第五项
                    if (playSeaSonData.ContainsKey(selectTechStats4))
                    {
                        HSeasonScore4 = playSeaSonData[selectTechStats4];
                    }
                    else
                    {
                        HSeasonScore4 = "0";
                    }
                }

                else if (index == 6)
                {

                    //第六项
                    if (playSeaSonData.ContainsKey(selectTechStats5))
                    {
                        HSeasonScore5 = playSeaSonData[selectTechStats5];
                    }
                    else
                    {
                        HSeasonScore5 = "0";
                    }
                }

                else if (index == 7)
                {


                    //第七项
                    if (playSeaSonData.ContainsKey(selectTechStats6))
                    {
                        HSeasonScore6 = playSeaSonData[selectTechStats6];
                    }
                    else
                    {
                        HSeasonScore6 = "0";
                    }
                }
                else
                {

                    //第一项
                    if (playSeaSonData.ContainsKey(selectTechStats))
                    {
                        HSeasonScore = playSeaSonData[selectTechStats];
                    }
                    else
                    {
                        HSeasonScore = "0";
                    }

                    //第二项
                    if (playSeaSonData.ContainsKey(selectTechStats1))
                    {
                        HSeasonScore1 = playSeaSonData[selectTechStats1];
                    }
                    else
                    {
                        HSeasonScore1 = "0";
                    }


                    //第三项
                    if (playSeaSonData.ContainsKey(selectTechStats2))
                    {
                        HSeasonScore2 = playSeaSonData[selectTechStats2];
                    }
                    else
                    {
                        HSeasonScore2 = "0";
                    }


                    //第四项
                    if (playSeaSonData.ContainsKey(selectTechStats3))
                    {
                        HSeasonScore3 = playSeaSonData[selectTechStats3];
                    }
                    else
                    {
                        HSeasonScore3 = "0";
                    }

                    //第五项
                    if (playSeaSonData.ContainsKey(selectTechStats4))
                    {
                        HSeasonScore4 = playSeaSonData[selectTechStats4];
                    }
                    else
                    {
                        HSeasonScore4 = "0";
                    }


                    //第六项
                    if (playSeaSonData.ContainsKey(selectTechStats5))
                    {
                        HSeasonScore5 = playSeaSonData[selectTechStats5];
                    }
                    else
                    {
                        HSeasonScore5 = "0";
                    }

                    //第七项
                    if (playSeaSonData.ContainsKey(selectTechStats6))
                    {
                        HSeasonScore6 = playSeaSonData[selectTechStats6];
                    }
                    else
                    {
                        HSeasonScore6 = "0";
                    }
                }

            }

        }


        /// <summary>
        /// 设置客队球员技术统计信息
        /// </summary>
        public void SetAData(int index)
        {
            if (APlayer == null) return;
            if (MvpVisitPlayerCompareNumDictionary.ContainsKey(APlayer))
            {
                var playSeaSonData = MvpVisitPlayerCompareNumDictionary[APlayer];

                if (index == 1)
                {
                    //第一项
                    if (playSeaSonData.ContainsKey(selectTechStats))
                    {
                        AScore = playSeaSonData[selectTechStats];
                    }
                    else
                    {
                        AScore = "0";
                    }
                }
                else if (index == 2)
                {

                    //第二项
                    if (playSeaSonData.ContainsKey(selectTechStats1))
                    {
                        AScore1 = playSeaSonData[selectTechStats1];
                    }
                    else
                    {
                        AScore1 = "0";
                    }

                }
                else if (index == 3)
                {

                    //第三项
                    if (playSeaSonData.ContainsKey(selectTechStats2))
                    {
                        AScore2 = playSeaSonData[selectTechStats2];
                    }
                    else
                    {
                        AScore2 = "0";
                    }
                }
                else if (index == 4)
                {
                    //第四项
                    if (playSeaSonData.ContainsKey(selectTechStats3))
                    {
                        AScore3 = playSeaSonData[selectTechStats3];
                    }
                    else
                    {
                        AScore3 = "0";
                    }
                }

                else if (index == 5)
                {
                    //第五项
                    if (playSeaSonData.ContainsKey(selectTechStats4))
                    {
                        AScore4 = playSeaSonData[selectTechStats4];
                    }
                    else
                    {
                        AScore4 = "0";
                    }

                }
                else if (index == 6)
                {
                    //第六项
                    if (playSeaSonData.ContainsKey(selectTechStats5))
                    {
                        AScore5 = playSeaSonData[selectTechStats5];
                    }
                    else
                    {
                        AScore5 = "0";
                    }
                }

                else if (index == 7)
                {
                    //第七项
                    if (playSeaSonData.ContainsKey(selectTechStats6))
                    {
                        AScore6 = playSeaSonData[selectTechStats6];
                    }
                    else
                    {
                        AScore6 = "0";
                    }

                }
                else
                {


                    //第一项
                    if (playSeaSonData.ContainsKey(selectTechStats))
                    {
                        AScore = playSeaSonData[selectTechStats];
                    }
                    else
                    {
                        AScore = "0";
                    }



                    //第二项
                    if (playSeaSonData.ContainsKey(selectTechStats1))
                    {
                        AScore1 = playSeaSonData[selectTechStats1];
                    }
                    else
                    {
                        AScore1 = "0";
                    }


                    //第三项
                    if (playSeaSonData.ContainsKey(selectTechStats2))
                    {
                        AScore2 = playSeaSonData[selectTechStats2];
                    }
                    else
                    {
                        AScore2 = "0";
                    }


                    //第四项
                    if (playSeaSonData.ContainsKey(selectTechStats3))
                    {
                        AScore3 = playSeaSonData[selectTechStats3];
                    }
                    else
                    {
                        AScore3 = "0";
                    }


                    //第五项
                    if (playSeaSonData.ContainsKey(selectTechStats4))
                    {
                        AScore4 = playSeaSonData[selectTechStats4];
                    }
                    else
                    {
                        AScore4 = "0";
                    }


                    //第六项
                    if (playSeaSonData.ContainsKey(selectTechStats5))
                    {
                        AScore5 = playSeaSonData[selectTechStats5];
                    }
                    else
                    {
                        AScore5 = "0";
                    }



                    //第七项
                    if (playSeaSonData.ContainsKey(selectTechStats6))
                    {
                        AScore6 = playSeaSonData[selectTechStats6];
                    }
                    else
                    {
                        AScore6 = "0";
                    }
                }



            }

            if (CNAliasPlayerSportsDictionary.ContainsKey(APlayer))
            {
                var playSeaSonData = CNAliasPlayerSportsDictionary[APlayer];

                if (index == 1)
                {


                    //第一项
                    if (playSeaSonData.ContainsKey(selectTechStats))
                    {
                        ASeasonScore = playSeaSonData[selectTechStats];
                    }
                    else
                    {
                        ASeasonScore = "0";
                    }
                }
                else if (index == 2)
                {

                    //第二项
                    if (playSeaSonData.ContainsKey(selectTechStats1))
                    {
                        ASeasonScore1 = playSeaSonData[selectTechStats1];
                    }
                    else
                    {
                        ASeasonScore1 = "0";
                    }
                }
                else if (index == 3)
                {

                    //第三项
                    if (playSeaSonData.ContainsKey(selectTechStats2))
                    {
                        ASeasonScore2 = playSeaSonData[selectTechStats2];
                    }
                    else
                    {
                        ASeasonScore2 = "0";
                    }

                }

                else if (index == 4)
                {

                    //第四项
                    if (playSeaSonData.ContainsKey(selectTechStats3))
                    {
                        ASeasonScore3 = playSeaSonData[selectTechStats3];
                    }
                    else
                    {
                        ASeasonScore3 = "0";
                    }
                }
                else if (index == 5)
                {
                    //第五项
                    if (playSeaSonData.ContainsKey(selectTechStats4))
                    {
                        ASeasonScore4 = playSeaSonData[selectTechStats4];
                    }
                    else
                    {
                        ASeasonScore4 = "0";
                    }
                }
                else if (index == 6)
                {
                    //第六项
                    if (playSeaSonData.ContainsKey(selectTechStats5))
                    {
                        ASeasonScore5 = playSeaSonData[selectTechStats5];
                    }
                    else
                    {
                        ASeasonScore5 = "0";
                    }

                }

                else if (index == 7)
                {

                    //第七项
                    if (playSeaSonData.ContainsKey(selectTechStats6))
                    {
                        ASeasonScore6 = playSeaSonData[selectTechStats6];
                    }
                    else
                    {
                        ASeasonScore6 = "0";
                    }
                }

                else
                {

                    //第一项
                    if (playSeaSonData.ContainsKey(selectTechStats))
                    {
                        ASeasonScore = playSeaSonData[selectTechStats];
                    }
                    else
                    {
                        ASeasonScore = "0";
                    }


                    //第二项
                    if (playSeaSonData.ContainsKey(selectTechStats1))
                    {
                        ASeasonScore1 = playSeaSonData[selectTechStats1];
                    }
                    else
                    {
                        ASeasonScore1 = "0";
                    }

                    //第三项
                    if (playSeaSonData.ContainsKey(selectTechStats2))
                    {
                        ASeasonScore2 = playSeaSonData[selectTechStats2];
                    }
                    else
                    {
                        ASeasonScore2 = "0";
                    }



                    //第四项
                    if (playSeaSonData.ContainsKey(selectTechStats3))
                    {
                        ASeasonScore3 = playSeaSonData[selectTechStats3];
                    }
                    else
                    {
                        ASeasonScore3 = "0";
                    }



                    //第五项
                    if (playSeaSonData.ContainsKey(selectTechStats4))
                    {
                        ASeasonScore4 = playSeaSonData[selectTechStats4];
                    }
                    else
                    {
                        ASeasonScore4 = "0";
                    }



                    //第六项
                    if (playSeaSonData.ContainsKey(selectTechStats5))
                    {
                        ASeasonScore5 = playSeaSonData[selectTechStats5];
                    }
                    else
                    {
                        ASeasonScore5 = "0";
                    }


                    //第七项
                    if (playSeaSonData.ContainsKey(selectTechStats6))
                    {
                        ASeasonScore6 = playSeaSonData[selectTechStats6];
                    }
                    else
                    {
                        ASeasonScore6 = "0";
                    }
                }


            }
        }



        static ObservableCollection<string> listTechStats = new ObservableCollection<string>() { "得分", "篮板", "助攻", "抢断", "盖帽", "上场时间", "投篮命中率", "两分命中率", "三分命中率", "罚球命中率", "篮下投篮命中率",
                                                                                            "中距离投篮命中率","三分","两分","两分区","三分区","三秒区","罚球","失误"}; //,"犯规","三分得分"


        #region 第一项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight;

        public bool IsHeight
        {
            get { return isHeight; }
            set { isHeight = value; this.RaisePropertyChanged(nameof(IsHeight)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible;
        public Visibility IsCheckVisible
        {
            get { return isCheckVisible; }
            set { isCheckVisible = value; this.RaisePropertyChanged(nameof(IsCheckVisible)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string hScore;

        public string HScore
        {
            get { return hScore; }
            set { hScore = value; this.RaisePropertyChanged(nameof(HScore)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible;

        public Visibility HScoreVisible
        {
            get { return hScoreVisible; }
            set { hScoreVisible = value; this.RaisePropertyChanged(nameof(hScoreVisible)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore;

        public string HSeasonScore
        {
            get { return hSeasonScore; }
            set { hSeasonScore = value; this.RaisePropertyChanged(nameof(HSeasonScore)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible;
        public Visibility HSeasonScoreVisible
        {
            get { return hSeasonScoreVisible; }
            set { hSeasonScoreVisible = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats = listTechStats;

        public ObservableCollection<string> TechStats
        {
            get { return techStats; }
            set { techStats = value; this.RaisePropertyChanged(nameof(TechStats)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats = "得分";

        public string SelectTechStats
        {
            get { return selectTechStats; }
            set
            {
                selectTechStats = value;
                this.RaisePropertyChanged(nameof(SelectTechStats));

                SetHData(1);
                SetAData(1);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible;


        public Visibility TechStatsVisible
        {
            get { return techStatsVisible; }
            set { techStatsVisible = value; this.RaisePropertyChanged(nameof(TechStatsVisible)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string aScore;

        public string AScore
        {
            get { return aScore; }
            set { aScore = value; this.RaisePropertyChanged(nameof(AScore)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible;

        public Visibility AScoreVisible
        {
            get { return aScoreVisible; }

            set { aScoreVisible = value; this.RaisePropertyChanged(nameof(AScoreVisible)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore;

        public string ASeasonScore
        {
            get { return aSeasonScore; }

            set { aSeasonScore = value; this.RaisePropertyChanged(nameof(ASeasonScore)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible;

        public Visibility ASeasonScoreVisible
        {
            get { return aSeasonScoreVisible; }
            set { aSeasonScoreVisible = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible)); }
        }

        #endregion


        #region 第二项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight1;

        public bool IsHeight1
        {
            get { return isHeight1; }
            set { isHeight1 = value; this.RaisePropertyChanged(nameof(IsHeight1)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible1;
        public Visibility IsCheckVisible1
        {
            get { return isCheckVisible1; }
            set { isCheckVisible1 = value; this.RaisePropertyChanged(nameof(IsCheckVisible1)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string hScore1;

        public string HScore1
        {
            get { return hScore1; }
            set { hScore1 = value; this.RaisePropertyChanged(nameof(HScore1)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible1;

        public Visibility HScoreVisible1
        {
            get { return hScoreVisible1; }
            set { hScoreVisible1 = value; this.RaisePropertyChanged(nameof(hScoreVisible1)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore1;

        public string HSeasonScore1
        {
            get { return hSeasonScore1; }
            set { hSeasonScore1 = value; this.RaisePropertyChanged(nameof(HSeasonScore1)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible1;
        public Visibility HSeasonScoreVisible1
        {
            get { return hSeasonScoreVisible1; }
            set { hSeasonScoreVisible1 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible1)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats1 = listTechStats;

        public ObservableCollection<string> TechStats1
        {
            get { return techStats1; }
            set { techStats1 = value; this.RaisePropertyChanged(nameof(TechStats1)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats1 = "篮板";

        public string SelectTechStats1
        {
            get { return selectTechStats1; }
            set
            {
                selectTechStats1 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats1));
                SetHData(2);
                SetAData(2);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible1;


        public Visibility TechStatsVisible1
        {
            get { return techStatsVisible1; }
            set { techStatsVisible1 = value; this.RaisePropertyChanged(nameof(TechStatsVisible1)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string aScore1;

        public string AScore1
        {
            get { return aScore1; }
            set { aScore1 = value; this.RaisePropertyChanged(nameof(AScore1)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible1;

        public Visibility AScoreVisible1
        {
            get { return aScoreVisible1; }

            set { aScoreVisible1 = value; this.RaisePropertyChanged(nameof(AScoreVisible1)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore1;

        public string ASeasonScore1
        {
            get { return aSeasonScore1; }

            set { aSeasonScore1 = value; this.RaisePropertyChanged(nameof(ASeasonScore1)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible1;

        public Visibility ASeasonScoreVisible1
        {
            get { return aSeasonScoreVisible1; }
            set { aSeasonScoreVisible1 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible1)); }
        }

        #endregion


        #region 第三项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight2;

        public bool IsHeight2
        {
            get { return isHeight2; }
            set { isHeight2 = value; this.RaisePropertyChanged(nameof(IsHeight2)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible2;
        public Visibility IsCheckVisible2
        {
            get { return isCheckVisible2; }
            set { isCheckVisible2 = value; this.RaisePropertyChanged(nameof(IsCheckVisible2)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string hScore2;

        public string HScore2
        {
            get { return hScore2; }
            set { hScore2 = value; this.RaisePropertyChanged(nameof(HScore2)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible2;

        public Visibility HScoreVisible2
        {
            get { return hScoreVisible2; }
            set { hScoreVisible2 = value; this.RaisePropertyChanged(nameof(hScoreVisible2)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore2;

        public string HSeasonScore2
        {
            get { return hSeasonScore2; }
            set { hSeasonScore2 = value; this.RaisePropertyChanged(nameof(HSeasonScore2)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible2;
        public Visibility HSeasonScoreVisible2
        {
            get { return hSeasonScoreVisible2; }
            set { hSeasonScoreVisible2 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible2)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats2 = listTechStats;

        public ObservableCollection<string> TechStats2
        {
            get { return techStats2; }
            set { techStats2 = value; this.RaisePropertyChanged(nameof(TechStats2)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats2 = "助攻";

        public string SelectTechStats2
        {
            get { return selectTechStats2; }
            set
            {
                selectTechStats2 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats2));
                SetHData(3);
                SetAData(3);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible2;


        public Visibility TechStatsVisible2
        {
            get { return techStatsVisible2; }
            set
            {
                techStatsVisible2 = value;
                this.RaisePropertyChanged(nameof(TechStatsVisible2));
            }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string aScore2;

        public string AScore2
        {
            get { return aScore2; }
            set { aScore2 = value; this.RaisePropertyChanged(nameof(AScore2)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible2;

        public Visibility AScoreVisible2
        {
            get { return aScoreVisible2; }

            set { aScoreVisible2 = value; this.RaisePropertyChanged(nameof(AScoreVisible2)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore2;

        public string ASeasonScore2
        {
            get { return aSeasonScore2; }

            set { aSeasonScore2 = value; this.RaisePropertyChanged(nameof(ASeasonScore2)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible2;

        public Visibility ASeasonScoreVisible2
        {
            get { return aSeasonScoreVisible2; }
            set { aSeasonScoreVisible2 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible2)); }
        }

        #endregion


        #region 第四项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight3;

        public bool IsHeight3
        {
            get { return isHeight3; }
            set { isHeight3 = value; this.RaisePropertyChanged(nameof(IsHeight3)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible3;
        public Visibility IsCheckVisible3
        {
            get { return isCheckVisible3; }
            set { isCheckVisible3 = value; this.RaisePropertyChanged(nameof(IsCheckVisible3)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string hScore3;

        public string HScore3
        {
            get { return hScore3; }
            set { hScore3 = value; this.RaisePropertyChanged(nameof(HScore3)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible3;

        public Visibility HScoreVisible3
        {
            get { return hScoreVisible3; }
            set { hScoreVisible3 = value; this.RaisePropertyChanged(nameof(hScoreVisible3)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore3;

        public string HSeasonScore3
        {
            get { return hSeasonScore3; }
            set { hSeasonScore3 = value; this.RaisePropertyChanged(nameof(HSeasonScore3)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible3;
        public Visibility HSeasonScoreVisible3
        {
            get { return hSeasonScoreVisible3; }
            set { hSeasonScoreVisible3 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible3)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats3 = listTechStats;

        public ObservableCollection<string> TechStats3
        {
            get { return techStats3; }
            set { techStats3 = value; this.RaisePropertyChanged(nameof(TechStats3)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats3 = "盖帽";

        public string SelectTechStats3
        {
            get { return selectTechStats3; }
            set
            {
                selectTechStats3 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats3));
                SetHData(4);
                SetAData(4);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible3;


        public Visibility TechStatsVisible3
        {
            get { return techStatsVisible3; }
            set { techStatsVisible3 = value; this.RaisePropertyChanged(nameof(TechStatsVisible3)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string aScore3;

        public string AScore3
        {
            get { return aScore3; }
            set { aScore3 = value; this.RaisePropertyChanged(nameof(AScore3)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible3;

        public Visibility AScoreVisible3
        {
            get { return aScoreVisible3; }

            set { aScoreVisible3 = value; this.RaisePropertyChanged(nameof(AScoreVisible3)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore3;

        public string ASeasonScore3
        {
            get { return aSeasonScore3; }

            set { aSeasonScore3 = value; this.RaisePropertyChanged(nameof(ASeasonScore3)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible3;

        public Visibility ASeasonScoreVisible3
        {
            get { return aSeasonScoreVisible3; }
            set { aSeasonScoreVisible3 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible3)); }
        }

        #endregion


        #region 第五项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight4;

        public bool IsHeight4
        {
            get { return isHeight4; }
            set { isHeight4 = value; this.RaisePropertyChanged(nameof(IsHeight4)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible4;
        public Visibility IsCheckVisible4
        {
            get { return isCheckVisible4; }
            set { isCheckVisible4 = value; this.RaisePropertyChanged(nameof(IsCheckVisible4)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string hScore4;

        public string HScore4
        {
            get { return hScore4; }
            set { hScore4 = value; this.RaisePropertyChanged(nameof(HScore4)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible4;

        public Visibility HScoreVisible4
        {
            get { return hScoreVisible4; }
            set { hScoreVisible4 = value; this.RaisePropertyChanged(nameof(hScoreVisible4)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore4;

        public string HSeasonScore4
        {
            get { return hSeasonScore4; }
            set { hSeasonScore4 = value; this.RaisePropertyChanged(nameof(HSeasonScore4)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible4;
        public Visibility HSeasonScoreVisible4
        {
            get { return hSeasonScoreVisible4; }
            set { hSeasonScoreVisible4 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible4)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats4 = listTechStats;

        public ObservableCollection<string> TechStats4
        {
            get { return techStats4; }
            set { techStats4 = value; this.RaisePropertyChanged(nameof(TechStats4)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats4 = "抢断";

        public string SelectTechStats4
        {
            get { return selectTechStats4; }
            set
            {
                selectTechStats4 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats4));
                SetHData(5);
                SetAData(5);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible4;


        public Visibility TechStatsVisible4
        {
            get { return techStatsVisible4; }
            set { techStatsVisible4 = value; this.RaisePropertyChanged(nameof(TechStatsVisible4)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string aScore4;

        public string AScore4
        {
            get { return aScore4; }
            set { aScore4 = value; this.RaisePropertyChanged(nameof(AScore4)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible4;

        public Visibility AScoreVisible4
        {
            get { return aScoreVisible4; }

            set { aScoreVisible4 = value; this.RaisePropertyChanged(nameof(AScoreVisible4)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore4;

        public string ASeasonScore4
        {
            get { return aSeasonScore4; }

            set { aSeasonScore4 = value; this.RaisePropertyChanged(nameof(ASeasonScore4)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible4;

        public Visibility ASeasonScoreVisible4
        {
            get { return aSeasonScoreVisible4; }
            set { aSeasonScoreVisible4 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible4)); }
        }

        #endregion



        #region 第六项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight5;

        public bool IsHeight5
        {
            get { return isHeight5; }
            set { isHeight5 = value; this.RaisePropertyChanged(nameof(IsHeight5)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible5;
        public Visibility IsCheckVisible5
        {
            get { return isCheckVisible5; }
            set { isCheckVisible5 = value; this.RaisePropertyChanged(nameof(IsCheckVisible5)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string hScore5;

        public string HScore5
        {
            get { return hScore5; }
            set { hScore5 = value; this.RaisePropertyChanged(nameof(HScore5)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible5;

        public Visibility HScoreVisible5
        {
            get { return hScoreVisible5; }
            set { hScoreVisible5 = value; this.RaisePropertyChanged(nameof(hScoreVisible5)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore5;

        public string HSeasonScore5
        {
            get { return hSeasonScore5; }
            set { hSeasonScore5 = value; this.RaisePropertyChanged(nameof(HSeasonScore5)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible5;
        public Visibility HSeasonScoreVisible5
        {
            get { return hSeasonScoreVisible5; }
            set { hSeasonScoreVisible5 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible5)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats5 = listTechStats;

        public ObservableCollection<string> TechStats5
        {
            get { return techStats5; }
            set { techStats5 = value; this.RaisePropertyChanged(nameof(TechStats5)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats5 = "投篮命中率";

        public string SelectTechStats5
        {
            get { return selectTechStats5; }
            set
            {
                selectTechStats5 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats5));
                SetHData(6);
                SetAData(6);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible5;


        public Visibility TechStatsVisible5
        {
            get { return techStatsVisible5; }
            set { techStatsVisible5 = value; this.RaisePropertyChanged(nameof(TechStatsVisible5)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string aScore5;

        public string AScore5
        {
            get { return aScore5; }
            set { aScore5 = value; this.RaisePropertyChanged(nameof(AScore5)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible5;

        public Visibility AScoreVisible5
        {
            get { return aScoreVisible5; }

            set { aScoreVisible5 = value; this.RaisePropertyChanged(nameof(AScoreVisible5)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore5;

        public string ASeasonScore5
        {
            get { return aSeasonScore5; }

            set { aSeasonScore5 = value; this.RaisePropertyChanged(nameof(ASeasonScore5)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible5;

        public Visibility ASeasonScoreVisible5
        {
            get { return aSeasonScoreVisible5; }
            set { aSeasonScoreVisible5 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible5)); }
        }

        #endregion


        #region 第七项数据

        /// <summary>
        /// 是否高亮
        /// </summary>

        private bool isHeight6;

        public bool IsHeight6
        {
            get { return isHeight6; }
            set { isHeight6 = value; this.RaisePropertyChanged(nameof(IsHeight6)); }
        }

        /// <summary>
        /// 是否显示
        /// </summary>
        private Visibility isCheckVisible6;
        public Visibility IsCheckVisible6
        {
            get { return isCheckVisible6; }
            set { isCheckVisible6 = value; this.RaisePropertyChanged(nameof(IsCheckVisible6)); }
        }



        /// <summary>
        ///主队本场得分
        /// </summary>
        private string hScore6;

        public string HScore6
        {
            get { return hScore6; }
            set { hScore6 = value; this.RaisePropertyChanged(nameof(HScore6)); }
        }


        /// <summary>
        /// 主队本场得分是否可见
        /// </summary>

        public Visibility hScoreVisible6;

        public Visibility HScoreVisible6
        {
            get { return hScoreVisible6; }
            set { hScoreVisible6 = value; this.RaisePropertyChanged(nameof(hScoreVisible6)); }
        }


        /// <summary>
        /// 赛季球员得分
        /// </summary>

        public string hSeasonScore6;

        public string HSeasonScore6
        {
            get { return hSeasonScore6; }
            set { hSeasonScore6 = value; this.RaisePropertyChanged(nameof(HSeasonScore6)); }
        }


        /// <summary>
        /// 赛季球员是否可见
        /// </summary>
        private Visibility hSeasonScoreVisible6;
        public Visibility HSeasonScoreVisible6
        {
            get { return hSeasonScoreVisible6; }
            set { hSeasonScoreVisible6 = value; this.RaisePropertyChanged(nameof(HSeasonScoreVisible6)); }
        }


        /// <summary>
        /// 技术统计
        /// </summary>
        private ObservableCollection<string> techStats6 = listTechStats;

        public ObservableCollection<string> TechStats6
        {
            get { return techStats6; }
            set { techStats6 = value; this.RaisePropertyChanged(nameof(TechStats6)); }
        }



        /// <summary>
        /// 选中的值
        /// </summary>
        private string selectTechStats6 = "三分命中率";

        public string SelectTechStats6
        {
            get { return selectTechStats6; }
            set
            {
                selectTechStats6 = value;
                this.RaisePropertyChanged(nameof(SelectTechStats6));
                SetHData(7);
                SetAData(7);
            }
        }


        /// <summary>
        /// 技术统计是否可见
        /// </summary>
        private Visibility techStatsVisible6;


        public Visibility TechStatsVisible6
        {
            get { return techStatsVisible6; }
            set { techStatsVisible6 = value; this.RaisePropertyChanged(nameof(TechStatsVisible6)); }
        }


        /// <summary>
        /// 客队得分
        /// </summary>

        private string aScore6;

        public string AScore6
        {
            get { return aScore6; }
            set { aScore6 = value; this.RaisePropertyChanged(nameof(AScore6)); }
        }


        /// <summary>
        /// 客队得分是否可见
        /// </summary>
        private Visibility aScoreVisible6;

        public Visibility AScoreVisible6
        {
            get { return aScoreVisible6; }

            set { aScoreVisible6 = value; this.RaisePropertyChanged(nameof(AScoreVisible6)); }
        }


        /// <summary>
        /// 客队赛季得分
        /// </summary>
        private string aSeasonScore6;

        public string ASeasonScore6
        {
            get { return aSeasonScore6; }

            set { aSeasonScore6 = value; this.RaisePropertyChanged(nameof(ASeasonScore6)); }
        }


        /// <summary>
        /// 客队赛季得分是否可见
        /// </summary>
        private Visibility aSeasonScoreVisible6;

        public Visibility ASeasonScoreVisible6
        {
            get { return aSeasonScoreVisible6; }
            set { aSeasonScoreVisible6 = value; this.RaisePropertyChanged(nameof(ASeasonScoreVisible6)); }
        }

        #endregion



    }
}
