﻿using DevExpress.Mvvm;
using DevExpress.Xpf.Core.ReflectionExtensions.Internal;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.CBA.Module
{
    /// <summary>
    /// 技术统计类
    /// </summary>
    public class MatchStatsNumbers:ViewModelBase
    {


        // public string HomeName { get; set; }

        /// <summary>
        /// 主队得分
        /// </summary>
        private string homeScore; 

        public string HomeScore
        {
            get { return homeScore; }

            set { homeScore = value; this.RaisePropertiesChanged(nameof(HomeScore)); }  
        }

        /// <summary>
        /// 主队赛季得分
        /// </summary>
        private string hSeasonScore;
        public string HSeasonScore
        {
            get { return hSeasonScore; }

            set { hSeasonScore = value; this.RaisePropertiesChanged(nameof(HSeasonScore)); }    
        }



        //public string AwayName { get; set; }
        /// <summary>
        /// 客场得分
        /// </summary>
        private string awayScore;
        public string AwayScore
        {
            get { return awayScore; }
            set { awayScore = value; this.RaisePropertiesChanged(nameof(AwayScore)); }  
        }


        /// <summary>
        /// 客场赛季得分
        /// </summary>
        private string aSeasonScore;
        public string ASeasonScore
        {
            get { return aSeasonScore; }

            set { aSeasonScore = value;this.RaisePropertiesChanged(nameof(ASeasonScore)); }
        }

        private HighLightEnum light = HighLightEnum.OffLight;
        /// <summary>
        ///高亮
        /// </summary>
        public HighLightEnum Light
        {
            get { return light; }
            set { light = value; this.RaisePropertiesChanged(nameof(Light)); }
        }

        /// <summary>
        /// 技术统计
        /// </summary>

        private TechStats techStats = TechStats.Goal;

        public TechStats TechStats
        {
            get { return techStats; }
            set { techStats = value; this.RaisePropertiesChanged(nameof(TechStats)); }
        }

        /// <summary>
        /// 选中行是否高亮
        /// </summary>
        private string selectLight = "不高亮";
        public string SelectLight
        {
            get { return selectLight; }
            set { selectLight = value; this.RaisePropertyChanged(nameof(SelectLight)); }
        }

        /// <summary>
        /// 技术统计名称
        /// </summary>
        private string techStatsName;
        public string TechStatsName
        {
            get { return techStatsName; }
            set { techStatsName = value; this.RaisePropertyChanged(nameof(TechStatsName)); }
        }


    }
}
