﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Module;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.CBA.Module
{
    /// <summary>
    /// Interaction logic for TeamStatsTaskView.xaml
    /// </summary>
    public partial class TeamStatsTaskView : UserControl, IPluginView
    {
        public TeamStatsTaskViewModel vm = new TeamStatsTaskViewModel();

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        public TeamStatsTaskView()
        {
            InitializeComponent();



            TeamStatsTaskViewModel.TeamStatsTaskViewModelInstance.Add(vm);
            WPFHelper.BindingViewModel(this, vm);



            task_Start.IsEnabled = true;
            task_Stop.IsEnabled = false;
            task_continue.IsEnabled = false;

            this.Loaded += NewTeamStatsView_Loaded;
            this.IsVisibleChanged += NewTeamStatsView_IsVisibleChanged;


        }

        private void NewTeamStatsView_IsVisibleChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            if (!string.IsNullOrEmpty(vm.ScheduleID) && !string.IsNullOrEmpty(vm.Matchtypeid))
            {
                if (e.NewValue != null && Convert.ToBoolean(e.NewValue))
                {
                    vm.SetTeamData();
                }
            }
        }

        private void NewTeamStatsView_Loaded(object sender, RoutedEventArgs e)
        {
            var service = ApplicationDomainEx.ServiceManager.GetService<IPluginService>(ViewServiceKeys.PLUGIN_SERVICE);
            if (service == null)
                return;
            vm.page = service.GetPageModelFromView(this);



        }

        public void Dispose()
        {

        }

        public void PreviewContinue(ConnModel conn)
        {

        }

        public void PreviewIn(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_PREVIEW_PLAY);
            if (conn.IsConnected)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombineTeamComData()));
            }
        }

        public void PreviewOut(ConnModel conn)
        {
            //if(conn.IsConnected)
            //{
            //    conn.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            //}
        }

        public void TakeContinue(ConnModel conns)
        {

        }

        public void TakeOut(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_OUT);
            if (conns.IsConnected)
            {
                conns.EndpointManager.Send(VizEngineCommands.STAGE_CONTINUE);
            }
        }

        public void TakeUpdate(ConnModel conns)
        {

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_UPDATE);

            if (conns.IsConnected)
            {
                conns.EndpointManager.Send(string.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombineTeamComData()));
            }
        }

        public void TakIn(ConnModel conns)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_TAKE);

            if (conns.IsConnected)
            {
                conns.EndpointManager.Send(string.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombineTeamComData()));
            }
        }


        private void OnPreviewUpdate(ConnModel conn)
        {
            if (conn.IsConnected)
            {
                vm.BtnCmd();
                if (vm.onAirDataModel != null)
                {
                    conn.EndpointManager.Send(string.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombineTeamComData()));
                }
                //task.CanExecute = vm.flag;
                //SCRIPT_INVOKE

            }
        }

        private void OnTakeUpdate(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_TAKE_UPDATE);
            if (conn.IsConnected)
            {
                vm.BtnCmd();

                if (vm.onAirDataModel != null)
                {
                    conn.EndpointManager.Send(string.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombineTeamComData()));
                }
                //SCRIPT_INVOKE

            }
        }



        private void task_Start_Click(object sender, RoutedEventArgs e)
        {
            TeamStatsView_Init();
            task_Start.IsEnabled = false;
            task_Stop.IsEnabled = true;
            task_continue.IsEnabled = true;
        }

        private void task_continue_Click(object sender, RoutedEventArgs e)
        {
            if (task.IsRunning)
            {
                task.IsRunning = false;
                task_continue.Content = "任务继续";
            }
            else
            {
                task.IsRunning = true;
                task_continue.Content = "任务暂停";
            }
            task_Start.IsEnabled = false;
            task_Stop.IsEnabled = true;
        }

        private void task_Stop_Click(object sender, RoutedEventArgs e)
        {
            service.Cancel(task);

            task = null;
            task_Start.IsEnabled = true;
            task_continue.Content = "任务暂停";
            task_continue.IsEnabled = false;
            task_Stop.IsEnabled = false;
        }



        /// <summary>
        /// 任务模型
        /// </summary>
        public PackageTaskModel task;
        /// <summary>
        /// 服务
        /// </summary>
        IPackageTaskService service;

        /// <summary>
        /// 注册任务
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void TeamStatsView_Init()
        {
            if (task != null)
                return;

            task = new PackageTaskModel(this);
            task.PreviewUpdateAction = OnPreviewUpdate;
            task.TakeUpdateAction = OnTakeUpdate;
            task.IsPreviewEnabled = true;
            task.IsTakeEnabled = true;
            task.IsRunning = true;

            task.Name = "球队对比数据";
            service = ApplicationDomainEx.ServiceManager.GetService<IPackageTaskService>(ViewServiceKeys.PACKAGE_TASK_SERVICE);
            if (service == null)
                return;
            service.Register(task);

            //var service2 = ApplicationDomainEx.ServiceManager.GetService<IPluginService>(ViewServiceKeys.PLUGIN_SERVICE);
            //if (service2 == null)
            //    return;

            //PageModel page= service2.GetPageModelFromView(this);
            //ApplicationDomainEx.CurrentPage == page;


        }

        public void PageOpend(ConnModel conn, PageModel page)
        {
            if (conn.IsConnected)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombineTeamComData()));
            }
        }

        public void PreviewUpdate(ConnModel conn)
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, RecordLogConstants.OPERATE_PREVIEW_UPDATE);

            if (conn.IsConnected)
            {
                conn.EndpointManager.Send(String.Format(VizEngineCommands.SCRIPT_INVOKE, "dqyData", vm.CombineTeamComData()));
            }
        }
    }
}
