﻿using DevExpress.Mvvm.Native;
using DevExpress.XtraPrinting.Native.WebClientUIControl;
using log4net;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.FTB.Module
{
    public static class JsonModel
    {

        /// <summary>
        /// 添加日志
        /// </summary>
        private static readonly ILog Log = LogManager.GetLogger(typeof(JsonModel));

        //读取url
        private static AppSetup_InitLiteDB appSetup_InitLiteDB = AppSetup_InitLiteDB.CreateInstance;


        //新的URL
        public static string strUrl = AppSetup_InitLiteDB.HttpUrlConfigEntity.Url;

        /// <summary>
        /// 读取艾果的数据平台的配置项
        /// </summary>
        public static string appID = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppId;
        //sd.Settings["AppID"].Value.ToString();
        public static string appKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppKey;

        //public  string type = AppSetup_InitLiteDB.HttpUrlConfigEntity.SelectFootballType;

        //public  string seasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.SeasonId;

        /// <summary>
        /// true 是主数据来源，false 是备份数据库来源
        /// </summary>
        public static bool dataFromSource = true;


        /// <summary>
        /// 获取URl地址
        /// </summary>
        public static void GethttpUrl()
        {
            if (dataFromSource)
            {
                strUrl = AppSetup_InitLiteDB.HttpUrlConfigEntity.Url;
                appID = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppId;
                appKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppKey;

            }
            else
            {
                JsonModel.strUrl = AppSetup_InitLiteDB.HttpUrlConfigEntity.BUrl;
                JsonModel.appKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.BAppKey;
                JsonModel.appID = AppSetup_InitLiteDB.HttpUrlConfigEntity.BAppId;
            }

        }


        /// <summary>
        /// 艾果平台的明日赛程数据服务器接口
        /// </summary>
        /// <returns></returns>
        public async static Task<Dayschedules> PostTomorrowMatch_Path(string round,string selectFootballType)
        {


            Dayschedules dayschedules = new Dayschedules();
            try

            {
                GethttpUrl();
                await Task.Run(() =>
                {
                    string GameRoundDataPath = strUrl + "schedule/getschedulelist";

                    Dictionary<string, string> dict = new Dictionary<string, string>();
                    //dict.Add("leagueid", "401");
                    dict.Add("round", round);
                    dict.Add("competitionId", selectFootballType);
                    

                    string newKey = Utils.GetKey(appID, appKey);
                    var str = JsonHelper.Post(GameRoundDataPath, dict, newKey);

                    if(dataFromSource)
                    {
                        Log.Info($"{DateHeaderViewModel.FoolballType} 轮次数据接口新:主数据来源:{GameRoundDataPath}=======>:" + str);
                    }
                    else
                    {
                        Log.Info($"{DateHeaderViewModel.FoolballType} 轮次数据接口新:备份数据来源:{GameRoundDataPath}=======>:" + str);
                    }
                   
                    JsonSerializerSettings settings = new JsonSerializerSettings();
                    settings.NullValueHandling = NullValueHandling.Ignore;
                    dayschedules = JsonConvert.DeserializeObject<Dayschedules>(str, settings);
                    if (dayschedules != null)
                    {
                        var sortList = dayschedules.schedulelist.OrderBy(b => Convert.ToDateTime(b.dates)).ThenBy(a => a.time).ToList();

                        dayschedules.schedulelist = sortList;
                    }
       

                });

                return dayschedules;

            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }

        }


        /// <summary>
        ///球队积分数据服务器地址
        /// </summary>
        /// <returns></returns>
        public  async static  Task<TeamRanks> PostTeamScoreData_Path(string footballType,string seasonId)
        {
            try
            {
                GethttpUrl();

                TeamRanks teamRanks = new TeamRanks();

                await Task.Run(() =>
                {
                    string TeamScoreDataPath = strUrl + "team/getteamstats";


                    Dictionary<string, string> dict = new Dictionary<string, string>();

                    dict.Add("competitionId", footballType);
                    dict.Add("seasonId", seasonId);//"110000005454"

                    string newKey = Utils.GetKey(appID, appKey);

                    string result = JsonHelper.Post(TeamScoreDataPath, dict, newKey);

                    if (dataFromSource)
                    {
                        Log.Info($"{DateHeaderViewModel.FoolballType}球队积分排行数据:主数据来源:{TeamScoreDataPath}==>:" + result);
                    }
                    else
                    {
                        Log.Info($"{DateHeaderViewModel.FoolballType}球队积分排行数据:备份数据来源:{TeamScoreDataPath}==>:" + result);
                    }

                    JsonSerializerSettings settings = new JsonSerializerSettings();
                    settings.NullValueHandling = NullValueHandling.Ignore;

                    teamRanks = JsonConvert.DeserializeObject<TeamRanks>(result, settings);
                    if (teamRanks != null)
                    {
                        var sortRanks = teamRanks.teamstats.OrderBy(a => Convert.ToInt32(a.rank)).ToList();
                        teamRanks.teamstats = sortRanks;
                    }
                    Console.WriteLine("球队积分排行数据============>:" + TeamScoreDataPath);

                });

                return teamRanks;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }
        }


       
        /// <summary>
        /// 获取赛季数据接口
        /// </summary>
        /// <returns></returns>
        public async static Task<Seasons> Post_MatchSeasonData_Path(string selectFootballType)
        {
            try
            {
                GethttpUrl();
                Seasons seasons = new Seasons();
                await Task.Run(() =>
                {
                    string MatchDataPath = strUrl + "matchSeason";
                    Dictionary<string, string> dict = new Dictionary<string, string>();

                    dict.Add("competitionId", selectFootballType);

                    string newKey = Utils.GetKey(appID, appKey);
                    string result = JsonHelper.Post(MatchDataPath, dict, newKey);

                    if (dataFromSource)
                    {
                        Log.Info($"{DateHeaderViewModel.FoolballType} 足球赛季数据:主数据来源:{MatchDataPath}==>" + result);
                    }
                    else
                    {
                        Log.Info($"{DateHeaderViewModel.FoolballType} 足球赛季数据:备份数据来源:{MatchDataPath}==>" + result);
                    }

                    JsonSerializerSettings settings = new JsonSerializerSettings();
                    settings.NullValueHandling = NullValueHandling.Ignore;

                    seasons = JsonConvert.DeserializeObject<Seasons>(result, settings);

                    if (seasons != null)
                    {
                        var sortSeason = seasons.matchseason.OrderByDescending(a => a.seasonName).ToList();
                        seasons.matchseason = sortSeason;
                    }
                    Console.WriteLine("足球赛季数据=========>" + MatchDataPath);
                   
                });
                return seasons;
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }

        }


        /// <summary>
        /// 获取球队射手榜数据
        /// </summary>
        /// <param name="footballType"></param>
        /// <param name="seasonId"></param>
        /// <returns></returns>
        public async static Task<ShootPlayerRanks> Post_ShootPlayerRankData(string footballType, string seasonId,string startOffset,string endOffset)
        {
            try
            {
                GethttpUrl();
                ShootPlayerRanks shootPlayerRanks = new ShootPlayerRanks();
                await Task.Run(() =>
                {
                    string shootPath = strUrl + "player/getplayerstats";

                    Dictionary<string, string> dict = new Dictionary<string, string>();

                    dict.Add("competitionId", footballType);
                    dict.Add("seasonId", seasonId);//"110000005454"
                    dict.Add("startOffset", startOffset);
                    dict.Add("endOffset", endOffset);

                    string newKey = Utils.GetKey(appID, appKey);

                    string result = JsonHelper.Post(shootPath, dict, newKey);

                    if (dataFromSource)
                    {
                        Log.Info($"{DateHeaderViewModel.FoolballType} 足球球员射手排行:主数据来源:{shootPath}==>" + result);
                    }
                    else
                    {
                        Log.Info($"{DateHeaderViewModel.FoolballType} 足球球员射手排行:备份数据来源:{shootPath}==>" + result);
                    }

                    JsonSerializerSettings settings = new JsonSerializerSettings();

                    settings.NullValueHandling = NullValueHandling.Ignore;

                    shootPlayerRanks = JsonConvert.DeserializeObject<ShootPlayerRanks>(result, settings);


                    //var sortPlayerShoot = shootPlayerRanks.playerstats.Take(5).ToList();

                    //shootPlayerRanks.playerstats = sortPlayerShoot;
                });
                return shootPlayerRanks;
            }
            catch(Exception ex)
            {
                Log.Error(ex.Message);
                return null;
            }

        }


    }
}
