﻿using DevExpress.Xpf.Grid;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Markup;
using VIZ.Framework.Core;
using VIZ.Package.Common;

namespace VIZ.TVP.FTB.Module
{
    public class FDayMatchViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(FDayMatchViewModel));


        public static FDayMatchViewModel FDayMatchViewModelInstance=new FDayMatchViewModel();

        public FDayMatchViewModel()
        {
            //初始化方法
            Init();
        }



       
        private string title = "意甲联赛第1轮";

        /// <summary>
        /// 标题
        /// </summary>
        public string Title
        {
            get { return title; }
            set { title = value; this.RaisePropertyChanged(nameof(Title)); }
        }


       /// <summary>
       /// 选中轮次
       /// </summary>
        private int roundMatchItem;

        public int RoundMatchItem
        {
            get { return roundMatchItem; }
            set 
            { 
                roundMatchItem = value; 
                this.RaisePropertyChanged(nameof(RoundMatchItem));
            }
        }


        private ObservableCollection<int> roundMatch;

        public ObservableCollection<int> RoundMatchs
        {
            get { return roundMatch; }
            set { roundMatch = value; this.RaisePropertyChanged(nameof(RoundMatchs)); }
        }


        /// <summary>
        /// 足球赛事类型
        /// </summary>
        public string FoolballType = "";

        /// <summary>
        /// 赛季ID
        /// </summary>
        public string SeasonId = "";


        /// <summary>
        /// 今日赛程轮次
        /// </summary>
        public VCommand BtnRoundCmd { get; set; }



        Dayschedules RoundMatchData = null;
        /// <summary>
        /// 添加轮次刷新
        /// </summary>
        private  async void BtmRoundCommand()
        {
            // SetRoundMatchData();


            RoundMatchData = await JsonModel.PostTomorrowMatch_Path(roundMatchItem.ToString(), FoolballType);


            if (RoundMatchData == null) return;



            MatchData = new ObservableCollection<Dayschedule>();



            foreach (var rudData in RoundMatchData.schedulelist)
            {

                Dayschedule d = new Dayschedule();


                d.round = rudData.round;
                d.dates = rudData.dates;
                d.time = rudData.time;
                d.homeTeamLogo = rudData.homeTeamName;
                d.homeTeamName = rudData.homeTeamName;
                d.homeTeamScore = rudData.homeTeamScore;

                d.visitingTeamScore = rudData.visitingTeamScore;
                d.visitingTeamName = rudData.visitingTeamName;
                d.visitingTeamLogo = rudData.visitingTeamName;

                d.matchId = rudData.matchId;
                d.competitionId = rudData.competitionId;

                if (rudData.status == "1")
                {
                    d.status = "未开赛";
                }
                else if (rudData.status == "2")
                {
                    d.status = "进行中";
                }
                else if (rudData.status == "3")
                {
                    d.status = "进行中";
                }
                else if (rudData.status == "4")
                {
                    d.status = "已结束";
                }
                else if (rudData.status == "5")
                {
                    d.status = "延期";
                }


                MatchData.Add(d);
            }


        }

        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {

            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;


            if (RoundMatchData != null)
            {
                string teamSeasonLastDate = $"{FoolballType}:足球轮次接口更新时间:{RoundMatchData.LastPushDataDateTime}";
                vm.OnErrorLogMessage(teamSeasonLastDate);
            }
            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;

            // messageLastRecordDate.ShowDialog();
        }

        #endregion


        /// <summary>
        /// 今日赛程信息
        /// </summary>
        private ObservableCollection<Dayschedule> matchData;

        /// <summary>
        /// 绑定数据列表
        /// </summary>
        public ObservableCollection<Dayschedule> MatchData
        {
            get { return matchData; }

            set { matchData = value; this.RaisePropertyChanged(nameof(MatchData)); }
        }



        /// <summary>
        /// 初始化方法
        /// </summary>
        private void Init()
        {

            BtnRoundCmd = new VCommand(BtmRoundCommand);
            PromptCommand = new VCommand(PromptCmd);

            ColumnChoiceCommand = new VCommand(ColumnChoice);
            ShowGridMenuCommand = new VCommand<GridMenuEventArgs>(ShowGridMenu);

            RoundMatchs = new ObservableCollection<int>();
            for (int i = 1; i < 39; i++)
            {
                RoundMatchs.Add(i);
            }

            roundMatchItem = 1;
            FoolballType = DateHeaderViewModel.FoolballType;
            SeasonId = DateHeaderViewModel.SeasonId;


        }


        #region IsColumnChooserVisible -- 是否显示列选择器

        private bool isColumnChooserVisible;
        /// <summary>
        /// 是否显示列选择器
        /// </summary>
        public bool IsColumnChooserVisible
        {
            get { return isColumnChooserVisible; }
            set { isColumnChooserVisible = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible)); }
        }

        #endregion


        #region ColumnChoiceCommand -- 列选择命令

        /// <summary>
        /// 列选择命令
        /// </summary>
        public VCommand ColumnChoiceCommand { get; set; }

        /// <summary>
        /// 列选择
        /// </summary>
        private void ColumnChoice()
        {
            this.IsColumnChooserVisible = true;
        }

        #endregion


        #region ShowGridMenuCommand -- 显示列命令

        /// <summary>
        /// 显示列命令
        /// </summary>
        public VCommand<GridMenuEventArgs> ShowGridMenuCommand { get; set; }

        /// <summary>
        /// 显示列
        /// </summary>
        /// <param name="e">事件参数</param>
        private void ShowGridMenu(GridMenuEventArgs e)
        {
            GridControlHelper.RemoveAllDefaultMenuItem(e);
        }

        #endregion


        /// <summary>
        /// 组装往包装发送得数据
        /// </summary>
        /// <returns></returns>
        public string CombineMatchData()
        {
            try

            {
                string data = "";
                data += title + "&";


                foreach (var tempMatchData in matchData)
                {
                    if (string.IsNullOrEmpty(tempMatchData.dates))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.dates.Replace(" ", "");
                    }


                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.time))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.time.Replace(" ", "");
                    }

                    data += "*";

                    //data += tempMatchData.homeTeamLogo.Replace(" ", "");

                    //data += "*";
                    if(string.IsNullOrEmpty(tempMatchData.homeTeamLogo))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.homeTeamLogo.Replace(" ", "");
                    }
                    data += "*";
                    if (string.IsNullOrEmpty(tempMatchData.homeTeamName))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.homeTeamName.Replace(" ", "");
                    }


                    data += "*";

                    if (string.IsNullOrEmpty(tempMatchData.homeTeamScore) || string.IsNullOrEmpty(tempMatchData.visitingTeamScore))
                    {
                        data += "0*";
                    }
                    else
                    {
                        data += "1*";
                    }
              
                    if (string.IsNullOrEmpty(tempMatchData.homeTeamScore))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.homeTeamScore.Replace(" ", "");
                    }
                    data += "*";

                    //客队得分
                    if (string.IsNullOrEmpty(tempMatchData.visitingTeamScore))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.visitingTeamScore.Replace(" ", "");
                    }
                    data += "*";

                    //客队名称
                    if (string.IsNullOrEmpty(tempMatchData.visitingTeamName))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.visitingTeamName.Replace(" ", "");
                    }
                    data += "*";



                    //客队国旗
                    if (string.IsNullOrEmpty(tempMatchData.visitingTeamLogo))
                    {
                        data += "";
                    }
                    else
                    {
                        data += tempMatchData.visitingTeamLogo.Replace(" ", "");
                    }
                    data += "*";

                    if (tempMatchData.SelectLight == "不高亮")
                    {
                        data += "0";
                    }
                    else
                    {
                        data += "1";
                    }

                    data += ";";

                }

                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.ToString());
                return "";
            }
        }

    }
}
