﻿using DevExpress.Xpf.Grid;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Common;
using VIZ.Package.Domain;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.TVP.FTB.Module
{

    /// <summary>
    /// 足球查看界面配置
    /// </summary>
    public class DateHeaderViewModel : ViewModelBase
    {

        public DateHeaderViewModel()
        {
            FootballTypes = new ObservableCollection<string>()
            {
               "英超","法甲","意甲","德甲","西甲"
            };
            SelectFootballType = "英超";

            InitRound();
            InitTeam();
            InitShoot();
        }

        private static AppSetup_InitLiteDB appSetup_InitCBALiteDB = AppSetup_InitLiteDB.CreateInstance;

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        /// <summary>
        /// 主数据库连接
        /// </summary>
        private bool mainDataConnection = true;
        public bool MainDataConnection
        {
            get { return mainDataConnection; }
            set
            {
                this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看主数据连接");

                mainDataConnection = value;
                this.RaisePropertyChanged(nameof(MainDataConnection));

                if (mainDataConnection)
                {
                    //JsonModel.strUrl = AppSetup_InitLiteDB.HttpUrlConfigEntity.Url;
                    //JsonModel.appKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppKey;
                    //JsonModel.appID = AppSetup_InitLiteDB.HttpUrlConfigEntity.AppId;
                    JsonModel.dataFromSource = true;
                    JsonModel.GethttpUrl();
                }
            }
        }


        /// <summary>
        /// 备份数据连接
        /// </summary>
        private bool backDataConnection;

        public bool BackDataConnection
        {
            get { return backDataConnection; }
            set
            {
                this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "CBA查看备数据连接");
                backDataConnection = value;
                this.RaisePropertyChanged(nameof(BackDataConnection));
                if (backDataConnection)
                {
                    //JsonModel.strUrl = AppSetup_InitLiteDB.HttpUrlConfigEntity.BUrl;
                    //JsonModel.appKey = AppSetup_InitLiteDB.HttpUrlConfigEntity.BAppKey;
                    //JsonModel.appID = AppSetup_InitLiteDB.HttpUrlConfigEntity.BAppId;
                    JsonModel.dataFromSource = false;
                    JsonModel.GethttpUrl();
                }
            }
        }




        /// <summary>
        /// 足球赛事类型
        /// </summary>
        public static string FoolballType= "";

        /// <summary>
        /// 赛季ID
        /// </summary>
        public static string SeasonId ="";


        /// <summary>
        /// 足球类型选择
        /// </summary>
        private ObservableCollection<string> footballTypes;

        public ObservableCollection<string> FootballTypes
        {
            get { return footballTypes; }
            set { footballTypes = value; this.RaisePropertyChanged(nameof(FootballTypes)); }
        }


        /// <summary>
        ///  选择的足球比赛
        /// </summary>
        private string selectFootballType;

        public string SelectFootballType
        {
            get { return selectFootballType; }
            set
            {
                selectFootballType = value;
                this.RaisePropertyChanged(nameof(SelectFootballType));

                this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看选择比赛类型:"+selectFootballType);

                FDayMatchViewModel.FDayMatchViewModelInstance.FoolballType = selectFootballType;
                FTeamStandingViewModel.FTeamStandingViewModelInstance.FoolballType = selectFootballType;
                ShootPlayerRankViewModel.ShootPlayerRanklInstance.FoolballType = selectFootballType;
                FoolballType = selectFootballType;

            }
        }


        #region 轮次赛程



        /// <summary>
        /// 选中轮次
        /// </summary>
        private int roundMatchItem;

        public int RoundMatchItem
        {
            get { return roundMatchItem; }
            set
            {
                roundMatchItem = value;
                this.RaisePropertyChanged(nameof(RoundMatchItem));
            }
        }


        private ObservableCollection<int> roundMatch;

        public ObservableCollection<int> RoundMatchs
        {
            get { return roundMatch; }
            set { roundMatch = value; this.RaisePropertyChanged(nameof(RoundMatchs)); }
        }




        /// <summary>
        /// 今日赛程轮次
        /// </summary>
        public VCommand BtnRoundCmd { get; set; }



        Dayschedules RoundMatchData = null;
        /// <summary>
        /// 添加轮次刷新
        /// </summary>
        private async void BtmRoundCommand()
        {
            // SetRoundMatchData();

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "获取比赛轮次:" + roundMatchItem.ToString() + " " + selectFootballType);

            RoundMatchData = await JsonModel.PostTomorrowMatch_Path(roundMatchItem.ToString(), FoolballType);


            if (RoundMatchData == null) return;



            MatchData = new ObservableCollection<Dayschedule>();



            foreach (var rudData in RoundMatchData.schedulelist)
            {

                Dayschedule d = new Dayschedule();


                d.round = rudData.round;
                d.dates = rudData.dates;
                d.time = rudData.time;
                d.homeTeamLogo = rudData.homeTeamName;
                d.homeTeamName = rudData.homeTeamName;
                d.homeTeamScore = rudData.homeTeamScore;

                d.visitingTeamScore = rudData.visitingTeamScore;
                d.visitingTeamName = rudData.visitingTeamName;
                d.visitingTeamLogo = rudData.visitingTeamName;

                d.matchId = rudData.matchId;
                d.competitionId = rudData.competitionId;

                if (rudData.status == "1")
                {
                    d.status = "未开赛";
                }
                else if (rudData.status == "2")
                {
                    d.status = "进行中";
                }
                else if (rudData.status == "3")
                {
                    d.status = "进行中";
                }
                else if (rudData.status == "4")
                {
                    d.status = "已结束";
                }
                else if (rudData.status == "5")
                {
                    d.status = "延期";
                }


                MatchData.Add(d);
            }


        }

        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        //public VCommand PromptCommand { get; set; }


        //MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        //private void PromptCmd()
        //{

        //    MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;


        //    if (RoundMatchData != null)
        //    {
        //        string teamSeasonLastDate = $"足球轮次接口更新时间:{RoundMatchData.LastPushDataDateTime}";
        //        vm.OnErrorLogMessage(teamSeasonLastDate);
        //    }
        //    messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
        //    messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;

        //    // messageLastRecordDate.ShowDialog();
        //}

        #endregion


        /// <summary>
        /// 轮次赛程信息
        /// </summary>
        private ObservableCollection<Dayschedule> matchData;

        /// <summary>
        /// 绑定数据列表
        /// </summary>
        public ObservableCollection<Dayschedule> MatchData
        {
            get { return matchData; }

            set { matchData = value; this.RaisePropertyChanged(nameof(MatchData)); }
        }



        /// <summary>
        /// 初始化方法
        /// </summary>
        private void InitRound()
        {

            BtnRoundCmd = new VCommand(BtmRoundCommand);
            //PromptCommand = new VCommand(PromptCmd);

            ColumnChoiceCommand = new VCommand(ColumnChoice);
            ShowGridMenuCommand = new VCommand<GridMenuEventArgs>(ShowGridMenu);

            RoundMatchs = new ObservableCollection<int>();
            for (int i = 1; i < 39; i++)
            {
                RoundMatchs.Add(i);
            }

            roundMatchItem = 1;

        }


        #region IsColumnChooserVisible -- 是否显示列选择器

        private bool isColumnChooserVisible;
        /// <summary>
        /// 是否显示列选择器
        /// </summary>
        public bool IsColumnChooserVisible
        {
            get { return isColumnChooserVisible; }
            set { isColumnChooserVisible = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible)); }
        }

        #endregion


        #region ColumnChoiceCommand -- 列选择命令

        /// <summary>
        /// 列选择命令
        /// </summary>
        public VCommand ColumnChoiceCommand { get; set; }

        /// <summary>
        /// 列选择
        /// </summary>
        private void ColumnChoice()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看轮次赛程显示列表:" + "IsColumnChooserVisible=true");
            this.IsColumnChooserVisible = true;
        }

        #endregion


        #region ShowGridMenuCommand -- 显示列命令

        /// <summary>
        /// 显示列命令
        /// </summary>
        public VCommand<GridMenuEventArgs> ShowGridMenuCommand { get; set; }

        /// <summary>
        /// 显示列
        /// </summary>
        /// <param name="e">事件参数</param>
        private void ShowGridMenu(GridMenuEventArgs e)
        {
            GridControlHelper.RemoveAllDefaultMenuItem(e);
        }

        #endregion




        #endregion


        #region 足球积分



        /// <summary>
        /// 球队绑定数据集合
        /// </summary>
        private ObservableCollection<Teamrank> teamRanksModel;
        public ObservableCollection<Teamrank> TeamRanksModel
        {
            get { return teamRanksModel; }

            set { teamRanksModel = value; this.RaisePropertyChanged(nameof(TeamRanksModel)); }
        }

        public VCommand BtnCmd1 { get; set; }


        TeamRanks teamStands = null;


        /// <summary>
        /// 刷新球队积分排名
        /// </summary>
        private async void BtmCommand1()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看球队积分:" + SeasonId + " " + selectFootballType);

            teamStands = new TeamRanks();

            if (FoolballType == "英超")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.EPCSeasonId;

            }
            else if (FoolballType == "法甲")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.FL1SeasonId;
            }
            else if (FoolballType == "意甲")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.ISASeasonId;
            }
            else if (FoolballType == "德甲")
            {
                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.LIGASeasonId;
            }
            else if (FoolballType == "西甲")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.SLPSeasonId;
            }

            teamStands = await JsonModel.PostTeamScoreData_Path(FoolballType, SeasonId);
            if (teamStands == null) return;
            TeamRanksModel = new ObservableCollection<Teamrank>();
            //int i = 1;
            foreach (var teamRank in teamStands.teamstats)
            {
               // teamRank.rank = i.ToString();

                teamRank.goalAndLoseNums = String.Format("{0}/{1}", teamRank.goalsNum, teamRank.loseGoalsNum);
                teamRank.teamLogo = teamRank.teamName;

                TeamRanksModel.Add(teamRank);
              // i++;
            }
        }

       

        /// <summary>
        /// 初始话
        /// </summary>
        private void InitTeam()
        {
            BtnCmd1 = new VCommand(BtmCommand1);

            //PromptCommand1 = new VCommand(PromptCmd1);

            ColumnChoiceCommand1 = new VCommand(ColumnChoic1e1);

            ShowGridMenuCommand1 = new VCommand<GridMenuEventArgs>(ShowGridMenu1);


        }


        #region IsColumnChooserVisible -- 是否显示列选择器

        private bool isColumnChooserVisible1;
        /// <summary>
        /// 是否显示列选择器
        /// </summary>
        public bool IsColumnChooserVisible1
        {
            get { return isColumnChooserVisible1; }
            set { isColumnChooserVisible1 = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible1)); }
        }

        #endregion


        #region ColumnChoiceCommand1 -- 列选择命令

        /// <summary>
        /// 列选择命令
        /// </summary>
        public VCommand ColumnChoiceCommand1 { get; set; }

        /// <summary>
        /// 列选择
        /// </summary>
        private void ColumnChoic1e1()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看球队积分显示列表:" + "IsColumnChooserVisible=true");
            this.IsColumnChooserVisible1 = true;
        }

        #endregion


        #region ShowGridMenuCommand -- 显示列命令

        /// <summary>
        /// 显示列命令
        /// </summary>
        public VCommand<GridMenuEventArgs> ShowGridMenuCommand1 { get; set; }

        /// <summary>
        /// 显示列
        /// </summary>
        /// <param name="e">事件参数</param>
        private void ShowGridMenu1(GridMenuEventArgs e)
        {
            GridControlHelper.RemoveAllDefaultMenuItem(e);
        }

        #endregion

        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        //public VCommand PromptCommand1 { get; set; }


        //MessageLastRecordDate messageLastRecordDate1 = new MessageLastRecordDate();
        //private void PromptCmd1()
        //{

        //    MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
        //    if (teamStands != null)
        //    {
        //        string LastDate = $"足球积分接口更新时间：{teamStands.LastPushDataDateTime}";
        //        vm.OnErrorLogMessage(LastDate);
        //    }


        //    messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
        //    messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;
        //}

        #endregion

        #endregion


        #region 射手榜排名

        /// <summary>
        /// 球员射手榜绑定数据集合
        /// </summary>
        private ObservableCollection<ShootPlayerRank> shootPlayerModel;
        public ObservableCollection<ShootPlayerRank> ShootPlayerModel
        {
            get { return shootPlayerModel; }

            set { shootPlayerModel = value; this.RaisePropertyChanged(nameof(ShootPlayerModel)); }
        }

        public VCommand BtnCmd2 { get; set; }


        ShootPlayerRanks shootPlayerRanks = null;


        /// <summary>
        /// 刷新射手排名
        /// </summary>
        private async void BtmCommand2()
        {
            shootPlayerRanks = new ShootPlayerRanks();

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看射手榜排名:" + SeasonId + " " + selectFootballType);

            if (FoolballType == "英超")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.EPCSeasonId;

            }
            else if (FoolballType == "法甲")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.FL1SeasonId;
            }
            else if (FoolballType == "意甲")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.ISASeasonId;
            }
            else if (FoolballType == "德甲")
            {
                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.LIGASeasonId;
            }
            else if (FoolballType == "西甲")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.SLPSeasonId;
            }


            shootPlayerRanks = await JsonModel.Post_ShootPlayerRankData(FoolballType, SeasonId, StartOffset, EndOffset);
            if (shootPlayerRanks == null) return;
            ShootPlayerModel = new ObservableCollection<ShootPlayerRank>();

            foreach (var playerRank in shootPlayerRanks.playerstats)
            {
                playerRank.playerLogo = playerRank.figureName;
                playerRank.teamLogo = playerRank.teamName;

                if (playerRank.goals != "0")
                {
                    playerRank.goals = playerRank.goals.TrimEnd('0').TrimEnd('.');
                }
                if (playerRank.penaltyGoals != "0")
                {
                    playerRank.penaltyGoals = playerRank.penaltyGoals.TrimEnd('0').TrimEnd('.');
                }
                ShootPlayerModel.Add(playerRank);

            }
        }

       
        /// <summary>
        /// 开始条数
        /// </summary>
        private string startOffset = "0";
        public string StartOffset
        {
            get { return startOffset; }
            set
            {
                startOffset = value;
                this.RaisePropertyChanged(nameof(StartOffset));
            }
        }

        /// <summary>
        /// 结束条数
        /// </summary>
        private string endOffset = "10";


        public string EndOffset
        {
            get { return endOffset; }
            set
            {
                endOffset = value;
                this.RaisePropertyChanged(nameof(EndOffset));
            }
        }


        /// <summary>
        /// 初始话
        /// </summary>
        private void InitShoot()
        {
            BtnCmd2 = new VCommand(BtmCommand2);

           // PromptCommand2 = new VCommand(PromptCmd2);

            ColumnChoiceCommand2 = new VCommand(ColumnChoice2);
            ShowGridMenuCommand2 = new VCommand<GridMenuEventArgs>(ShowGridMenu2);

        }


        #region IsColumnChooserVisible2 -- 是否显示列选择器

        private bool isColumnChooserVisible2;
        /// <summary>
        /// 是否显示列选择器
        /// </summary>
        public bool IsColumnChooserVisible2
        {
            get { return isColumnChooserVisible2; }
            set { isColumnChooserVisible2 = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible2)); }
        }

        #endregion


        #region ColumnChoiceCommand -- 列选择命令

        /// <summary>
        /// 列选择命令
        /// </summary>
        public VCommand ColumnChoiceCommand2 { get; set; }

        /// <summary>
        /// 列选择
        /// </summary>
        private void ColumnChoice2()
        {
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "足球查看射手榜显示列表:" + "IsColumnChooserVisible=true");
            this.IsColumnChooserVisible2 = true;
        }

        #endregion


        #region ShowGridMenuCommand -- 显示列命令

        /// <summary>
        /// 显示列命令
        /// </summary>
        public VCommand<GridMenuEventArgs> ShowGridMenuCommand2 { get; set; }

        /// <summary>
        /// 显示列
        /// </summary>
        /// <param name="e">事件参数</param>
        private void ShowGridMenu2(GridMenuEventArgs e)
        {
            GridControlHelper.RemoveAllDefaultMenuItem(e);
        }

        #endregion


        #endregion

    }
}
