﻿using DevExpress.Mvvm.POCO;
using DevExpress.Xpf.Grid;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Common;

namespace VIZ.TVP.FTB.Module
{
    public class ShootPlayerRankViewModel: ViewModelBase
    {

        /// <summary>
        /// 日志
        /// </summary>
        private static ILog Log = LogManager.GetLogger(typeof(ShootPlayerRankViewModel));

        /// <summary>
        /// 
        /// </summary>
        public static ShootPlayerRankViewModel ShootPlayerRanklInstance = new ShootPlayerRankViewModel();


        /// <summary>
        /// 初始话
        /// </summary>
        public ShootPlayerRankViewModel()
        {
            Init();
        }


        /// <summary>
        /// 球员射手榜绑定数据集合
        /// </summary>
        private ObservableCollection<ShootPlayerRank> shootPlayerModel;
        public ObservableCollection<ShootPlayerRank> ShootPlayerModel
        {
            get { return shootPlayerModel; }

            set { shootPlayerModel = value; this.RaisePropertyChanged(nameof(ShootPlayerModel)); }
        }

        public VCommand BtnCmd { get; set; }


        ShootPlayerRanks shootPlayerRanks = null;


        /// <summary>
        /// 刷新球队积分排名
        /// </summary>
        private async void BtmCommand()
        {
            shootPlayerRanks = new ShootPlayerRanks();

            if (FoolballType == "英超")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.EPCSeasonId;

            }
            else if (FoolballType == "法甲")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.FL1SeasonId;
            }
            else if (FoolballType == "意甲")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.ISASeasonId;
            }
            else if (FoolballType == "德甲")
            {
                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.LIGASeasonId;
            }
            else if (FoolballType == "西甲")
            {

                SeasonId = AppSetup_InitLiteDB.HttpUrlConfigEntity.SLPSeasonId;
            }
            shootPlayerRanks = await JsonModel.Post_ShootPlayerRankData(FoolballType, SeasonId,StartOffset,EndOffset);
            if (shootPlayerRanks == null) return;
            ShootPlayerModel = new ObservableCollection<ShootPlayerRank>();
        
            foreach (var playerRank in shootPlayerRanks.playerstats)
            {
                playerRank.playerLogo = playerRank.figureName;
                playerRank.teamLogo = playerRank.teamName;
                if (playerRank.goals != "0")
                {
                    playerRank.goals = playerRank.goals.TrimEnd('0').TrimEnd('.');
                }

                if (playerRank.penaltyGoals != "0")
                {
                    playerRank.penaltyGoals = playerRank.penaltyGoals.TrimEnd('0').TrimEnd('.');
                }

                ShootPlayerModel.Add(playerRank);
               
            }
        }

        /// <summary>
        /// 组装积分排名数据上传
        /// </summary>
        /// <returns></returns>
        public string CombineData()
        {
            try
            {


                string data = "";

                data += title;

                data += "&";

        

                foreach (var tempTeamRankModel in ShootPlayerModel)
                {
      
                    data += tempTeamRankModel.rank.ToString().Replace(" ", "");

                    data += "*";
                    data += tempTeamRankModel.playerLogo.Replace(" ","");

                    data += "*";
                    data += tempTeamRankModel.teamLogo.Replace(" ", "");

                    data += "*";
                    data += tempTeamRankModel.figureName.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.goals.ToString().Replace(" ", "");


                    data += "*";
                    data += tempTeamRankModel.penaltyGoals.ToString().Replace(" ", "");

         
                    data += ";";

     
                }

                if (FoolballType == "英超")
                {

                    data += "&1";

                }
                else if (FoolballType == "法甲")
                {

                    data += "&2";
                }
                else if (FoolballType == "意甲")
                {

                    data += "&3";
                }
                else if (FoolballType == "德甲")
                {
                    data += "&4";
                }
                else if (FoolballType == "西甲")
                {

                    data += "&5";
                }

     

                return data;
            }
            catch (Exception ex)
            {
                Log.Error(ex.Message);
                return "";
            }
        }


        private string title = "22/23赛季意大利足球超级联赛射手榜";

        public string Title
        {
            get { return title; }
            set
            {
                title = value; 
                this.RaisePropertyChanged(nameof(Title)); 
            }
        }


        /// <summary>
        /// 开始条数
        /// </summary>
        private string startOffset = "0";
        public string StartOffset
        {
            get { return startOffset; }
            set
            {
                startOffset = value;
                this.RaisePropertyChanged(nameof(StartOffset));
            } 
        }

        /// <summary>
        /// 结束条数
        /// </summary>
        private string endOffset = "5";


        public string EndOffset
        {
            get { return endOffset; }
            set
            { 
                endOffset = value;
                this.RaisePropertyChanged(nameof(EndOffset));
            }
        }


        /// <summary>
        /// 足球赛事类型
        /// </summary>
        public string FoolballType = "";

        /// <summary>
        /// 赛季ID
        /// </summary>
        public string SeasonId = "";


        /// <summary>
        /// 初始话
        /// </summary>
        private void Init()
        {
            BtnCmd = new VCommand(BtmCommand);

            PromptCommand = new VCommand(PromptCmd);

            ColumnChoiceCommand = new VCommand(ColumnChoice);
            ShowGridMenuCommand = new VCommand<GridMenuEventArgs>(ShowGridMenu);

            FoolballType = DateHeaderViewModel.FoolballType;
            SeasonId = DateHeaderViewModel.SeasonId;
        }


        #region IsColumnChooserVisible -- 是否显示列选择器

        private bool isColumnChooserVisible;
        /// <summary>
        /// 是否显示列选择器
        /// </summary>
        public bool IsColumnChooserVisible
        {
            get { return isColumnChooserVisible; }
            set { isColumnChooserVisible = value; this.RaisePropertyChanged(nameof(IsColumnChooserVisible)); }
        }

        #endregion


        #region ColumnChoiceCommand -- 列选择命令

        /// <summary>
        /// 列选择命令
        /// </summary>
        public VCommand ColumnChoiceCommand { get; set; }

        /// <summary>
        /// 列选择
        /// </summary>
        private void ColumnChoice()
        {
            this.IsColumnChooserVisible = true;
        }

        #endregion


        #region ShowGridMenuCommand -- 显示列命令

        /// <summary>
        /// 显示列命令
        /// </summary>
        public VCommand<GridMenuEventArgs> ShowGridMenuCommand { get; set; }

        /// <summary>
        /// 显示列
        /// </summary>
        /// <param name="e">事件参数</param>
        private void ShowGridMenu(GridMenuEventArgs e)
        {
            GridControlHelper.RemoveAllDefaultMenuItem(e);
        }

        #endregion


        #region 打开更新数据时间日志
        /// <summary>
        /// 打开数据更新日志
        /// </summary>
        public VCommand PromptCommand { get; set; }


        MessageLastRecordDate messageLastRecordDate = new MessageLastRecordDate();
        private void PromptCmd()
        {

            MessageLRDateViewModel vm = messageLastRecordDate.DataContext as MessageLRDateViewModel;
            if (shootPlayerRanks != null)
            {
                string LastDate = $"{FoolballType}:射手榜积分接口更新时间：{shootPlayerRanks.LastPushDataDateTime}";
                vm.OnErrorLogMessage(LastDate);
            }


            messageLastRecordDate.Visibility = System.Windows.Visibility.Visible;
            messageLastRecordDate.WindowState = System.Windows.WindowState.Normal;
        }

        #endregion
    }
}
